/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.metrics;

import com.codahale.metrics.Counter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.metrics.MapMetrics;
import org.apache.hadoop.hive.metastore.metrics.Metrics;
import org.apache.hadoop.hive.metastore.testutils.CapturingLogAppender;
import org.apache.logging.log4j.Level;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class TestMetrics {
    private static final long REPORT_INTERVAL = 1L;

    @Before
    public void shutdownMetrics() {
        Metrics.shutdown();
    }

    @Test
    public void slf4jReporter() throws Exception {
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METRICS_REPORTERS, (String)"slf4j");
        MetastoreConf.setTimeVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METRICS_SLF4J_LOG_FREQUENCY_MINS, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METRICS_SLF4J_LOG_LEVEL, (String)"INFO");
        this.validateSlf4jReporter(conf, Level.INFO);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METRICS_SLF4J_LOG_LEVEL, (String)"DEBUG");
        this.validateSlf4jReporter(conf, Level.DEBUG);
    }

    private void validateSlf4jReporter(Configuration conf, Level level) throws Exception {
        this.initializeMetrics(conf);
        Counter counter = Metrics.getOrCreateCounter((String)"my-counter");
        counter.inc(5L);
        Thread.sleep(1500L);
        List<String> capturedLogMessages = CapturingLogAppender.findLogMessagesContaining(level, "my-counter");
        Assert.assertTrue((String)("Not a single counter message was logged from metrics when configured for SLF4J metric reporting at level " + level + "!"), (capturedLogMessages.size() > 0 ? 1 : 0) != 0);
        String logMessage = capturedLogMessages.get(0);
        Assert.assertTrue((String)("Counter value is incorrect on captured log message: \"" + logMessage + "\""), (boolean)logMessage.contains("count=5"));
        Metrics.shutdown();
    }

    @Test
    public void jsonReporter() throws Exception {
        File jsonReportFile = File.createTempFile("TestMetrics", ".json");
        String jsonFile = jsonReportFile.getAbsolutePath();
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METRICS_REPORTERS, (String)"json");
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METRICS_JSON_FILE_LOCATION, (String)jsonFile);
        MetastoreConf.setTimeVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METRICS_JSON_FILE_INTERVAL, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        this.initializeMetrics(conf);
        Counter counter = Metrics.getOrCreateCounter((String)"my-counter");
        MapMetrics mapMetrics = Metrics.getOrCreateMapMetrics((String)"my-map");
        for (int i = 0; i < 5; ++i) {
            counter.inc();
            mapMetrics.update((Map)ImmutableMap.of((Object)"const", (Object)1000, (Object)"var", (Object)(i * 100)));
            Thread.sleep(1500L);
            String json = new String(MetricsTestUtils.getFileData(jsonFile, 200, 10));
            MetricsTestUtils.verifyMetricsJson(json, MetricsTestUtils.COUNTER, "my-counter", i + 1);
            MetricsTestUtils.verifyMapMetricsJson(json, "my-map", (Map<String, Integer>)ImmutableMap.of((Object)"const", (Object)1000, (Object)"var", (Object)(i * 100)));
        }
    }

    @Test
    public void testJsonStructure() throws Exception {
        File jsonReportFile = File.createTempFile("TestMetrics", ".json");
        String jsonFile = jsonReportFile.getAbsolutePath();
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METRICS_REPORTERS, (String)"json");
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METRICS_JSON_FILE_LOCATION, (String)jsonFile);
        MetastoreConf.setTimeVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METRICS_JSON_FILE_INTERVAL, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        this.initializeMetrics(conf);
        Counter openConnections = Metrics.getOpenConnectionsCounter();
        openConnections.inc();
        Thread.sleep(1500L);
        String json = new String(MetricsTestUtils.getFileData(jsonFile, 200, 10));
        MetricsTestUtils.verifyMetricsJson(json, MetricsTestUtils.GAUGE, "buffers.direct.capacity");
        MetricsTestUtils.verifyMetricsJson(json, MetricsTestUtils.GAUGE, "memory.heap.used");
        MetricsTestUtils.verifyMetricsJson(json, MetricsTestUtils.GAUGE, "threads.count");
        MetricsTestUtils.verifyMetricsJson(json, MetricsTestUtils.GAUGE, "classLoading.loaded");
        MetricsTestUtils.verifyMetricsJson(json, MetricsTestUtils.COUNTER, "open_connections", 1);
    }

    @Test
    public void allReporters() throws Exception {
        String jsonFile = System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + "TestMetricsOutput.json";
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METRICS_REPORTERS, (String)"json,jmx,console,hadoop");
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METRICS_JSON_FILE_LOCATION, (String)jsonFile);
        this.initializeMetrics(conf);
        Assert.assertEquals((long)4L, (long)Metrics.getReporters().size());
    }

    @Test
    public void allReportersHiveConfig() throws Exception {
        String jsonFile = System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + "TestMetricsOutput.json";
        Configuration conf = MetastoreConf.newMetastoreConf();
        conf.set(MetastoreConf.ConfVars.HIVE_CODAHALE_METRICS_REPORTER_CLASSES.getHiveName(), "org.apache.hadoop.hive.common.metrics.metrics2.JsonFileMetricsReporter,org.apache.hadoop.hive.common.metrics.metrics2.JmxMetricsReporter,org.apache.hadoop.hive.common.metrics.metrics2.ConsoleMetricsReporter,org.apache.hadoop.hive.common.metrics.metrics2.Metrics2Reporter");
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METRICS_JSON_FILE_LOCATION, (String)jsonFile);
        this.initializeMetrics(conf);
        Assert.assertEquals((long)4L, (long)Metrics.getReporters().size());
    }

    @Test
    public void allReportersOldHiveConfig() throws Exception {
        String jsonFile = System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + "TestMetricsOutput.json";
        Configuration conf = MetastoreConf.newMetastoreConf();
        conf.set(MetastoreConf.ConfVars.HIVE_METRICS_REPORTER.getHiveName(), "JSON_FILE,JMX,CONSOLE,HADOOP2");
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METRICS_JSON_FILE_LOCATION, (String)jsonFile);
        this.initializeMetrics(conf);
        Assert.assertEquals((long)4L, (long)Metrics.getReporters().size());
    }

    @Test
    public void defaults() throws Exception {
        String jsonFile = System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + "TestMetricsOutput.json";
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METRICS_JSON_FILE_LOCATION, (String)jsonFile);
        this.initializeMetrics(conf);
        Assert.assertEquals((long)2L, (long)Metrics.getReporters().size());
    }

    private void initializeMetrics(Configuration conf) throws Exception {
        Field field = Metrics.class.getDeclaredField("self");
        field.setAccessible(true);
        Constructor cons = Metrics.class.getDeclaredConstructor(Configuration.class);
        cons.setAccessible(true);
        field.set(null, cons.newInstance(conf));
    }

    private static class MetricsTestUtils {
        static final MetricsCategory COUNTER = new MetricsCategory("counters", "count");
        static final MetricsCategory TIMER = new MetricsCategory("timers", "count");
        static final MetricsCategory GAUGE = new MetricsCategory("gauges", "value");
        static final MetricsCategory METER = new MetricsCategory("meters", "count");

        private MetricsTestUtils() {
        }

        static void verifyMapMetricsJson(String rawJson, String mBeanField, Map<String, Integer> expectedValue) throws Exception {
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode rootNode = objectMapper.readTree(rawJson);
            JsonNode mbeansNode = rootNode.get("mbeans");
            Assert.assertTrue((boolean)(mbeansNode instanceof ObjectNode));
            JsonNode mBeanObj = mbeansNode.get(mBeanField);
            Assert.assertTrue((boolean)(mBeanObj instanceof ObjectNode));
            Map content = (Map)objectMapper.convertValue((Object)mBeanObj, (TypeReference)new TypeReference<Map<String, Integer>>(){});
            MatcherAssert.assertThat((Object)content, (Matcher)CoreMatchers.is(expectedValue));
        }

        static void verifyMetricsJson(String json, MetricsCategory category, String metricsName, Object expectedValue) throws Exception {
            JsonNode jsonNode = MetricsTestUtils.getJsonNode(json, category, metricsName);
            Assert.assertTrue((String)String.format("%s.%s.%s should not be empty", category.category, metricsName, category.metricsHandle), (!jsonNode.asText().isEmpty() ? 1 : 0) != 0);
            if (expectedValue != null) {
                Assert.assertEquals((Object)expectedValue.toString(), (Object)jsonNode.asText());
            }
        }

        static void verifyMetricsJson(String json, MetricsCategory category, String metricsName) throws Exception {
            MetricsTestUtils.verifyMetricsJson(json, category, metricsName, null);
        }

        static JsonNode getJsonNode(String json, MetricsCategory category, String metricsName) throws Exception {
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode rootNode = objectMapper.readTree(json);
            JsonNode categoryNode = rootNode.path(category.category);
            JsonNode metricsNode = categoryNode.path(metricsName);
            return metricsNode.path(category.metricsHandle);
        }

        static byte[] getFileData(String path, int timeoutInterval, int tries) throws Exception {
            File file = new File(path);
            do {
                Thread.sleep(timeoutInterval);
            } while (--tries > 0 && !file.exists());
            return Files.readAllBytes(Paths.get(path, new String[0]));
        }

        static class MetricsCategory {
            String category;
            String metricsHandle;

            MetricsCategory(String category, String metricsHandle) {
                this.category = category;
                this.metricsHandle = metricsHandle;
            }
        }
    }
}

