/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.ldap;

import org.apache.hadoop.hive.metastore.ldap.Query;
import org.junit.Assert;
import org.junit.Test;

public class TestQuery {
    @Test
    public void testQueryBuilderFilter() {
        Query q = Query.builder().filter("test <uid_attr>=<value> query").map("uid_attr", "uid").map("value", "Hello!").build();
        Assert.assertEquals((Object)"test uid=Hello! query", (Object)q.getFilter());
        Assert.assertEquals((long)0L, (long)q.getControls().getCountLimit());
    }

    @Test
    public void testQueryBuilderLimit() {
        Query q = Query.builder().filter("<key1>,<key2>").map("key1", "value1").map("key2", "value2").limit(8).build();
        Assert.assertEquals((Object)"value1,value2", (Object)q.getFilter());
        Assert.assertEquals((long)8L, (long)q.getControls().getCountLimit());
    }

    @Test
    public void testQueryBuilderReturningAttributes() {
        Query q = Query.builder().filter("(query)").returnAttribute("attr1").returnAttribute("attr2").build();
        Assert.assertEquals((Object)"(query)", (Object)q.getFilter());
        Assert.assertArrayEquals((Object[])new String[]{"attr1", "attr2"}, (Object[])q.getControls().getReturningAttributes());
    }
}

