/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.ldap;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.ldap.LdapUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestLdapUtils {
    @Test
    public void testCreateCandidatePrincipalsForUserDn() {
        Configuration conf = MetastoreConf.newMetastoreConf();
        String userDn = "cn=user1,ou=CORP,dc=mycompany,dc=com";
        List<String> expected = Arrays.asList(userDn);
        List actual = LdapUtils.createCandidatePrincipals((Configuration)conf, (String)userDn);
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testCreateCandidatePrincipalsForUserWithDomain() {
        Configuration conf = MetastoreConf.newMetastoreConf();
        String userWithDomain = "user1@mycompany.com";
        List<String> expected = Arrays.asList(userWithDomain);
        List actual = LdapUtils.createCandidatePrincipals((Configuration)conf, (String)userWithDomain);
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testCreateCandidatePrincipalsLdapDomain() {
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_DOMAIN, (String)"mycompany.com");
        List<String> expected = Arrays.asList("user1@mycompany.com");
        List actual = LdapUtils.createCandidatePrincipals((Configuration)conf, (String)"user1");
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testCreateCandidatePrincipalsUserPatternsDefaultBaseDn() {
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_GUIDKEY, (String)"sAMAccountName");
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_BASEDN, (String)"dc=mycompany,dc=com");
        List<String> expected = Arrays.asList("sAMAccountName=user1,dc=mycompany,dc=com");
        List actual = LdapUtils.createCandidatePrincipals((Configuration)conf, (String)"user1");
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testCreateCandidatePrincipals() {
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_BASEDN, (String)"dc=mycompany,dc=com");
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_USERDNPATTERN, (String)"cn=%s,ou=CORP1,dc=mycompany,dc=com:cn=%s,ou=CORP2,dc=mycompany,dc=com");
        List<String> expected = Arrays.asList("cn=user1,ou=CORP1,dc=mycompany,dc=com", "cn=user1,ou=CORP2,dc=mycompany,dc=com");
        List actual = LdapUtils.createCandidatePrincipals((Configuration)conf, (String)"user1");
        Collections.sort(expected);
        Collections.sort(actual);
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testExtractFirstRdn() {
        String dn = "cn=user1,ou=CORP1,dc=mycompany,dc=com";
        String expected = "cn=user1";
        String actual = LdapUtils.extractFirstRdn((String)dn);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testExtractBaseDn() {
        String dn = "cn=user1,ou=CORP1,dc=mycompany,dc=com";
        String expected = "ou=CORP1,dc=mycompany,dc=com";
        String actual = LdapUtils.extractBaseDn((String)dn);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testExtractBaseDnNegative() {
        String dn = "cn=user1";
        Assert.assertNull((Object)LdapUtils.extractBaseDn((String)dn));
    }
}

