/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.ldap;

import java.io.IOException;
import java.util.Arrays;
import javax.naming.NamingException;
import javax.security.sasl.AuthenticationException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.ldap.DirSearch;
import org.apache.hadoop.hive.metastore.ldap.Filter;
import org.apache.hadoop.hive.metastore.ldap.FilterFactory;
import org.apache.hadoop.hive.metastore.ldap.GroupFilterFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestGroupFilter {
    private FilterFactory factory;
    private Configuration conf;
    @Mock
    private DirSearch search;

    @Before
    public void setup() {
        this.conf = MetastoreConf.newMetastoreConf();
        this.conf.set("hive.root.logger", "DEBUG,console");
        this.factory = new GroupFilterFactory();
    }

    @Test
    public void testGetInstanceWhenGroupFilterIsEmpty() {
        this.conf.unset(MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_GROUPFILTER.getVarname());
        Assert.assertNull((Object)this.factory.getInstance(this.conf));
    }

    @Test
    public void testGetInstanceOfGroupMembershipKeyFilter() {
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_GROUPFILTER, (String)"G1");
        Filter instance = this.factory.getInstance(this.conf);
        Assert.assertNotNull((Object)instance);
        Assert.assertThat((Object)instance, (Matcher)CoreMatchers.instanceOf(GroupFilterFactory.GroupMembershipKeyFilter.class));
    }

    @Test
    public void testGetInstanceOfUserMembershipKeyFilter() {
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_GROUPFILTER, (String)"G1");
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_USERMEMBERSHIP_KEY, (String)"memberof");
        Filter instance = this.factory.getInstance(this.conf);
        Assert.assertNotNull((Object)instance);
        Assert.assertThat((Object)instance, (Matcher)CoreMatchers.instanceOf(GroupFilterFactory.UserMembershipKeyFilter.class));
    }

    @Test
    public void testGroupMembershipKeyFilterApplyPositive() throws AuthenticationException, NamingException, IOException {
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_GROUPFILTER, (String)"HiveUsers");
        Mockito.when((Object)this.search.findUserDn((String)Mockito.eq((Object)"user1"))).thenReturn((Object)"cn=user1,ou=People,dc=example,dc=com");
        Mockito.when((Object)this.search.findUserDn((String)Mockito.eq((Object)"cn=user2,dc=example,dc=com"))).thenReturn((Object)"cn=user2,ou=People,dc=example,dc=com");
        Mockito.when((Object)this.search.findUserDn((String)Mockito.eq((Object)"user3@mydomain.com"))).thenReturn((Object)"cn=user3,ou=People,dc=example,dc=com");
        Mockito.when((Object)this.search.findGroupsForUser((String)Mockito.eq((Object)"cn=user1,ou=People,dc=example,dc=com"))).thenReturn(Arrays.asList("cn=SuperUsers,ou=Groups,dc=example,dc=com", "cn=Office1,ou=Groups,dc=example,dc=com", "cn=HiveUsers,ou=Groups,dc=example,dc=com", "cn=G1,ou=Groups,dc=example,dc=com"));
        Mockito.when((Object)this.search.findGroupsForUser((String)Mockito.eq((Object)"cn=user2,ou=People,dc=example,dc=com"))).thenReturn(Arrays.asList("cn=HiveUsers,ou=Groups,dc=example,dc=com"));
        Mockito.when((Object)this.search.findGroupsForUser((String)Mockito.eq((Object)"cn=user3,ou=People,dc=example,dc=com"))).thenReturn(Arrays.asList("cn=HiveUsers,ou=Groups,dc=example,dc=com", "cn=G1,ou=Groups,dc=example,dc=com", "cn=G2,ou=Groups,dc=example,dc=com"));
        Filter filter = this.factory.getInstance(this.conf);
        filter.apply(this.search, "user1");
        filter.apply(this.search, "cn=user2,dc=example,dc=com");
        filter.apply(this.search, "user3@mydomain.com");
    }

    @Test
    public void testGroupMembershipKeyCaseInsensitiveFilterApplyPositive() throws AuthenticationException, NamingException, IOException {
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_GROUPFILTER, (String)"hiveusers,g1");
        Mockito.when((Object)this.search.findUserDn((String)Mockito.eq((Object)"user1"))).thenReturn((Object)"cn=user1,ou=People,dc=example,dc=com");
        Mockito.when((Object)this.search.findUserDn((String)Mockito.eq((Object)"cn=user2,dc=example,dc=com"))).thenReturn((Object)"cn=user2,ou=People,dc=example,dc=com");
        Mockito.when((Object)this.search.findUserDn((String)Mockito.eq((Object)"user3@mydomain.com"))).thenReturn((Object)"cn=user3,ou=People,dc=example,dc=com");
        Mockito.when((Object)this.search.findGroupsForUser((String)Mockito.eq((Object)"cn=user1,ou=People,dc=example,dc=com"))).thenReturn(Arrays.asList("cn=SuperUsers,ou=Groups,dc=example,dc=com", "cn=Office1,ou=Groups,dc=example,dc=com", "cn=HiveUsers,ou=Groups,dc=example,dc=com", "cn=G1,ou=Groups,dc=example,dc=com"));
        Mockito.when((Object)this.search.findGroupsForUser((String)Mockito.eq((Object)"cn=user2,ou=People,dc=example,dc=com"))).thenReturn(Arrays.asList("cn=HiveUsers,ou=Groups,dc=example,dc=com"));
        Mockito.when((Object)this.search.findGroupsForUser((String)Mockito.eq((Object)"cn=user3,ou=People,dc=example,dc=com"))).thenReturn(Arrays.asList("cn=G1,ou=Groups,dc=example,dc=com", "cn=G2,ou=Groups,dc=example,dc=com"));
        Filter filter = this.factory.getInstance(this.conf);
        filter.apply(this.search, "user1");
        filter.apply(this.search, "cn=user2,dc=example,dc=com");
        filter.apply(this.search, "user3@mydomain.com");
    }

    @Test(expected=AuthenticationException.class)
    public void testGroupMembershipKeyCaseInsensitiveFilterApplyNegative() throws AuthenticationException, NamingException, IOException {
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_GROUPFILTER, (String)"hiveusers,containsg1");
        Mockito.lenient().when((Object)this.search.findGroupsForUser((String)Mockito.eq((Object)"user1"))).thenReturn(Arrays.asList("SuperUsers", "Office1", "G1", "G2"));
        Filter filter = this.factory.getInstance(this.conf);
        filter.apply(this.search, "user1");
    }

    @Test(expected=AuthenticationException.class)
    public void testGroupMembershipKeyFilterApplyNegative() throws AuthenticationException, NamingException, IOException {
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_GROUPFILTER, (String)"HiveUsers");
        Mockito.lenient().when((Object)this.search.findGroupsForUser((String)Mockito.eq((Object)"user1"))).thenReturn(Arrays.asList("SuperUsers", "Office1", "G1", "G2"));
        Filter filter = this.factory.getInstance(this.conf);
        filter.apply(this.search, "user1");
    }

    @Test
    public void testUserMembershipKeyFilterApplyPositiveWithUserId() throws AuthenticationException, NamingException, IOException {
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_USERMEMBERSHIP_KEY, (String)"memberOf");
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_GROUPFILTER, (String)"Group1,Group2");
        Mockito.when((Object)this.search.findGroupDn("Group1")).thenReturn((Object)"cn=Group1,dc=a,dc=b");
        Mockito.when((Object)this.search.findGroupDn("Group2")).thenReturn((Object)"cn=Group2,dc=a,dc=b");
        Mockito.when((Object)this.search.isUserMemberOfGroup("User1", "cn=Group2,dc=a,dc=b")).thenReturn((Object)true);
        Filter filter = this.factory.getInstance(this.conf);
        filter.apply(this.search, "User1");
    }

    @Test
    public void testUserMembershipKeyFilterApplyPositiveWithUserDn() throws AuthenticationException, NamingException, IOException {
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_USERMEMBERSHIP_KEY, (String)"memberOf");
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_GROUPFILTER, (String)"Group1,Group2");
        Mockito.when((Object)this.search.findGroupDn("Group1")).thenReturn((Object)"cn=Group1,dc=a,dc=b");
        Mockito.when((Object)this.search.findGroupDn("Group2")).thenReturn((Object)"cn=Group2,dc=a,dc=b");
        Mockito.when((Object)this.search.isUserMemberOfGroup("cn=User1,dc=a,dc=b", "cn=Group2,dc=a,dc=b")).thenReturn((Object)true);
        Filter filter = this.factory.getInstance(this.conf);
        filter.apply(this.search, "cn=User1,dc=a,dc=b");
    }

    @Test(expected=AuthenticationException.class)
    public void testUserMembershipKeyFilterApplyNegative() throws AuthenticationException, NamingException, IOException {
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_USERMEMBERSHIP_KEY, (String)"memberOf");
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_GROUPFILTER, (String)"Group1,Group2");
        Mockito.when((Object)this.search.findGroupDn("Group1")).thenReturn((Object)"cn=Group1,dc=a,dc=b");
        Mockito.when((Object)this.search.findGroupDn("Group2")).thenReturn((Object)"cn=Group2,dc=a,dc=b");
        Filter filter = this.factory.getInstance(this.conf);
        filter.apply(this.search, "User1");
    }
}

