/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.ldap;

import java.io.IOException;
import java.util.Arrays;
import javax.naming.NamingException;
import javax.security.sasl.AuthenticationException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.ldap.CustomQueryFilterFactory;
import org.apache.hadoop.hive.metastore.ldap.DirSearch;
import org.apache.hadoop.hive.metastore.ldap.Filter;
import org.apache.hadoop.hive.metastore.ldap.FilterFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestCustomQueryFilter {
    private static final String USER2_DN = "uid=user2,ou=People,dc=example,dc=com";
    private static final String USER1_DN = "uid=user1,ou=People,dc=example,dc=com";
    private static final String CUSTOM_QUERY = "(&(objectClass=person)(|(uid=user1)(uid=user2)))";
    private FilterFactory factory;
    private Configuration conf;
    @Mock
    private DirSearch search;

    @Before
    public void setup() {
        this.conf = MetastoreConf.newMetastoreConf();
        this.conf.set("hive.root.logger", "DEBUG,console");
        this.factory = new CustomQueryFilterFactory();
    }

    @Test
    public void testFactory() {
        this.conf.unset(MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_CUSTOMLDAPQUERY.getVarname());
        Assert.assertNull((Object)this.factory.getInstance(this.conf));
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_CUSTOMLDAPQUERY, (String)CUSTOM_QUERY);
        Assert.assertNotNull((Object)this.factory.getInstance(this.conf));
    }

    @Test
    public void testApplyPositive() throws AuthenticationException, NamingException, IOException {
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_CUSTOMLDAPQUERY, (String)CUSTOM_QUERY);
        Mockito.when((Object)this.search.executeCustomQuery((String)Mockito.eq((Object)CUSTOM_QUERY))).thenReturn(Arrays.asList(USER1_DN, USER2_DN));
        Filter filter = this.factory.getInstance(this.conf);
        filter.apply(this.search, "user1");
        filter.apply(this.search, "user2");
    }

    @Test(expected=AuthenticationException.class)
    public void testApplyNegative() throws AuthenticationException, NamingException, IOException {
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_CUSTOMLDAPQUERY, (String)CUSTOM_QUERY);
        Mockito.when((Object)this.search.executeCustomQuery((String)Mockito.eq((Object)CUSTOM_QUERY))).thenReturn(Arrays.asList(USER1_DN, USER2_DN));
        Filter filter = this.factory.getInstance(this.conf);
        filter.apply(this.search, "user3");
    }
}

