/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.ldap;

import java.io.IOException;
import javax.naming.NamingException;
import javax.security.sasl.AuthenticationException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.ldap.ChainFilterFactory;
import org.apache.hadoop.hive.metastore.ldap.DirSearch;
import org.apache.hadoop.hive.metastore.ldap.Filter;
import org.apache.hadoop.hive.metastore.ldap.FilterFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class TestChainFilter {
    private FilterFactory factory;
    private Configuration conf;
    @Mock
    public Filter filter1;
    @Mock
    public Filter filter2;
    @Mock
    public Filter filter3;
    @Mock
    public FilterFactory factory1;
    @Mock
    public FilterFactory factory2;
    @Mock
    public FilterFactory factory3;
    @Mock
    private DirSearch search;

    @Before
    public void setup() {
        this.conf = MetastoreConf.newMetastoreConf();
        this.factory = new ChainFilterFactory(new FilterFactory[]{this.factory1, this.factory2, this.factory3});
    }

    @Test
    public void testFactoryAllNull() {
        Assert.assertNull((Object)this.factory.getInstance(this.conf));
    }

    @Test
    public void testFactoryAllEmpty() {
        ChainFilterFactory emptyFactory = new ChainFilterFactory(new FilterFactory[0]);
        Assert.assertNull((Object)emptyFactory.getInstance(this.conf));
    }

    @Test
    public void testFactory() throws AuthenticationException {
        Mockito.when((Object)this.factory1.getInstance((Configuration)Mockito.any(Configuration.class))).thenReturn((Object)this.filter1);
        Mockito.when((Object)this.factory2.getInstance((Configuration)Mockito.any(Configuration.class))).thenReturn((Object)this.filter2);
        Mockito.when((Object)this.factory3.getInstance((Configuration)Mockito.any(Configuration.class))).thenReturn((Object)this.filter3);
        Filter filter = this.factory.getInstance(this.conf);
        filter.apply(this.search, "User");
        ((Filter)Mockito.verify((Object)this.filter1, (VerificationMode)Mockito.times((int)1))).apply(this.search, "User");
        ((Filter)Mockito.verify((Object)this.filter2, (VerificationMode)Mockito.times((int)1))).apply(this.search, "User");
        ((Filter)Mockito.verify((Object)this.filter3, (VerificationMode)Mockito.times((int)1))).apply(this.search, "User");
    }

    @Test(expected=AuthenticationException.class)
    public void testApplyNegative() throws AuthenticationException, NamingException, IOException {
        ((Filter)Mockito.doThrow(AuthenticationException.class).when((Object)this.filter3)).apply((DirSearch)Mockito.anyObject(), Mockito.anyString());
        Mockito.when((Object)this.factory1.getInstance((Configuration)Mockito.any(Configuration.class))).thenReturn((Object)this.filter1);
        Mockito.when((Object)this.factory3.getInstance((Configuration)Mockito.any(Configuration.class))).thenReturn((Object)this.filter3);
        Filter filter = this.factory.getInstance(this.conf);
        filter.apply(this.search, "User");
    }
}

