/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.events;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.events.AbortTxnEvent;
import org.apache.hadoop.hive.metastore.messaging.AbortTxnMessage;
import org.apache.hadoop.hive.metastore.messaging.EventMessage;
import org.apache.hadoop.hive.metastore.messaging.MessageBuilder;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageDeserializer;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageEncoder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class TestAbortTxnEventDbsUpdated {
    @Test
    public void testBackwardsCompatibility() {
        String json = "{\"txnid\":12787,\"timestamp\":1654116516,\"server\":\"\",\"servicePrincipal\":\"\"}";
        JSONMessageDeserializer deserializer = new JSONMessageDeserializer();
        AbortTxnMessage abortTxnMsg = deserializer.getAbortTxnMessage("{\"txnid\":12787,\"timestamp\":1654116516,\"server\":\"\",\"servicePrincipal\":\"\"}");
        Assert.assertNull((Object)abortTxnMsg.getDbsUpdated());
        Assert.assertEquals((long)12787L, (long)abortTxnMsg.getTxnId());
    }

    @Test
    public void testSerializeDeserialize() {
        List<String> dbsUpdated = Arrays.asList("db1", "db22");
        AbortTxnEvent event = new AbortTxnEvent(Long.valueOf(999L), TxnType.DEFAULT, null, dbsUpdated);
        AbortTxnMessage msg = MessageBuilder.getInstance().buildAbortTxnMessage(event.getTxnId(), event.getDbsUpdated());
        JSONMessageEncoder msgEncoder = new JSONMessageEncoder();
        String json = msgEncoder.getSerializer().serialize((EventMessage)msg);
        JSONMessageDeserializer deserializer = new JSONMessageDeserializer();
        AbortTxnMessage abortTxnMsg = deserializer.getAbortTxnMessage(json);
        HashSet<String> expected = new HashSet<String>(dbsUpdated);
        Assert.assertEquals((long)expected.size(), (long)abortTxnMsg.getDbsUpdated().size());
        List actual = abortTxnMsg.getDbsUpdated();
        Assert.assertTrue((boolean)actual.remove("db1"));
        Assert.assertTrue((boolean)actual.remove("db22"));
        Assert.assertTrue((boolean)actual.isEmpty());
        Assert.assertEquals((long)999L, (long)abortTxnMsg.getTxnId());
    }
}

