/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.dbinstall.rules;

import org.apache.hadoop.hive.metastore.dbinstall.rules.DatabaseRule;
import org.postgresql.Driver;

public class Postgres
extends DatabaseRule {
    @Override
    public String getDockerImageName() {
        return "postgres:11.6";
    }

    @Override
    public String[] getDockerAdditionalArgs() {
        return this.buildArray("-p", "5432:5432", "-e", "POSTGRES_PASSWORD=" + this.getDbRootPassword(), "-d");
    }

    @Override
    public String getDbType() {
        return "postgres";
    }

    @Override
    public String getDbRootUser() {
        return "postgres";
    }

    @Override
    public String getDbRootPassword() {
        return "its-a-secret";
    }

    @Override
    public String getJdbcDriver() {
        return Driver.class.getName();
    }

    @Override
    public String getJdbcUrl(String hostAddress) {
        return "jdbc:postgresql://" + hostAddress + ":5432/" + "hivedb";
    }

    @Override
    public String getInitialJdbcUrl(String hostAddress) {
        return "jdbc:postgresql://" + hostAddress + ":5432/postgres";
    }

    @Override
    public boolean isContainerReady(DatabaseRule.ProcessResults pr) {
        return pr.stdout.contains("database system is ready to accept connections") && pr.stderr.contains("database system is ready to accept connections");
    }

    @Override
    public String getHivePassword() {
        return "hivepassword";
    }
}

