/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.dbinstall.rules;

import org.apache.hadoop.hive.metastore.dbinstall.rules.DatabaseRule;

public class Oracle
extends DatabaseRule {
    @Override
    public String getDockerImageName() {
        return "abstractdog/oracle-xe:18.4.0-slim";
    }

    @Override
    public String[] getDockerAdditionalArgs() {
        return this.buildArray("-p", "1521:1521", "-d", "-e", "ORACLE_PASSWORD=" + this.getDbRootPassword());
    }

    @Override
    public String getDbType() {
        return "oracle";
    }

    @Override
    public String getDbRootUser() {
        return "SYS as SYSDBA";
    }

    @Override
    public String getDbRootPassword() {
        return "oracle";
    }

    @Override
    public String getJdbcDriver() {
        return "oracle.jdbc.OracleDriver";
    }

    @Override
    public String getJdbcUrl(String hostAddress) {
        return "jdbc:oracle:thin:@//" + hostAddress + ":1521/xe";
    }

    @Override
    public String getInitialJdbcUrl(String hostAddress) {
        return "jdbc:oracle:thin:@//" + hostAddress + ":1521/xe";
    }

    @Override
    public boolean isContainerReady(DatabaseRule.ProcessResults pr) {
        return pr.stdout.contains("DATABASE IS READY TO USE!");
    }

    @Override
    public String getHivePassword() {
        return "hivepassword";
    }

    @Override
    public String getHiveUser() {
        return "c##" + super.getHiveUser();
    }
}

