/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.dbinstall.rules;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hive.metastore.dbinstall.rules.DatabaseRule;

public class Mysql
extends DatabaseRule {
    @Override
    public String getDockerImageName() {
        return "mysql:5.7.37";
    }

    @Override
    public String[] getDockerAdditionalArgs() {
        return this.buildArray("-p", "3306:3306", "-e", "MYSQL_ROOT_PASSWORD=" + this.getDbRootPassword(), "-d");
    }

    @Override
    public String getDbType() {
        return "mysql";
    }

    @Override
    public String getDbRootUser() {
        return "root";
    }

    @Override
    public String getDbRootPassword() {
        return "its-a-secret";
    }

    @Override
    public String getJdbcDriver() {
        return "com.mysql.jdbc.Driver";
    }

    @Override
    public String getJdbcUrl(String hostAddress) {
        return "jdbc:mysql://" + hostAddress + ":3306/" + "hivedb";
    }

    @Override
    public String getInitialJdbcUrl(String hostAddress) {
        return "jdbc:mysql://" + hostAddress + ":3306/?allowPublicKeyRetrieval=true";
    }

    @Override
    public boolean isContainerReady(DatabaseRule.ProcessResults pr) {
        Pattern pat = Pattern.compile("ready for connections");
        Matcher m = pat.matcher(pr.stderr);
        return m.find() && m.find();
    }

    @Override
    public String getHivePassword() {
        return "hivepassword";
    }
}

