/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.datasource;

import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.HikariPoolMXBean;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.jdo.PersistenceManagerFactory;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.PersistenceManagerProvider;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.datasource.DataSourceProvider;
import org.apache.hadoop.hive.metastore.datasource.DataSourceProviderFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class TestDataSourceProviderFactory {
    private Configuration conf;

    @Before
    public void init() {
        this.conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECTION_USER_NAME, (String)"dummyUser");
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.PWD, (String)"dummyPass");
        this.conf.unset(MetastoreConf.ConfVars.CONNECTION_POOLING_TYPE.getVarname());
    }

    @Test
    public void testNoDataSourceCreatedWithoutProps() throws SQLException {
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECTION_POOLING_TYPE, (String)"dummy");
        DataSourceProvider dsp = DataSourceProviderFactory.tryGetDataSourceProviderOrNull((Configuration)this.conf);
        Assert.assertNull((Object)dsp);
    }

    @Test
    public void testSetHikariCpLeakDetectionThresholdProperty() throws SQLException {
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECTION_POOLING_TYPE, (String)"hikaricp");
        this.conf.set("hikaricp.leakDetectionThreshold", "3600");
        this.conf.set("hikaricp.initializationFailTimeout", "-1");
        DataSourceProvider dsp = DataSourceProviderFactory.tryGetDataSourceProviderOrNull((Configuration)this.conf);
        Assert.assertNotNull((Object)dsp);
        DataSource ds = dsp.create(this.conf);
        Assert.assertTrue((boolean)(ds instanceof HikariDataSource));
        Assert.assertEquals((long)3600L, (long)((HikariDataSource)ds).getLeakDetectionThreshold());
    }

    @Test
    public void testCreateHikariCpDataSource() throws SQLException {
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECTION_POOLING_TYPE, (String)"hikaricp");
        this.conf.set("hikaricp.initializationFailTimeout", "-1");
        DataSourceProvider dsp = DataSourceProviderFactory.tryGetDataSourceProviderOrNull((Configuration)this.conf);
        Assert.assertNotNull((Object)dsp);
        DataSource ds = dsp.create(this.conf);
        Assert.assertTrue((boolean)(ds instanceof HikariDataSource));
    }

    @Test
    public void testSetHikariCpStringProperty() throws SQLException {
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECTION_POOLING_TYPE, (String)"hikaricp");
        this.conf.set("hikaricp.connectionInitSql", "select 1 from dual");
        this.conf.set("hikaricp.initializationFailTimeout", "-1");
        DataSourceProvider dsp = DataSourceProviderFactory.tryGetDataSourceProviderOrNull((Configuration)this.conf);
        Assert.assertNotNull((Object)dsp);
        DataSource ds = dsp.create(this.conf);
        Assert.assertTrue((boolean)(ds instanceof HikariDataSource));
        Assert.assertEquals((Object)"select 1 from dual", (Object)((HikariDataSource)ds).getConnectionInitSql());
    }

    @Test
    public void testSetHikariCpNumberProperty() throws SQLException {
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECTION_POOLING_TYPE, (String)"hikaricp");
        this.conf.set("hikaricp.idleTimeout", "59999");
        this.conf.set("hikaricp.initializationFailTimeout", "-1");
        DataSourceProvider dsp = DataSourceProviderFactory.tryGetDataSourceProviderOrNull((Configuration)this.conf);
        Assert.assertNotNull((Object)dsp);
        DataSource ds = dsp.create(this.conf);
        Assert.assertTrue((boolean)(ds instanceof HikariDataSource));
        Assert.assertEquals((long)59999L, (long)((HikariDataSource)ds).getIdleTimeout());
    }

    @Test
    public void testSetHikariCpBooleanProperty() throws SQLException {
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECTION_POOLING_TYPE, (String)"hikaricp");
        this.conf.set("hikaricp.allowPoolSuspension", "false");
        this.conf.set("hikaricp.initializationFailTimeout", "-1");
        DataSourceProvider dsp = DataSourceProviderFactory.tryGetDataSourceProviderOrNull((Configuration)this.conf);
        Assert.assertNotNull((Object)dsp);
        DataSource ds = dsp.create(this.conf);
        Assert.assertTrue((boolean)(ds instanceof HikariDataSource));
        Assert.assertEquals((Object)false, (Object)((HikariDataSource)ds).isAllowPoolSuspension());
    }

    @Test
    public void testCreateDbCpDataSource() throws SQLException {
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECTION_POOLING_TYPE, (String)"dbcp");
        DataSourceProvider dsp = DataSourceProviderFactory.tryGetDataSourceProviderOrNull((Configuration)this.conf);
        Assert.assertNotNull((Object)dsp);
        DataSource ds = dsp.create(this.conf);
        Assert.assertTrue((boolean)(ds instanceof PoolingDataSource));
    }

    @Test
    public void testEvictIdleConnection() throws Exception {
        String[] dataSourceType = new String[]{"hikaricp", "dbcp"};
        try (DataSourceProvider.DataSourceNameConfigurator configurator = new DataSourceProvider.DataSourceNameConfigurator(this.conf, "mutex");){
            for (String type : dataSourceType) {
                MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECTION_POOLING_TYPE, (String)type);
                boolean isHikari = "hikaricp".equals(type);
                if (isHikari) {
                    this.conf.unset("hikaricp.connectionInitSql");
                    this.conf.set("hikaricp.idleTimeout", "10000");
                    System.setProperty("com.zaxxer.hikari.housekeeping.periodMs", "1000");
                } else {
                    this.conf.set("dbcp.timeBetweenEvictionRunsMillis", "1000");
                    this.conf.set("dbcp.softMinEvictableIdleTimeMillis", "3000");
                    this.conf.set("dbcp.maxIdle", "0");
                }
                DataSourceProvider dsp = DataSourceProviderFactory.tryGetDataSourceProviderOrNull((Configuration)this.conf);
                DataSource ds = dsp.create(this.conf, 5);
                ArrayList<Connection> connections = new ArrayList<Connection>();
                for (int i = 0; i < 5; ++i) {
                    connections.add(ds.getConnection());
                }
                HikariPoolMXBean poolMXBean = null;
                GenericObjectPool objectPool = null;
                if (isHikari) {
                    poolMXBean = ((HikariDataSource)ds).getHikariPoolMXBean();
                    Assert.assertEquals((String)type, (long)5L, (long)poolMXBean.getTotalConnections());
                    Assert.assertEquals((String)type, (long)5L, (long)poolMXBean.getActiveConnections());
                } else {
                    objectPool = (GenericObjectPool)MethodUtils.invokeMethod((Object)ds, (boolean)true, (String)"getPool");
                    Assert.assertEquals((String)type, (long)5L, (long)objectPool.getNumActive());
                    Assert.assertEquals((String)type, (long)5L, (long)objectPool.getMaxTotal());
                }
                connections.forEach(connection -> {
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                });
                Thread.sleep(isHikari ? 15000L : 7000L);
                if (isHikari) {
                    Assert.assertEquals((String)type, (long)2L, (long)poolMXBean.getTotalConnections());
                    Assert.assertEquals((String)type, (long)2L, (long)poolMXBean.getIdleConnections());
                    continue;
                }
                Assert.assertEquals((String)type, (long)0L, (long)objectPool.getNumActive());
                Assert.assertEquals((String)type, (long)0L, (long)objectPool.getNumIdle());
            }
        }
    }

    @Test
    public void testClosePersistenceManagerProvider() throws Exception {
        String[] dataSourceType;
        for (String type : dataSourceType = new String[]{"hikaricp", "dbcp"}) {
            boolean isHikari = "hikaricp".equals(type);
            MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECTION_POOLING_TYPE, (String)type);
            PersistenceManagerProvider.updatePmfProperties((Configuration)this.conf);
            PersistenceManagerFactory factory = PersistenceManagerProvider.getPersistenceManager().getPersistenceManagerFactory();
            DataSource connFactory = (DataSource)factory.getConnectionFactory();
            DataSource connFactory2 = (DataSource)factory.getConnectionFactory2();
            factory.close();
            if (isHikari) {
                Assert.assertFalse((boolean)((HikariDataSource)connFactory).isClosed());
                Assert.assertFalse((boolean)((HikariDataSource)connFactory2).isClosed());
            }
            try (Connection conn = connFactory.getConnection();){
                Assert.assertFalse((boolean)conn.isClosed());
            }
            PersistenceManagerProvider.closePmfInternal((PersistenceManagerFactory)factory);
            if (isHikari) {
                Assert.assertTrue((boolean)((HikariDataSource)connFactory).isClosed());
                Assert.assertTrue((boolean)((HikariDataSource)connFactory2).isClosed());
            }
            try {
                connFactory.getConnection();
                Assert.fail((String)"Should fail as the DataSource is shutdown");
            }
            catch (Exception e) {
                if (isHikari) {
                    Assert.assertTrue((boolean)(e instanceof SQLException));
                    continue;
                }
                Assert.assertTrue((boolean)(e instanceof IllegalStateException));
            }
        }
    }
}

