/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.columnstats.merge;

import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Date;
import org.apache.hadoop.hive.metastore.columnstats.ColStatsBuilder;
import org.apache.hadoop.hive.metastore.columnstats.cache.DateColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.merge.ColumnStatsMergerTest;
import org.apache.hadoop.hive.metastore.columnstats.merge.DateColumnStatsMerger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class DateColumnStatsMergerTest {
    private static final Date DATE_1 = new Date(1L);
    private static final Date DATE_2 = new Date(2L);
    private static final Date DATE_3 = new Date(3L);
    private static final DateColumnStatsDataInspector DATA_1 = new DateColumnStatsDataInspector();
    private static final DateColumnStatsDataInspector DATA_2 = new DateColumnStatsDataInspector();
    private static final DateColumnStatsDataInspector DATA_3 = new DateColumnStatsDataInspector();
    private final DateColumnStatsMerger merger = new DateColumnStatsMerger();

    @Test
    public void testMergeNullValues() {
        ColumnStatisticsObj aggrObj = ColumnStatsMergerTest.createColumnStatisticsObj(new ColStatsBuilder<Date>(Date.class).low(null).high(null).numNulls(1L).numDVs(0L).build());
        this.merger.merge(aggrObj, aggrObj);
        ColumnStatisticsData expectedColumnStatisticsData = new ColStatsBuilder<Date>(Date.class).low(null).high(null).numNulls(2L).numDVs(0L).build();
        Assert.assertEquals((Object)expectedColumnStatisticsData, (Object)aggrObj.getStatsData());
    }

    @Test
    public void testMergeNullWithNonNullValues() {
        ColumnStatisticsObj aggrObj = ColumnStatsMergerTest.createColumnStatisticsObj(new ColStatsBuilder<Date>(Date.class).low(null).high(null).numNulls(0L).numDVs(0L).build());
        ColumnStatisticsObj newObj = ColumnStatsMergerTest.createColumnStatisticsObj(new ColStatsBuilder<Date>(Date.class).low(DATE_1).high(DATE_3).numNulls(4L).numDVs(2L).hll(DATE_1.getDaysSinceEpoch(), DATE_3.getDaysSinceEpoch(), DATE_3.getDaysSinceEpoch()).kll(DATE_1.getDaysSinceEpoch(), DATE_3.getDaysSinceEpoch(), DATE_3.getDaysSinceEpoch()).build());
        this.merger.merge(aggrObj, newObj);
        ColumnStatisticsData expectedColumnStatisticsData = new ColStatsBuilder<Date>(Date.class).low(DATE_1).high(DATE_3).numNulls(4L).numDVs(2L).hll(DATE_1.getDaysSinceEpoch(), DATE_3.getDaysSinceEpoch(), DATE_3.getDaysSinceEpoch()).kll(DATE_1.getDaysSinceEpoch(), DATE_3.getDaysSinceEpoch(), DATE_3.getDaysSinceEpoch()).build();
        Assert.assertEquals((Object)expectedColumnStatisticsData, (Object)aggrObj.getStatsData());
    }

    @Test
    public void testMergeNonNullWithNullValues() {
        ColumnStatisticsObj aggrObj = ColumnStatsMergerTest.createColumnStatisticsObj(new ColStatsBuilder<Date>(Date.class).low(DATE_1).high(DATE_3).numNulls(4L).numDVs(2L).hll(DATE_1.getDaysSinceEpoch(), DATE_3.getDaysSinceEpoch(), DATE_3.getDaysSinceEpoch()).kll(DATE_1.getDaysSinceEpoch(), DATE_3.getDaysSinceEpoch(), DATE_3.getDaysSinceEpoch()).build());
        ColumnStatisticsObj newObj = ColumnStatsMergerTest.createColumnStatisticsObj(new ColStatsBuilder<Date>(Date.class).low(null).high(null).numNulls(2L).numDVs(0L).build());
        this.merger.merge(aggrObj, newObj);
        ColumnStatisticsData expectedColumnStatisticsData = new ColStatsBuilder<Date>(Date.class).low(DATE_1).high(DATE_3).numNulls(6L).numDVs(2L).hll(DATE_1.getDaysSinceEpoch(), DATE_3.getDaysSinceEpoch(), DATE_3.getDaysSinceEpoch()).kll(DATE_1.getDaysSinceEpoch(), DATE_3.getDaysSinceEpoch(), DATE_3.getDaysSinceEpoch()).build();
        Assert.assertEquals((Object)expectedColumnStatisticsData, (Object)aggrObj.getStatsData());
    }

    @Test
    public void testMergeNonNullValues() {
        ColumnStatisticsObj aggrObj = ColumnStatsMergerTest.createColumnStatisticsObj(new ColStatsBuilder<Date>(Date.class).low(DATE_2).high(DATE_2).numNulls(2L).numDVs(1L).hll(DATE_2.getDaysSinceEpoch()).kll(DATE_2.getDaysSinceEpoch()).build());
        ColumnStatisticsObj newObj = ColumnStatsMergerTest.createColumnStatisticsObj(new ColStatsBuilder<Date>(Date.class).low(DATE_3).high(DATE_3).numNulls(3L).numDVs(1L).hll(DATE_3.getDaysSinceEpoch()).kll(DATE_3.getDaysSinceEpoch()).build());
        this.merger.merge(aggrObj, newObj);
        newObj = ColumnStatsMergerTest.createColumnStatisticsObj(new ColStatsBuilder<Date>(Date.class).low(DATE_1).high(DATE_1).numNulls(1L).numDVs(1L).hll(DATE_1.getDaysSinceEpoch(), DATE_1.getDaysSinceEpoch()).kll(DATE_1.getDaysSinceEpoch(), DATE_1.getDaysSinceEpoch()).build());
        this.merger.merge(aggrObj, newObj);
        ColumnStatisticsData expectedColumnStatisticsData = new ColStatsBuilder<Date>(Date.class).low(DATE_1).high(DATE_3).numNulls(6L).numDVs(3L).hll(DATE_2.getDaysSinceEpoch(), DATE_3.getDaysSinceEpoch(), DATE_1.getDaysSinceEpoch(), DATE_1.getDaysSinceEpoch()).kll(DATE_2.getDaysSinceEpoch(), DATE_3.getDaysSinceEpoch(), DATE_1.getDaysSinceEpoch(), DATE_1.getDaysSinceEpoch()).build();
        Assert.assertEquals((Object)expectedColumnStatisticsData, (Object)aggrObj.getStatsData());
    }

    @Test
    public void testCompareSimple() {
        DateColumnStatsDataInspector data1 = new DateColumnStatsDataInspector(DATA_1);
        DateColumnStatsDataInspector data2 = new DateColumnStatsDataInspector(DATA_2);
        Assert.assertEquals((Object)DATE_2, (Object)this.merger.mergeHighValue(this.merger.getHighValue(data1), this.merger.getHighValue(data2)));
    }

    @Test
    public void testCompareSimpleFlipped() {
        DateColumnStatsDataInspector data1 = new DateColumnStatsDataInspector(DATA_2);
        DateColumnStatsDataInspector data2 = new DateColumnStatsDataInspector(DATA_1);
        Assert.assertEquals((Object)DATE_2, (Object)this.merger.mergeHighValue(this.merger.getHighValue(data1), this.merger.getHighValue(data2)));
    }

    @Test
    public void testCompareSimpleReversed() {
        DateColumnStatsDataInspector data1 = new DateColumnStatsDataInspector(DATA_1);
        DateColumnStatsDataInspector data2 = new DateColumnStatsDataInspector(DATA_2);
        Assert.assertEquals((Object)DATE_1, (Object)this.merger.mergeLowValue(this.merger.getLowValue(data1), this.merger.getLowValue(data2)));
    }

    @Test
    public void testCompareSimpleFlippedReversed() {
        DateColumnStatsDataInspector data1 = new DateColumnStatsDataInspector(DATA_2);
        DateColumnStatsDataInspector data2 = new DateColumnStatsDataInspector(DATA_1);
        Assert.assertEquals((Object)DATE_1, (Object)this.merger.mergeLowValue(this.merger.getLowValue(data1), this.merger.getLowValue(data2)));
    }

    @Test
    public void testCompareNullsMin() {
        DateColumnStatsDataInspector data1 = new DateColumnStatsDataInspector();
        DateColumnStatsDataInspector data2 = new DateColumnStatsDataInspector();
        Assert.assertNull((Object)this.merger.mergeLowValue(this.merger.getLowValue(data1), this.merger.getLowValue(data2)));
    }

    @Test
    public void testCompareNullsMax() {
        DateColumnStatsDataInspector data1 = new DateColumnStatsDataInspector();
        DateColumnStatsDataInspector data2 = new DateColumnStatsDataInspector();
        Assert.assertNull((Object)this.merger.mergeHighValue(this.merger.getHighValue(data1), this.merger.getHighValue(data2)));
    }

    @Test
    public void testCompareFirstNullMin() {
        DateColumnStatsDataInspector data1 = new DateColumnStatsDataInspector();
        DateColumnStatsDataInspector data2 = new DateColumnStatsDataInspector(DATA_1);
        Assert.assertEquals((Object)DATE_1, (Object)this.merger.mergeLowValue(this.merger.getLowValue(data1), this.merger.getLowValue(data2)));
    }

    @Test
    public void testCompareSecondNullMin() {
        DateColumnStatsDataInspector data1 = new DateColumnStatsDataInspector(DATA_1);
        DateColumnStatsDataInspector data2 = new DateColumnStatsDataInspector();
        Assert.assertEquals((Object)DATE_1, (Object)this.merger.mergeLowValue(this.merger.getLowValue(data1), this.merger.getLowValue(data2)));
    }

    @Test
    public void testCompareFirstNullMax() {
        DateColumnStatsDataInspector data1 = new DateColumnStatsDataInspector(DATA_1);
        DateColumnStatsDataInspector data2 = new DateColumnStatsDataInspector();
        Assert.assertEquals((Object)DATE_1, (Object)this.merger.mergeHighValue(this.merger.getHighValue(data1), this.merger.getHighValue(data2)));
    }

    @Test
    public void testCompareSecondNullMax() {
        DateColumnStatsDataInspector data1 = new DateColumnStatsDataInspector();
        DateColumnStatsDataInspector data2 = new DateColumnStatsDataInspector(DATA_1);
        Assert.assertEquals((Object)DATE_1, (Object)this.merger.mergeHighValue(this.merger.getHighValue(data1), this.merger.getHighValue(data2)));
    }

    static {
        DATA_1.setLowValue(DATE_1);
        DATA_1.setHighValue(DATE_1);
        DATA_2.setLowValue(DATE_2);
        DATA_2.setHighValue(DATE_2);
        DATA_3.setLowValue(DATE_3);
        DATA_3.setHighValue(DATE_3);
    }
}

