/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.columnstats.aggr;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.metastore.StatisticsTestUtils;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.columnstats.ColStatsBuilder;
import org.apache.hadoop.hive.metastore.columnstats.aggr.StringColumnStatsAggregator;
import org.apache.hadoop.hive.metastore.utils.MetaStoreServerUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class StringColumnStatsAggregatorTest {
    private static final Table TABLE = new Table("dummy", "db", "hive", 0, 0, 0, null, null, Collections.emptyMap(), null, null, TableType.MANAGED_TABLE.toString());
    private static final FieldSchema COL = new FieldSchema("col", "string", "");
    private static final String S_1 = "test";
    private static final String S_2 = "try";
    private static final String S_3 = "longer string";
    private static final String S_4 = "even longer string";
    private static final String S_5 = "some string";
    private static final String S_6 = "some other string";
    private static final String S_7 = "yet another string";

    @Test
    public void testAggregateSingleStat() throws MetaException {
        List<String> partitions = Collections.singletonList("part1");
        ColumnStatisticsData data1 = new ColStatsBuilder<String>(String.class).numNulls(1L).numDVs(2L).avgColLen(8.5).maxColLen(13L).hll(S_1, S_3).build();
        List<MetaStoreServerUtils.ColStatsObjWithSourceInfo> statsList = Collections.singletonList(StatisticsTestUtils.createStatsWithInfo(data1, TABLE, COL, partitions.get(0)));
        StringColumnStatsAggregator aggregator = new StringColumnStatsAggregator();
        ColumnStatisticsObj computedStatsObj = aggregator.aggregate(statsList, partitions, true);
        Assert.assertEquals((Object)data1, (Object)computedStatsObj.getStatsData());
    }

    @Test
    public void testAggregateMultiStatsWhenAllAvailable() throws MetaException {
        List<String> partitions = Arrays.asList("part1", "part2", "part3");
        ColumnStatisticsData data1 = new ColStatsBuilder<String>(String.class).numNulls(1L).numDVs(3L).avgColLen(6.666666666666667).maxColLen(13L).hll(S_1, S_2, S_3).build();
        ColumnStatisticsData data2 = new ColStatsBuilder<String>(String.class).numNulls(2L).numDVs(3L).avgColLen(14.0).maxColLen(18L).hll(S_3, S_4, S_5).build();
        ColumnStatisticsData data3 = new ColStatsBuilder<String>(String.class).numNulls(3L).numDVs(2L).avgColLen(17.5).maxColLen(18L).hll(S_6, S_7).build();
        List<MetaStoreServerUtils.ColStatsObjWithSourceInfo> statsList = Arrays.asList(StatisticsTestUtils.createStatsWithInfo(data1, TABLE, COL, partitions.get(0)), StatisticsTestUtils.createStatsWithInfo(data2, TABLE, COL, partitions.get(1)), StatisticsTestUtils.createStatsWithInfo(data3, TABLE, COL, partitions.get(2)));
        StringColumnStatsAggregator aggregator = new StringColumnStatsAggregator();
        ColumnStatisticsObj computedStatsObj = aggregator.aggregate(statsList, partitions, true);
        ColumnStatisticsData expectedStats = new ColStatsBuilder<String>(String.class).numNulls(6L).numDVs(7L).avgColLen(17.5).maxColLen(18L).hll(S_1, S_2, S_3).build();
        Assert.assertEquals((Object)expectedStats, (Object)computedStatsObj.getStatsData());
    }

    @Test
    public void testAggregateMultiStatsWhenUnmergeableBitVectors() throws MetaException {
        double[] tunerValues;
        List<String> partitions = Arrays.asList("part1", "part2", "part3");
        ColumnStatisticsData data1 = new ColStatsBuilder<String>(String.class).numNulls(1L).numDVs(3L).avgColLen(6.666666666666667).maxColLen(13L).fmSketch(S_1, S_2, S_3).build();
        ColumnStatisticsData data2 = new ColStatsBuilder<String>(String.class).numNulls(2L).numDVs(3L).avgColLen(14.0).maxColLen(18L).hll(S_3, S_4, S_5).build();
        ColumnStatisticsData data3 = new ColStatsBuilder<String>(String.class).numNulls(3L).numDVs(2L).avgColLen(17.5).maxColLen(18L).hll(S_6, S_7).build();
        List<MetaStoreServerUtils.ColStatsObjWithSourceInfo> statsList = Arrays.asList(StatisticsTestUtils.createStatsWithInfo(data1, TABLE, COL, partitions.get(0)), StatisticsTestUtils.createStatsWithInfo(data2, TABLE, COL, partitions.get(1)), StatisticsTestUtils.createStatsWithInfo(data3, TABLE, COL, partitions.get(2)));
        StringColumnStatsAggregator aggregator = new StringColumnStatsAggregator();
        ColumnStatisticsObj computedStatsObj = aggregator.aggregate(statsList, partitions, true);
        ColumnStatisticsData expectedStats = new ColStatsBuilder<String>(String.class).numNulls(6L).numDVs(3L).avgColLen(17.5).maxColLen(18L).fmSketch(S_1, S_2, S_3).build();
        Assert.assertEquals((Object)expectedStats, (Object)computedStatsObj.getStatsData());
        aggregator.useDensityFunctionForNDVEstimation = true;
        computedStatsObj = aggregator.aggregate(statsList, partitions, true);
        Assert.assertEquals((Object)expectedStats, (Object)computedStatsObj.getStatsData());
        aggregator.useDensityFunctionForNDVEstimation = false;
        double[] dArray = tunerValues = new double[]{0.0, 0.5, 0.75, 1.0};
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double tunerValue;
            aggregator.ndvTuner = tunerValue = dArray[i];
            computedStatsObj = aggregator.aggregate(statsList, partitions, true);
            Assert.assertEquals((Object)expectedStats, (Object)computedStatsObj.getStatsData());
        }
    }

    @Test
    public void testAggregateMultiStatsWhenOnlySomeAvailable() throws MetaException {
        List<String> partitions = Arrays.asList("part1", "part2", "part3", "part4");
        ColumnStatisticsData data1 = new ColStatsBuilder<String>(String.class).numNulls(1L).numDVs(3L).avgColLen(6.666666666666667).maxColLen(13L).hll(S_1, S_2, S_3).build();
        ColumnStatisticsData data3 = new ColStatsBuilder<String>(String.class).numNulls(3L).numDVs(2L).avgColLen(17.5).maxColLen(18L).hll(S_6, S_7).build();
        ColumnStatisticsData data4 = new ColStatsBuilder<String>(String.class).numNulls(2L).numDVs(3L).avgColLen(14.0).maxColLen(18L).hll(S_3, S_4, S_5).build();
        List<MetaStoreServerUtils.ColStatsObjWithSourceInfo> statsList = Arrays.asList(StatisticsTestUtils.createStatsWithInfo(data1, TABLE, COL, partitions.get(0)), StatisticsTestUtils.createStatsWithInfo(data3, TABLE, COL, partitions.get(2)), StatisticsTestUtils.createStatsWithInfo(data4, TABLE, COL, partitions.get(3)));
        StringColumnStatsAggregator aggregator = new StringColumnStatsAggregator();
        ColumnStatisticsObj computedStatsObj = aggregator.aggregate(statsList, partitions, false);
        ColumnStatisticsData expectedStats = new ColStatsBuilder<String>(String.class).numNulls(8L).numDVs(6L).avgColLen(24.0).maxColLen(24L).build();
        Assert.assertEquals((Object)expectedStats, (Object)computedStatsObj.getStatsData());
    }

    @Test
    public void testAggregateMultiStatsOnlySomeAvailableButUnmergeableBitVector() throws MetaException {
        List<String> partitions = Arrays.asList("part1", "part2", "part3");
        ColumnStatisticsData data1 = new ColStatsBuilder<String>(String.class).numNulls(1L).numDVs(3L).avgColLen(6.666666666666667).maxColLen(13L).fmSketch(S_1, S_2, S_3).build();
        ColumnStatisticsData data3 = new ColStatsBuilder<String>(String.class).numNulls(3L).numDVs(2L).avgColLen(17.5).maxColLen(18L).hll(S_6, S_7).build();
        List<MetaStoreServerUtils.ColStatsObjWithSourceInfo> statsList = Arrays.asList(StatisticsTestUtils.createStatsWithInfo(data1, TABLE, COL, partitions.get(0)), StatisticsTestUtils.createStatsWithInfo(data3, TABLE, COL, partitions.get(2)));
        StringColumnStatsAggregator aggregator = new StringColumnStatsAggregator();
        ColumnStatisticsObj computedStatsObj = aggregator.aggregate(statsList, partitions, false);
        ColumnStatisticsData expectedStats = new ColStatsBuilder<String>(String.class).numNulls(6L).numDVs(3L).avgColLen(22.916666666666668).maxColLen(22L).build();
        Assert.assertEquals((Object)expectedStats, (Object)computedStatsObj.getStatsData());
        aggregator.useDensityFunctionForNDVEstimation = true;
        computedStatsObj = aggregator.aggregate(statsList, partitions, false);
        Assert.assertEquals((Object)expectedStats, (Object)computedStatsObj.getStatsData());
    }
}

