/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.columnstats.aggr;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.metastore.StatisticsTestUtils;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.columnstats.ColStatsBuilder;
import org.apache.hadoop.hive.metastore.columnstats.aggr.LongColumnStatsAggregator;
import org.apache.hadoop.hive.metastore.utils.MetaStoreServerUtils;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class LongColumnStatsAggregatorTest {
    private static final Table TABLE = new Table("dummy", "db", "hive", 0, 0, 0, null, null, Collections.emptyMap(), null, null, TableType.MANAGED_TABLE.toString());
    private static final FieldSchema COL = new FieldSchema("col", "int", "");

    @Test
    public void testAggregateSingleStat() throws MetaException {
        List<String> partitions = Collections.singletonList("part1");
        ColumnStatisticsData data1 = new ColStatsBuilder<Long>(Long.TYPE).numNulls(1L).numDVs(2L).low(1L).high(4L).hll(1L, 4L).kll(1L, 4L).build();
        List<MetaStoreServerUtils.ColStatsObjWithSourceInfo> statsList = Collections.singletonList(StatisticsTestUtils.createStatsWithInfo(data1, TABLE, COL, partitions.get(0)));
        LongColumnStatsAggregator aggregator = new LongColumnStatsAggregator();
        ColumnStatisticsObj computedStatsObj = aggregator.aggregate(statsList, partitions, true);
        StatisticsTestUtils.assertEqualStatistics(data1, computedStatsObj.getStatsData());
    }

    @Test
    public void testAggregateSingleStatWhenNullValues() throws MetaException {
        List<String> partitions = Collections.singletonList("part1");
        ColumnStatisticsData data1 = new ColStatsBuilder<Long>(Long.TYPE).numNulls(1L).numDVs(2L).build();
        List<MetaStoreServerUtils.ColStatsObjWithSourceInfo> statsList = Collections.singletonList(StatisticsTestUtils.createStatsWithInfo(data1, TABLE, COL, partitions.get(0)));
        LongColumnStatsAggregator aggregator = new LongColumnStatsAggregator();
        ColumnStatisticsObj computedStatsObj = aggregator.aggregate(statsList, partitions, true);
        StatisticsTestUtils.assertEqualStatistics(data1, computedStatsObj.getStatsData());
        aggregator.useDensityFunctionForNDVEstimation = true;
        computedStatsObj = aggregator.aggregate(statsList, partitions, true);
        StatisticsTestUtils.assertEqualStatistics(data1, computedStatsObj.getStatsData());
        aggregator.useDensityFunctionForNDVEstimation = false;
        aggregator.ndvTuner = 1.0;
        computedStatsObj = aggregator.aggregate(statsList, partitions, true);
        StatisticsTestUtils.assertEqualStatistics(data1, computedStatsObj.getStatsData());
    }

    @Test
    public void testAggregateMultipleStatsWhenSomeNullValues() throws MetaException {
        List<String> partitions = Arrays.asList("part1", "part2");
        ColumnStatisticsData data1 = new ColStatsBuilder<Long>(Long.TYPE).numNulls(1L).numDVs(2L).low(1L).high(2L).hll(1L, 2L).build();
        ColumnStatisticsData data2 = new ColStatsBuilder<Long>(Long.TYPE).numNulls(2L).numDVs(3L).build();
        List<MetaStoreServerUtils.ColStatsObjWithSourceInfo> statsList = Arrays.asList(StatisticsTestUtils.createStatsWithInfo(data1, TABLE, COL, partitions.get(0)), StatisticsTestUtils.createStatsWithInfo(data2, TABLE, COL, partitions.get(1)));
        LongColumnStatsAggregator aggregator = new LongColumnStatsAggregator();
        ColumnStatisticsObj computedStatsObj = aggregator.aggregate(statsList, partitions, true);
        ColumnStatisticsData expectedStats = new ColStatsBuilder<Long>(Long.TYPE).numNulls(3L).numDVs(3L).low(1L).high(2L).hll(1L, 2L).build();
        StatisticsTestUtils.assertEqualStatistics(expectedStats, computedStatsObj.getStatsData());
        aggregator.useDensityFunctionForNDVEstimation = true;
        computedStatsObj = aggregator.aggregate(statsList, partitions, true);
        expectedStats = new ColStatsBuilder<Long>(Long.TYPE).numNulls(3L).numDVs(4L).low(1L).high(2L).hll(1L, 2L).build();
        StatisticsTestUtils.assertEqualStatistics(expectedStats, computedStatsObj.getStatsData());
        aggregator.useDensityFunctionForNDVEstimation = false;
        aggregator.ndvTuner = 1.0;
        computedStatsObj = aggregator.aggregate(statsList, partitions, true);
        expectedStats = new ColStatsBuilder<Long>(Long.TYPE).numNulls(3L).numDVs(5L).low(1L).high(2L).hll(1L, 2L).build();
        StatisticsTestUtils.assertEqualStatistics(expectedStats, computedStatsObj.getStatsData());
    }

    @Test
    public void testAggregateMultiStatsWhenAllAvailable() throws MetaException {
        List<String> partitions = Arrays.asList("part1", "part2", "part3");
        ColumnStatisticsData data1 = new ColStatsBuilder<Long>(Long.TYPE).numNulls(1L).numDVs(3L).low(1L).high(3L).hll(1L, 2L, 3L).kll(1L, 2L, 3L).build();
        ColumnStatisticsData data2 = new ColStatsBuilder<Long>(Long.TYPE).numNulls(2L).numDVs(3L).low(3L).high(5L).hll(3L, 4L, 5L).kll(3L, 4L, 5L).build();
        ColumnStatisticsData data3 = new ColStatsBuilder<Long>(Long.TYPE).numNulls(3L).numDVs(2L).low(6L).high(7L).hll(6L, 7L).kll(6L, 7L).build();
        List<MetaStoreServerUtils.ColStatsObjWithSourceInfo> statsList = Arrays.asList(StatisticsTestUtils.createStatsWithInfo(data1, TABLE, COL, partitions.get(0)), StatisticsTestUtils.createStatsWithInfo(data2, TABLE, COL, partitions.get(1)), StatisticsTestUtils.createStatsWithInfo(data3, TABLE, COL, partitions.get(2)));
        LongColumnStatsAggregator aggregator = new LongColumnStatsAggregator();
        ColumnStatisticsObj computedStatsObj = aggregator.aggregate(statsList, partitions, true);
        ColumnStatisticsData expectedStats = new ColStatsBuilder<Long>(Long.TYPE).numNulls(6L).numDVs(7L).low(1L).high(7L).hll(1L, 2L, 3L).kll(1L, 2L, 3L, 3L, 4L, 5L, 6L, 7L).build();
        StatisticsTestUtils.assertEqualStatistics(expectedStats, computedStatsObj.getStatsData());
    }

    @Test
    public void testAggregateMultiStatsWhenUnmergeableBitVectors() throws MetaException {
        List<String> partitions = Arrays.asList("part1", "part2", "part3");
        long[] values = new long[]{1L, 2L, 3L, 3L, 4L, 5L, 1L, 2L, 6L, 8L};
        ColumnStatisticsData data1 = new ColStatsBuilder<Long>(Long.TYPE).numNulls(1L).numDVs(3L).low(1L).high(3L).fmSketch(1L, 2L, 3L).kll(1L, 2L, 3L).build();
        ColumnStatisticsData data2 = new ColStatsBuilder<Long>(Long.TYPE).numNulls(2L).numDVs(3L).low(3L).high(5L).hll(3L, 4L, 5L).kll(3L, 4L, 5L).build();
        ColumnStatisticsData data3 = new ColStatsBuilder<Long>(Long.TYPE).numNulls(3L).numDVs(4L).low(1L).high(8L).hll(1L, 2L, 6L, 8L).kll(1L, 2L, 6L, 8L).build();
        List<MetaStoreServerUtils.ColStatsObjWithSourceInfo> statsList = Arrays.asList(StatisticsTestUtils.createStatsWithInfo(data1, TABLE, COL, partitions.get(0)), StatisticsTestUtils.createStatsWithInfo(data2, TABLE, COL, partitions.get(1)), StatisticsTestUtils.createStatsWithInfo(data3, TABLE, COL, partitions.get(2)));
        LongColumnStatsAggregator aggregator = new LongColumnStatsAggregator();
        ColumnStatisticsObj computedStatsObj = aggregator.aggregate(statsList, partitions, true);
        ColumnStatisticsData expectedStats = new ColStatsBuilder<Long>(Long.TYPE).numNulls(6L).numDVs(4L).low(1L).high(8L).fmSketch(1L, 2L, 3L).kll(values).build();
        StatisticsTestUtils.assertEqualStatistics(expectedStats, computedStatsObj.getStatsData());
        aggregator.useDensityFunctionForNDVEstimation = true;
        computedStatsObj = aggregator.aggregate(statsList, partitions, true);
        expectedStats = new ColStatsBuilder<Long>(Long.TYPE).numNulls(6L).numDVs(6L).low(1L).high(8L).fmSketch(1L, 2L, 3L).kll(values).build();
        StatisticsTestUtils.assertEqualStatistics(expectedStats, computedStatsObj.getStatsData());
        aggregator.useDensityFunctionForNDVEstimation = false;
        double[] tunerValues = new double[]{0.0, 0.5, 0.75, 1.0};
        long[] expectedDVs = new long[]{4L, 7L, 8L, 10L};
        for (int i = 0; i < tunerValues.length; ++i) {
            aggregator.ndvTuner = tunerValues[i];
            computedStatsObj = aggregator.aggregate(statsList, partitions, true);
            expectedStats = new ColStatsBuilder<Long>(Long.TYPE).numNulls(6L).numDVs(expectedDVs[i]).low(1L).high(8L).fmSketch(1L, 2L, 3L).kll(values).build();
            StatisticsTestUtils.assertEqualStatistics(expectedStats, computedStatsObj.getStatsData());
        }
    }

    @Test
    public void testAggregateMultiStatsWhenOnlySomeAvailable() throws MetaException {
        List<String> partitions = Arrays.asList("part1", "part2", "part3", "part4");
        ColumnStatisticsData data1 = new ColStatsBuilder<Long>(Long.TYPE).numNulls(1L).numDVs(3L).low(1L).high(3L).hll(1L, 2L, 3L).kll(1L, 2L, 3L).build();
        ColumnStatisticsData data3 = new ColStatsBuilder<Long>(Long.TYPE).numNulls(3L).numDVs(1L).low(7L).high(7L).hll(7L).kll(7L).build();
        ColumnStatisticsData data4 = new ColStatsBuilder<Long>(Long.TYPE).numNulls(2L).numDVs(3L).low(3L).high(5L).hll(3L, 4L, 5L).kll(3L, 4L, 5L).build();
        List<MetaStoreServerUtils.ColStatsObjWithSourceInfo> statsList = Arrays.asList(StatisticsTestUtils.createStatsWithInfo(data1, TABLE, COL, partitions.get(0)), StatisticsTestUtils.createStatsWithInfo(data3, TABLE, COL, partitions.get(2)), StatisticsTestUtils.createStatsWithInfo(data4, TABLE, COL, partitions.get(3)));
        LongColumnStatsAggregator aggregator = new LongColumnStatsAggregator();
        ColumnStatisticsObj computedStatsObj = aggregator.aggregate(statsList, partitions, false);
        ColumnStatisticsData expectedStats = new ColStatsBuilder<Long>(Long.TYPE).numNulls(8L).numDVs(4L).low(1L).high(9L).kll(1L, 2L, 3L, 7L, 3L, 4L, 5L).build();
        StatisticsTestUtils.assertEqualStatistics(expectedStats, computedStatsObj.getStatsData());
    }

    @Test
    public void testAggregateMultiStatsOnlySomeAvailableButUnmergeableBitVector() throws MetaException {
        List<String> partitions = Arrays.asList("part1", "part2", "part3");
        ColumnStatisticsData data1 = new ColStatsBuilder<Long>(Long.TYPE).numNulls(1L).numDVs(3L).low(1L).high(6L).fmSketch(1L, 2L, 6L).kll(1L, 2L, 6L).build();
        ColumnStatisticsData data3 = new ColStatsBuilder<Long>(Long.TYPE).numNulls(3L).numDVs(1L).low(7L).high(7L).hll(7L).kll(7L).build();
        List<MetaStoreServerUtils.ColStatsObjWithSourceInfo> statsList = Arrays.asList(StatisticsTestUtils.createStatsWithInfo(data1, TABLE, COL, partitions.get(0)), StatisticsTestUtils.createStatsWithInfo(data3, TABLE, COL, partitions.get(2)));
        LongColumnStatsAggregator aggregator = new LongColumnStatsAggregator();
        ColumnStatisticsObj computedStatsObj = aggregator.aggregate(statsList, partitions, false);
        ColumnStatisticsData expectedStats = new ColStatsBuilder<Long>(Long.TYPE).numNulls(6L).numDVs(3L).low(1L).high(7L).kll(1L, 2L, 6L, 7L).build();
        StatisticsTestUtils.assertEqualStatistics(expectedStats, computedStatsObj.getStatsData());
        aggregator.useDensityFunctionForNDVEstimation = true;
        computedStatsObj = aggregator.aggregate(statsList, partitions, false);
        expectedStats = new ColStatsBuilder<Long>(Long.TYPE).numNulls(6L).numDVs(4L).low(1L).high(7L).kll(1L, 2L, 6L, 7L).build();
        StatisticsTestUtils.assertEqualStatistics(expectedStats, computedStatsObj.getStatsData());
    }
}

