/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.columnstats.aggr;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.metastore.StatisticsTestUtils;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.columnstats.ColStatsBuilder;
import org.apache.hadoop.hive.metastore.columnstats.aggr.BinaryColumnStatsAggregator;
import org.apache.hadoop.hive.metastore.utils.MetaStoreServerUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class BinaryColumnStatsAggregatorTest {
    private static final Table TABLE = new Table("dummy", "db", "hive", 0, 0, 0, null, null, Collections.emptyMap(), null, null, TableType.MANAGED_TABLE.toString());
    private static final FieldSchema COL = new FieldSchema("col", "binary", "");

    @Test
    public void testAggregateSingleStat() throws MetaException {
        List<String> partitions = Collections.singletonList("part1");
        ColumnStatisticsData data1 = new ColStatsBuilder<byte[]>(byte[].class).numNulls(1L).avgColLen(8.5).maxColLen(13L).build();
        List<MetaStoreServerUtils.ColStatsObjWithSourceInfo> statsList = Collections.singletonList(StatisticsTestUtils.createStatsWithInfo(data1, TABLE, COL, partitions.get(0)));
        BinaryColumnStatsAggregator aggregator = new BinaryColumnStatsAggregator();
        ColumnStatisticsObj computedStatsObj = aggregator.aggregate(statsList, partitions, true);
        Assert.assertEquals((Object)data1, (Object)computedStatsObj.getStatsData());
    }

    @Test
    public void testAggregateMultiStatsWhenAllAvailable() throws MetaException {
        List<String> partitions = Arrays.asList("part1", "part2", "part3");
        ColumnStatisticsData data1 = new ColStatsBuilder<byte[]>(byte[].class).numNulls(1L).avgColLen(6.666666666666667).maxColLen(13L).build();
        ColumnStatisticsData data2 = new ColStatsBuilder<byte[]>(byte[].class).numNulls(2L).avgColLen(14.0).maxColLen(18L).build();
        ColumnStatisticsData data3 = new ColStatsBuilder<byte[]>(byte[].class).numNulls(3L).avgColLen(17.5).maxColLen(18L).build();
        List<MetaStoreServerUtils.ColStatsObjWithSourceInfo> statsList = Arrays.asList(StatisticsTestUtils.createStatsWithInfo(data1, TABLE, COL, partitions.get(0)), StatisticsTestUtils.createStatsWithInfo(data2, TABLE, COL, partitions.get(1)), StatisticsTestUtils.createStatsWithInfo(data3, TABLE, COL, partitions.get(2)));
        BinaryColumnStatsAggregator aggregator = new BinaryColumnStatsAggregator();
        ColumnStatisticsObj computedStatsObj = aggregator.aggregate(statsList, partitions, true);
        ColumnStatisticsData expectedStats = new ColStatsBuilder<byte[]>(byte[].class).numNulls(6L).avgColLen(17.5).maxColLen(18L).build();
        Assert.assertEquals((Object)expectedStats, (Object)computedStatsObj.getStatsData());
    }

    @Test
    public void testAggregateMultiStatsWhenOnlySomeAvailable() throws MetaException {
        List<String> partitions = Arrays.asList("part1", "part2", "part3", "part4");
        ColumnStatisticsData data1 = new ColStatsBuilder<byte[]>(byte[].class).numNulls(1L).avgColLen(6.666666666666667).maxColLen(13L).build();
        ColumnStatisticsData data3 = new ColStatsBuilder<byte[]>(byte[].class).numNulls(3L).avgColLen(17.5).maxColLen(18L).build();
        ColumnStatisticsData data4 = new ColStatsBuilder<byte[]>(byte[].class).numNulls(2L).avgColLen(14.0).maxColLen(18L).build();
        List<MetaStoreServerUtils.ColStatsObjWithSourceInfo> statsList = Arrays.asList(StatisticsTestUtils.createStatsWithInfo(data1, TABLE, COL, partitions.get(0)), StatisticsTestUtils.createStatsWithInfo(data3, TABLE, COL, partitions.get(2)), StatisticsTestUtils.createStatsWithInfo(data4, TABLE, COL, partitions.get(3)));
        BinaryColumnStatsAggregator aggregator = new BinaryColumnStatsAggregator();
        ColumnStatisticsObj computedStatsObj = aggregator.aggregate(statsList, partitions, false);
        ColumnStatisticsData expectedStats = new ColStatsBuilder<byte[]>(byte[].class).numNulls(6L).avgColLen(17.5).maxColLen(18L).build();
        Assert.assertEquals((Object)expectedStats, (Object)computedStatsObj.getStatsData());
    }
}

