/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client;

import java.util.List;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.client.MetaStoreClientTest;
import org.apache.hadoop.hive.metastore.client.builder.CatalogBuilder;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.minihms.AbstractMetaStoreService;
import org.apache.thrift.TException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreCheckinTest.class})
public class TestTablesList
extends MetaStoreClientTest {
    private static final String DEFAULT_DATABASE = "default";
    private static final String OTHER_DATABASE = "dummy";
    private final AbstractMetaStoreService metaStore;
    private IMetaStoreClient client;
    private Table[] testTables = new Table[7];

    public TestTablesList(String name, AbstractMetaStoreService metaStore) {
        this.metaStore = metaStore;
    }

    @Before
    public void setUp() throws Exception {
        this.client = this.metaStore.getClient();
        this.client.dropDatabase(OTHER_DATABASE, true, true, true);
        for (String tableName : this.client.getAllTables(DEFAULT_DATABASE)) {
            this.client.dropTable(DEFAULT_DATABASE, tableName, true, true, true);
        }
        this.metaStore.cleanWarehouseDirs();
        this.testTables[0] = ((TableBuilder)new TableBuilder().setDbName(DEFAULT_DATABASE).setTableName("filter_test_table_0").addCol("test_col", "int")).setOwner("Owner1").setLastAccessTime(1000).addTableParam("param1", "value1").create(this.client, this.metaStore.getConf());
        this.testTables[1] = ((TableBuilder)new TableBuilder().setDbName(DEFAULT_DATABASE).setTableName("filter_test_table_1").addCol("test_col", "int")).setOwner("Owner1").setLastAccessTime(2000).addTableParam("param1", "value2").create(this.client, this.metaStore.getConf());
        this.testTables[2] = ((TableBuilder)new TableBuilder().setDbName(DEFAULT_DATABASE).setTableName("filter_test_table_2").addCol("test_col", "int")).setOwner("Owner2").setLastAccessTime(1000).addTableParam("param1", "value2").create(this.client, this.metaStore.getConf());
        this.testTables[3] = ((TableBuilder)new TableBuilder().setDbName(DEFAULT_DATABASE).setTableName("filter_test_table_3").addCol("test_col", "int")).setOwner("Owner3").setLastAccessTime(3000).addTableParam("param1", "value2").create(this.client, this.metaStore.getConf());
        this.testTables[4] = ((TableBuilder)new TableBuilder().setDbName(DEFAULT_DATABASE).setTableName("filter_test_table_4").addCol("test_col", "int")).setOwner("Tester").setLastAccessTime(2500).addTableParam("param1", "value4").create(this.client, this.metaStore.getConf());
        this.testTables[5] = ((TableBuilder)new TableBuilder().setDbName(DEFAULT_DATABASE).setTableName("filter_test_table_5").addCol("test_col", "int")).create(this.client, this.metaStore.getConf());
        new DatabaseBuilder().setName(OTHER_DATABASE).create(this.client, this.metaStore.getConf());
        this.testTables[6] = ((TableBuilder)new TableBuilder().setDbName(OTHER_DATABASE).setTableName("filter_test_table_0").addCol("test_col", "int")).setOwner("Owner1").setLastAccessTime(1000).addTableParam("param1", "value1").create(this.client, this.metaStore.getConf());
        for (int i = 0; i < this.testTables.length; ++i) {
            this.testTables[i] = this.client.getTable(this.testTables[i].getCatName(), this.testTables[i].getDbName(), this.testTables[i].getTableName());
        }
    }

    @After
    public void tearDown() throws Exception {
        try {
            if (this.client != null) {
                try {
                    this.client.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        finally {
            this.client = null;
        }
    }

    @Test
    public void testListTableNamesByFilterCheckOwner() throws Exception {
        String filter = "hive_filter_field_owner__=\"Owner1\"";
        List tableNames = this.client.listTableNamesByFilter(DEFAULT_DATABASE, filter, (short)-1);
        Assert.assertEquals((String)"Found tables", (long)2L, (long)tableNames.size());
        Assert.assertTrue((boolean)tableNames.contains(this.testTables[0].getTableName()));
        Assert.assertTrue((boolean)tableNames.contains(this.testTables[1].getTableName()));
    }

    @Test
    public void testListTableNamesByFilterCheckLastAccess() throws Exception {
        String filter = "hive_filter_field_last_access__=1000";
        List tableNames = this.client.listTableNamesByFilter(DEFAULT_DATABASE, filter, (short)-1);
        Assert.assertEquals((String)"Found tables", (long)2L, (long)tableNames.size());
        Assert.assertTrue((boolean)tableNames.contains(this.testTables[0].getTableName()));
        Assert.assertTrue((boolean)tableNames.contains(this.testTables[2].getTableName()));
    }

    @Test
    public void testListTableNamesByFilterCheckParameter() throws Exception {
        String filter = "hive_filter_field_params__param1=\"value2\"";
        List tableNames = this.client.listTableNamesByFilter(DEFAULT_DATABASE, filter, (short)-1);
        Assert.assertEquals((String)"Found tables", (long)3L, (long)tableNames.size());
        Assert.assertTrue((boolean)tableNames.contains(this.testTables[1].getTableName()));
        Assert.assertTrue((boolean)tableNames.contains(this.testTables[2].getTableName()));
        Assert.assertTrue((boolean)tableNames.contains(this.testTables[3].getTableName()));
    }

    @Test
    public void testListTableNamesByFilterCheckLike() throws Exception {
        String filter = "hive_filter_field_owner__ LIKE \"Owner.*\"";
        List tableNames = this.client.listTableNamesByFilter(DEFAULT_DATABASE, filter, (short)-1);
        Assert.assertEquals((String)"Found tables", (long)4L, (long)tableNames.size());
        Assert.assertTrue((boolean)tableNames.contains(this.testTables[0].getTableName()));
        Assert.assertTrue((boolean)tableNames.contains(this.testTables[1].getTableName()));
        Assert.assertTrue((boolean)tableNames.contains(this.testTables[2].getTableName()));
        Assert.assertTrue((boolean)tableNames.contains(this.testTables[3].getTableName()));
    }

    @Test
    public void testListTableNamesByFilterCheckLessOrEquals() throws Exception {
        String filter = "hive_filter_field_last_access__<=2000";
        List tableNames = this.client.listTableNamesByFilter(DEFAULT_DATABASE, filter, (short)-1);
        Assert.assertEquals((String)"Found tables", (long)3L, (long)tableNames.size());
        Assert.assertTrue((boolean)tableNames.contains(this.testTables[0].getTableName()));
        Assert.assertTrue((boolean)tableNames.contains(this.testTables[1].getTableName()));
        Assert.assertTrue((boolean)tableNames.contains(this.testTables[2].getTableName()));
    }

    @Test
    public void testListTableNamesByFilterCheckNotEquals() throws Exception {
        String filter = "hive_filter_field_params__param1<>\"value2\"";
        List tableNames = this.client.listTableNamesByFilter(DEFAULT_DATABASE, filter, (short)-1);
        Assert.assertEquals((String)"Found tables", (long)2L, (long)tableNames.size());
        Assert.assertTrue((boolean)tableNames.contains(this.testTables[0].getTableName()));
        Assert.assertTrue((boolean)tableNames.contains(this.testTables[4].getTableName()));
    }

    @Test
    public void testListTableNamesByFilterCheckCombined() throws Exception {
        String filter = "hive_filter_field_last_access__<3000 and (hive_filter_field_owner__=\"Tester\" or hive_filter_field_params__param1=\"value2\")";
        List tableNames = this.client.listTableNamesByFilter(DEFAULT_DATABASE, filter, (short)-1);
        Assert.assertEquals((String)"Found tables", (long)3L, (long)tableNames.size());
        Assert.assertTrue((boolean)tableNames.contains(this.testTables[1].getTableName()));
        Assert.assertTrue((boolean)tableNames.contains(this.testTables[2].getTableName()));
        Assert.assertTrue((boolean)tableNames.contains(this.testTables[4].getTableName()));
    }

    @Test
    public void testListTableNamesByFilterCheckLimit() throws Exception {
        String filter = "hive_filter_field_owner__ LIKE \"Owner.*\"";
        List tableNames = this.client.listTableNamesByFilter(DEFAULT_DATABASE, filter, (short)1);
        Assert.assertEquals((String)"Found tables", (long)1L, (long)tableNames.size());
        Assert.assertTrue((tableNames.contains(this.testTables[0].getTableName()) || tableNames.contains(this.testTables[1].getTableName()) || tableNames.contains(this.testTables[2].getTableName()) || tableNames.contains(this.testTables[3].getTableName()) ? 1 : 0) != 0);
    }

    @Test
    public void testListTableNamesByFilterCheckNoSuchDatabase() throws Exception {
        List tableNames = this.client.listTableNamesByFilter("no_such_database", "hive_filter_field_last_access__>2000", (short)-1);
        Assert.assertEquals((String)"Found tables", (long)0L, (long)tableNames.size());
    }

    @Test(expected=UnknownDBException.class)
    public void testListTableNamesByFilterNullDatabase() throws Exception {
        this.client.listTableNamesByFilter(null, "hive_filter_field_last_access__>2000", (short)-1);
    }

    @Test(expected=InvalidOperationException.class)
    public void testListTableNamesByFilterNullFilter() throws Exception {
        this.client.listTableNamesByFilter(DEFAULT_DATABASE, null, (short)-1);
    }

    @Test(expected=MetaException.class)
    public void testListTableNamesByFilterInvalidFilter() throws Exception {
        this.client.listTableNamesByFilter(DEFAULT_DATABASE, "invalid filter", (short)-1);
    }

    @Test
    public void otherCatalogs() throws TException {
        String catName = "list_tables_in_other_catalogs";
        Catalog cat = new CatalogBuilder().setName(catName).setLocation(MetaStoreTestUtils.getTestWarehouseDir(catName)).build();
        this.client.createCatalog(cat);
        String dbName = "db_in_other_catalog";
        Database db = new DatabaseBuilder().setName(dbName).setCatalogName(catName).create(this.client, this.metaStore.getConf());
        String[] tableNames = new String[4];
        for (int i = 0; i < tableNames.length; ++i) {
            tableNames[i] = "table_in_other_catalog_" + i;
            TableBuilder builder = (TableBuilder)((TableBuilder)new TableBuilder().inDb(db).setTableName(tableNames[i]).addCol("col1_" + i, "string")).addCol("col2_" + i, "int");
            if (i == 0) {
                builder.addTableParam("the_key", "the_value");
            }
            builder.create(this.client, this.metaStore.getConf());
        }
        String filter = "hive_filter_field_params__the_key=\"the_value\"";
        List fetchedNames = this.client.listTableNamesByFilter(catName, dbName, filter, -1);
        Assert.assertEquals((long)1L, (long)fetchedNames.size());
        Assert.assertEquals((Object)tableNames[0], fetchedNames.get(0));
    }

    @Test(expected=UnknownDBException.class)
    public void listTablesBogusCatalog() throws TException {
        String filter = "hive_filter_field_params__the_key=\"the_value\"";
        List fetchedNames = this.client.listTableNamesByFilter("", DEFAULT_DATABASE, filter, -1);
    }
}

