/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.GetProjectionsSpec;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.client.MetaStoreClientTest;
import org.apache.hadoop.hive.metastore.client.builder.CatalogBuilder;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.GetTableProjectionsSpecBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.minihms.AbstractMetaStoreService;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.transport.TTransportException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreCheckinTest.class})
public class TestTablesGetExists
extends MetaStoreClientTest {
    private static final String DEFAULT_DATABASE = "default";
    private static final String OTHER_DATABASE = "dummy";
    private final AbstractMetaStoreService metaStore;
    private IMetaStoreClient client;
    private Table[] testTables = new Table[7];

    public TestTablesGetExists(String name, AbstractMetaStoreService metaStore) {
        this.metaStore = metaStore;
    }

    @Before
    public void setUp() throws Exception {
        this.client = this.metaStore.getClient();
        this.client.dropDatabase(OTHER_DATABASE, true, true, true);
        for (String tableName : this.client.getAllTables(DEFAULT_DATABASE)) {
            this.client.dropTable(DEFAULT_DATABASE, tableName, true, true, true);
        }
        this.metaStore.cleanWarehouseDirs();
        this.testTables[0] = ((TableBuilder)new TableBuilder().setDbName(DEFAULT_DATABASE).setTableName("test_table").addCol("test_col", "int")).create(this.client, this.metaStore.getConf());
        this.testTables[1] = ((TableBuilder)new TableBuilder().setDbName(DEFAULT_DATABASE).setTableName("test_view").addCol("test_col", "int")).setType("VIEW").create(this.client, this.metaStore.getConf());
        this.testTables[2] = ((TableBuilder)new TableBuilder().setDbName(DEFAULT_DATABASE).setTableName("test_table_to_find_1").addCol("test_col", "int")).create(this.client, this.metaStore.getConf());
        this.testTables[3] = ((TableBuilder)new TableBuilder().setDbName(DEFAULT_DATABASE).setTableName("test_table_to_find_2").addCol("test_col", "int")).setType("VIEW").create(this.client, this.metaStore.getConf());
        this.testTables[4] = ((TableBuilder)new TableBuilder().setDbName(DEFAULT_DATABASE).setTableName("test_table_hidden_1").addCol("test_col", "int")).create(this.client, this.metaStore.getConf());
        new DatabaseBuilder().setName(OTHER_DATABASE).create(this.client, this.metaStore.getConf());
        this.testTables[5] = ((TableBuilder)new TableBuilder().setDbName(OTHER_DATABASE).setTableName("test_table").addCol("test_col", "int")).create(this.client, this.metaStore.getConf());
        this.testTables[6] = ((TableBuilder)new TableBuilder().setDbName(OTHER_DATABASE).setTableName("test_table_to_find_3").addCol("test_col", "int")).create(this.client, this.metaStore.getConf());
        for (int i = 0; i < this.testTables.length; ++i) {
            this.testTables[i] = this.client.getTable(this.testTables[i].getCatName(), this.testTables[i].getDbName(), this.testTables[i].getTableName());
        }
    }

    @After
    public void tearDown() throws Exception {
        try {
            if (this.client != null) {
                try {
                    this.client.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        finally {
            this.client = null;
        }
    }

    @Test
    public void testGetTableCaseInsensitive() throws Exception {
        Table table = this.testTables[0];
        Table resultUpper = this.client.getTable(table.getCatName().toUpperCase(), table.getDbName().toUpperCase(), table.getTableName().toUpperCase());
        Assert.assertEquals((String)"Comparing tables", (Object)table, (Object)resultUpper);
        Table resultMix = this.client.getTable("hIvE", "DeFaUlt", "tEsT_TabLE");
        Assert.assertEquals((String)"Comparing tables", (Object)table, (Object)resultMix);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testGetTableNoSuchDatabase() throws Exception {
        Table table = this.testTables[2];
        this.client.getTable("no_such_database", table.getTableName());
    }

    @Test(expected=NoSuchObjectException.class)
    public void testGetTableNoSuchTable() throws Exception {
        Table table = this.testTables[2];
        this.client.getTable(table.getDbName(), "no_such_table");
    }

    @Test(expected=NoSuchObjectException.class)
    public void testGetTableNoSuchTableInTheDatabase() throws Exception {
        Table table = this.testTables[2];
        this.client.getTable(OTHER_DATABASE, table.getTableName());
    }

    @Test
    public void testGetTableNullDatabase() throws Exception {
        try {
            this.client.getTable(null, OTHER_DATABASE);
            Assert.fail((String)"Expected an MetaException or TProtocolException to be thrown");
        }
        catch (MetaException metaException) {
        }
        catch (TProtocolException tProtocolException) {
            // empty catch block
        }
    }

    @Test
    public void testGetTableNullTableName() throws Exception {
        try {
            this.client.getTable(DEFAULT_DATABASE, null);
            Assert.fail((String)"Expected an MetaException or TProtocolException to be thrown");
        }
        catch (MetaException metaException) {
        }
        catch (TProtocolException tProtocolException) {
            // empty catch block
        }
    }

    @Test
    public void testGetAllTables() throws Exception {
        List tables = this.client.getAllTables(DEFAULT_DATABASE);
        Assert.assertEquals((String)"All tables size", (long)5L, (long)tables.size());
        for (Table table : this.testTables) {
            if (!table.getDbName().equals(DEFAULT_DATABASE)) continue;
            Assert.assertTrue((String)"Checking table names", (boolean)tables.contains(table.getTableName()));
        }
        this.client.dropTable(this.testTables[1].getCatName(), this.testTables[1].getDbName(), this.testTables[1].getTableName());
        tables = this.client.getAllTables(DEFAULT_DATABASE);
        Assert.assertEquals((String)"All tables size", (long)4L, (long)tables.size());
        for (Table table : this.testTables) {
            if (!table.getDbName().equals(DEFAULT_DATABASE) || table.getTableName().equals(this.testTables[1].getTableName())) continue;
            Assert.assertTrue((String)"Checking table names", (boolean)tables.contains(table.getTableName()));
        }
        tables = this.client.getAllTables("no_such_database");
        Assert.assertEquals((String)"All tables size", (long)0L, (long)tables.size());
    }

    @Test(expected=MetaException.class)
    public void testGetAllTablesInvalidData() throws Exception {
        this.client.getAllTables(null);
    }

    @Test
    public void testGetAllTablesCaseInsensitive() throws Exception {
        List tables = this.client.getAllTables("dEFauLt");
        Assert.assertEquals((String)"Found tables size", (long)5L, (long)tables.size());
    }

    @Test
    public void testGetTables() throws Exception {
        List tables = this.client.getTables(DEFAULT_DATABASE, "*_to_find_*");
        Assert.assertEquals((String)"All tables size", (long)2L, (long)tables.size());
        Assert.assertTrue((String)"Comparing tablenames", (boolean)tables.contains(this.testTables[2].getTableName()));
        Assert.assertTrue((String)"Comparing tablenames", (boolean)tables.contains(this.testTables[3].getTableName()));
        tables = this.client.getTables(DEFAULT_DATABASE, "*_to_find_*|*_hidden_*");
        Assert.assertEquals((String)"All tables size", (long)3L, (long)tables.size());
        Assert.assertTrue((String)"Comparing tablenames", (boolean)tables.contains(this.testTables[2].getTableName()));
        Assert.assertTrue((String)"Comparing tablenames", (boolean)tables.contains(this.testTables[3].getTableName()));
        Assert.assertTrue((String)"Comparing tablenames", (boolean)tables.contains(this.testTables[4].getTableName()));
        tables = this.client.getTables(OTHER_DATABASE, "*_to_find_*");
        Assert.assertEquals((String)"Found functions size", (long)1L, (long)tables.size());
        Assert.assertTrue((String)"Comparing tablenames", (boolean)tables.contains(this.testTables[6].getTableName()));
        tables = this.client.getTables(DEFAULT_DATABASE, "*_not_such_function_*");
        Assert.assertEquals((String)"No such table size", (long)0L, (long)tables.size());
        tables = this.client.getTables(DEFAULT_DATABASE, (String)null);
        Assert.assertEquals((String)"No such functions size", (long)5L, (long)tables.size());
        tables = this.client.getTables(DEFAULT_DATABASE, "");
        Assert.assertEquals((String)"No such functions size", (long)0L, (long)tables.size());
        try {
            tables = this.client.getTables("no_such_database", OTHER_DATABASE);
        }
        catch (MetaException metaException) {
            // empty catch block
        }
    }

    @Test
    public void testGetTablesCaseInsensitive() throws Exception {
        List tables = this.client.getTables(DEFAULT_DATABASE, "*_tO_FiND*");
        Assert.assertEquals((String)"Found tables size", (long)2L, (long)tables.size());
        Assert.assertTrue((String)"Comparing tablenames", (boolean)tables.contains(this.testTables[2].getTableName()));
        Assert.assertTrue((String)"Comparing tablenames", (boolean)tables.contains(this.testTables[3].getTableName()));
    }

    @Test(expected=MetaException.class)
    public void testGetTablesNullDatabase() throws Exception {
        this.client.getTables(null, "*_tO_FiND*");
    }

    @Test
    public void testTableExists() throws Exception {
        Table table = this.testTables[1];
        Assert.assertTrue((String)"Table exists", (boolean)this.client.tableExists(table.getCatName(), table.getDbName(), table.getTableName()));
        Assert.assertFalse((String)"Table not exists", (boolean)this.client.tableExists(table.getCatName(), table.getDbName(), "non_existing_table"));
        Assert.assertFalse((String)"Table not exists", (boolean)this.client.tableExists("no_such_database", table.getTableName()));
        Assert.assertFalse((String)"Table not exists", (boolean)this.client.tableExists(OTHER_DATABASE, table.getTableName()));
    }

    @Test
    public void testTableExistsCaseInsensitive() throws Exception {
        Table table = this.testTables[0];
        Assert.assertTrue((String)"Table exists", (boolean)this.client.tableExists(table.getCatName().toUpperCase(), table.getDbName().toUpperCase(), table.getTableName().toUpperCase()));
        Assert.assertTrue((String)"Table exists", (boolean)this.client.tableExists("hIVe", "DeFaUlt", "tEsT_TabLE"));
    }

    @Test
    public void testTableExistsNullDatabase() throws Exception {
        try {
            this.client.tableExists(null, OTHER_DATABASE);
            Assert.fail((String)"Expected an MetaException or TProtocolException to be thrown");
        }
        catch (MetaException metaException) {
        }
        catch (TProtocolException tProtocolException) {
            // empty catch block
        }
    }

    @Test
    public void testTableExistsNullTableName() throws Exception {
        try {
            this.client.tableExists(DEFAULT_DATABASE, null);
            Assert.fail((String)"Expected an MetaException or TProtocolException to be thrown");
        }
        catch (MetaException metaException) {
        }
        catch (TProtocolException tProtocolException) {
            // empty catch block
        }
    }

    @Test
    public void testGetTableObjectsByName() throws Exception {
        ArrayList<String> tableNames = new ArrayList<String>();
        tableNames.add(this.testTables[0].getTableName());
        tableNames.add(this.testTables[1].getTableName());
        List tables = this.client.getTableObjectsByName(DEFAULT_DATABASE, tableNames);
        Assert.assertEquals((String)"Found tables", (long)2L, (long)tables.size());
        for (Table table : tables) {
            if (table.getTableName().equals(this.testTables[0].getTableName())) {
                Assert.assertEquals((String)"Comparing tables", (Object)this.testTables[0], (Object)table);
                continue;
            }
            Assert.assertEquals((String)"Comparing tables", (Object)this.testTables[1], (Object)table);
        }
        tables = this.client.getTableObjectsByName(DEFAULT_DATABASE, new ArrayList());
        Assert.assertEquals((String)"Found tables", (long)0L, (long)tables.size());
        tableNames = new ArrayList();
        tableNames.add("no_such_table");
        this.client.getTableObjectsByName(this.testTables[0].getCatName(), this.testTables[0].getDbName(), tableNames);
        Assert.assertEquals((String)"Found tables", (long)0L, (long)tables.size());
        tableNames = new ArrayList();
        tableNames.add(this.testTables[0].getTableName());
        this.client.getTableObjectsByName(OTHER_DATABASE, tableNames);
        Assert.assertEquals((String)"Found tables", (long)0L, (long)tables.size());
    }

    @Test
    public void testGetTableObjectsWithProjectionOfSingleField() throws Exception {
        ArrayList<String> tableNames = new ArrayList<String>();
        tableNames.add(this.testTables[0].getTableName());
        tableNames.add(this.testTables[1].getTableName());
        GetProjectionsSpec projectSpec = new GetTableProjectionsSpecBuilder().includeSdLocation().build();
        List tables = this.client.getTables(null, DEFAULT_DATABASE, tableNames, projectSpec);
        Assert.assertEquals((String)"Found tables", (long)2L, (long)tables.size());
        for (Table table : tables) {
            Assert.assertFalse((boolean)table.isSetDbName());
            Assert.assertFalse((boolean)table.isSetCatName());
            Assert.assertFalse((boolean)table.isSetTableName());
            Assert.assertTrue((boolean)table.isSetSd());
        }
    }

    @Test
    public void testGetTableObjectsWithNullProjectionSpec() throws Exception {
        ArrayList<String> tableNames = new ArrayList<String>();
        tableNames.add(this.testTables[0].getTableName());
        tableNames.add(this.testTables[1].getTableName());
        List tables = this.client.getTables(null, DEFAULT_DATABASE, tableNames, null);
        Assert.assertEquals((String)"Found tables", (long)2L, (long)tables.size());
    }

    @Test
    public void testGetTableObjectsWithIncludePattern() throws Exception {
        ArrayList<String> tableNames = new ArrayList<String>();
        tableNames.add(this.testTables[0].getTableName());
        tableNames.add(this.testTables[1].getTableName());
        GetProjectionsSpec projectSpec = new GetTableProjectionsSpecBuilder().setExcludeColumnPattern("foo").build();
        Assert.assertThrows(Exception.class, () -> this.client.getTables(null, DEFAULT_DATABASE, tableNames, projectSpec));
    }

    @Test
    public void testGetTableObjectsWithNonExistentColumn() throws Exception {
        ArrayList<String> tableNames = new ArrayList<String>();
        tableNames.add(this.testTables[0].getTableName());
        tableNames.add(this.testTables[1].getTableName());
        GetProjectionsSpec projectSpec = new GetTableProjectionsSpecBuilder().setColumnList(Arrays.asList("Invalid1")).build();
        Assert.assertThrows(Exception.class, () -> this.client.getTables(null, DEFAULT_DATABASE, tableNames, projectSpec));
    }

    @Test
    public void testGetTableObjectsWithNonExistentColumns() throws Exception {
        ArrayList<String> tableNames = new ArrayList<String>();
        tableNames.add(this.testTables[0].getTableName());
        tableNames.add(this.testTables[1].getTableName());
        GetProjectionsSpec projectSpec = new GetTableProjectionsSpecBuilder().setColumnList(Arrays.asList("Invalid1", "Invalid2")).build();
        Assert.assertThrows(Exception.class, () -> this.client.getTables(null, DEFAULT_DATABASE, tableNames, projectSpec));
    }

    @Test
    public void testGetTableObjectsWithEmptyProjection() throws Exception {
        ArrayList<String> tableNames = new ArrayList<String>();
        tableNames.add(this.testTables[0].getTableName());
        tableNames.add(this.testTables[1].getTableName());
        GetProjectionsSpec projectSpec = new GetTableProjectionsSpecBuilder().build();
        List tables = this.client.getTables(null, DEFAULT_DATABASE, tableNames, projectSpec);
        Assert.assertEquals((String)"Found tables", (long)2L, (long)tables.size());
    }

    @Test
    public void testGetTableObjectsWithProjectionOfMultipleField_1() throws Exception {
        ArrayList<String> tableNames = new ArrayList<String>();
        tableNames.add(this.testTables[0].getTableName());
        tableNames.add(this.testTables[1].getTableName());
        GetProjectionsSpec projectSpec = new GetTableProjectionsSpecBuilder().includeDatabase().includeTableName().includeCreateTime().includeLastAccessTime().build();
        List tables = this.client.getTables(null, DEFAULT_DATABASE, tableNames, projectSpec);
        Assert.assertEquals((String)"Found tables", (long)2L, (long)tables.size());
        for (Table table : tables) {
            Assert.assertTrue((boolean)table.isSetDbName());
            Assert.assertTrue((boolean)table.isSetTableName());
            Assert.assertTrue((boolean)table.isSetCreateTime());
            Assert.assertFalse((boolean)table.isSetSd());
            Assert.assertFalse((boolean)table.isSetOwner());
        }
    }

    @Test
    public void testGetTableObjectsWithProjectionOfMultipleField_2() throws Exception {
        ArrayList<String> tableNames = new ArrayList<String>();
        tableNames.add(this.testTables[0].getTableName());
        tableNames.add(this.testTables[1].getTableName());
        GetProjectionsSpec projectSpec = new GetTableProjectionsSpecBuilder().includeOwner().includeOwnerType().includeSdLocation().build();
        List tables = this.client.getTables(null, DEFAULT_DATABASE, tableNames, projectSpec);
        Assert.assertEquals((String)"Found tables", (long)2L, (long)tables.size());
        for (Table table : tables) {
            Assert.assertFalse((boolean)table.isSetDbName());
            Assert.assertFalse((boolean)table.isSetTableName());
            Assert.assertTrue((boolean)table.isSetCreateTime());
            Assert.assertTrue((boolean)table.isSetSd());
            Assert.assertTrue((boolean)table.isSetOwnerType());
            Assert.assertTrue((boolean)table.isSetOwner());
            StorageDescriptor sd = table.getSd();
            Assert.assertTrue((boolean)sd.isSetLocation());
        }
    }

    @Test
    public void testGetTableObjectsWithProjectionOfSerDeInfoSingleValuedFields() throws Exception {
        ArrayList<String> tableNames = new ArrayList<String>();
        tableNames.add(this.testTables[0].getTableName());
        tableNames.add(this.testTables[1].getTableName());
        GetProjectionsSpec projectSpec = new GetTableProjectionsSpecBuilder().includeSdSerDeInfoSerializationLib().build();
        List tables = this.client.getTables(null, DEFAULT_DATABASE, tableNames, projectSpec);
        Assert.assertEquals((String)"Found tables", (long)2L, (long)tables.size());
        for (Table table : tables) {
            Assert.assertFalse((boolean)table.isSetDbName());
            Assert.assertTrue((boolean)table.isSetSd());
            StorageDescriptor sd = table.getSd();
            Assert.assertFalse((boolean)sd.isSetCols());
            Assert.assertTrue((boolean)sd.isSetSerdeInfo());
            SerDeInfo serDeInfo = sd.getSerdeInfo();
            Assert.assertTrue((boolean)serDeInfo.isSetSerializationLib());
        }
    }

    @Test
    public void testGetTableObjectsWithProjectionOfMultiValuedFields() throws Exception {
        ArrayList<String> tableNames = new ArrayList<String>();
        tableNames.add(this.testTables[0].getTableName());
        tableNames.add(this.testTables[1].getTableName());
        GetProjectionsSpec projectSpec = new GetTableProjectionsSpecBuilder().includeSdLocation().includeSdSerDeInfoName().includeSdSerDeInfoSerializationLib().includeSdSerDeInfoParameters().build();
        List tables = this.client.getTables(null, DEFAULT_DATABASE, tableNames, projectSpec);
        Assert.assertEquals((String)"Found tables", (long)2L, (long)tables.size());
        for (Table table : tables) {
            Assert.assertTrue((boolean)table.isSetDbName());
            Assert.assertTrue((boolean)table.isSetCatName());
            Assert.assertTrue((boolean)table.isSetTableName());
            Assert.assertTrue((boolean)table.isSetLastAccessTime());
            Assert.assertTrue((boolean)table.isSetSd());
            StorageDescriptor sd = table.getSd();
            Assert.assertTrue((boolean)sd.isSetCols());
            Assert.assertTrue((boolean)sd.isSetSerdeInfo());
            Assert.assertTrue((boolean)sd.isSetBucketCols());
            Assert.assertTrue((boolean)sd.isSetCompressed());
            Assert.assertTrue((boolean)sd.isSetInputFormat());
        }
    }

    @Test
    public void testGetTableProjectionSpecification() throws Exception {
        ArrayList<String> tableNames = new ArrayList<String>();
        tableNames.add(this.testTables[0].getTableName());
        tableNames.add(this.testTables[1].getTableName());
        GetProjectionsSpec projectSpec = new GetTableProjectionsSpecBuilder().includeTableName().includeDatabase().includeSdCdColsName().includeSdCdColsType().includeSdCdColsComment().includeSdLocation().includeSdInputFormat().includeSdOutputFormat().includeSdIsCompressed().includeSdNumBuckets().includeSdSerDeInfoName().includeSdSerDeInfoSerializationLib().includeSdSerDeInfoParameters().includeSdSerDeInfoDescription().includeSdSerDeInfoSerializerClass().includeSdSerDeInfoDeserializerClass().includeSdSerDeInfoSerdeType().includeSdBucketCols().includeSdSortColsCol().includeSdSortColsOrder().includeSdparameters().includeSdSkewedColNames().includeSdSkewedColValues().includeSdSkewedColValueLocationMaps().includeSdIsStoredAsSubDirectories().includeOwner().includeOwnerType().includeCreateTime().includeLastAccessTime().includeRetention().includePartitionKeysName().includePartitionKeysType().includePartitionKeysComment().includeParameters().includeViewOriginalText().includeRewriteEnabled().includeTableType().build();
        List tables = this.client.getTables(null, DEFAULT_DATABASE, tableNames, projectSpec);
        Assert.assertEquals((String)"Found tables", (long)2L, (long)tables.size());
        for (Table table : tables) {
            Assert.assertTrue((boolean)table.isSetDbName());
            Assert.assertTrue((boolean)table.isSetCatName());
            Assert.assertTrue((boolean)table.isSetTableName());
            Assert.assertTrue((boolean)table.isSetLastAccessTime());
            Assert.assertTrue((boolean)table.isSetSd());
            StorageDescriptor sd = table.getSd();
            Assert.assertTrue((boolean)sd.isSetCols());
            Assert.assertTrue((boolean)sd.isSetSerdeInfo());
            Assert.assertTrue((boolean)sd.isSetBucketCols());
            Assert.assertTrue((boolean)sd.isSetCompressed());
            Assert.assertTrue((boolean)sd.isSetInputFormat());
            Assert.assertTrue((boolean)sd.isSetSerdeInfo());
            SerDeInfo serDeInfo = sd.getSerdeInfo();
            Assert.assertTrue((boolean)serDeInfo.isSetSerializationLib());
        }
    }

    @Test
    public void testGetTableObjectsByNameCaseInsensitive() throws Exception {
        Table table = this.testTables[0];
        ArrayList<String> tableNames = new ArrayList<String>();
        tableNames.add(this.testTables[0].getTableName().toUpperCase());
        List tables = this.client.getTableObjectsByName(table.getCatName().toUpperCase(), table.getDbName().toUpperCase(), tableNames);
        Assert.assertEquals((String)"Found tables", (long)1L, (long)tables.size());
        Assert.assertEquals((String)"Comparing tables", (Object)table, tables.get(0));
        tableNames = new ArrayList();
        tableNames.add("tEsT_TabLE");
        tables = this.client.getTableObjectsByName("HiVe", "DeFaUlt", tableNames);
        Assert.assertEquals((String)"Found tables", (long)1L, (long)tables.size());
        Assert.assertEquals((String)"Comparing tables", (Object)table, tables.get(0));
    }

    @Test(expected=UnknownDBException.class)
    public void testGetTableObjectsByNameNoSuchDatabase() throws Exception {
        ArrayList<String> tableNames = new ArrayList<String>();
        tableNames.add(this.testTables[0].getTableName());
        this.client.getTableObjectsByName("no_such_database", tableNames);
    }

    @Test
    public void testGetTableObjectsByNameNullDatabase() throws Exception {
        try {
            ArrayList<String> tableNames = new ArrayList<String>();
            tableNames.add(OTHER_DATABASE);
            this.client.getTableObjectsByName(null, tableNames);
            Assert.fail((String)"Expected an UnknownDBException or TProtocolException to be thrown");
        }
        catch (UnknownDBException unknownDBException) {
        }
        catch (TProtocolException tProtocolException) {
            // empty catch block
        }
    }

    @Test
    public void testGetTableObjectsByNameNullTableNameList() throws Exception {
        try {
            this.client.getTableObjectsByName(DEFAULT_DATABASE, null);
            Assert.fail((String)"Expected an InvalidOperationException to be thrown");
        }
        catch (InvalidOperationException invalidOperationException) {
        }
        catch (TTransportException tTransportException) {
            // empty catch block
        }
    }

    @Test
    public void otherCatalog() throws TException {
        String catName = "get_exists_tables_in_other_catalogs";
        Catalog cat = new CatalogBuilder().setName(catName).setLocation(MetaStoreTestUtils.getTestWarehouseDir(catName)).build();
        this.client.createCatalog(cat);
        String dbName = "db_in_other_catalog";
        Database db = new DatabaseBuilder().setName(dbName).setCatalogName(catName).create(this.client, this.metaStore.getConf());
        String[] tableNames = new String[4];
        for (int i = 0; i < tableNames.length; ++i) {
            tableNames[i] = "table_in_other_catalog_" + i;
            ((TableBuilder)((TableBuilder)new TableBuilder().inDb(db).setTableName(tableNames[i]).addCol("col1_" + i, "string")).addCol("col2_" + i, "int")).create(this.client, this.metaStore.getConf());
        }
        HashSet tables = new HashSet(this.client.getTables(catName, dbName, "*e_in_other_*"));
        Assert.assertEquals((long)4L, (long)tables.size());
        for (String tableName : tableNames) {
            Assert.assertTrue((boolean)tables.contains(tableName));
        }
        List fetchedNames = this.client.getTables(catName, dbName, "*_3");
        Assert.assertEquals((long)1L, (long)fetchedNames.size());
        Assert.assertEquals((Object)tableNames[3], fetchedNames.get(0));
        Assert.assertTrue((String)"Table exists", (boolean)this.client.tableExists(catName, dbName, tableNames[0]));
        Assert.assertFalse((String)"Table not exists", (boolean)this.client.tableExists(catName, dbName, "non_existing_table"));
    }

    @Test(expected=UnknownDBException.class)
    public void getTablesBogusCatalog() throws TException {
        this.client.getTables("nosuch", DEFAULT_DATABASE, "*_to_find_*");
    }

    @Test
    public void tableExistsBogusCatalog() throws TException {
        Assert.assertFalse((boolean)this.client.tableExists("nosuch", this.testTables[0].getDbName(), this.testTables[0].getTableName()));
    }
}

