/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.TestHiveMetaStore;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.CreationMetadata;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.SourceTable;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.client.MetaStoreClientTest;
import org.apache.hadoop.hive.metastore.client.builder.CatalogBuilder;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.PartitionBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.minihms.AbstractMetaStoreService;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocolException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreCheckinTest.class})
public class TestTablesCreateDropAlterTruncate
extends MetaStoreClientTest {
    private static final String DEFAULT_DATABASE = "default";
    private static final String OTHER_DATABASE = "dummy";
    private final AbstractMetaStoreService metaStore;
    private IMetaStoreClient client;
    private Table[] testTables = new Table[6];
    private Table partitionedTable = null;
    private Table externalTable = null;

    public TestTablesCreateDropAlterTruncate(String name, AbstractMetaStoreService metaStore) {
        this.metaStore = metaStore;
    }

    @BeforeClass
    public static void startMetaStores() {
        HashMap<MetastoreConf.ConfVars, String> msConf = new HashMap<MetastoreConf.ConfVars, String>();
        HashMap<String, String> extraConf = new HashMap<String, String>();
        extraConf.put("fs.trash.checkpoint.interval", "30");
        extraConf.put("fs.trash.interval", "30");
        extraConf.put(MetastoreConf.ConfVars.HIVE_IN_TEST.getVarname(), "true");
        extraConf.put(MetastoreConf.ConfVars.METASTORE_METADATA_TRANSFORMER_CLASS.getVarname(), " ");
        TestTablesCreateDropAlterTruncate.startMetaStores(msConf, extraConf);
    }

    @Before
    public void setUp() throws Exception {
        this.client = this.metaStore.getClient();
        this.client.dropDatabase(OTHER_DATABASE, true, true, true);
        for (Object tableName : this.client.getAllTables(DEFAULT_DATABASE)) {
            this.client.dropTable(DEFAULT_DATABASE, (String)tableName, true, true, true);
        }
        this.metaStore.cleanWarehouseDirs();
        this.testTables[0] = ((TableBuilder)new TableBuilder().setTableName("test_table").addCol("test_col", "int")).create(this.client, this.metaStore.getConf());
        this.testTables[1] = ((TableBuilder)new TableBuilder().setTableName("test_view").addCol("test_col", "int")).setType("VIRTUAL_VIEW").create(this.client, this.metaStore.getConf());
        this.testTables[2] = ((TableBuilder)new TableBuilder().setTableName("test_table_to_find_1").addCol("test_col", "int")).create(this.client, this.metaStore.getConf());
        this.testTables[3] = ((TableBuilder)((TableBuilder)new TableBuilder().setTableName("test_partitioned_table").addCol("test_col1", "int")).addCol("test_col2", "int")).addPartCol("test_part_col", "int").create(this.client, this.metaStore.getConf());
        this.testTables[4] = ((TableBuilder)((TableBuilder)new TableBuilder().setTableName("external_table_for_test").addCol("test_col", "int")).setLocation(this.metaStore.getExternalWarehouseRoot() + "/external/table_dir")).addTableParam("EXTERNAL", "TRUE").setType("EXTERNAL_TABLE").create(this.client, this.metaStore.getConf());
        new DatabaseBuilder().setName(OTHER_DATABASE).create(this.client, this.metaStore.getConf());
        this.testTables[5] = ((TableBuilder)new TableBuilder().setDbName(OTHER_DATABASE).setTableName("test_table").addCol("test_col", "int")).create(this.client, this.metaStore.getConf());
        for (int i = 0; i < 2; ++i) {
            new PartitionBuilder().inTable(this.testTables[3]).addValue("a" + i).addToTable(this.client, this.metaStore.getConf());
        }
        ((PartitionBuilder)new PartitionBuilder().inTable(this.testTables[3]).addValue("a2").setLocation(this.metaStore.getWarehouseRoot() + "/external/a2")).addToTable(this.client, this.metaStore.getConf());
        List partitions = this.client.listPartitions(this.testTables[3].getDbName(), this.testTables[3].getTableName(), (short)-1);
        for (Partition partition : partitions) {
            Path dataFile = new Path(partition.getSd().getLocation() + "/dataFile");
            this.metaStore.createFile(dataFile, "100");
        }
        for (int i = 0; i < this.testTables.length; ++i) {
            this.testTables[i] = this.client.getTable(this.testTables[i].getDbName(), this.testTables[i].getTableName());
            if (!this.testTables[i].getPartitionKeys().isEmpty() || this.testTables[i].getSd().getLocation() == null) continue;
            Path dataFile = new Path(this.testTables[i].getSd().getLocation() + "/dataFile");
            this.metaStore.createFile(dataFile, "100");
        }
        this.partitionedTable = this.testTables[3];
        this.externalTable = this.testTables[4];
    }

    @After
    public void tearDown() throws Exception {
        try {
            if (this.client != null) {
                try {
                    this.client.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        finally {
            this.client = null;
        }
    }

    @Test
    public void testCreateGetDeleteTable() throws Exception {
        Table table = this.getTableWithAllParametersSet();
        this.client.createTable(table);
        table.unsetId();
        Table createdTable = this.client.getTable(table.getDbName(), table.getTableName());
        table.setCreateTime(createdTable.getCreateTime());
        for (String key : table.getParameters().keySet()) {
            Assert.assertEquals((String)"parameters are the same", table.getParameters().get(key), createdTable.getParameters().get(key));
        }
        table.setParameters(createdTable.getParameters());
        table.setCreationMetadata(createdTable.getCreationMetadata());
        table.setWriteId(createdTable.getWriteId());
        Assert.assertTrue((boolean)createdTable.isSetId());
        createdTable.unsetId();
        Assert.assertEquals((String)"create/get table data", (Object)table, (Object)createdTable);
        Assert.assertTrue((String)"The directory should not be created", (boolean)this.metaStore.isPathExists(new Path(createdTable.getSd().getLocation())));
        this.client.dropTable(table.getDbName(), table.getTableName(), true, false);
        try {
            this.client.getTable(table.getDbName(), table.getTableName());
            Assert.fail((String)"Expected a NoSuchObjectException to be thrown");
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateTableDefaultValues() throws Exception {
        Table table = new Table();
        StorageDescriptor sd = new StorageDescriptor();
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        table.setDbName(DEFAULT_DATABASE);
        table.setTableName("test_table_2");
        cols.add(new FieldSchema("column_name", "int", null));
        sd.setCols(cols);
        sd.setSerdeInfo(new SerDeInfo());
        table.setSd(sd);
        this.client.createTable(table);
        Table createdTable = this.client.getTable(table.getDbName(), table.getTableName());
        Assert.assertEquals((String)"Comparing OwnerType", (Object)PrincipalType.USER, (Object)createdTable.getOwnerType());
        Assert.assertNull((String)"Comparing OwnerName", (Object)createdTable.getOwner());
        Assert.assertNotEquals((String)"Comparing CreateTime", (long)0L, (long)createdTable.getCreateTime());
        Assert.assertEquals((String)"Comparing LastAccessTime", (long)0L, (long)createdTable.getLastAccessTime());
        Assert.assertEquals((String)"Comparing Retention", (long)0L, (long)createdTable.getRetention());
        Assert.assertEquals((String)"Comparing PartitionKeys", (long)0L, (long)createdTable.getPartitionKeys().size());
        Assert.assertEquals((String)"Comparing Parameters length", (long)1L, (long)createdTable.getParameters().size());
        Assert.assertNotEquals((String)"Comparing Parameters(transient_lastDdlTime)", (Object)"0", createdTable.getParameters().get("transient_lastDdlTime"));
        Assert.assertNull((String)"Comparing ViewOriginalText", (Object)createdTable.getViewOriginalText());
        Assert.assertNull((String)"Comparing ViewExpandedText", (Object)createdTable.getViewExpandedText());
        Assert.assertEquals((String)"Comparing TableType", (Object)"MANAGED_TABLE", (Object)createdTable.getTableType());
        Assert.assertTrue((String)"Creation metadata should be empty", (createdTable.getCreationMetadata() == null ? 1 : 0) != 0);
        StorageDescriptor createdSd = createdTable.getSd();
        Assert.assertEquals((String)"Storage descriptor cols", (long)1L, (long)createdSd.getCols().size());
        Assert.assertNull((String)"Storage descriptor cols[0].comment", (Object)((FieldSchema)createdSd.getCols().get(0)).getComment());
        Assert.assertEquals((String)"Storage descriptor location", (Object)(this.metaStore.getWarehouseRoot() + "/" + table.getTableName()), (Object)createdSd.getLocation());
        Assert.assertTrue((String)"Table path should be created", (boolean)this.metaStore.isPathExists(new Path(createdSd.getLocation())));
        Assert.assertNull((String)"Storage descriptor input format", (Object)createdSd.getInputFormat());
        Assert.assertNull((String)"Storage descriptor output format", (Object)createdSd.getOutputFormat());
        Assert.assertFalse((String)"Storage descriptor compressed", (boolean)createdSd.isCompressed());
        Assert.assertEquals((String)"Storage descriptor num buckets", (long)0L, (long)createdSd.getNumBuckets());
        Assert.assertEquals((String)"Storage descriptor bucket cols", (long)0L, (long)createdSd.getBucketCols().size());
        Assert.assertEquals((String)"Storage descriptor sort cols", (long)0L, (long)createdSd.getSortCols().size());
        Assert.assertEquals((String)"Storage descriptor parameters", (long)0L, (long)createdSd.getParameters().size());
        Assert.assertFalse((String)"Storage descriptor stored as subdir", (boolean)createdSd.isStoredAsSubDirectories());
        SerDeInfo serDeInfo = createdSd.getSerdeInfo();
        Assert.assertNull((String)"SerDeInfo name", (Object)serDeInfo.getName());
        Assert.assertNull((String)"SerDeInfo serialization lib", (Object)serDeInfo.getSerializationLib());
        Assert.assertEquals((String)"SerDeInfo parameters", (long)0L, (long)serDeInfo.getParameters().size());
        SkewedInfo skewedInfo = createdSd.getSkewedInfo();
        Assert.assertEquals((String)"Skewed info col names", (long)0L, (long)skewedInfo.getSkewedColNames().size());
        Assert.assertEquals((String)"Skewed info col values", (long)0L, (long)skewedInfo.getSkewedColValues().size());
        Assert.assertEquals((String)"Skewed info col value maps", (long)0L, (long)skewedInfo.getSkewedColValueLocationMaps().size());
    }

    @Test
    public void testCreateTableDefaultLocationInSpecificDatabase() throws Exception {
        Table table = new Table();
        StorageDescriptor sd = new StorageDescriptor();
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        table.setDbName(OTHER_DATABASE);
        table.setTableName("test_table_2");
        cols.add(new FieldSchema("column_name", "int", null));
        sd.setCols(cols);
        sd.setSerdeInfo(new SerDeInfo());
        table.setSd(sd);
        this.client.createTable(table);
        Table createdTable = this.client.getTable(table.getDbName(), table.getTableName());
        Assert.assertEquals((String)"Storage descriptor location", (Object)(this.metaStore.getWarehouseRoot() + "/" + table.getDbName() + ".db/" + table.getTableName()), (Object)createdTable.getSd().getLocation());
    }

    @Test
    public void testCreateTableRooPathLocationInSpecificDatabase() {
        Table table = new Table();
        StorageDescriptor sd = new StorageDescriptor();
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        sd.setLocation("hdfs://localhost:8020");
        table.setDbName(DEFAULT_DATABASE);
        table.setTableName("test_table_2_with_root_path");
        cols.add(new FieldSchema("column_name", "int", null));
        sd.setCols(cols);
        sd.setSerdeInfo(new SerDeInfo());
        table.setSd(sd);
        Exception exception = (Exception)Assert.assertThrows(InvalidObjectException.class, () -> this.client.createTable(table));
        Assert.assertEquals((String)"Storage descriptor location", (Object)(table.getTableName() + " location must not be root path"), (Object)exception.getMessage());
    }

    @Test
    public void testCreateTableDefaultValuesView() throws Exception {
        Table table = new Table();
        StorageDescriptor sd = new StorageDescriptor();
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        table.setDbName(DEFAULT_DATABASE);
        table.setTableName("test_table_2");
        table.setTableType("VIRTUAL_VIEW");
        cols.add(new FieldSchema("column_name", "int", null));
        sd.setCols(cols);
        sd.setSerdeInfo(new SerDeInfo());
        table.setSd(sd);
        this.client.createTable(table);
        Table createdTable = this.client.getTable(table.getDbName(), table.getTableName());
        Assert.assertNull((String)"Storage descriptor location should be null", (Object)createdTable.getSd().getLocation());
    }

    @Test(expected=MetaException.class)
    public void testCreateTableNullDatabase() throws Exception {
        Table table = this.testTables[0];
        table.setDbName(null);
        this.client.createTable(table);
    }

    @Test(expected=MetaException.class)
    public void testCreateTableNullTableName() throws Exception {
        Table table = this.testTables[0];
        table.setTableName(null);
        this.client.createTable(table);
    }

    @Test(expected=InvalidObjectException.class)
    public void testCreateTableInvalidTableName() throws Exception {
        Table table = this.testTables[0];
        table.setTableName("test\u00a7table;");
        this.client.createTable(table);
    }

    @Test(expected=InvalidObjectException.class)
    public void testCreateTableEmptyName() throws Exception {
        Table table = this.testTables[0];
        table.setTableName("");
        this.client.createTable(table);
    }

    @Test(expected=MetaException.class)
    public void testCreateTableNullStorageDescriptor() throws Exception {
        Table table = this.testTables[0];
        table.setTableName("NullStorageT");
        table.setSd(null);
        this.client.createTable(table);
    }

    private Table getNewTable() throws MetaException {
        return ((TableBuilder)new TableBuilder().setTableName("test_table_with_invalid_sd").addCol("test_col", "int")).build(this.metaStore.getConf());
    }

    @Test(expected=MetaException.class)
    public void testCreateTableInvalidStorageDescriptorNullColumns() throws Exception {
        Table table = this.getNewTable();
        table.getSd().setCols(null);
        this.client.createTable(table);
    }

    @Test(expected=MetaException.class)
    public void testCreateTableInvalidStorageDescriptorNullSerdeInfo() throws Exception {
        Table table = this.getNewTable();
        table.getSd().setSerdeInfo(null);
        this.client.createTable(table);
    }

    @Test(expected=MetaException.class)
    public void testCreateTableInvalidStorageDescriptorNullColumnType() throws Exception {
        Table table = this.getNewTable();
        ((FieldSchema)table.getSd().getCols().get(0)).setType(null);
        this.client.createTable(table);
    }

    @Test(expected=InvalidObjectException.class)
    public void testCreateTableInvalidStorageDescriptorInvalidColumnType() throws Exception {
        Table table = this.getNewTable();
        ((FieldSchema)table.getSd().getCols().get(0)).setType("xyz");
        this.client.createTable(table);
    }

    @Test(expected=InvalidObjectException.class)
    public void testCreateTableNoSuchDatabase() throws Exception {
        Table table = this.testTables[0];
        table.setDbName("no_such_database");
        this.client.createTable(table);
    }

    @Test(expected=AlreadyExistsException.class)
    public void testCreateTableAlreadyExists() throws Exception {
        Table table = this.testTables[0];
        table.unsetId();
        this.client.createTable(table);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testDropTableNoSuchDatabase() throws Exception {
        Table table = this.testTables[2];
        this.client.dropTable("no_such_database", table.getTableName(), true, false);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testDropTableNoSuchTable() throws Exception {
        Table table = this.testTables[2];
        this.client.dropTable(table.getDbName(), "no_such_table", true, false);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testDropTableNoSuchTableInTheDatabase() throws Exception {
        Table table = this.testTables[2];
        this.client.dropTable(OTHER_DATABASE, table.getTableName(), true, false);
    }

    @Test
    public void testDropTableNullDatabase() throws Exception {
        try {
            this.client.dropTable(null, OTHER_DATABASE, true, false);
            Assert.fail((String)"Expected an MetaException or TProtocolException to be thrown");
        }
        catch (MetaException metaException) {
        }
        catch (TProtocolException tProtocolException) {
            // empty catch block
        }
    }

    @Test
    public void testDropTableNullTableName() throws Exception {
        try {
            this.client.dropTable(DEFAULT_DATABASE, null, true, false);
            Assert.fail((String)"Expected an MetaException or TProtocolException to be thrown");
        }
        catch (MetaException metaException) {
        }
        catch (TProtocolException tProtocolException) {
            // empty catch block
        }
    }

    @Test
    public void testDropTableCaseInsensitive() throws Exception {
        Table table = this.testTables[0];
        this.client.dropTable(table.getDbName().toUpperCase(), table.getTableName().toUpperCase());
        try {
            this.client.getTable(table.getDbName(), table.getTableName());
            Assert.fail((String)"Expected a NoSuchObjectException to be thrown");
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        table.unsetId();
        this.client.createTable(table);
        this.client.dropTable("DeFaUlt", "TeST_tAbLE");
        try {
            this.client.getTable(table.getDbName(), table.getTableName());
            Assert.fail((String)"Expected a NoSuchObjectException to be thrown");
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    @Test
    public void testDropTableDeleteDir() throws Exception {
        Table table = this.testTables[0];
        Partition externalPartition = this.client.getPartition(this.partitionedTable.getDbName(), this.partitionedTable.getTableName(), "test_part_col=a2");
        this.client.dropTable(table.getDbName(), table.getTableName(), true, false);
        Assert.assertFalse((String)"Table path should be removed", (boolean)this.metaStore.isPathExists(new Path(table.getSd().getLocation())));
        table.unsetId();
        this.client.createTable(table);
        this.client.dropTable(table.getDbName(), table.getTableName(), false, false);
        Assert.assertTrue((String)"Table path should be kept", (boolean)this.metaStore.isPathExists(new Path(table.getSd().getLocation())));
        this.client.dropTable(this.partitionedTable.getDbName(), this.partitionedTable.getTableName(), true, false);
        Assert.assertFalse((String)"Table path should be removed", (boolean)this.metaStore.isPathExists(new Path(this.partitionedTable.getSd().getLocation())));
        Assert.assertFalse((String)"Extra partition path should be removed", (boolean)this.metaStore.isPathExists(new Path(externalPartition.getSd().getLocation())));
    }

    @Test
    public void testDropTableIgnoreUnknown() throws Exception {
        Table table = this.testTables[0];
        this.client.dropTable("no_such_database", table.getTableName(), true, true);
        this.client.dropTable(table.getDbName(), "no_such_table", false, true);
        this.client.dropTable(OTHER_DATABASE, table.getTableName(), true, true);
        this.client.dropTable("no_such_database", table.getTableName());
        this.client.dropTable(table.getDbName(), "no_such_table");
        this.client.dropTable(OTHER_DATABASE, table.getTableName());
    }

    @Test
    public void testDropTableWithPurge() throws Exception {
        Table table = this.testTables[0];
        this.client.dropTable(table.getDbName(), table.getTableName(), true, true, true);
        Assert.assertFalse((String)"Table path should be removed", (boolean)this.metaStore.isPathExists(new Path(table.getSd().getLocation())));
        Assert.assertFalse((String)"Table path should not be in trash", (boolean)this.metaStore.isPathExistsInTrash(new Path(table.getSd().getLocation())));
    }

    @Test
    public void testDropTableWithoutPurge() throws Exception {
        Table table = this.testTables[0];
        this.client.dropTable(table.getDbName(), table.getTableName(), true, true, false);
        Assert.assertFalse((String)"Table path should be removed", (boolean)this.metaStore.isPathExists(new Path(table.getSd().getLocation())));
        Assert.assertTrue((String)"Table path should be in trash", (boolean)this.metaStore.isPathExistsInTrash(new Path(table.getSd().getLocation())));
    }

    @Test
    public void testDropTableExternalWithPurge() throws Exception {
        Table table = this.externalTable;
        this.client.dropTable(table.getDbName(), table.getTableName(), true, true, true);
        Assert.assertTrue((String)"Table path should not be removed", (boolean)this.metaStore.isPathExists(new Path(table.getSd().getLocation())));
        Assert.assertFalse((String)"Table path should not be in trash", (boolean)this.metaStore.isPathExistsInTrash(new Path(table.getSd().getLocation())));
        Table newTable = table.deepCopy();
        newTable.setTableName("external_table_for_purge");
        newTable.getSd().setLocation(this.metaStore.getWarehouseRoot() + "/external/purge_table_dir");
        newTable.getParameters().put("external.table.purge", "true");
        this.client.createTable(newTable);
        this.client.dropTable(newTable.getDbName(), newTable.getTableName(), true, true, true);
        Assert.assertFalse((String)"Table path should be removed", (boolean)this.metaStore.isPathExists(new Path(newTable.getSd().getLocation())));
        Assert.assertFalse((String)"Table path should not be in trash", (boolean)this.metaStore.isPathExistsInTrash(new Path(newTable.getSd().getLocation())));
        newTable.getParameters().put("skip.trash", "true");
        this.client.createTable(newTable);
        this.client.dropTable(newTable.getDbName(), newTable.getTableName(), true, true, false);
        Assert.assertFalse((String)"Table path should be removed", (boolean)this.metaStore.isPathExists(new Path(newTable.getSd().getLocation())));
        Assert.assertFalse((String)"Table path should not be in trash", (boolean)this.metaStore.isPathExistsInTrash(new Path(newTable.getSd().getLocation())));
    }

    @Test
    public void testDropTableExternalWithoutPurge() throws Exception {
        Table table = this.externalTable;
        this.client.dropTable(table.getDbName(), table.getTableName(), true, true, false);
        Assert.assertTrue((String)"Table path should not be removed", (boolean)this.metaStore.isPathExists(new Path(table.getSd().getLocation())));
        Assert.assertFalse((String)"Table path should not be in trash", (boolean)this.metaStore.isPathExistsInTrash(new Path(table.getSd().getLocation())));
        Table newTable = table.deepCopy();
        newTable.setTableName("external_table_for_purge");
        newTable.getSd().setLocation(this.metaStore.getWarehouseRoot() + "/external/purge_table_dir");
        newTable.getParameters().put("external.table.purge", "true");
        this.client.createTable(newTable);
        this.client.dropTable(newTable.getDbName(), newTable.getTableName(), true, true, false);
        Assert.assertFalse((String)"Table path should be removed", (boolean)this.metaStore.isPathExists(new Path(newTable.getSd().getLocation())));
        Assert.assertTrue((String)"Table path should be in trash", (boolean)this.metaStore.isPathExistsInTrash(new Path(newTable.getSd().getLocation())));
    }

    @Test
    public void testTruncateTableUnpartitioned() throws Exception {
        Path dataFile = new Path(this.testTables[0].getSd().getLocation() + "/dataFile");
        this.client.truncateTable(this.testTables[0].getDbName(), this.testTables[0].getTableName(), null);
        Assert.assertTrue((String)"Location should exist", (boolean)this.metaStore.isPathExists(new Path(this.testTables[0].getSd().getLocation())));
        Assert.assertFalse((String)"DataFile should be removed", (boolean)this.metaStore.isPathExists(dataFile));
    }

    @Test
    public void testTruncateTablePartitioned() throws Exception {
        ArrayList<String> partitionsToDelete = new ArrayList<String>();
        partitionsToDelete.add("test_part_col=a0");
        partitionsToDelete.add("test_part_col=a2");
        this.client.truncateTable(this.partitionedTable.getDbName(), this.partitionedTable.getTableName(), partitionsToDelete);
        Assert.assertTrue((String)"Location should exist", (boolean)this.metaStore.isPathExists(new Path(this.testTables[0].getSd().getLocation())));
        List partitions = this.client.listPartitions(this.partitionedTable.getDbName(), this.partitionedTable.getTableName(), (short)-1);
        for (Partition partition : partitions) {
            Path dataFile = new Path(partition.getSd().getLocation() + "/dataFile");
            if (partition.getValues().contains("a0") || partition.getValues().contains("a2")) {
                Assert.assertFalse((String)"DataFile should be removed", (boolean)this.metaStore.isPathExists(dataFile));
                continue;
            }
            Assert.assertTrue((String)"DataFile should not be removed", (boolean)this.metaStore.isPathExists(dataFile));
        }
    }

    @Test
    public void testTruncateTablePartitionedDeleteAll() throws Exception {
        this.client.truncateTable(this.partitionedTable.getDbName(), this.partitionedTable.getTableName(), null);
        Assert.assertTrue((String)"Location should exist", (boolean)this.metaStore.isPathExists(new Path(this.testTables[0].getSd().getLocation())));
        List partitions = this.client.listPartitions(this.partitionedTable.getDbName(), this.partitionedTable.getTableName(), (short)-1);
        for (Partition partition : partitions) {
            Path dataFile = new Path(partition.getSd().getLocation() + "/dataFile");
            Assert.assertFalse((String)"Every dataFile should be removed", (boolean)this.metaStore.isPathExists(dataFile));
        }
    }

    @Test
    public void testAlterTable() throws Exception {
        Table originalTable = this.testTables[2];
        String originalTableName = originalTable.getTableName();
        String originalDatabase = originalTable.getDbName();
        Table newTable = this.getTableWithAllParametersSet();
        newTable.setTableName(originalTableName);
        newTable.setDbName(originalDatabase);
        newTable.setPartitionKeys(originalTable.getPartitionKeys());
        this.client.alter_table(originalDatabase, originalTableName, newTable);
        Table alteredTable = this.client.getTable(originalDatabase, originalTableName);
        for (String key : newTable.getParameters().keySet()) {
            Assert.assertEquals((String)"parameters are present", newTable.getParameters().get(key), alteredTable.getParameters().get(key));
        }
        newTable.setParameters(alteredTable.getParameters());
        newTable.setCreateTime(alteredTable.getCreateTime());
        newTable.setCreationMetadata(alteredTable.getCreationMetadata());
        newTable.setWriteId(alteredTable.getWriteId());
        Assert.assertTrue((boolean)alteredTable.isSetId());
        alteredTable.unsetId();
        Assert.assertEquals((String)"The table data should be the same", (Object)newTable, (Object)alteredTable);
    }

    @Test
    public void testAlterTableRename() throws Exception {
        Table originalTable = this.testTables[2];
        String originalTableName = originalTable.getTableName();
        String originalDatabase = originalTable.getDbName();
        Table newTable = originalTable.deepCopy();
        newTable.setTableName("new_table");
        this.client.alter_table(originalDatabase, originalTableName, newTable);
        List tableNames = this.client.getTables(originalDatabase, originalTableName);
        Assert.assertEquals((String)"Original table should be removed", (long)0L, (long)tableNames.size());
        Assert.assertFalse((String)"Original table directory should be removed", (boolean)this.metaStore.isPathExists(new Path(originalTable.getSd().getLocation())));
        Table alteredTable = this.client.getTable(newTable.getDbName(), newTable.getTableName());
        Assert.assertTrue((String)"New table directory should exist", (boolean)this.metaStore.isPathExists(new Path(alteredTable.getSd().getLocation())));
        Assert.assertEquals((String)"New directory should be set", (Object)new Path(this.metaStore.getWarehouseRoot() + "/" + alteredTable.getTableName()), (Object)new Path(alteredTable.getSd().getLocation()));
        Path dataFile = new Path(alteredTable.getSd().getLocation() + "/dataFile");
        Assert.assertTrue((String)"New directory should contain data", (boolean)this.metaStore.isPathExists(dataFile));
        newTable.getSd().setLocation(alteredTable.getSd().getLocation());
        Assert.assertEquals((String)"The table data should be the same", (Object)newTable, (Object)alteredTable);
    }

    @Test
    public void testAlterTableChangingDatabase() throws Exception {
        Table originalTable = this.testTables[2];
        String originalTableName = originalTable.getTableName();
        String originalDatabase = originalTable.getDbName();
        Table newTable = originalTable.deepCopy();
        newTable.setDbName(OTHER_DATABASE);
        this.client.alter_table(originalDatabase, originalTableName, newTable);
        List tableNames = this.client.getTables(originalDatabase, originalTableName);
        Assert.assertEquals((String)"Original table should be removed", (long)0L, (long)tableNames.size());
        Assert.assertFalse((String)"Original table directory should be removed", (boolean)this.metaStore.isPathExists(new Path(originalTable.getSd().getLocation())));
        Table alteredTable = this.client.getTable(newTable.getDbName(), newTable.getTableName());
        Assert.assertTrue((String)"New table directory should exist", (boolean)this.metaStore.isPathExists(new Path(alteredTable.getSd().getLocation())));
        Assert.assertEquals((String)"New directory should be set", (Object)new Path(this.metaStore.getWarehouseRoot() + "/" + alteredTable.getDbName() + ".db/" + alteredTable.getTableName()), (Object)new Path(alteredTable.getSd().getLocation()));
        Path dataFile = new Path(alteredTable.getSd().getLocation() + "/dataFile");
        Assert.assertTrue((String)"New directory should contain data", (boolean)this.metaStore.isPathExists(dataFile));
        newTable.getSd().setLocation(alteredTable.getSd().getLocation());
        Assert.assertEquals((String)"The table data should be the same", (Object)newTable, (Object)alteredTable);
    }

    @Test
    public void testAlterTableExternalTable() throws Exception {
        Table originalTable = this.externalTable;
        String originalTableName = originalTable.getTableName();
        String originalDatabase = originalTable.getDbName();
        Table newTable = originalTable.deepCopy();
        newTable.setTableName("new_external_table_for_test");
        this.client.alter_table(originalDatabase, originalTableName, newTable);
        List tableNames = this.client.getTables(originalDatabase, originalTableName);
        Assert.assertEquals((String)"Original table should be removed", (long)0L, (long)tableNames.size());
        Assert.assertTrue((String)"Original table directory should be kept", (boolean)this.metaStore.isPathExists(new Path(originalTable.getSd().getLocation())));
        Table alteredTable = this.client.getTable(newTable.getDbName(), newTable.getTableName());
        Assert.assertEquals((String)"New location should be the same", (Object)originalTable.getSd().getLocation(), (Object)alteredTable.getSd().getLocation());
        Path dataFile = new Path(alteredTable.getSd().getLocation() + "/dataFile");
        Assert.assertTrue((String)"The location should contain data", (boolean)this.metaStore.isPathExists(dataFile));
        for (String key : newTable.getParameters().keySet()) {
            Assert.assertEquals((String)"parameters are present", newTable.getParameters().get(key), alteredTable.getParameters().get(key));
        }
        newTable.setParameters(alteredTable.getParameters());
        Assert.assertEquals((String)"The table data should be the same", (Object)newTable, (Object)alteredTable);
    }

    @Test
    public void testAlterTableExternalTableChangeLocation() throws Exception {
        Table originalTable = this.externalTable;
        Table newTable = originalTable.deepCopy();
        newTable.getSd().setLocation(newTable.getSd().getLocation() + "_modified");
        this.client.alter_table(originalTable.getDbName(), originalTable.getTableName(), newTable);
        Table alteredTable = this.client.getTable(newTable.getDbName(), newTable.getTableName());
        Assert.assertTrue((String)"Original table directory should be kept", (boolean)this.metaStore.isPathExists(new Path(originalTable.getSd().getLocation())));
        Assert.assertEquals((String)"New location should be the new one", (Object)newTable.getSd().getLocation(), (Object)alteredTable.getSd().getLocation());
        Path dataFile = new Path(alteredTable.getSd().getLocation() + "/dataFile");
        Assert.assertFalse((String)"The location should not contain data", (boolean)this.metaStore.isPathExists(dataFile));
        for (String key : newTable.getParameters().keySet()) {
            Assert.assertEquals((String)"parameters are present", newTable.getParameters().get(key), alteredTable.getParameters().get(key));
        }
        newTable.setParameters(alteredTable.getParameters());
        newTable.getSd().setLocation(alteredTable.getSd().getLocation());
        Assert.assertEquals((String)"The table data should be the same", (Object)newTable, (Object)alteredTable);
    }

    @Test
    public void testAlterTableChangeCols() throws Exception {
        Table originalTable = this.partitionedTable;
        Table newTable = originalTable.deepCopy();
        List cols = newTable.getSd().getCols();
        ((FieldSchema)cols.get(0)).setName("modified_col");
        cols.remove(1);
        cols.add(new FieldSchema("new_col", "int", null));
        this.client.alter_table(originalTable.getDbName(), originalTable.getTableName(), newTable);
        Table alteredTable = this.client.getTable(newTable.getDbName(), newTable.getTableName());
        Assert.assertTrue((String)"Original table directory should be kept", (boolean)this.metaStore.isPathExists(new Path(originalTable.getSd().getLocation())));
        alteredTable.setParameters(newTable.getParameters());
        Assert.assertEquals((String)"The table data should be the same", (Object)newTable, (Object)alteredTable);
        ((FieldSchema)newTable.getPartitionKeys().get(0)).setType("string");
        ((FieldSchema)newTable.getPartitionKeys().get(0)).setComment("changed comment");
        this.client.alter_table(originalTable.getDbName(), originalTable.getTableName(), newTable);
        alteredTable = this.client.getTable(newTable.getDbName(), newTable.getTableName());
        alteredTable.setParameters(newTable.getParameters());
        Assert.assertEquals((String)"The table data should be the same", (Object)newTable, (Object)alteredTable);
    }

    @Test
    public void testAlterTableCascade() throws Exception {
        Table originalTable = this.partitionedTable;
        Table newTable = originalTable.deepCopy();
        List cols = newTable.getSd().getCols();
        cols.add(new FieldSchema("new_col_1", "int", null));
        this.client.alter_table(originalTable.getDbName(), originalTable.getTableName(), newTable, false);
        Table alteredTable = this.client.getTable(newTable.getDbName(), newTable.getTableName());
        Assert.assertEquals((String)"The table data should be changed", (Object)newTable, (Object)alteredTable);
        List partitions = this.client.listPartitions(originalTable.getDbName(), originalTable.getTableName(), (short)-1);
        for (Partition partition : partitions) {
            Assert.assertEquals((String)"Partition columns should not be changed", (long)2L, (long)partition.getSd().getCols().size());
        }
        cols.add(new FieldSchema("new_col_2", "int", null));
        this.client.alter_table(originalTable.getDbName(), originalTable.getTableName(), newTable, true);
        alteredTable = this.client.getTable(newTable.getDbName(), newTable.getTableName());
        Assert.assertEquals((String)"The table data should be changed", (Object)newTable, (Object)alteredTable);
        partitions = this.client.listPartitions(originalTable.getDbName(), originalTable.getTableName(), (short)-1);
        for (Partition partition : partitions) {
            Assert.assertEquals((String)"Partition columns should be changed", (long)4L, (long)partition.getSd().getCols().size());
        }
        cols.add(new FieldSchema("new_col_3", "int", null));
        EnvironmentContext context = new EnvironmentContext();
        context.putToProperties("CASCADE", "true");
        this.client.alter_table_with_environmentContext(originalTable.getDbName(), originalTable.getTableName(), newTable, context);
        alteredTable = this.client.getTable(newTable.getDbName(), newTable.getTableName());
        Assert.assertEquals((String)"The table data should be changed", (Object)newTable, (Object)alteredTable);
        partitions = this.client.listPartitions(originalTable.getDbName(), originalTable.getTableName(), (short)-1);
        for (Partition partition : partitions) {
            Assert.assertEquals((String)"Partition columns should be changed", (long)5L, (long)partition.getSd().getCols().size());
        }
    }

    @Test(expected=MetaException.class)
    public void testAlterTableNullDatabaseInNew() throws Exception {
        Table originalTable = this.testTables[0];
        Table newTable = originalTable.deepCopy();
        newTable.setDbName(null);
        this.client.alter_table(originalTable.getDbName(), originalTable.getTableName(), newTable);
    }

    @Test
    public void testAlterTableNullTableNameInNew() throws Exception {
        Table originalTable = this.testTables[0];
        Table newTable = originalTable.deepCopy();
        newTable.setTableName(null);
        try {
            this.client.alter_table(originalTable.getDbName(), originalTable.getTableName(), newTable);
            Assert.fail((String)"Expected exception");
        }
        catch (MetaException | TProtocolException throwable) {
            // empty catch block
        }
    }

    @Test(expected=InvalidOperationException.class)
    public void testAlterTableInvalidTableNameInNew() throws Exception {
        Table originalTable = this.testTables[0];
        Table newTable = originalTable.deepCopy();
        newTable.setTableName("test\u00a7table;");
        this.client.alter_table(originalTable.getDbName(), originalTable.getTableName(), newTable);
    }

    @Test(expected=InvalidOperationException.class)
    public void testAlterTableEmptyTableNameInNew() throws Exception {
        Table originalTable = this.testTables[0];
        Table newTable = originalTable.deepCopy();
        newTable.setTableName("");
        this.client.alter_table(originalTable.getDbName(), originalTable.getTableName(), newTable);
    }

    @Test(expected=MetaException.class)
    public void testAlterTableNullStorageDescriptorInNew() throws Exception {
        Table originalTable = this.testTables[0];
        Table newTable = originalTable.deepCopy();
        newTable.setSd(null);
        this.client.alter_table(originalTable.getDbName(), originalTable.getTableName(), newTable);
    }

    @Test
    public void testAlterTableNullDatabase() throws Exception {
        Table originalTable = this.testTables[0];
        Table newTable = originalTable.deepCopy();
        try {
            this.client.alter_table(null, originalTable.getTableName(), newTable);
            Assert.fail((String)"Expected exception");
        }
        catch (MetaException | TProtocolException throwable) {
            // empty catch block
        }
    }

    @Test
    public void testAlterTableNullTableName() throws Exception {
        Table originalTable = this.testTables[0];
        Table newTable = originalTable.deepCopy();
        try {
            this.client.alter_table(originalTable.getDbName(), null, newTable);
            Assert.fail((String)"Expected exception");
        }
        catch (MetaException | TProtocolException throwable) {
            // empty catch block
        }
    }

    @Test
    public void testAlterTableNullNewTable() throws Exception {
        Table originalTable = this.testTables[0];
        try {
            this.client.alter_table(originalTable.getDbName(), originalTable.getTableName(), null);
            Assert.fail((String)"Expected a NullPointerException or TTransportException to be thrown");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (TProtocolException tProtocolException) {
            // empty catch block
        }
    }

    @Test(expected=MetaException.class)
    public void testAlterTableInvalidStorageDescriptorNullCols() throws Exception {
        Table originalTable = this.testTables[0];
        Table newTable = originalTable.deepCopy();
        newTable.getSd().setCols(null);
        this.client.alter_table(originalTable.getDbName(), originalTable.getTableName(), newTable);
    }

    @Test(expected=MetaException.class)
    public void testAlterTableInvalidStorageDescriptorNullSerdeInfo() throws Exception {
        Table originalTable = this.testTables[0];
        Table newTable = originalTable.deepCopy();
        newTable.getSd().setSerdeInfo(null);
        this.client.alter_table(originalTable.getDbName(), originalTable.getTableName(), newTable);
    }

    @Test(expected=MetaException.class)
    public void testAlterTableInvalidStorageDescriptorNullColumnType() throws Exception {
        Table originalTable = this.testTables[0];
        Table newTable = originalTable.deepCopy();
        ((FieldSchema)newTable.getSd().getCols().get(0)).setType(null);
        this.client.alter_table(originalTable.getDbName(), originalTable.getTableName(), newTable);
    }

    @Test(expected=MetaException.class)
    public void testAlterTableInvalidStorageDescriptorNullLocation() throws Exception {
        Table originalTable = this.testTables[0];
        Table newTable = originalTable.deepCopy();
        newTable.getSd().setLocation(null);
        this.client.alter_table(originalTable.getDbName(), originalTable.getTableName(), newTable);
    }

    @Test(expected=InvalidOperationException.class)
    public void testAlterTableInvalidStorageDescriptorInvalidColumnType() throws Exception {
        Table originalTable = this.testTables[0];
        Table newTable = originalTable.deepCopy();
        ((FieldSchema)newTable.getSd().getCols().get(0)).setType("xyz");
        this.client.alter_table(originalTable.getDbName(), originalTable.getTableName(), newTable);
    }

    @Test(expected=InvalidOperationException.class)
    public void testAlterTableInvalidStorageDescriptorAddPartitionColumns() throws Exception {
        Table originalTable = this.testTables[0];
        Table newTable = originalTable.deepCopy();
        newTable.addToPartitionKeys(new FieldSchema("new_part", "int", "comment"));
        this.client.alter_table(originalTable.getDbName(), originalTable.getTableName(), newTable);
    }

    @Test(expected=InvalidOperationException.class)
    public void testAlterTableInvalidStorageDescriptorAlterPartitionColumnName() throws Exception {
        Table originalTable = this.partitionedTable;
        Table newTable = originalTable.deepCopy();
        ((FieldSchema)newTable.getPartitionKeys().get(0)).setName("altered_name");
        this.client.alter_table(originalTable.getDbName(), originalTable.getTableName(), newTable);
    }

    @Test(expected=InvalidOperationException.class)
    public void testAlterTableInvalidStorageDescriptorRemovePartitionColumn() throws Exception {
        Table originalTable = this.partitionedTable;
        Table newTable = originalTable.deepCopy();
        newTable.getPartitionKeys().remove(0);
        this.client.alter_table(originalTable.getDbName(), originalTable.getTableName(), newTable);
    }

    @Test(expected=InvalidOperationException.class)
    public void testAlterTableNoSuchDatabase() throws Exception {
        Table originalTable = this.testTables[2];
        Table newTable = originalTable.deepCopy();
        this.client.alter_table("no_such_database", originalTable.getTableName(), newTable);
    }

    @Test(expected=InvalidOperationException.class)
    public void testAlterTableNoSuchTable() throws Exception {
        Table originalTable = this.testTables[2];
        Table newTable = originalTable.deepCopy();
        this.client.alter_table(originalTable.getDbName(), "no_such_table_name", newTable);
    }

    @Test(expected=InvalidOperationException.class)
    public void testAlterTableNoSuchTableInThisDatabase() throws Exception {
        Table originalTable = this.testTables[2];
        Table newTable = originalTable.deepCopy();
        this.client.alter_table(OTHER_DATABASE, originalTable.getTableName(), newTable);
    }

    @Test
    public void testAlterTableAlreadyExists() throws Exception {
        Table originalTable = this.testTables[0];
        Table newTable = originalTable.deepCopy();
        newTable.setTableName(this.testTables[2].getTableName());
        try {
            this.client.alter_table(originalTable.getDbName(), originalTable.getTableName(), newTable);
            Assert.fail((String)"Expected an InvalidOperationException to be thrown");
        }
        catch (InvalidOperationException invalidOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testAlterTableExpectedPropertyMatch() throws Exception {
        Table originalTable = this.testTables[0];
        EnvironmentContext context = new EnvironmentContext();
        context.putToProperties("expected_parameter_key", "transient_lastDdlTime");
        context.putToProperties("expected_parameter_value", (String)originalTable.getParameters().get("transient_lastDdlTime"));
        this.client.alter_table(originalTable.getCatName(), originalTable.getDbName(), originalTable.getTableName(), originalTable, context);
    }

    @Test(expected=MetaException.class)
    public void testAlterTableExpectedPropertyDifferent() throws Exception {
        Table originalTable = this.testTables[0];
        EnvironmentContext context = new EnvironmentContext();
        context.putToProperties("expected_parameter_key", "transient_lastDdlTime");
        context.putToProperties("expected_parameter_value", "alma");
        this.client.alter_table(originalTable.getCatName(), originalTable.getDbName(), originalTable.getTableName(), originalTable, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAlterTableExpectedPropertyConcurrent() throws Exception {
        Table originalTable = this.testTables[0];
        originalTable.getParameters().put("snapshot", "0");
        this.client.alter_table(originalTable.getCatName(), originalTable.getDbName(), originalTable.getTableName(), originalTable, null);
        ExecutorService threads = null;
        try {
            threads = Executors.newFixedThreadPool(2);
            for (int i = 0; i < 3; ++i) {
                EnvironmentContext context = new EnvironmentContext();
                context.putToProperties("expected_parameter_key", "snapshot");
                context.putToProperties("expected_parameter_value", String.valueOf(i));
                Table newTable = originalTable.deepCopy();
                newTable.getParameters().put("snapshot", String.valueOf(i + 1));
                HiveMetaStoreClient client1 = this.metaStore.getClient();
                HiveMetaStoreClient client2 = this.metaStore.getClient();
                ArrayList<Callable<Boolean>> concurrentTasks = new ArrayList<Callable<Boolean>>(2);
                concurrentTasks.add(this.alterTask((IMetaStoreClient)client1, newTable, context));
                concurrentTasks.add(this.alterTask((IMetaStoreClient)client2, newTable, context));
                List results = threads.invokeAll(concurrentTasks);
                boolean foundSuccess = false;
                boolean foundFailure = false;
                for (Future future : results) {
                    if (((Boolean)future.get()).booleanValue()) {
                        foundSuccess = true;
                        continue;
                    }
                    foundFailure = true;
                }
                Assert.assertTrue((String)"At least one success is expected", (boolean)foundSuccess);
                Assert.assertTrue((String)"At least one failure is expected", (boolean)foundFailure);
            }
        }
        finally {
            if (threads != null) {
                threads.shutdown();
            }
        }
    }

    private Callable<Boolean> alterTask(IMetaStoreClient hmsClient, Table newTable, EnvironmentContext context) {
        return () -> {
            try {
                hmsClient.alter_table(newTable.getCatName(), newTable.getDbName(), newTable.getTableName(), newTable, context);
            }
            catch (Throwable e) {
                return false;
            }
            return true;
        };
    }

    @Test
    public void tablesInOtherCatalogs() throws TException, URISyntaxException {
        int i;
        String catName = "create_etc_tables_in_other_catalogs";
        Catalog cat = new CatalogBuilder().setName(catName).setLocation(MetaStoreTestUtils.getTestWarehouseDir(catName)).build();
        this.client.createCatalog(cat);
        String dbName = "db_in_other_catalog";
        Database db = new DatabaseBuilder().setName(dbName).setCatalogName(catName).create(this.client, this.metaStore.getConf());
        Table table = ((TableBuilder)((TableBuilder)new TableBuilder().inDb(db).setTableName("mvSource").addCol("col1_1", "string")).addCol("col2_2", "int")).build(this.metaStore.getConf());
        this.client.createTable(table);
        SourceTable sourceTable = TestHiveMetaStore.createSourceTable(table);
        String[] tableNames = new String[4];
        for (int i2 = 0; i2 < tableNames.length; ++i2) {
            tableNames[i2] = "table_in_other_catalog_" + i2;
            TableBuilder builder = (TableBuilder)((TableBuilder)new TableBuilder().inDb(db).setTableName(tableNames[i2]).addCol("col1_" + i2, "string")).addCol("col2_" + i2, "int");
            if (i2 == 0) {
                builder.setLocation(MetaStoreTestUtils.getTestWarehouseDir(tableNames[i2]));
            }
            if (i2 == 2) {
                builder.addPartCol("pcol1", "string");
            }
            if (i2 == 3) {
                builder.setType(TableType.MATERIALIZED_VIEW.name()).setRewriteEnabled(true).addMaterializedViewReferencedTable(sourceTable);
            }
            this.client.createTable(builder.build(this.metaStore.getConf()));
        }
        String[] partVals = new String[3];
        Table partitionedTable = this.client.getTable(catName, dbName, tableNames[2]);
        for (i = 0; i < partVals.length; ++i) {
            partVals[i] = "part" + i;
            new PartitionBuilder().inTable(partitionedTable).addValue(partVals[i]).addToTable(this.client, this.metaStore.getConf());
        }
        for (i = 0; i < tableNames.length; ++i) {
            String[] t = this.client.getTable(catName, dbName, tableNames[i]);
            Assert.assertEquals((Object)catName, (Object)t.getCatName());
            String expectedLocation = i < 1 ? new File(MetaStoreTestUtils.getTestWarehouseDir(tableNames[i])).toURI().toString() : new File(cat.getLocationUri() + File.separatorChar + dbName + ".db", tableNames[i]).toURI().toString();
            Assert.assertEquals((Object)expectedLocation, (Object)(t.getSd().getLocation() + "/"));
            File dir = new File(new URI(t.getSd().getLocation()).getPath());
            Assert.assertTrue((dir.exists() && dir.isDirectory() ? 1 : 0) != 0);
        }
        try {
            Table t = this.client.getTable(DEFAULT_DATABASE, tableNames[0]);
            Assert.fail();
        }
        catch (NoSuchObjectException t) {
            // empty catch block
        }
        HashSet fetchedNames = new HashSet(this.client.getAllTables(catName, dbName));
        Assert.assertEquals((long)(tableNames.length + 1), (long)fetchedNames.size());
        for (String tableName : tableNames) {
            Assert.assertTrue((boolean)fetchedNames.contains(tableName));
        }
        fetchedNames = new HashSet(this.client.getAllTables(DEFAULT_DATABASE));
        for (String tableName : tableNames) {
            Assert.assertFalse((boolean)fetchedNames.contains(tableName));
        }
        List materializedViews = this.client.getMaterializedViewsForRewriting(catName, dbName);
        Assert.assertEquals((long)1L, (long)materializedViews.size());
        Assert.assertEquals((Object)tableNames[3], materializedViews.get(0));
        fetchedNames = new HashSet(this.client.getMaterializedViewsForRewriting(DEFAULT_DATABASE));
        Assert.assertFalse((boolean)fetchedNames.contains(tableNames[3]));
        List fetchedTables = this.client.getTableObjectsByName(catName, dbName, Arrays.asList(tableNames[0], tableNames[1]));
        Assert.assertEquals((long)2L, (long)fetchedTables.size());
        Collections.sort(fetchedTables);
        Assert.assertEquals((Object)tableNames[0], (Object)((Table)fetchedTables.get(0)).getTableName());
        Assert.assertEquals((Object)tableNames[1], (Object)((Table)fetchedTables.get(1)).getTableName());
        fetchedTables = this.client.getTableObjectsByName(DEFAULT_DATABASE, Arrays.asList(tableNames[0], tableNames[1]));
        Assert.assertEquals((long)0L, (long)fetchedTables.size());
        Table t = this.client.getTable(catName, dbName, tableNames[0]).deepCopy();
        t.getParameters().put("test", "test");
        this.client.alter_table(catName, dbName, tableNames[0], t);
        t = this.client.getTable(catName, dbName, tableNames[0]).deepCopy();
        Assert.assertEquals((Object)"test", t.getParameters().get("test"));
        try {
            this.client.alter_table(DEFAULT_DATABASE, tableNames[0], t);
            Assert.fail();
        }
        catch (InvalidOperationException tableName) {
            // empty catch block
        }
        CreationMetadata cm = this.client.getTable(catName, dbName, tableNames[3]).getCreationMetadata();
        Table table1 = ((TableBuilder)((TableBuilder)new TableBuilder().inDb(db).setTableName("mvSource2").addCol("col1_1", "string")).addCol("col2_2", "int")).build(this.metaStore.getConf());
        this.client.createTable(table1);
        sourceTable = TestHiveMetaStore.createSourceTable(table1);
        cm.addToTablesUsed(TableName.getDbTable((String)sourceTable.getTable().getDbName(), (String)sourceTable.getTable().getTableName()));
        cm.addToSourceTables(sourceTable);
        cm.unsetMaterializationTime();
        this.client.updateCreationMetadata(catName, dbName, tableNames[3], cm);
        ArrayList<String> partNames = new ArrayList<String>();
        for (String partVal : partVals) {
            partNames.add("pcol1=" + partVal);
        }
        this.client.truncateTable(catName, dbName, tableNames[0], partNames);
        try {
            this.client.truncateTable(DEFAULT_DATABASE, tableNames[0], partNames);
            Assert.fail();
        }
        catch (NoSuchObjectException | TApplicationException throwable) {
            // empty catch block
        }
        try {
            this.client.dropTable(DEFAULT_DATABASE, tableNames[0], true, false);
            Assert.fail();
        }
        catch (NoSuchObjectException | TApplicationException throwable) {
            // empty catch block
        }
        this.client.dropTable(DEFAULT_DATABASE, tableNames[0], false, true);
        for (int i3 = tableNames.length - 1; i3 >= 0; --i3) {
            t = this.client.getTable(catName, dbName, tableNames[i3]);
            File tableDir = new File(new URI(t.getSd().getLocation()).getPath());
            Assert.assertTrue((tableDir.exists() && tableDir.isDirectory() ? 1 : 0) != 0);
            if (tableNames[i3].equalsIgnoreCase(tableNames[0])) {
                this.client.dropTable(catName, dbName, tableNames[i3], false, false);
                Assert.assertTrue((tableDir.exists() && tableDir.isDirectory() ? 1 : 0) != 0);
                continue;
            }
            this.client.dropTable(catName, dbName, tableNames[i3]);
            Assert.assertFalse((boolean)tableDir.exists());
        }
        this.client.dropTable(table.getCatName(), table.getDbName(), table.getTableName());
        this.client.dropTable(table1.getCatName(), table1.getDbName(), table1.getTableName());
        Assert.assertEquals((long)0L, (long)this.client.getAllTables(catName, dbName).size());
    }

    @Test(expected=InvalidObjectException.class)
    public void createTableInBogusCatalog() throws TException {
        ((TableBuilder)((TableBuilder)new TableBuilder().setCatName("nosuch").setTableName("doomed").addCol("col1", "string")).addCol("col2", "int")).create(this.client, this.metaStore.getConf());
    }

    @Test(expected=NoSuchObjectException.class)
    public void getTableInBogusCatalog() throws TException {
        this.client.getTable("nosuch", this.testTables[0].getDbName(), this.testTables[0].getTableName());
    }

    @Test
    public void getAllTablesInBogusCatalog() throws TException {
        List names = this.client.getAllTables("nosuch", this.testTables[0].getDbName());
        Assert.assertTrue((boolean)names.isEmpty());
    }

    @Test(expected=UnknownDBException.class)
    public void getTableObjectsByNameBogusCatalog() throws TException {
        this.client.getTableObjectsByName("nosuch", this.testTables[0].getDbName(), Arrays.asList(this.testTables[0].getTableName(), this.testTables[1].getTableName()));
    }

    @Test
    public void getMaterializedViewsInBogusCatalog() throws TException {
        List names = this.client.getMaterializedViewsForRewriting("nosuch", DEFAULT_DATABASE);
        Assert.assertTrue((boolean)names.isEmpty());
    }

    @Test(expected=InvalidOperationException.class)
    public void alterTableBogusCatalog() throws TException {
        Table t = this.testTables[0].deepCopy();
        t.getParameters().put("a", "b");
        this.client.alter_table("nosuch", t.getDbName(), t.getTableName(), t);
    }

    @Test(expected=InvalidOperationException.class)
    public void moveTablesBetweenCatalogsOnAlter() throws TException {
        String catName = "move_table_between_catalogs_on_alter";
        Catalog cat = new CatalogBuilder().setName(catName).setLocation(MetaStoreTestUtils.getTestWarehouseDir(catName)).build();
        this.client.createCatalog(cat);
        String dbName = "a_db";
        Database db = new DatabaseBuilder().setName(dbName).setCatalogName(catName).create(this.client, this.metaStore.getConf());
        String tableName = "non_movable_table";
        Table before = ((TableBuilder)((TableBuilder)new TableBuilder().inDb(db).setTableName(tableName).addCol("col1", "string")).addCol("col2", "int")).create(this.client, this.metaStore.getConf());
        Table after = before.deepCopy();
        after.setCatName("hive");
        this.client.alter_table(catName, dbName, tableName, after);
    }

    @Test
    public void truncateTableBogusCatalog() throws TException {
        try {
            List partNames = this.client.listPartitionNames(this.partitionedTable.getDbName(), this.partitionedTable.getTableName(), (short)-1);
            this.client.truncateTable("nosuch", this.partitionedTable.getDbName(), this.partitionedTable.getTableName(), partNames);
            Assert.fail();
        }
        catch (NoSuchObjectException | TApplicationException throwable) {
            // empty catch block
        }
    }

    @Test(expected=NoSuchObjectException.class)
    public void dropTableBogusCatalog() throws TException {
        this.client.dropTable("nosuch", this.testTables[0].getDbName(), this.testTables[0].getTableName(), true, false);
    }

    private Table getTableWithAllParametersSet() throws MetaException {
        return ((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)new TableBuilder().setDbName(DEFAULT_DATABASE).setTableName("test_table_with_all_parameters_set").setCreateTime(100).setOwnerType(PrincipalType.ROLE).setOwner("owner").setLastAccessTime(200).addPartCol("part_col", "int", "part col comment").addCol("test_col", "int", "test col comment")).addCol("test_bucket_col", "int", "test bucket col comment")).addCol("test_skewed_col", "int", "test skewed col comment")).addCol("test_sort_col", "int", "test sort col comment")).addBucketCol("test_bucket_col")).addSkewedColName("test_skewed_col")).addSortCol("test_sort_col", 1)).setCompressed(true)).setInputFormat("inputFormat")).setInputFormat("outputFormat")).setLocation(this.metaStore.getWarehouseRoot() + "/location")).setNumBuckets(4)).setRetention(30000).setRewriteEnabled(true).setType("VIEW").setViewExpandedText("viewExplainedText").setViewOriginalText("viewOriginalText").setSerdeLib("serdelib")).setSerdeName("serdename")).setStoredAsSubDirectories(true)).addSerdeParam("serdeParam", "serdeParamValue")).addTableParam("tableParam", "tableParamValue").addStorageDescriptorParam("sdParam", "sdParamValue")).build(this.metaStore.getConf());
    }
}

