/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.ObjectStore;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.GetReplicationMetricsRequest;
import org.apache.hadoop.hive.metastore.api.ReplicationMetricList;
import org.apache.hadoop.hive.metastore.api.ReplicationMetrics;
import org.apache.hadoop.hive.metastore.client.MetaStoreClientTest;
import org.apache.hadoop.hive.metastore.minihms.AbstractMetaStoreService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreUnitTest.class})
public class TestReplicationMetrics
extends MetaStoreClientTest {
    private final AbstractMetaStoreService metaStore;
    private IMetaStoreClient client;

    public TestReplicationMetrics(String name, AbstractMetaStoreService metaStore) throws Exception {
        this.metaStore = metaStore;
    }

    @Before
    public void setUp() throws Exception {
        this.client = this.metaStore.getClient();
    }

    @After
    public void tearDown() throws Exception {
        try {
            this.client.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.client = null;
    }

    @Test
    public void testAddMetrics() throws Exception {
        ObjectStore objStore = new ObjectStore();
        objStore.setConf(this.metaStore.getConf());
        objStore.deleteReplicationMetrics(0);
        ReplicationMetricList replicationMetricList = new ReplicationMetricList();
        ArrayList<ReplicationMetrics> replicationMetrics = new ArrayList<ReplicationMetrics>();
        replicationMetrics.add(this.createReplicationMetric("repl1", 1L));
        replicationMetrics.add(this.createReplicationMetric("repl1", 2L));
        replicationMetricList.setReplicationMetricList(replicationMetrics);
        objStore.addReplicationMetrics(replicationMetricList);
        Thread.sleep(1000L);
        replicationMetrics = new ArrayList();
        replicationMetrics.add(this.createReplicationMetric("repl2", 3L));
        replicationMetrics.add(this.createReplicationMetric("repl2", 4L));
        replicationMetricList.setReplicationMetricList(replicationMetrics);
        objStore.addReplicationMetrics(replicationMetricList);
        Thread.sleep(1000L);
        GetReplicationMetricsRequest getReplicationMetricsRequest = new GetReplicationMetricsRequest();
        getReplicationMetricsRequest.setPolicy("repl1");
        ReplicationMetricList actualList = this.client.getReplicationMetrics(getReplicationMetricsRequest);
        Assert.assertEquals((long)2L, (long)actualList.getReplicationMetricListSize());
        List actualMetrics = actualList.getReplicationMetricList();
        ReplicationMetrics actualMetric0 = (ReplicationMetrics)actualMetrics.get(0);
        Assert.assertEquals((Object)"repl1", (Object)actualMetric0.getPolicy());
        Assert.assertEquals((long)2L, (long)actualMetric0.getScheduledExecutionId());
        Assert.assertEquals((long)1L, (long)actualMetric0.getDumpExecutionId());
        Assert.assertEquals((Object)"metadata", (Object)actualMetric0.getMetadata());
        Assert.assertEquals((Object)"progress", (Object)actualMetric0.getProgress());
        ReplicationMetrics actualMetric1 = (ReplicationMetrics)actualMetrics.get(1);
        Assert.assertEquals((Object)"repl1", (Object)actualMetric1.getPolicy());
        Assert.assertEquals((long)1L, (long)actualMetric1.getScheduledExecutionId());
        Assert.assertEquals((long)1L, (long)actualMetric1.getDumpExecutionId());
        Assert.assertEquals((Object)"metadata", (Object)actualMetric1.getMetadata());
        Assert.assertEquals((Object)"progress", (Object)actualMetric1.getProgress());
        getReplicationMetricsRequest = new GetReplicationMetricsRequest();
        getReplicationMetricsRequest.setPolicy("repl2");
        actualList = this.client.getReplicationMetrics(getReplicationMetricsRequest);
        Assert.assertEquals((long)2L, (long)actualList.getReplicationMetricListSize());
        actualMetrics = actualList.getReplicationMetricList();
        actualMetric0 = (ReplicationMetrics)actualMetrics.get(0);
        Assert.assertEquals((Object)"repl2", (Object)actualMetric0.getPolicy());
        Assert.assertEquals((long)4L, (long)actualMetric0.getScheduledExecutionId());
        Assert.assertEquals((long)1L, (long)actualMetric0.getDumpExecutionId());
        Assert.assertEquals((Object)"metadata", (Object)actualMetric0.getMetadata());
        Assert.assertEquals((Object)"progress", (Object)actualMetric0.getProgress());
        actualMetric1 = (ReplicationMetrics)actualMetrics.get(1);
        Assert.assertEquals((Object)"repl2", (Object)actualMetric1.getPolicy());
        Assert.assertEquals((long)3L, (long)actualMetric1.getScheduledExecutionId());
        Assert.assertEquals((long)1L, (long)actualMetric1.getDumpExecutionId());
        Assert.assertEquals((Object)"metadata", (Object)actualMetric1.getMetadata());
        Assert.assertEquals((Object)"progress", (Object)actualMetric1.getProgress());
    }

    @Test
    public void testUpdateMetrics() throws Exception {
        ObjectStore objStore = new ObjectStore();
        objStore.setConf(this.metaStore.getConf());
        objStore.deleteReplicationMetrics(0);
        ReplicationMetricList replicationMetricList = new ReplicationMetricList();
        ArrayList<ReplicationMetrics> replicationMetrics = new ArrayList<ReplicationMetrics>();
        replicationMetrics.add(this.createReplicationMetric("repl1", 1L));
        replicationMetrics.add(this.createReplicationMetric("repl1", 2L));
        replicationMetricList.setReplicationMetricList(replicationMetrics);
        objStore.addReplicationMetrics(replicationMetricList);
        Thread.sleep(1000L);
        replicationMetrics = new ArrayList();
        replicationMetrics.add(this.createReplicationMetric("repl2", 3L));
        replicationMetrics.add(this.createReplicationMetric("repl2", 4L));
        replicationMetricList.setReplicationMetricList(replicationMetrics);
        objStore.addReplicationMetrics(replicationMetricList);
        Thread.sleep(1000L);
        replicationMetrics = new ArrayList();
        replicationMetrics.add(this.updateReplicationMetric("repl2", 3L, "progress1"));
        replicationMetricList.setReplicationMetricList(replicationMetrics);
        objStore.addReplicationMetrics(replicationMetricList);
        Thread.sleep(1000L);
        GetReplicationMetricsRequest getReplicationMetricsRequest = new GetReplicationMetricsRequest();
        getReplicationMetricsRequest.setPolicy("repl1");
        ReplicationMetricList actualList = this.client.getReplicationMetrics(getReplicationMetricsRequest);
        Assert.assertEquals((long)2L, (long)actualList.getReplicationMetricListSize());
        List actualMetrics = actualList.getReplicationMetricList();
        ReplicationMetrics actualMetric0 = (ReplicationMetrics)actualMetrics.get(0);
        Assert.assertEquals((Object)"repl1", (Object)actualMetric0.getPolicy());
        Assert.assertEquals((long)2L, (long)actualMetric0.getScheduledExecutionId());
        Assert.assertEquals((long)1L, (long)actualMetric0.getDumpExecutionId());
        Assert.assertEquals((Object)"metadata", (Object)actualMetric0.getMetadata());
        Assert.assertEquals((Object)"progress", (Object)actualMetric0.getProgress());
        ReplicationMetrics actualMetric1 = (ReplicationMetrics)actualMetrics.get(1);
        Assert.assertEquals((Object)"repl1", (Object)actualMetric1.getPolicy());
        Assert.assertEquals((long)1L, (long)actualMetric1.getScheduledExecutionId());
        Assert.assertEquals((long)1L, (long)actualMetric1.getDumpExecutionId());
        Assert.assertEquals((Object)"metadata", (Object)actualMetric1.getMetadata());
        Assert.assertEquals((Object)"progress", (Object)actualMetric1.getProgress());
        getReplicationMetricsRequest = new GetReplicationMetricsRequest();
        getReplicationMetricsRequest.setPolicy("repl2");
        actualList = this.client.getReplicationMetrics(getReplicationMetricsRequest);
        Assert.assertEquals((long)2L, (long)actualList.getReplicationMetricListSize());
        actualMetrics = actualList.getReplicationMetricList();
        actualMetric0 = (ReplicationMetrics)actualMetrics.get(0);
        Assert.assertEquals((Object)"repl2", (Object)actualMetric0.getPolicy());
        Assert.assertEquals((long)4L, (long)actualMetric0.getScheduledExecutionId());
        Assert.assertEquals((long)1L, (long)actualMetric0.getDumpExecutionId());
        Assert.assertEquals((Object)"metadata", (Object)actualMetric0.getMetadata());
        Assert.assertEquals((Object)"progress", (Object)actualMetric0.getProgress());
        actualMetric1 = (ReplicationMetrics)actualMetrics.get(1);
        Assert.assertEquals((Object)"repl2", (Object)actualMetric1.getPolicy());
        Assert.assertEquals((long)3L, (long)actualMetric1.getScheduledExecutionId());
        Assert.assertEquals((long)1L, (long)actualMetric1.getDumpExecutionId());
        Assert.assertEquals((Object)"metadata", (Object)actualMetric1.getMetadata());
        Assert.assertEquals((Object)"progress1", (Object)actualMetric1.getProgress());
    }

    @Test
    public void testGetMetricsByScheduleId() throws Exception {
        ObjectStore objStore = new ObjectStore();
        objStore.setConf(this.metaStore.getConf());
        objStore.deleteReplicationMetrics(0);
        ReplicationMetricList replicationMetricList = new ReplicationMetricList();
        ArrayList<ReplicationMetrics> replicationMetrics = new ArrayList<ReplicationMetrics>();
        replicationMetrics.add(this.createReplicationMetric("repl1", 1L));
        replicationMetrics.add(this.createReplicationMetric("repl1", 2L));
        replicationMetricList.setReplicationMetricList(replicationMetrics);
        objStore.addReplicationMetrics(replicationMetricList);
        Thread.sleep(1000L);
        replicationMetrics = new ArrayList();
        replicationMetrics.add(this.createReplicationMetric("repl2", 3L));
        replicationMetrics.add(this.createReplicationMetric("repl2", 4L));
        replicationMetricList.setReplicationMetricList(replicationMetrics);
        objStore.addReplicationMetrics(replicationMetricList);
        Thread.sleep(1000L);
        GetReplicationMetricsRequest getReplicationMetricsRequest = new GetReplicationMetricsRequest();
        getReplicationMetricsRequest.setScheduledExecutionId(1L);
        ReplicationMetricList actualList = this.client.getReplicationMetrics(getReplicationMetricsRequest);
        Assert.assertEquals((long)1L, (long)actualList.getReplicationMetricListSize());
        List actualMetrics = actualList.getReplicationMetricList();
        ReplicationMetrics actualMetric0 = (ReplicationMetrics)actualMetrics.get(0);
        Assert.assertEquals((Object)"repl1", (Object)actualMetric0.getPolicy());
        Assert.assertEquals((long)1L, (long)actualMetric0.getScheduledExecutionId());
        Assert.assertEquals((long)1L, (long)actualMetric0.getDumpExecutionId());
        Assert.assertEquals((Object)"metadata", (Object)actualMetric0.getMetadata());
        Assert.assertEquals((Object)"progress", (Object)actualMetric0.getProgress());
        replicationMetrics = new ArrayList();
        replicationMetrics.add(this.updateReplicationMetric("repl1", 1L, "progress1"));
        replicationMetricList.setReplicationMetricList(replicationMetrics);
        objStore.addReplicationMetrics(replicationMetricList);
        Thread.sleep(1000L);
        getReplicationMetricsRequest = new GetReplicationMetricsRequest();
        getReplicationMetricsRequest.setScheduledExecutionId(1L);
        actualList = this.client.getReplicationMetrics(getReplicationMetricsRequest);
        Assert.assertEquals((long)1L, (long)actualList.getReplicationMetricListSize());
        actualMetrics = actualList.getReplicationMetricList();
        actualMetric0 = (ReplicationMetrics)actualMetrics.get(0);
        Assert.assertEquals((Object)"repl1", (Object)actualMetric0.getPolicy());
        Assert.assertEquals((long)1L, (long)actualMetric0.getScheduledExecutionId());
        Assert.assertEquals((long)1L, (long)actualMetric0.getDumpExecutionId());
        Assert.assertEquals((Object)"metadata", (Object)actualMetric0.getMetadata());
        Assert.assertEquals((Object)"progress1", (Object)actualMetric0.getProgress());
    }

    @Test
    public void testDeleteMetrics() throws Exception {
        ObjectStore objStore = new ObjectStore();
        objStore.setConf(this.metaStore.getConf());
        objStore.deleteReplicationMetrics(0);
        ReplicationMetricList replicationMetricList = new ReplicationMetricList();
        ArrayList<ReplicationMetrics> replicationMetrics = new ArrayList<ReplicationMetrics>();
        replicationMetrics.add(this.createReplicationMetric("repl1", 1L));
        replicationMetrics.add(this.createReplicationMetric("repl1", 2L));
        replicationMetricList.setReplicationMetricList(replicationMetrics);
        objStore.addReplicationMetrics(replicationMetricList);
        Thread.sleep(2000L);
        replicationMetrics = new ArrayList();
        replicationMetrics.add(this.createReplicationMetric("repl1", 3L));
        replicationMetricList.setReplicationMetricList(replicationMetrics);
        objStore.addReplicationMetrics(replicationMetricList);
        Thread.sleep(500L);
        GetReplicationMetricsRequest getReplicationMetricsRequest = new GetReplicationMetricsRequest();
        getReplicationMetricsRequest.setPolicy("repl1");
        ReplicationMetricList actualList = this.client.getReplicationMetrics(getReplicationMetricsRequest);
        Assert.assertEquals((long)3L, (long)actualList.getReplicationMetricListSize());
        objStore.deleteReplicationMetrics(2);
        getReplicationMetricsRequest = new GetReplicationMetricsRequest();
        getReplicationMetricsRequest.setPolicy("repl1");
        actualList = this.client.getReplicationMetrics(getReplicationMetricsRequest);
        Assert.assertEquals((long)1L, (long)actualList.getReplicationMetricListSize());
        List actualMetrics = actualList.getReplicationMetricList();
        ReplicationMetrics actualMetric0 = (ReplicationMetrics)actualMetrics.get(0);
        Assert.assertEquals((Object)"repl1", (Object)actualMetric0.getPolicy());
        Assert.assertEquals((long)3L, (long)actualMetric0.getScheduledExecutionId());
        Assert.assertEquals((long)1L, (long)actualMetric0.getDumpExecutionId());
        Assert.assertEquals((Object)"metadata", (Object)actualMetric0.getMetadata());
        Assert.assertEquals((Object)"progress", (Object)actualMetric0.getProgress());
    }

    private ReplicationMetrics createReplicationMetric(String policyName, Long scheduleId) {
        ReplicationMetrics replicationMetrics = new ReplicationMetrics();
        replicationMetrics.setPolicy(policyName);
        replicationMetrics.setScheduledExecutionId(scheduleId.longValue());
        replicationMetrics.setDumpExecutionId(1L);
        replicationMetrics.setMetadata("metadata");
        replicationMetrics.setProgress("progress");
        return replicationMetrics;
    }

    private ReplicationMetrics updateReplicationMetric(String policyName, Long scheduleId, String progress) {
        ReplicationMetrics replicationMetrics = new ReplicationMetrics();
        replicationMetrics.setPolicy(policyName);
        replicationMetrics.setScheduledExecutionId(scheduleId.longValue());
        replicationMetrics.setProgress(progress);
        return replicationMetrics;
    }
}

