/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client;

import java.util.List;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.PrimaryKeysRequest;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.MetaStoreClientTest;
import org.apache.hadoop.hive.metastore.client.builder.CatalogBuilder;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.SQLPrimaryKeyBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.minihms.AbstractMetaStoreService;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreCheckinTest.class})
public class TestPrimaryKey
extends MetaStoreClientTest {
    private static final String OTHER_DATABASE = "test_constraints_other_database";
    private static final String OTHER_CATALOG = "test_constraints_other_catalog";
    private static final String DATABASE_IN_OTHER_CATALOG = "test_constraints_database_in_other_catalog";
    private final AbstractMetaStoreService metaStore;
    private IMetaStoreClient client;
    private Table[] testTables = new Table[3];
    private Database inOtherCatalog;

    public TestPrimaryKey(String name, AbstractMetaStoreService metaStore) throws Exception {
        this.metaStore = metaStore;
    }

    @Before
    public void setUp() throws Exception {
        this.client = this.metaStore.getClient();
        this.client.dropDatabase(OTHER_DATABASE, true, true, true);
        for (String tableName : this.client.getAllTables("default")) {
            this.client.dropTable("default", tableName, true, true, true);
        }
        this.client.dropDatabase(OTHER_CATALOG, DATABASE_IN_OTHER_CATALOG, true, true, true);
        try {
            this.client.dropCatalog(OTHER_CATALOG);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        this.metaStore.cleanWarehouseDirs();
        new DatabaseBuilder().setName(OTHER_DATABASE).create(this.client, this.metaStore.getConf());
        Catalog cat = new CatalogBuilder().setName(OTHER_CATALOG).setLocation(MetaStoreTestUtils.getTestWarehouseDir(OTHER_CATALOG)).build();
        this.client.createCatalog(cat);
        this.inOtherCatalog = new DatabaseBuilder().setName(DATABASE_IN_OTHER_CATALOG).setCatalogName(OTHER_CATALOG).create(this.client, this.metaStore.getConf());
        this.testTables[0] = ((TableBuilder)((TableBuilder)new TableBuilder().setTableName("test_table_1").addCol("col1", "int")).addCol("col2", "varchar(32)")).create(this.client, this.metaStore.getConf());
        this.testTables[1] = ((TableBuilder)((TableBuilder)new TableBuilder().setDbName(OTHER_DATABASE).setTableName("test_table_2").addCol("col1", "int")).addCol("col2", "varchar(32)")).create(this.client, this.metaStore.getConf());
        this.testTables[2] = ((TableBuilder)((TableBuilder)new TableBuilder().inDb(this.inOtherCatalog).setTableName("test_table_3").addCol("col1", "int")).addCol("col2", "varchar(32)")).create(this.client, this.metaStore.getConf());
        for (int i = 0; i < this.testTables.length; ++i) {
            this.testTables[i] = this.client.getTable(this.testTables[i].getCatName(), this.testTables[i].getDbName(), this.testTables[i].getTableName());
        }
    }

    @After
    public void tearDown() throws Exception {
        try {
            if (this.client != null) {
                try {
                    this.client.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        finally {
            this.client = null;
        }
    }

    @Test
    public void createGetDrop() throws TException {
        Table table = this.testTables[0];
        PrimaryKeysRequest rqst = new PrimaryKeysRequest(table.getDbName(), table.getTableName());
        rqst.setCatName(table.getCatName());
        List fetched = this.client.getPrimaryKeys(rqst);
        Assert.assertTrue((boolean)fetched.isEmpty());
        List pk = ((SQLPrimaryKeyBuilder)((SQLPrimaryKeyBuilder)new SQLPrimaryKeyBuilder().onTable(table)).addColumn("col1")).build(this.metaStore.getConf());
        this.client.addPrimaryKey(pk);
        rqst = new PrimaryKeysRequest(table.getDbName(), table.getTableName());
        rqst.setCatName(table.getCatName());
        fetched = this.client.getPrimaryKeys(rqst);
        ((SQLPrimaryKey)pk.get(0)).setPk_name(((SQLPrimaryKey)fetched.get(0)).getPk_name());
        Assert.assertEquals((Object)pk, (Object)fetched);
        this.client.dropConstraint(table.getCatName(), table.getDbName(), table.getTableName(), ((SQLPrimaryKey)pk.get(0)).getPk_name());
        rqst = new PrimaryKeysRequest(table.getDbName(), table.getTableName());
        rqst.setCatName(table.getCatName());
        fetched = this.client.getPrimaryKeys(rqst);
        Assert.assertTrue((boolean)fetched.isEmpty());
        this.client.addPrimaryKey(pk);
    }

    @Test
    public void createGetDrop2Column() throws TException {
        Table table = this.testTables[1];
        PrimaryKeysRequest rqst = new PrimaryKeysRequest(table.getDbName(), table.getTableName());
        rqst.setCatName(table.getCatName());
        List fetched = this.client.getPrimaryKeys(rqst);
        Assert.assertTrue((boolean)fetched.isEmpty());
        String constraintName = "cgd2cpk";
        List pk = ((SQLPrimaryKeyBuilder)((SQLPrimaryKeyBuilder)((SQLPrimaryKeyBuilder)((SQLPrimaryKeyBuilder)((SQLPrimaryKeyBuilder)((SQLPrimaryKeyBuilder)((SQLPrimaryKeyBuilder)new SQLPrimaryKeyBuilder().onTable(table)).addColumn("col1")).addColumn("col2")).setEnable(false)).setConstraintName(constraintName)).setValidate(true)).setRely(true)).build(this.metaStore.getConf());
        this.client.addPrimaryKey(pk);
        rqst = new PrimaryKeysRequest(table.getDbName(), table.getTableName());
        rqst.setCatName(table.getCatName());
        fetched = this.client.getPrimaryKeys(rqst);
        Assert.assertEquals((Object)pk, (Object)fetched);
        this.client.dropConstraint(table.getCatName(), table.getDbName(), table.getTableName(), constraintName);
        rqst = new PrimaryKeysRequest(table.getDbName(), table.getTableName());
        rqst.setCatName(table.getCatName());
        fetched = this.client.getPrimaryKeys(rqst);
        Assert.assertTrue((boolean)fetched.isEmpty());
        this.client.addPrimaryKey(pk);
    }

    @Test
    public void inOtherCatalog() throws TException {
        PrimaryKeysRequest rqst = new PrimaryKeysRequest(this.testTables[2].getDbName(), this.testTables[2].getTableName());
        rqst.setCatName(this.testTables[2].getCatName());
        List fetched = this.client.getPrimaryKeys(rqst);
        Assert.assertTrue((boolean)fetched.isEmpty());
        String constraintName = "ocpk";
        List pk = ((SQLPrimaryKeyBuilder)((SQLPrimaryKeyBuilder)((SQLPrimaryKeyBuilder)new SQLPrimaryKeyBuilder().onTable(this.testTables[2])).addColumn("col1")).setConstraintName(constraintName)).build(this.metaStore.getConf());
        this.client.addPrimaryKey(pk);
        rqst = new PrimaryKeysRequest(this.testTables[2].getDbName(), this.testTables[2].getTableName());
        rqst.setCatName(this.testTables[2].getCatName());
        fetched = this.client.getPrimaryKeys(rqst);
        Assert.assertEquals((Object)pk, (Object)fetched);
        this.client.dropConstraint(this.testTables[2].getCatName(), this.testTables[2].getDbName(), this.testTables[2].getTableName(), constraintName);
        rqst = new PrimaryKeysRequest(this.testTables[2].getDbName(), this.testTables[2].getTableName());
        rqst.setCatName(this.testTables[2].getCatName());
        fetched = this.client.getPrimaryKeys(rqst);
        Assert.assertTrue((boolean)fetched.isEmpty());
    }

    @Test
    public void createTableWithConstraintsPk() throws TException {
        String constraintName = "ctwcpk";
        Table table = ((TableBuilder)((TableBuilder)new TableBuilder().setTableName("table_with_constraints").addCol("col1", "int")).addCol("col2", "varchar(32)")).build(this.metaStore.getConf());
        List pk = ((SQLPrimaryKeyBuilder)((SQLPrimaryKeyBuilder)((SQLPrimaryKeyBuilder)new SQLPrimaryKeyBuilder().onTable(table)).addColumn("col1")).setConstraintName(constraintName)).build(this.metaStore.getConf());
        this.client.createTableWithConstraints(table, pk, null, null, null, null, null);
        PrimaryKeysRequest rqst = new PrimaryKeysRequest(table.getDbName(), table.getTableName());
        rqst.setCatName(table.getCatName());
        List fetched = this.client.getPrimaryKeys(rqst);
        Assert.assertEquals((Object)pk, (Object)fetched);
        this.client.dropConstraint(table.getCatName(), table.getDbName(), table.getTableName(), constraintName);
        rqst = new PrimaryKeysRequest(table.getDbName(), table.getTableName());
        rqst.setCatName(table.getCatName());
        fetched = this.client.getPrimaryKeys(rqst);
        Assert.assertTrue((boolean)fetched.isEmpty());
    }

    @Test
    public void createTableWithConstraintsPkInOtherCatalog() throws TException {
        Table table = ((TableBuilder)((TableBuilder)new TableBuilder().setTableName("table_in_other_catalog_with_constraints").inDb(this.inOtherCatalog).addCol("col1", "int")).addCol("col2", "varchar(32)")).build(this.metaStore.getConf());
        List pk = ((SQLPrimaryKeyBuilder)((SQLPrimaryKeyBuilder)new SQLPrimaryKeyBuilder().onTable(table)).addColumn("col1")).build(this.metaStore.getConf());
        this.client.createTableWithConstraints(table, pk, null, null, null, null, null);
        PrimaryKeysRequest rqst = new PrimaryKeysRequest(table.getDbName(), table.getTableName());
        rqst.setCatName(table.getCatName());
        List fetched = this.client.getPrimaryKeys(rqst);
        ((SQLPrimaryKey)pk.get(0)).setPk_name(((SQLPrimaryKey)fetched.get(0)).getPk_name());
        Assert.assertEquals((Object)pk, (Object)fetched);
        this.client.dropConstraint(table.getCatName(), table.getDbName(), table.getTableName(), ((SQLPrimaryKey)pk.get(0)).getPk_name());
        rqst = new PrimaryKeysRequest(table.getDbName(), table.getTableName());
        rqst.setCatName(table.getCatName());
        fetched = this.client.getPrimaryKeys(rqst);
        Assert.assertTrue((boolean)fetched.isEmpty());
    }

    @Test
    public void doubleAddPrimaryKey() throws TException {
        Table table = this.testTables[0];
        PrimaryKeysRequest rqst = new PrimaryKeysRequest(table.getDbName(), table.getTableName());
        rqst.setCatName(table.getCatName());
        List fetched = this.client.getPrimaryKeys(rqst);
        Assert.assertTrue((boolean)fetched.isEmpty());
        List pk = ((SQLPrimaryKeyBuilder)((SQLPrimaryKeyBuilder)new SQLPrimaryKeyBuilder().onTable(table)).addColumn("col1")).build(this.metaStore.getConf());
        this.client.addPrimaryKey(pk);
        try {
            pk = ((SQLPrimaryKeyBuilder)((SQLPrimaryKeyBuilder)new SQLPrimaryKeyBuilder().onTable(table)).addColumn("col2")).build(this.metaStore.getConf());
            this.client.addPrimaryKey(pk);
            Assert.fail();
        }
        catch (MetaException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Primary key already exists for"));
        }
    }

    @Test
    public void addNoSuchTable() throws TException {
        try {
            List pk = ((SQLPrimaryKeyBuilder)((SQLPrimaryKeyBuilder)new SQLPrimaryKeyBuilder().setTableName("nosuch")).addColumn("col2")).build(this.metaStore.getConf());
            this.client.addPrimaryKey(pk);
            Assert.fail();
        }
        catch (InvalidObjectException | TApplicationException throwable) {
            // empty catch block
        }
    }

    @Test
    public void getNoSuchTable() throws TException {
        PrimaryKeysRequest rqst = new PrimaryKeysRequest("default", "nosuch");
        List pk = this.client.getPrimaryKeys(rqst);
        Assert.assertTrue((boolean)pk.isEmpty());
    }

    @Test
    public void getNoSuchDb() throws TException {
        PrimaryKeysRequest rqst = new PrimaryKeysRequest("nosuch", this.testTables[0].getTableName());
        List pk = this.client.getPrimaryKeys(rqst);
        Assert.assertTrue((boolean)pk.isEmpty());
    }

    @Test
    public void getNoSuchCatalog() throws TException {
        PrimaryKeysRequest rqst = new PrimaryKeysRequest(this.testTables[0].getTableName(), this.testTables[0].getTableName());
        rqst.setCatName("nosuch");
        List pk = this.client.getPrimaryKeys(rqst);
        Assert.assertTrue((boolean)pk.isEmpty());
    }

    @Test
    public void dropNoSuchConstraint() throws TException {
        try {
            this.client.dropConstraint(this.testTables[0].getCatName(), this.testTables[0].getDbName(), this.testTables[0].getTableName(), "nosuch");
            Assert.fail();
        }
        catch (InvalidObjectException | TApplicationException throwable) {
            // empty catch block
        }
    }

    @Test
    public void dropNoSuchTable() throws TException {
        try {
            this.client.dropConstraint(this.testTables[0].getCatName(), this.testTables[0].getDbName(), "nosuch", "mypk");
            Assert.fail();
        }
        catch (InvalidObjectException | TApplicationException throwable) {
            // empty catch block
        }
    }

    @Test
    public void dropNoSuchDatabase() throws TException {
        try {
            this.client.dropConstraint(this.testTables[0].getCatName(), "nosuch", this.testTables[0].getTableName(), "mypk");
            Assert.fail();
        }
        catch (InvalidObjectException | TApplicationException throwable) {
            // empty catch block
        }
    }

    @Test
    public void dropNoSuchCatalog() throws TException {
        try {
            this.client.dropConstraint("nosuch", this.testTables[0].getDbName(), this.testTables[0].getTableName(), "nosuch");
            Assert.fail();
        }
        catch (InvalidObjectException | TApplicationException throwable) {
            // empty catch block
        }
    }
}

