/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.GetPartitionRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionResponse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.ConditionalIgnoreOnSessionHiveMetastoreClient;
import org.apache.hadoop.hive.metastore.client.MetaStoreClientTest;
import org.apache.hadoop.hive.metastore.client.builder.CatalogBuilder;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.PartitionBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.minihms.AbstractMetaStoreService;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreCheckinTest.class})
public class TestGetPartitions
extends MetaStoreClientTest {
    private AbstractMetaStoreService metaStore;
    private IMetaStoreClient client;
    protected static final String DB_NAME = "testpartdb";
    protected static final String TABLE_NAME = "testparttable";

    public TestGetPartitions(String name, AbstractMetaStoreService metaStore) {
        this.metaStore = metaStore;
    }

    @Before
    public void setUp() throws Exception {
        this.client = this.metaStore.getClient();
        this.createDB(DB_NAME);
    }

    @After
    public void tearDown() throws Exception {
        try {
            this.client.dropDatabase(DB_NAME, true, true, true);
            try {
                this.client.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            this.client = null;
        }
    }

    public IMetaStoreClient getClient() {
        return this.client;
    }

    public void setClient(IMetaStoreClient client) {
        this.client = client;
    }

    private void createDB(String dbName) throws TException {
        new DatabaseBuilder().setName(dbName).create(this.client, this.metaStore.getConf());
    }

    protected Table createTestTable(IMetaStoreClient client, String dbName, String tableName, List<String> partCols, boolean setPartitionLevelPrivilages) throws TException {
        TableBuilder builder = (TableBuilder)((TableBuilder)new TableBuilder().setDbName(dbName).setTableName(tableName).addCol("id", "int")).addCol("name", "string");
        partCols.forEach(col -> builder.addPartCol(col, "string"));
        Table table = builder.build(this.metaStore.getConf());
        if (setPartitionLevelPrivilages) {
            table.putToParameters("PARTITION_LEVEL_PRIVILEGE", "true");
        }
        client.createTable(table);
        return table;
    }

    protected void addPartition(IMetaStoreClient client, Table table, List<String> values) throws TException {
        PartitionBuilder partitionBuilder = new PartitionBuilder().inTable(table);
        values.forEach(val -> partitionBuilder.addValue(val));
        client.add_partition(partitionBuilder.build(this.metaStore.getConf()));
    }

    private void createTable3PartCols1PartGeneric(IMetaStoreClient client, boolean authOn) throws TException {
        Table t = this.createTestTable(client, DB_NAME, TABLE_NAME, Lists.newArrayList((Object[])new String[]{"yyyy", "mm", "dd"}), authOn);
        this.addPartition(client, t, Lists.newArrayList((Object[])new String[]{"1997", "05", "16"}));
    }

    protected void createTable3PartCols1Part(IMetaStoreClient client) throws TException {
        this.createTable3PartCols1PartGeneric(client, false);
    }

    protected void createTable3PartCols1PartAuthOn(IMetaStoreClient client) throws TException {
        this.createTable3PartCols1PartGeneric(client, true);
    }

    protected List<List<String>> createTable4PartColsParts(IMetaStoreClient client) throws Exception {
        Table t = this.createTestTable(client, DB_NAME, TABLE_NAME, Lists.newArrayList((Object[])new String[]{"yyyy", "mm", "dd"}), false);
        ArrayList testValues = Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new String[]{"1999", "01", "02"}), Lists.newArrayList((Object[])new String[]{"2009", "02", "10"}), Lists.newArrayList((Object[])new String[]{"2017", "10", "26"}), Lists.newArrayList((Object[])new String[]{"2017", "11", "27"})});
        for (List vals : testValues) {
            this.addPartition(client, t, vals);
        }
        return testValues;
    }

    private static void assertAuthInfoReturned(String user, String group, Partition partition) {
        Assert.assertNotNull((Object)partition.getPrivileges());
        Assert.assertEquals((Object)Lists.newArrayList(), partition.getPrivileges().getUserPrivileges().get(user));
        Assert.assertEquals((Object)Lists.newArrayList(), partition.getPrivileges().getGroupPrivileges().get(group));
        Assert.assertEquals((Object)Lists.newArrayList(), partition.getPrivileges().getRolePrivileges().get("public"));
    }

    @Test
    public void testGetPartition() throws Exception {
        this.createTable3PartCols1Part(this.client);
        Partition partition = this.client.getPartition(DB_NAME, TABLE_NAME, "yyyy=1997/mm=05/dd=16");
        Assert.assertNotNull((Object)partition);
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"1997", "05", "16"}), (Object)partition.getValues());
    }

    @Test(expected=NoSuchObjectException.class)
    public void testGetPartitionCaseSensitive() throws Exception {
        this.createTable3PartCols1Part(this.client);
        this.client.getPartition(DB_NAME, TABLE_NAME, "YyYy=1997/mM=05/dD=16");
    }

    @Test(expected=NoSuchObjectException.class)
    public void testGetPartitionIncompletePartName() throws Exception {
        this.createTable3PartCols1Part(this.client);
        this.client.getPartition(DB_NAME, TABLE_NAME, "yyyy=1997/mm=05");
    }

    @Test(expected=MetaException.class)
    public void testGetPartitionEmptyPartName() throws Exception {
        this.createTable3PartCols1Part(this.client);
        this.client.getPartition(DB_NAME, TABLE_NAME, "");
    }

    @Test(expected=NoSuchObjectException.class)
    public void testGetPartitionNonexistingPart() throws Exception {
        this.createTable3PartCols1Part(this.client);
        this.client.getPartition(DB_NAME, TABLE_NAME, "yyyy=1997/mm=05/dd=99");
    }

    @Test(expected=NoSuchObjectException.class)
    public void testGetPartitionNoDbName() throws Exception {
        this.createTable3PartCols1Part(this.client);
        this.client.getPartition("", TABLE_NAME, "yyyy=1997/mm=05/dd=16");
    }

    @Test(expected=NoSuchObjectException.class)
    public void testGetPartitionNoTblName() throws Exception {
        this.createTable3PartCols1Part(this.client);
        this.client.getPartition(DB_NAME, "", "yyyy=1997/mm=05/dd=16");
    }

    @Test(expected=NoSuchObjectException.class)
    public void testGetPartitionNoTable() throws Exception {
        this.client.getPartition(DB_NAME, TABLE_NAME, "yyyy=1997/mm=05/dd=16");
    }

    @Test(expected=NoSuchObjectException.class)
    public void testGetPartitionNoDb() throws Exception {
        this.client.dropDatabase(DB_NAME);
        this.client.getPartition(DB_NAME, TABLE_NAME, "yyyy=1997/mm=05/dd=16");
    }

    @Test(expected=MetaException.class)
    public void testGetPartitionNullDbName() throws Exception {
        this.createTable3PartCols1Part(this.client);
        this.client.getPartition(null, TABLE_NAME, "yyyy=1997/mm=05/dd=16");
    }

    @Test(expected=MetaException.class)
    public void testGetPartitionNullTblName() throws Exception {
        this.createTable3PartCols1Part(this.client);
        this.client.getPartition(DB_NAME, null, "yyyy=1997/mm=05/dd=16");
    }

    @Test(expected=MetaException.class)
    public void testGetPartitionNullPartName() throws Exception {
        this.createTable3PartCols1Part(this.client);
        this.client.getPartition(DB_NAME, TABLE_NAME, (String)null);
    }

    @Test
    @ConditionalIgnoreOnSessionHiveMetastoreClient
    public void testGetPartitionRequest() throws Exception {
        this.createTable3PartCols1Part(this.client);
        ArrayList parts = Lists.newArrayList((Object[])new String[]{"1997", "05", "16"});
        GetPartitionRequest req = new GetPartitionRequest();
        req.setCatName(MetaStoreUtils.getDefaultCatalog((Configuration)this.metaStore.getConf()));
        req.setDbName(DB_NAME);
        req.setTblName(TABLE_NAME);
        req.setPartVals((List)parts);
        GetPartitionResponse res = this.client.getPartitionRequest(req);
        Partition partition = res.getPartition();
        Assert.assertNotNull((Object)partition);
        Assert.assertEquals((Object)parts, (Object)partition.getValues());
    }

    @Test
    public void testGetPartitionByValues() throws Exception {
        this.createTable3PartCols1Part(this.client);
        ArrayList parts = Lists.newArrayList((Object[])new String[]{"1997", "05", "16"});
        Partition partition = this.client.getPartition(DB_NAME, TABLE_NAME, (List)parts);
        Assert.assertNotNull((Object)partition);
        Assert.assertEquals((Object)parts, (Object)partition.getValues());
    }

    @Test(expected=NoSuchObjectException.class)
    public void testGetPartitionByValuesWrongPart() throws Exception {
        this.createTable3PartCols1Part(this.client);
        this.client.getPartition(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"1997", "05", "66"}));
    }

    @Test(expected=MetaException.class)
    public void testGetPartitionByValuesWrongNumOfPartVals() throws Exception {
        this.createTable3PartCols1Part(this.client);
        this.client.getPartition(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"1997", "05"}));
    }

    @Test(expected=MetaException.class)
    public void testGetPartitionByValuesEmptyPartVals() throws Exception {
        this.createTable3PartCols1Part(this.client);
        this.client.getPartition(DB_NAME, TABLE_NAME, (List)Lists.newArrayList());
    }

    @Test(expected=NoSuchObjectException.class)
    public void testGetPartitionByValuesNoDbName() throws Exception {
        this.createTable3PartCols1Part(this.client);
        this.client.getPartition("", TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"1997", "05", "16"}));
    }

    @Test(expected=NoSuchObjectException.class)
    public void testGetPartitionByValuesNoTblName() throws Exception {
        this.createTable3PartCols1Part(this.client);
        this.client.getPartition(DB_NAME, "", (List)Lists.newArrayList((Object[])new String[]{"1997", "05", "16"}));
    }

    @Test(expected=NoSuchObjectException.class)
    public void testGetPartitionByValuesNoTable() throws Exception {
        this.client.getPartition(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"1997", "05", "16"}));
    }

    @Test(expected=NoSuchObjectException.class)
    public void testGetPartitionByValuesNoDb() throws Exception {
        this.client.dropDatabase(DB_NAME);
        this.client.getPartition(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"1997", "05", "16"}));
    }

    @Test(expected=MetaException.class)
    public void testGetPartitionByValuesNullDbName() throws Exception {
        this.createTable3PartCols1Part(this.client);
        this.client.getPartition(null, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"1997", "05", "16"}));
    }

    @Test(expected=MetaException.class)
    public void testGetPartitionByValuesNullTblName() throws Exception {
        this.createTable3PartCols1Part(this.client);
        this.client.getPartition(DB_NAME, null, (List)Lists.newArrayList((Object[])new String[]{"1997", "05", "16"}));
    }

    @Test(expected=MetaException.class)
    public void testGetPartitionByValuesNullValues() throws Exception {
        this.createTable3PartCols1Part(this.client);
        this.client.getPartition(DB_NAME, TABLE_NAME, (List)null);
    }

    @Test
    public void testGetPartitionsByNames() throws Exception {
        List<List<String>> testValues = this.createTable4PartColsParts(this.client);
        List partitions = this.client.getPartitionsByNames(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"yYYy=2017/MM=11/DD=27", "yYyY=1999/mM=01/dD=02"}));
        Assert.assertEquals((long)0L, (long)partitions.size());
        partitions = this.client.getPartitionsByNames(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"yyyy=2017/mm=11/dd=27", "yyyy=1999/mm=01/dd=02"}));
        Assert.assertEquals((long)2L, (long)partitions.size());
        partitions.forEach(p -> Assert.assertTrue((boolean)testValues.contains(p.getValues())));
        partitions = this.client.getPartitionsByNames(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"yyyy=2017", "yyyy=1999/mm=01/dd=02"}));
        Assert.assertEquals(testValues.get(0), (Object)((Partition)partitions.get(0)).getValues());
    }

    @Test
    public void testGetPartitionsByNamesEmptyParts() throws Exception {
        List<List<String>> testValues = this.createTable4PartColsParts(this.client);
        List partitions = this.client.getPartitionsByNames(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"", ""}));
        Assert.assertEquals((long)0L, (long)partitions.size());
        partitions = this.client.getPartitionsByNames(DB_NAME, TABLE_NAME, (List)Lists.newArrayList());
        Assert.assertEquals((long)0L, (long)partitions.size());
    }

    @Test(expected=NoSuchObjectException.class)
    public void testGetPartitionsByNamesNoDbName() throws Exception {
        this.createTable3PartCols1Part(this.client);
        this.client.getPartitionsByNames("", TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"yyyy=2000/mm=01/dd=02"}));
    }

    @Test(expected=NoSuchObjectException.class)
    public void testGetPartitionsByNamesNoTblName() throws Exception {
        this.createTable3PartCols1Part(this.client);
        this.client.getPartitionsByNames(DB_NAME, "", (List)Lists.newArrayList((Object[])new String[]{"yyyy=2000/mm=01/dd=02"}));
    }

    @Test(expected=TException.class)
    public void testGetPartitionsByNamesNoTable() throws Exception {
        this.client.getPartitionsByNames(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"yyyy=2000/mm=01/dd=02"}));
    }

    @Test(expected=TException.class)
    public void testGetPartitionsByNamesNoDb() throws Exception {
        this.client.dropDatabase(DB_NAME);
        this.client.getPartitionsByNames(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"yyyy=2000/mm=01/dd=02"}));
    }

    @Test
    public void testGetPartitionsByNamesNullDbName() throws Exception {
        try {
            this.createTable3PartCols1Part(this.client);
            this.client.getPartitionsByNames(null, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"yyyy=2000/mm=01/dd=02"}));
            Assert.fail((String)"Should have thrown exception");
        }
        catch (NullPointerException | MetaException | TTransportException throwable) {
            // empty catch block
        }
    }

    @Test
    public void testGetPartitionsByNamesNullTblName() throws Exception {
        try {
            this.createTable3PartCols1Part(this.client);
            this.client.getPartitionsByNames(DB_NAME, null, (List)Lists.newArrayList((Object[])new String[]{"yyyy=2000/mm=01/dd=02"}));
            Assert.fail((String)"Should have thrown exception");
        }
        catch (NullPointerException | TTransportException throwable) {
            // empty catch block
        }
    }

    @Test(expected=MetaException.class)
    public void testGetPartitionsByNamesNullNames() throws Exception {
        this.createTable3PartCols1Part(this.client);
        this.client.getPartitionsByNames(DB_NAME, TABLE_NAME, (List)null);
    }

    @Test
    public void testGetPartitionWithAuthInfoNoPrivilagesSet() throws Exception {
        this.createTable3PartCols1Part(this.client);
        Partition partition = this.client.getPartitionWithAuthInfo(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"1997", "05", "16"}), "", (List)Lists.newArrayList());
        Assert.assertNotNull((Object)partition);
        Assert.assertNull((Object)partition.getPrivileges());
    }

    @Test
    public void testGetPartitionWithAuthInfo() throws Exception {
        this.createTable3PartCols1PartAuthOn(this.client);
        Partition partition = this.client.getPartitionWithAuthInfo(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"1997", "05", "16"}), "user0", (List)Lists.newArrayList((Object[])new String[]{"group0"}));
        Assert.assertNotNull((Object)partition);
        TestGetPartitions.assertAuthInfoReturned("user0", "group0", partition);
    }

    @Test
    public void testGetPartitionWithAuthInfoEmptyUserGroup() throws Exception {
        this.createTable3PartCols1PartAuthOn(this.client);
        Partition partition = this.client.getPartitionWithAuthInfo(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"1997", "05", "16"}), "", (List)Lists.newArrayList((Object[])new String[]{""}));
        Assert.assertNotNull((Object)partition);
        TestGetPartitions.assertAuthInfoReturned("", "", partition);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testGetPartitionWithAuthInfoNoDbName() throws Exception {
        this.createTable3PartCols1PartAuthOn(this.client);
        this.client.getPartitionWithAuthInfo("", TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"1997", "05", "16"}), "user0", (List)Lists.newArrayList((Object[])new String[]{"group0"}));
    }

    @Test(expected=NoSuchObjectException.class)
    public void testGetPartitionWithAuthInfoNoTblName() throws Exception {
        this.createTable3PartCols1PartAuthOn(this.client);
        this.client.getPartitionWithAuthInfo(DB_NAME, "", (List)Lists.newArrayList((Object[])new String[]{"1997", "05", "16"}), "user0", (List)Lists.newArrayList((Object[])new String[]{"group0"}));
    }

    @Test(expected=NoSuchObjectException.class)
    public void testGetPartitionWithAuthInfoNoSuchPart() throws Exception {
        this.createTable3PartCols1PartAuthOn(this.client);
        this.client.getPartitionWithAuthInfo(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"1997", "05", "66"}), "user0", (List)Lists.newArrayList((Object[])new String[]{"group0"}));
    }

    @Test(expected=MetaException.class)
    public void testGetPartitionWithAuthInfoWrongNumOfPartVals() throws Exception {
        this.createTable3PartCols1PartAuthOn(this.client);
        this.client.getPartitionWithAuthInfo(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"1997", "05"}), "user0", (List)Lists.newArrayList((Object[])new String[]{"group0"}));
    }

    @Test(expected=MetaException.class)
    public void testGetPartitionWithAuthInfoNullDbName() throws Exception {
        try {
            this.createTable3PartCols1PartAuthOn(this.client);
            this.client.getPartitionWithAuthInfo(null, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"1997", "05", "16"}), "user0", (List)Lists.newArrayList((Object[])new String[]{"group0"}));
            Assert.fail((String)"Should have thrown exception");
        }
        catch (NullPointerException | TTransportException throwable) {
            // empty catch block
        }
    }

    @Test(expected=MetaException.class)
    public void testGetPartitionWithAuthInfoNullTblName() throws Exception {
        try {
            this.createTable3PartCols1PartAuthOn(this.client);
            this.client.getPartitionWithAuthInfo(DB_NAME, null, (List)Lists.newArrayList((Object[])new String[]{"1997", "05", "16"}), "user0", (List)Lists.newArrayList((Object[])new String[]{"group0"}));
            Assert.fail((String)"Should have thrown exception");
        }
        catch (NullPointerException | TTransportException throwable) {
            // empty catch block
        }
    }

    @Test(expected=MetaException.class)
    public void testGetPartitionWithAuthInfoNullValues() throws Exception {
        this.createTable3PartCols1PartAuthOn(this.client);
        this.client.getPartitionWithAuthInfo(DB_NAME, TABLE_NAME, null, "user0", (List)Lists.newArrayList((Object[])new String[]{"group0"}));
    }

    @Test(expected=NoSuchObjectException.class)
    public void testGetPartitionWithAuthInfoNullUser() throws Exception {
        this.createTable3PartCols1PartAuthOn(this.client);
        this.client.getPartitionWithAuthInfo(DB_NAME, "", (List)Lists.newArrayList((Object[])new String[]{"1997", "05", "16"}), null, (List)Lists.newArrayList((Object[])new String[]{"group0"}));
    }

    @Test
    public void testGetPartitionWithAuthInfoNullGroups() throws Exception {
        this.createTable3PartCols1PartAuthOn(this.client);
        this.client.getPartitionWithAuthInfo(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"1997", "05", "16"}), "user0", null);
    }

    @Test
    @ConditionalIgnoreOnSessionHiveMetastoreClient
    public void otherCatalog() throws TException {
        String catName = "get_partition_catalog";
        Catalog cat = new CatalogBuilder().setName(catName).setLocation(MetaStoreTestUtils.getTestWarehouseDir(catName)).build();
        this.client.createCatalog(cat);
        String dbName = "get_partition_database_in_other_catalog";
        Database db = new DatabaseBuilder().setName(dbName).setCatalogName(catName).create(this.client, this.metaStore.getConf());
        String tableName = "table_in_other_catalog";
        Table table = ((TableBuilder)((TableBuilder)new TableBuilder().inDb(db).setTableName(tableName).addCol("id", "int")).addCol("name", "string")).addPartCol("partcol", "string").addTableParam("PARTITION_LEVEL_PRIVILEGE", "true").create(this.client, this.metaStore.getConf());
        Partition[] parts = new Partition[5];
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = new PartitionBuilder().inTable(table).addValue("a" + i).build(this.metaStore.getConf());
        }
        this.client.add_partitions(Arrays.asList(parts));
        Partition fetched = this.client.getPartition(catName, dbName, tableName, Collections.singletonList("a0"));
        Assert.assertEquals((Object)catName, (Object)fetched.getCatName());
        Assert.assertEquals((Object)"a0", fetched.getValues().get(0));
        fetched = this.client.getPartition(catName, dbName, tableName, "partcol=a0");
        Assert.assertEquals((Object)catName, (Object)fetched.getCatName());
        Assert.assertEquals((Object)"a0", fetched.getValues().get(0));
        List fetchedParts = this.client.getPartitionsByNames(catName, dbName, tableName, Arrays.asList("partcol=a0", "partcol=a1"));
        Assert.assertEquals((long)2L, (long)fetchedParts.size());
        HashSet vals = new HashSet(fetchedParts.size());
        for (Partition part : fetchedParts) {
            vals.add(part.getValues().get(0));
        }
        Assert.assertTrue((boolean)vals.contains("a0"));
        Assert.assertTrue((boolean)vals.contains("a1"));
    }

    @Test(expected=NoSuchObjectException.class)
    @ConditionalIgnoreOnSessionHiveMetastoreClient
    public void getPartitionBogusCatalog() throws TException {
        this.createTable3PartCols1Part(this.client);
        this.client.getPartition("bogus", DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"1997", "05", "16"}));
    }

    @Test(expected=NoSuchObjectException.class)
    @ConditionalIgnoreOnSessionHiveMetastoreClient
    public void getPartitionByNameBogusCatalog() throws TException {
        this.createTable3PartCols1Part(this.client);
        this.client.getPartition("bogus", DB_NAME, TABLE_NAME, "yyyy=1997/mm=05/dd=16");
    }

    @Test(expected=NoSuchObjectException.class)
    @ConditionalIgnoreOnSessionHiveMetastoreClient
    public void getPartitionWithAuthBogusCatalog() throws TException {
        this.createTable3PartCols1PartAuthOn(this.client);
        this.client.getPartitionWithAuthInfo("bogus", DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"1997", "05", "16"}), "user0", (List)Lists.newArrayList((Object[])new String[]{"group0"}));
    }

    @Test(expected=TException.class)
    @ConditionalIgnoreOnSessionHiveMetastoreClient
    public void getPartitionsByNamesBogusCatalog() throws TException {
        this.createTable3PartCols1Part(this.client);
        this.client.getPartitionsByNames("bogus", DB_NAME, TABLE_NAME, Collections.singletonList("yyyy=1997/mm=05/dd=16"));
    }
}

