/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client;

import java.util.ArrayList;
import java.util.List;
import javax.jdo.PersistenceManager;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.ObjectStore;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.GetAllWriteEventInfoRequest;
import org.apache.hadoop.hive.metastore.api.WriteEventInfo;
import org.apache.hadoop.hive.metastore.client.MetaStoreClientTest;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.minihms.AbstractMetaStoreService;
import org.apache.hadoop.hive.metastore.model.MTxnWriteNotificationLog;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreCheckinTest.class})
public class TestGetAllWriteEventInfo
extends MetaStoreClientTest {
    private final AbstractMetaStoreService metaStore;
    private ObjectStore objectStore = null;
    private IMetaStoreClient client = null;
    private MTxnWriteNotificationLog notificationLog = null;
    private static final String DB_NAME = "test_db";
    private static final String TABLE_NAME = "test_table";
    private static final long TXN_ID = 1L;
    private static final long WRITE_ID = 1L;

    public TestGetAllWriteEventInfo(String name, AbstractMetaStoreService metaStore) {
        this.metaStore = metaStore;
    }

    @Before
    public void setUp() throws Exception {
        this.client = this.metaStore.getClient();
        if (this.objectStore == null) {
            this.objectStore = new ObjectStore();
            this.objectStore.setConf(this.metaStore.getConf());
        }
        this.client.dropDatabase(DB_NAME, true, true, true);
        this.metaStore.cleanWarehouseDirs();
        this.createDB(DB_NAME);
        this.createTable(DB_NAME, TABLE_NAME);
        this.notificationLog = this.insertTxnWriteNotificationLog(1L, 1L, DB_NAME, TABLE_NAME);
    }

    @After
    public void tearDown() throws Exception {
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.client = null;
        }
        try {
            if (this.notificationLog != null) {
                this.objectStore.getPersistenceManager().deletePersistent((Object)this.notificationLog);
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.notificationLog = null;
        }
    }

    private void createDB(String dbName) throws Exception {
        new DatabaseBuilder().setName(dbName).create(this.client, this.metaStore.getConf());
    }

    private void createTable(String dbName, String tableName) throws Exception {
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema("id", "int", "test col id"));
        cols.add(new FieldSchema("value", "string", "test col value"));
        ((TableBuilder)new TableBuilder().setDbName(dbName).setTableName(tableName).setType(TableType.MANAGED_TABLE.name()).setCols(cols)).create(this.client, this.metaStore.getConf());
    }

    private MTxnWriteNotificationLog insertTxnWriteNotificationLog(long txnId, long writeId, String dbName, String tableName) {
        PersistenceManager pm = this.objectStore.getPersistenceManager();
        MTxnWriteNotificationLog log = new MTxnWriteNotificationLog(txnId, writeId, 1, dbName, tableName, "", "", "", "");
        return (MTxnWriteNotificationLog)pm.makePersistent((Object)log);
    }

    @Test
    public void testGetByTxnId() throws Exception {
        GetAllWriteEventInfoRequest req = new GetAllWriteEventInfoRequest();
        req.setTxnId(1L);
        List writeEventInfoList = this.client.getAllWriteEventInfo(req);
        Assert.assertEquals((long)1L, (long)writeEventInfoList.size());
        WriteEventInfo writeEventInfo = (WriteEventInfo)writeEventInfoList.get(0);
        Assert.assertEquals((long)1L, (long)writeEventInfo.getWriteId());
        Assert.assertEquals((Object)DB_NAME, (Object)writeEventInfo.getDatabase());
        Assert.assertEquals((Object)TABLE_NAME, (Object)writeEventInfo.getTable());
    }

    @Test
    public void testGetByTxnIdAndTableName() throws Exception {
        GetAllWriteEventInfoRequest req = new GetAllWriteEventInfoRequest();
        req.setTxnId(1L);
        req.setDbName(DB_NAME);
        req.setTableName(TABLE_NAME);
        List writeEventInfoList = this.client.getAllWriteEventInfo(req);
        Assert.assertEquals((long)1L, (long)writeEventInfoList.size());
        WriteEventInfo writeEventInfo = (WriteEventInfo)writeEventInfoList.get(0);
        Assert.assertEquals((long)1L, (long)writeEventInfo.getWriteId());
        Assert.assertEquals((Object)DB_NAME, (Object)writeEventInfo.getDatabase());
        Assert.assertEquals((Object)TABLE_NAME, (Object)writeEventInfo.getTable());
    }

    @Test
    public void testGetByWrongTxnId() throws Exception {
        GetAllWriteEventInfoRequest req = new GetAllWriteEventInfoRequest();
        req.setTxnId(-1L);
        List writeEventInfoList = this.client.getAllWriteEventInfo(req);
        Assert.assertTrue((boolean)writeEventInfoList.isEmpty());
    }

    @Test
    public void testGetByWrongDB() throws Exception {
        GetAllWriteEventInfoRequest req = new GetAllWriteEventInfoRequest();
        req.setTxnId(1L);
        req.setDbName("wrong_db");
        List writeEventInfoList = this.client.getAllWriteEventInfo(req);
        Assert.assertTrue((boolean)writeEventInfoList.isEmpty());
    }

    @Test
    public void testGetByWrongTable() throws Exception {
        GetAllWriteEventInfoRequest req = new GetAllWriteEventInfoRequest();
        req.setTxnId(1L);
        req.setDbName(DB_NAME);
        req.setTableName("wrong_table");
        List writeEventInfoList = this.client.getAllWriteEventInfo(req);
        Assert.assertTrue((boolean)writeEventInfoList.isEmpty());
    }
}

