/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jdo.PersistenceManager;
import org.apache.hadoop.hive.metastore.PartitionProjectionEvaluator;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MetastoreUnitTest.class})
public class TestPartitionProjectionEvaluator {
    private ImmutableMap<String, String> fieldNameToColumnName = ImmutableMap.builder().put((Object)"createTime", (Object)"\"PARTITIONS\".\"CREATE_TIME\"").put((Object)"lastAccessTime", (Object)"\"PARTITIONS\".\"LAST_ACCESS_TIME\"").put((Object)"sd.location", (Object)"\"SDS\".\"LOCATION\"").put((Object)"sd.inputFormat", (Object)"\"SDS\".\"INPUT_FORMAT\"").put((Object)"sd.outputFormat", (Object)"\"SDS\".\"OUTPUT_FORMAT\"").put((Object)"sd.storedAsSubDirectories", (Object)"\"SDS\".\"IS_STOREDASSUBDIRECTORIES\"").put((Object)"sd.compressed", (Object)"\"SDS\".\"IS_COMPRESSED\"").put((Object)"sd.numBuckets", (Object)"\"SDS\".\"NUM_BUCKETS\"").put((Object)"sd.serdeInfo.name", (Object)"\"SDS\".\"NAME\"").put((Object)"sd.serdeInfo.serializationLib", (Object)"\"SDS\".\"SLIB\"").put((Object)"PART_ID", (Object)"\"PARTITIONS\".\"PART_ID\"").put((Object)"SD_ID", (Object)"\"SDS\".\"SD_ID\"").put((Object)"SERDE_ID", (Object)"\"SERDES\".\"SERDE_ID\"").put((Object)"CD_ID", (Object)"\"SDS\".\"CD_ID\"").build();

    private static void compareTreeUtil(PartitionProjectionEvaluator.PartitionFieldNode expected, PartitionProjectionEvaluator.PartitionFieldNode given) {
        if (expected == null || given == null) {
            Assert.assertTrue((expected == null && given == null ? 1 : 0) != 0);
        }
        Assert.assertEquals((String)"Field names should match", (Object)expected.getFieldName(), (Object)given.getFieldName());
        Assert.assertEquals((String)("IsLeafNode: Expected " + expected + " " + expected.isLeafNode() + " Given " + given + " " + given.isLeafNode()), (Object)expected.isLeafNode(), (Object)given.isLeafNode());
        Assert.assertEquals((String)("IsMultivalued: Expected " + expected + " " + expected.isMultiValued() + " Given " + given + " " + given.isMultiValued()), (Object)expected.isMultiValued(), (Object)given.isMultiValued());
        for (PartitionProjectionEvaluator.PartitionFieldNode child : expected.getChildren()) {
            Assert.assertTrue((String)("given node " + given + " does not have the child node " + child), (boolean)given.getChildren().contains(child));
            int counter = 0;
            for (PartitionProjectionEvaluator.PartitionFieldNode giveChild : given.getChildren()) {
                if (!child.equals((Object)giveChild)) continue;
                TestPartitionProjectionEvaluator.compareTreeUtil(child, giveChild);
                ++counter;
            }
            Assert.assertEquals((String)("More than one copies of node " + child + " found"), (long)1L, (long)counter);
        }
    }

    private static void compare(Set<PartitionProjectionEvaluator.PartitionFieldNode> roots, Set<PartitionProjectionEvaluator.PartitionFieldNode> giveRoots) {
        Assert.assertEquals((String)"Given roots size does not match with the size of expected number of roots", (long)roots.size(), (long)giveRoots.size());
        for (PartitionProjectionEvaluator.PartitionFieldNode root : roots) {
            Assert.assertTrue((boolean)giveRoots.contains(root));
            int counter = 0;
            for (PartitionProjectionEvaluator.PartitionFieldNode givenRoot : giveRoots) {
                if (!givenRoot.equals((Object)root)) continue;
                TestPartitionProjectionEvaluator.compareTreeUtil(root, givenRoot);
                ++counter;
            }
            Assert.assertEquals((String)("More than one copies of node found for " + root), (long)1L, (long)counter);
        }
    }

    @Test
    public void testPartitionFieldTree() throws MetaException {
        PersistenceManager mockPm = (PersistenceManager)Mockito.mock(PersistenceManager.class);
        ArrayList<String> projectionFields = new ArrayList<String>(2);
        projectionFields.add("sd.location");
        projectionFields.add("sd.parameters");
        projectionFields.add("createTime");
        projectionFields.add("sd.serdeInfo.serializationLib");
        projectionFields.add("sd.cols");
        projectionFields.add("parameters");
        PartitionProjectionEvaluator projectionEvaluator = new PartitionProjectionEvaluator(mockPm, this.fieldNameToColumnName, projectionFields, false, false, null, null);
        Set roots = projectionEvaluator.getRoots();
        HashSet<PartitionProjectionEvaluator.PartitionFieldNode> expected = new HashSet<PartitionProjectionEvaluator.PartitionFieldNode>();
        PartitionProjectionEvaluator.PartitionFieldNode sdNode = new PartitionProjectionEvaluator.PartitionFieldNode("sd");
        sdNode.addChild(new PartitionProjectionEvaluator.PartitionFieldNode("sd.location"));
        sdNode.addChild(new PartitionProjectionEvaluator.PartitionFieldNode("sd.parameters", true));
        PartitionProjectionEvaluator.PartitionFieldNode sdColsNodes = new PartitionProjectionEvaluator.PartitionFieldNode("sd.cols", true);
        sdColsNodes.addChild(new PartitionProjectionEvaluator.PartitionFieldNode("sd.cols.name", true));
        sdColsNodes.addChild(new PartitionProjectionEvaluator.PartitionFieldNode("sd.cols.type", true));
        sdColsNodes.addChild(new PartitionProjectionEvaluator.PartitionFieldNode("sd.cols.comment", true));
        sdNode.addChild(sdColsNodes);
        PartitionProjectionEvaluator.PartitionFieldNode serdeNode = new PartitionProjectionEvaluator.PartitionFieldNode("sd.serdeInfo");
        serdeNode.addChild(new PartitionProjectionEvaluator.PartitionFieldNode("sd.serdeInfo.serializationLib"));
        sdNode.addChild(serdeNode);
        expected.add(sdNode);
        expected.add(new PartitionProjectionEvaluator.PartitionFieldNode("parameters", true));
        expected.add(new PartitionProjectionEvaluator.PartitionFieldNode("createTime"));
        expected.add(new PartitionProjectionEvaluator.PartitionFieldNode("PART_ID"));
        expected.add(new PartitionProjectionEvaluator.PartitionFieldNode("SD_ID"));
        expected.add(new PartitionProjectionEvaluator.PartitionFieldNode("CD_ID"));
        expected.add(new PartitionProjectionEvaluator.PartitionFieldNode("SERDE_ID"));
        TestPartitionProjectionEvaluator.compare(expected, roots);
    }

    @Test
    public void testProjectionCompaction() throws MetaException {
        PersistenceManager mockPm = (PersistenceManager)Mockito.mock(PersistenceManager.class);
        ArrayList<String> projectionFields = new ArrayList<String>(2);
        projectionFields.add("sd.location");
        projectionFields.add("sd.parameters");
        projectionFields.add("createTime");
        projectionFields.add("sd");
        PartitionProjectionEvaluator projectionEvaluator = new PartitionProjectionEvaluator(mockPm, this.fieldNameToColumnName, projectionFields, false, false, null, null);
        Set roots = projectionEvaluator.getRoots();
        Assert.assertFalse((String)"sd.location should not contained since it is already included in sd", (boolean)roots.contains(new PartitionProjectionEvaluator.PartitionFieldNode("sd.location")));
        Assert.assertFalse((String)"sd.parameters should not contained since it is already included in sd", (boolean)roots.contains(new PartitionProjectionEvaluator.PartitionFieldNode("sd.parameters")));
    }

    @Test(expected=MetaException.class)
    public void testInvalidProjectFields() throws MetaException {
        PersistenceManager mockPm = (PersistenceManager)Mockito.mock(PersistenceManager.class);
        ArrayList<String> projectionFields = new ArrayList<String>(2);
        projectionFields.add("sd.location");
        projectionFields.add("sd.parameters");
        projectionFields.add("createTime");
        projectionFields.add("sd");
        projectionFields.add("invalid");
        new PartitionProjectionEvaluator(mockPm, this.fieldNameToColumnName, projectionFields, false, false, null, null);
    }

    @Test
    public void testFind() throws MetaException {
        PersistenceManager mockPm = (PersistenceManager)Mockito.mock(PersistenceManager.class);
        List<String> projectionFields = Arrays.asList("sd", "createTime", "sd.location", "parameters");
        PartitionProjectionEvaluator projectionEvaluator = new PartitionProjectionEvaluator(mockPm, this.fieldNameToColumnName, projectionFields, false, false, null, null);
        Assert.assertTrue((boolean)projectionEvaluator.find("sd|sd\\."));
        projectionFields = Arrays.asList("sd", "createTime", "parameters");
        projectionEvaluator = new PartitionProjectionEvaluator(mockPm, this.fieldNameToColumnName, projectionFields, false, false, null, null);
        Assert.assertTrue((boolean)projectionEvaluator.find("sd|sd\\."));
        projectionFields = Arrays.asList("createTime", "parameters", "sd.serdeInfo.serializationLib");
        projectionEvaluator = new PartitionProjectionEvaluator(mockPm, this.fieldNameToColumnName, projectionFields, false, false, null, null);
        Assert.assertTrue((boolean)projectionEvaluator.find("sd|sd\\."));
        projectionFields = Arrays.asList("createTime", "parameters", "sd.location");
        projectionEvaluator = new PartitionProjectionEvaluator(mockPm, this.fieldNameToColumnName, projectionFields, false, false, null, null);
        Assert.assertTrue((boolean)projectionEvaluator.find("sd|sd\\."));
        projectionFields = Arrays.asList("createTime", "parameters", "sd.location");
        projectionEvaluator = new PartitionProjectionEvaluator(mockPm, this.fieldNameToColumnName, projectionFields, false, false, null, null);
        Assert.assertFalse((boolean)projectionEvaluator.find("sd\\.serdeInfo|sd\\.serdeInfo\\."));
        projectionFields = Arrays.asList("createTime", "parameters", "sd.serdeInfo.serializationLib");
        projectionEvaluator = new PartitionProjectionEvaluator(mockPm, this.fieldNameToColumnName, projectionFields, false, false, null, null);
        Assert.assertTrue((boolean)projectionEvaluator.find("sd\\.serdeInfo|sd\\.serdeInfo\\."));
        projectionFields = Arrays.asList("createTime", "parameters", "sd.serdeInfo");
        projectionEvaluator = new PartitionProjectionEvaluator(mockPm, this.fieldNameToColumnName, projectionFields, false, false, null, null);
        Assert.assertTrue((boolean)projectionEvaluator.find("sd\\.serdeInfo|sd\\.serdeInfo\\."));
        projectionFields = Arrays.asList("createTime", "parameters");
        projectionEvaluator = new PartitionProjectionEvaluator(mockPm, this.fieldNameToColumnName, projectionFields, false, false, null, null);
        Assert.assertFalse((boolean)projectionEvaluator.find("sd|sd\\."));
        projectionFields = Arrays.asList("createTime", "parameters", "sd.cols");
        projectionEvaluator = new PartitionProjectionEvaluator(mockPm, this.fieldNameToColumnName, projectionFields, false, false, null, null);
        Assert.assertTrue((boolean)projectionEvaluator.find("sd\\.cols|sd\\.cols\\."));
        projectionFields = Arrays.asList("createTime", "parameters", "sd.cols.name");
        projectionEvaluator = new PartitionProjectionEvaluator(mockPm, this.fieldNameToColumnName, projectionFields, false, false, null, null);
        Assert.assertTrue((boolean)projectionEvaluator.find("sd\\.cols|sd\\.cols\\."));
        projectionFields = Arrays.asList("createTime", "parameters", "sd", "sd.location");
        projectionEvaluator = new PartitionProjectionEvaluator(mockPm, this.fieldNameToColumnName, projectionFields, false, false, null, null);
        Assert.assertTrue((boolean)projectionEvaluator.find("sd\\.cols|sd\\.cols\\."));
    }

    @Test(expected=MetaException.class)
    public void testFindNegative() throws MetaException {
        PersistenceManager mockPm = (PersistenceManager)Mockito.mock(PersistenceManager.class);
        List<String> projectionFields = Arrays.asList("createTime", "parameters", "sdxcols");
        PartitionProjectionEvaluator projectionEvaluator = new PartitionProjectionEvaluator(mockPm, this.fieldNameToColumnName, projectionFields, false, false, null, null);
    }
}

