/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.MsckPartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.PartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.PartitionManagementTask;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.builder.CatalogBuilder;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.PartitionBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.security.HadoopThriftAuthBridge;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.utils.TestTxnDbUtil;
import org.apache.thrift.TException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class TestPartitionManagement {
    private IMetaStoreClient client;
    private Configuration conf;

    @Before
    public void setUp() throws Exception {
        this.conf = MetastoreConf.newMetastoreConf();
        this.conf.setClass(MetastoreConf.ConfVars.EXPRESSION_PROXY_CLASS.getVarname(), MsckPartitionExpressionProxy.class, PartitionExpressionProxy.class);
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_METADATA_TRANSFORMER_CLASS, (String)" ");
        MetaStoreTestUtils.setConfForStandloneMode(this.conf);
        this.conf.setBoolean(MetastoreConf.ConfVars.MULTITHREADED.getVarname(), false);
        this.conf.setBoolean(MetastoreConf.ConfVars.HIVE_IN_TEST.getVarname(), true);
        MetaStoreTestUtils.startMetaStoreWithRetry(HadoopThriftAuthBridge.getBridge(), this.conf);
        TestTxnDbUtil.setConfValues(this.conf);
        TestTxnDbUtil.prepDb(this.conf);
        this.client = new HiveMetaStoreClient(this.conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void tearDown() throws Exception {
        if (this.client != null) {
            List catalogs = this.client.getCatalogs();
            for (String catName : catalogs) {
                List databases;
                if (!catName.equalsIgnoreCase("hive")) {
                    databases = this.client.getAllDatabases(catName);
                    for (String db : databases) {
                        this.client.dropDatabase(catName, db, true, false, true);
                    }
                    this.client.dropCatalog(catName);
                    continue;
                }
                databases = this.client.getAllDatabases(catName);
                for (String db : databases) {
                    if (db.equalsIgnoreCase("default")) continue;
                    this.client.dropDatabase(catName, db, true, false, true);
                }
            }
        }
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        finally {
            this.client = null;
        }
    }

    private Map<String, Column> buildAllColumns() {
        Column[] cols;
        HashMap<String, Column> colMap = new HashMap<String, Column>(6);
        for (Column c : cols = new Column[]{new Column("b", "binary"), new Column("bo", "boolean"), new Column("d", "date"), new Column("do", "double"), new Column("l", "bigint"), new Column("s", "string")}) {
            colMap.put(c.colName, c);
        }
        return colMap;
    }

    /*
     * WARNING - void declaration
     */
    private List<String> createMetadata(String catName, String dbName, String tableName, List<String> partKeys, List<String> partKeyTypes, List<List<String>> partVals, Map<String, Column> colMap, boolean isOrc) throws TException {
        Database db;
        if (!"hive".equals(catName)) {
            Catalog cat = new CatalogBuilder().setName(catName).setLocation(MetaStoreTestUtils.getTestWarehouseDir(catName)).build();
            this.client.createCatalog(cat);
        }
        if (!"default".equals(dbName)) {
            DatabaseBuilder dbBuilder = new DatabaseBuilder().setName(dbName);
            dbBuilder.setCatalogName(catName);
            db = dbBuilder.create(this.client, this.conf);
        } else {
            db = this.client.getDatabase("hive", "default");
        }
        TableBuilder tb = new TableBuilder().inDb(db).setTableName(tableName);
        if (isOrc) {
            ((TableBuilder)tb.setInputFormat("org.apache.hadoop.hive.ql.io.orc.OrcInputFormat")).setOutputFormat("org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat");
        }
        for (Column column : colMap.values()) {
            tb.addCol(column.colName, column.colType);
        }
        if (partKeys != null) {
            if (partKeyTypes == null) {
                throw new IllegalArgumentException("partKeyTypes cannot be null when partKeys is non-null");
            }
            if (partKeys.size() != partKeyTypes.size()) {
                throw new IllegalArgumentException("partKeys and partKeyTypes size should be same");
            }
            if (partVals.isEmpty()) {
                throw new IllegalArgumentException("partVals cannot be empty for patitioned table");
            }
            for (int i = 0; i < partKeys.size(); ++i) {
                tb.addPartCol(partKeys.get(i), partKeyTypes.get(i));
            }
        }
        Table table = tb.create(this.client, this.conf);
        if (partKeys != null) {
            for (List<String> list : partVals) {
                new PartitionBuilder().inTable(table).setValues(list).addToTable(this.client, this.conf);
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (partKeys != null) {
            void var13_19;
            boolean bl = false;
            while (var13_19 < partKeys.size()) {
                String partKey = partKeys.get((int)var13_19);
                for (String partVal : partVals.get((int)var13_19)) {
                    String partName = partKey + "=" + partVal;
                    arrayList.add(partName);
                }
                ++var13_19;
            }
        }
        this.client.flushCache();
        return arrayList;
    }

    @Test
    public void testPartitionDiscoveryDisabledByDefault() throws TException, IOException {
        String dbName = "db1";
        String tableName = "tbl1";
        Map<String, Column> colMap = this.buildAllColumns();
        ArrayList partKeys = Lists.newArrayList((Object[])new String[]{"state", "dt"});
        ArrayList partKeyTypes = Lists.newArrayList((Object[])new String[]{"string", "date"});
        ArrayList partVals = Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new String[]{"__HIVE_DEFAULT_PARTITION__", "1990-01-01"}), Lists.newArrayList((Object[])new String[]{"CA", "1986-04-28"}), Lists.newArrayList((Object[])new String[]{"MN", "2018-11-31"})});
        this.createMetadata("hive", dbName, tableName, partKeys, partKeyTypes, partVals, colMap, false);
        Table table = this.client.getTable(dbName, tableName);
        List partitions = this.client.listPartitions(dbName, tableName, (short)-1);
        Assert.assertEquals((long)3L, (long)partitions.size());
        String tableLocation = table.getSd().getLocation();
        URI location = URI.create(tableLocation);
        Path tablePath = new Path(location);
        FileSystem fs = FileSystem.get((URI)location, (Configuration)this.conf);
        fs.mkdirs(new Path(tablePath, "state=WA/dt=2018-12-01"));
        fs.mkdirs(new Path(tablePath, "state=UT/dt=2018-12-02"));
        Assert.assertEquals((long)5L, (long)fs.listStatus(tablePath).length);
        partitions = this.client.listPartitions(dbName, tableName, (short)-1);
        Assert.assertEquals((long)3L, (long)partitions.size());
        this.runPartitionManagementTask(this.conf);
        partitions = this.client.listPartitions(dbName, tableName, (short)-1);
        Assert.assertEquals((long)3L, (long)partitions.size());
        table.getParameters().put("discover.partitions", "false");
        this.client.alter_table(dbName, tableName, table);
        this.runPartitionManagementTask(this.conf);
        partitions = this.client.listPartitions(dbName, tableName, (short)-1);
        Assert.assertEquals((long)3L, (long)partitions.size());
    }

    @Test
    public void testPartitionDiscoveryEnabledBothTableTypes() throws TException, IOException {
        String dbName = "db2";
        String tableName = "tbl2";
        Map<String, Column> colMap = this.buildAllColumns();
        ArrayList partKeys = Lists.newArrayList((Object[])new String[]{"state", "dt"});
        ArrayList partKeyTypes = Lists.newArrayList((Object[])new String[]{"string", "date"});
        ArrayList partVals = Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new String[]{"__HIVE_DEFAULT_PARTITION__", "1990-01-01"}), Lists.newArrayList((Object[])new String[]{"CA", "1986-04-28"}), Lists.newArrayList((Object[])new String[]{"MN", "2018-11-31"})});
        this.createMetadata("hive", dbName, tableName, partKeys, partKeyTypes, partVals, colMap, false);
        Table table = this.client.getTable(dbName, tableName);
        List partitions = this.client.listPartitions(dbName, tableName, (short)-1);
        Assert.assertEquals((long)3L, (long)partitions.size());
        String tableLocation = table.getSd().getLocation();
        URI location = URI.create(tableLocation);
        Path tablePath = new Path(location);
        FileSystem fs = FileSystem.get((URI)location, (Configuration)this.conf);
        Path newPart1 = new Path(tablePath, "state=WA/dt=2018-12-01");
        Path newPart2 = new Path(tablePath, "state=UT/dt=2018-12-02");
        fs.mkdirs(newPart1);
        fs.mkdirs(newPart2);
        Assert.assertEquals((long)5L, (long)fs.listStatus(tablePath).length);
        partitions = this.client.listPartitions(dbName, tableName, (short)-1);
        Assert.assertEquals((long)3L, (long)partitions.size());
        table.getParameters().put("discover.partitions", "true");
        this.client.alter_table(dbName, tableName, table);
        this.runPartitionManagementTask(this.conf);
        partitions = this.client.listPartitions(dbName, tableName, (short)-1);
        Assert.assertEquals((long)5L, (long)partitions.size());
        table.getParameters().put("EXTERNAL", "true");
        table.setTableType(TableType.EXTERNAL_TABLE.name());
        this.client.alter_table(dbName, tableName, table);
        boolean deleted = fs.delete(newPart1.getParent(), true);
        Assert.assertTrue((boolean)deleted);
        Assert.assertEquals((long)4L, (long)fs.listStatus(tablePath).length);
        this.runPartitionManagementTask(this.conf);
        partitions = this.client.listPartitions(dbName, tableName, (short)-1);
        Assert.assertEquals((long)4L, (long)partitions.size());
        this.conf.set(MetastoreConf.ConfVars.PARTITION_MANAGEMENT_TABLE_TYPES.getVarname(), TableType.MANAGED_TABLE.name());
        deleted = fs.delete(newPart2.getParent(), true);
        Assert.assertTrue((boolean)deleted);
        Assert.assertEquals((long)3L, (long)fs.listStatus(tablePath).length);
        this.runPartitionManagementTask(this.conf);
        partitions = this.client.listPartitions(dbName, tableName, (short)-1);
        Assert.assertEquals((long)4L, (long)partitions.size());
        this.conf.set(MetastoreConf.ConfVars.PARTITION_MANAGEMENT_TABLE_TYPES.getVarname(), "");
        this.runPartitionManagementTask(this.conf);
        partitions = this.client.listPartitions(dbName, tableName, (short)-1);
        Assert.assertEquals((long)4L, (long)partitions.size());
        this.conf.set(MetastoreConf.ConfVars.PARTITION_MANAGEMENT_TABLE_TYPES.getVarname(), TableType.EXTERNAL_TABLE.name());
        this.runPartitionManagementTask(this.conf);
        partitions = this.client.listPartitions(dbName, tableName, (short)-1);
        Assert.assertEquals((long)3L, (long)partitions.size());
        this.conf.set(MetastoreConf.ConfVars.PARTITION_MANAGEMENT_TABLE_TYPES.getVarname(), TableType.MANAGED_TABLE.name());
        table.getParameters().remove("EXTERNAL");
        table.setTableType(TableType.MANAGED_TABLE.name());
        this.client.alter_table(dbName, tableName, table);
        Assert.assertTrue((boolean)fs.mkdirs(newPart1));
        Assert.assertTrue((boolean)fs.mkdirs(newPart2));
        this.runPartitionManagementTask(this.conf);
        partitions = this.client.listPartitions(dbName, tableName, (short)-1);
        Assert.assertEquals((long)5L, (long)partitions.size());
        Assert.assertTrue((boolean)fs.delete(newPart1, true));
        this.runPartitionManagementTask(this.conf);
        partitions = this.client.listPartitions(dbName, tableName, (short)-1);
        Assert.assertEquals((long)4L, (long)partitions.size());
    }

    @Test
    public void testPartitionDiscoveryNonDefaultCatalog() throws TException, IOException {
        String catName = "cat3";
        String dbName = "db3";
        String tableName = "tbl3";
        Map<String, Column> colMap = this.buildAllColumns();
        ArrayList partKeys = Lists.newArrayList((Object[])new String[]{"state", "dt"});
        ArrayList partKeyTypes = Lists.newArrayList((Object[])new String[]{"string", "date"});
        ArrayList partVals = Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new String[]{"__HIVE_DEFAULT_PARTITION__", "1990-01-01"}), Lists.newArrayList((Object[])new String[]{"CA", "1986-04-28"}), Lists.newArrayList((Object[])new String[]{"MN", "2018-11-31"})});
        this.createMetadata(catName, dbName, tableName, partKeys, partKeyTypes, partVals, colMap, false);
        Table table = this.client.getTable(catName, dbName, tableName);
        List partitions = this.client.listPartitions(catName, dbName, tableName, -1);
        Assert.assertEquals((long)3L, (long)partitions.size());
        String tableLocation = table.getSd().getLocation();
        URI location = URI.create(tableLocation);
        Path tablePath = new Path(location);
        FileSystem fs = FileSystem.get((URI)location, (Configuration)this.conf);
        Path newPart1 = new Path(tablePath, "state=WA/dt=2018-12-01");
        Path newPart2 = new Path(tablePath, "state=UT/dt=2018-12-02");
        fs.mkdirs(newPart1);
        fs.mkdirs(newPart2);
        Assert.assertEquals((long)5L, (long)fs.listStatus(tablePath).length);
        table.getParameters().put("discover.partitions", "true");
        this.client.alter_table(catName, dbName, tableName, table);
        this.runPartitionManagementTask(this.conf);
        partitions = this.client.listPartitions(catName, dbName, tableName, -1);
        Assert.assertEquals((long)3L, (long)partitions.size());
        this.conf.set(MetastoreConf.ConfVars.PARTITION_MANAGEMENT_CATALOG_NAME.getVarname(), catName);
        this.runPartitionManagementTask(this.conf);
        partitions = this.client.listPartitions(catName, dbName, tableName, -1);
        Assert.assertEquals((long)5L, (long)partitions.size());
    }

    @Test
    public void testPartitionDiscoveryDBPattern() throws TException, IOException {
        String dbName = "db4";
        String tableName = "tbl4";
        Map<String, Column> colMap = this.buildAllColumns();
        ArrayList partKeys = Lists.newArrayList((Object[])new String[]{"state", "dt"});
        ArrayList partKeyTypes = Lists.newArrayList((Object[])new String[]{"string", "date"});
        ArrayList partVals = Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new String[]{"__HIVE_DEFAULT_PARTITION__", "1990-01-01"}), Lists.newArrayList((Object[])new String[]{"CA", "1986-04-28"}), Lists.newArrayList((Object[])new String[]{"MN", "2018-11-31"})});
        this.createMetadata("hive", dbName, tableName, partKeys, partKeyTypes, partVals, colMap, false);
        Table table = this.client.getTable(dbName, tableName);
        List partitions = this.client.listPartitions(dbName, tableName, (short)-1);
        Assert.assertEquals((long)3L, (long)partitions.size());
        String tableLocation = table.getSd().getLocation();
        URI location = URI.create(tableLocation);
        Path tablePath = new Path(location);
        FileSystem fs = FileSystem.get((URI)location, (Configuration)this.conf);
        Path newPart1 = new Path(tablePath, "state=WA/dt=2018-12-01");
        Path newPart2 = new Path(tablePath, "state=UT/dt=2018-12-02");
        fs.mkdirs(newPart1);
        fs.mkdirs(newPart2);
        Assert.assertEquals((long)5L, (long)fs.listStatus(tablePath).length);
        table.getParameters().put("discover.partitions", "true");
        this.client.alter_table(dbName, tableName, table);
        this.conf.set(MetastoreConf.ConfVars.PARTITION_MANAGEMENT_DATABASE_PATTERN.getVarname(), "*dbfoo*");
        this.runPartitionManagementTask(this.conf);
        partitions = this.client.listPartitions(dbName, tableName, (short)-1);
        Assert.assertEquals((long)3L, (long)partitions.size());
        this.conf.set(MetastoreConf.ConfVars.PARTITION_MANAGEMENT_DATABASE_PATTERN.getVarname(), "*db4*");
        this.runPartitionManagementTask(this.conf);
        partitions = this.client.listPartitions(dbName, tableName, (short)-1);
        Assert.assertEquals((long)5L, (long)partitions.size());
        fs.mkdirs(new Path(tablePath, "state=MG/dt=2021-28-05"));
        Assert.assertEquals((long)6L, (long)fs.listStatus(tablePath).length);
        Database db = this.client.getDatabase(table.getDbName());
        db.putToParameters("repl.failover.endpoint", MetaStoreUtils.FailoverEndpoint.SOURCE.toString());
        this.client.alterDatabase(dbName, db);
        this.runPartitionManagementTask(this.conf);
        partitions = this.client.listPartitions(dbName, tableName, (short)-1);
        Assert.assertEquals((long)5L, (long)partitions.size());
    }

    @Test
    public void testPartitionDiscoveryTablePattern() throws TException, IOException {
        String dbName = "db5";
        String tableName = "tbl5";
        Map<String, Column> colMap = this.buildAllColumns();
        ArrayList partKeys = Lists.newArrayList((Object[])new String[]{"state", "dt"});
        ArrayList partKeyTypes = Lists.newArrayList((Object[])new String[]{"string", "date"});
        ArrayList partVals = Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new String[]{"__HIVE_DEFAULT_PARTITION__", "1990-01-01"}), Lists.newArrayList((Object[])new String[]{"CA", "1986-04-28"}), Lists.newArrayList((Object[])new String[]{"MN", "2018-11-31"})});
        this.createMetadata("hive", dbName, tableName, partKeys, partKeyTypes, partVals, colMap, false);
        Table table = this.client.getTable(dbName, tableName);
        List partitions = this.client.listPartitions(dbName, tableName, (short)-1);
        Assert.assertEquals((long)3L, (long)partitions.size());
        String tableLocation = table.getSd().getLocation();
        URI location = URI.create(tableLocation);
        Path tablePath = new Path(location);
        FileSystem fs = FileSystem.get((URI)location, (Configuration)this.conf);
        Path newPart1 = new Path(tablePath, "state=WA/dt=2018-12-01");
        Path newPart2 = new Path(tablePath, "state=UT/dt=2018-12-02");
        fs.mkdirs(newPart1);
        fs.mkdirs(newPart2);
        Assert.assertEquals((long)5L, (long)fs.listStatus(tablePath).length);
        table.getParameters().put("discover.partitions", "true");
        this.client.alter_table(dbName, tableName, table);
        this.conf.set(MetastoreConf.ConfVars.PARTITION_MANAGEMENT_TABLE_PATTERN.getVarname(), "*tblfoo*");
        this.runPartitionManagementTask(this.conf);
        partitions = this.client.listPartitions(dbName, tableName, (short)-1);
        Assert.assertEquals((long)3L, (long)partitions.size());
        this.conf.set(MetastoreConf.ConfVars.PARTITION_MANAGEMENT_TABLE_PATTERN.getVarname(), "tbl5*");
        this.runPartitionManagementTask(this.conf);
        partitions = this.client.listPartitions(dbName, tableName, (short)-1);
        Assert.assertEquals((long)5L, (long)partitions.size());
    }

    @Test
    public void testPartitionDiscoveryTransactionalTable() throws TException, IOException, InterruptedException, ExecutionException {
        String dbName = "db6";
        String tableName = "tbl6";
        Map<String, Column> colMap = this.buildAllColumns();
        ArrayList partKeys = Lists.newArrayList((Object[])new String[]{"state", "dt"});
        ArrayList partKeyTypes = Lists.newArrayList((Object[])new String[]{"string", "date"});
        ArrayList partVals = Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new String[]{"__HIVE_DEFAULT_PARTITION__", "1990-01-01"}), Lists.newArrayList((Object[])new String[]{"CA", "1986-04-28"}), Lists.newArrayList((Object[])new String[]{"MN", "2018-11-31"})});
        this.createMetadata("hive", dbName, tableName, partKeys, partKeyTypes, partVals, colMap, true);
        Table table = this.client.getTable(dbName, tableName);
        List partitions = this.client.listPartitions(dbName, tableName, (short)-1);
        Assert.assertEquals((long)3L, (long)partitions.size());
        String tableLocation = table.getSd().getLocation();
        URI location = URI.create(tableLocation);
        Path tablePath = new Path(location);
        FileSystem fs = FileSystem.get((URI)location, (Configuration)this.conf);
        Path newPart1 = new Path(tablePath, "state=WA/dt=2018-12-01");
        Path newPart2 = new Path(tablePath, "state=UT/dt=2018-12-02");
        fs.mkdirs(newPart1);
        fs.mkdirs(newPart2);
        Assert.assertEquals((long)5L, (long)fs.listStatus(tablePath).length);
        table.getParameters().put("discover.partitions", "true");
        table.getParameters().put("transactional", "true");
        table.getParameters().put("transactional_properties", "insert_only");
        this.client.alter_table(dbName, tableName, table);
        this.runPartitionManagementTask(this.conf);
        partitions = this.client.listPartitions(dbName, tableName, (short)-1);
        Assert.assertEquals((long)5L, (long)partitions.size());
        Assert.assertEquals((long)0L, (long)PartitionManagementTask.getSkippedAttempts());
        boolean deleted = fs.delete(newPart1.getParent(), true);
        Assert.assertTrue((boolean)deleted);
        Assert.assertEquals((long)4L, (long)fs.listStatus(tablePath).length);
        PartitionManagementTask partitionDiscoveryTask1 = new PartitionManagementTask();
        partitionDiscoveryTask1.setConf(this.conf);
        PartitionManagementTask partitionDiscoveryTask2 = new PartitionManagementTask();
        partitionDiscoveryTask2.setConf(this.conf);
        PartitionManagementTask partitionDiscoveryTask3 = new PartitionManagementTask();
        partitionDiscoveryTask3.setConf(this.conf);
        ArrayList tasks = Lists.newArrayList((Object[])new PartitionManagementTask[]{partitionDiscoveryTask1, partitionDiscoveryTask2, partitionDiscoveryTask3});
        ExecutorService executorService = Executors.newFixedThreadPool(3);
        int successBefore = PartitionManagementTask.getCompletedAttempts();
        int skippedBefore = PartitionManagementTask.getSkippedAttempts();
        ArrayList futures = new ArrayList();
        for (PartitionManagementTask partitionManagementTask : tasks) {
            futures.add(executorService.submit((Runnable)partitionManagementTask));
        }
        for (Future future : futures) {
            future.get();
        }
        int successAfter = PartitionManagementTask.getCompletedAttempts();
        int n = PartitionManagementTask.getSkippedAttempts();
        Assert.assertEquals((long)1L, (long)(successAfter - successBefore));
        Assert.assertEquals((long)2L, (long)(n - skippedBefore));
        partitions = this.client.listPartitions(dbName, tableName, (short)-1);
        Assert.assertEquals((long)4L, (long)partitions.size());
    }

    @Test
    public void testPartitionRetention() throws TException, IOException, InterruptedException {
        String dbName = "db7";
        String tableName = "tbl7";
        Map<String, Column> colMap = this.buildAllColumns();
        ArrayList partKeys = Lists.newArrayList((Object[])new String[]{"state", "dt"});
        ArrayList partKeyTypes = Lists.newArrayList((Object[])new String[]{"string", "date"});
        ArrayList partVals = Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new String[]{"__HIVE_DEFAULT_PARTITION__", "1990-01-01"}), Lists.newArrayList((Object[])new String[]{"CA", "1986-04-28"}), Lists.newArrayList((Object[])new String[]{"MN", "2018-11-31"})});
        this.createMetadata("hive", dbName, tableName, partKeys, partKeyTypes, partVals, colMap, false);
        Table table = this.client.getTable(dbName, tableName);
        List partitions = this.client.listPartitions(dbName, tableName, (short)-1);
        Assert.assertEquals((long)3L, (long)partitions.size());
        String tableLocation = table.getSd().getLocation();
        URI location = URI.create(tableLocation);
        Path tablePath = new Path(location);
        FileSystem fs = FileSystem.get((URI)location, (Configuration)this.conf);
        Path newPart1 = new Path(tablePath, "state=WA/dt=2018-12-01");
        Path newPart2 = new Path(tablePath, "state=UT/dt=2018-12-02");
        fs.mkdirs(newPart1);
        fs.mkdirs(newPart2);
        Assert.assertEquals((long)5L, (long)fs.listStatus(tablePath).length);
        table.getParameters().put("discover.partitions", "true");
        table.getParameters().put("partition.retention.period", "20000ms");
        this.client.alter_table(dbName, tableName, table);
        this.runPartitionManagementTask(this.conf);
        partitions = this.client.listPartitions(dbName, tableName, (short)-1);
        Assert.assertEquals((long)5L, (long)partitions.size());
        Database db = this.client.getDatabase(table.getDbName());
        db.putToParameters("repl.failover.endpoint", MetaStoreUtils.FailoverEndpoint.SOURCE.toString());
        this.client.alterDatabase(table.getDbName(), db);
        Thread.sleep(30000L);
        this.runPartitionManagementTask(this.conf);
        partitions = this.client.listPartitions(dbName, tableName, (short)-1);
        Assert.assertEquals((long)5L, (long)partitions.size());
        db.putToParameters("repl.failover.endpoint", "");
        this.client.alterDatabase(table.getDbName(), db);
        Thread.sleep(30000L);
        this.runPartitionManagementTask(this.conf);
        partitions = this.client.listPartitions(dbName, tableName, (short)-1);
        Assert.assertEquals((long)0L, (long)partitions.size());
    }

    @Test
    public void testPartitionDiscoverySkipInvalidPath() throws TException, IOException, InterruptedException {
        String dbName = "db8";
        String tableName = "tbl8";
        Map<String, Column> colMap = this.buildAllColumns();
        ArrayList partKeys = Lists.newArrayList((Object[])new String[]{"state", "dt"});
        ArrayList partKeyTypes = Lists.newArrayList((Object[])new String[]{"string", "date"});
        ArrayList partVals = Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new String[]{"__HIVE_DEFAULT_PARTITION__", "1990-01-01"}), Lists.newArrayList((Object[])new String[]{"CA", "1986-04-28"}), Lists.newArrayList((Object[])new String[]{"MN", "2018-11-31"})});
        this.createMetadata("hive", dbName, tableName, partKeys, partKeyTypes, partVals, colMap, false);
        Table table = this.client.getTable(dbName, tableName);
        List partitions = this.client.listPartitions(dbName, tableName, (short)-1);
        Assert.assertEquals((long)3L, (long)partitions.size());
        String tableLocation = table.getSd().getLocation();
        URI location = URI.create(tableLocation);
        Path tablePath = new Path(location);
        FileSystem fs = FileSystem.get((URI)location, (Configuration)this.conf);
        Path newPart1 = new Path(tablePath, "state=WA/dt=2018-12-01");
        Path newPart2 = new Path(tablePath, "state=UT/dt=");
        fs.mkdirs(newPart1);
        fs.mkdirs(newPart2);
        Assert.assertEquals((long)5L, (long)fs.listStatus(tablePath).length);
        table.getParameters().put("discover.partitions", "true");
        table.getParameters().put("partition.retention.period", "");
        this.client.alter_table(dbName, tableName, table);
        this.runPartitionManagementTask(this.conf);
        partitions = this.client.listPartitions(dbName, tableName, (short)-1);
        Assert.assertEquals((long)4L, (long)partitions.size());
    }

    @Test
    public void testNoPartitionDiscoveryForReplTable() throws Exception {
        String dbName = "db_repl1";
        String tableName = "tbl_repl1";
        Map<String, Column> colMap = this.buildAllColumns();
        ArrayList partKeys = Lists.newArrayList((Object[])new String[]{"state", "dt"});
        ArrayList partKeyTypes = Lists.newArrayList((Object[])new String[]{"string", "date"});
        ArrayList partVals = Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new String[]{"__HIVE_DEFAULT_PARTITION__", "1990-01-01"}), Lists.newArrayList((Object[])new String[]{"CA", "1986-04-28"}), Lists.newArrayList((Object[])new String[]{"MN", "2018-11-31"})});
        this.createMetadata("hive", dbName, tableName, partKeys, partKeyTypes, partVals, colMap, false);
        Table table = this.client.getTable(dbName, tableName);
        List partitions = this.client.listPartitions(dbName, tableName, (short)-1);
        Assert.assertEquals((long)3L, (long)partitions.size());
        String tableLocation = table.getSd().getLocation();
        URI location = URI.create(tableLocation);
        Path tablePath = new Path(location);
        FileSystem fs = FileSystem.get((URI)location, (Configuration)this.conf);
        Path newPart1 = new Path(tablePath, "state=WA/dt=2018-12-01");
        Path newPart2 = new Path(tablePath, "state=UT/dt=2018-12-02");
        fs.mkdirs(newPart1);
        fs.mkdirs(newPart2);
        Assert.assertEquals((long)5L, (long)fs.listStatus(tablePath).length);
        partitions = this.client.listPartitions(dbName, tableName, (short)-1);
        Assert.assertEquals((long)3L, (long)partitions.size());
        table.getParameters().put("discover.partitions", "true");
        Database db = this.client.getDatabase(table.getDbName());
        db.putToParameters("repl.target.for", "true");
        this.client.alterDatabase(table.getDbName(), db);
        this.client.alter_table(dbName, tableName, table);
        this.runPartitionManagementTask(this.conf);
        partitions = this.client.listPartitions(dbName, tableName, (short)-1);
        Assert.assertEquals((long)3L, (long)partitions.size());
        table.getParameters().put("EXTERNAL", "true");
        table.setTableType(TableType.EXTERNAL_TABLE.name());
        this.client.alter_table(dbName, tableName, table);
        boolean deleted = fs.delete(new Path(URI.create(((Partition)partitions.get(0)).getSd().getLocation())).getParent(), true);
        Assert.assertTrue((boolean)deleted);
        Assert.assertEquals((long)4L, (long)fs.listStatus(tablePath).length);
        this.runPartitionManagementTask(this.conf);
        partitions = this.client.listPartitions(dbName, tableName, (short)-1);
        Assert.assertEquals((long)3L, (long)partitions.size());
        db = this.client.getDatabase(table.getDbName());
        db.putToParameters("repl.background.enable", "true");
        this.client.alterDatabase(table.getDbName(), db);
        this.runPartitionManagementTask(this.conf);
        partitions = this.client.listPartitions(dbName, tableName, (short)-1);
        Assert.assertEquals((long)4L, (long)partitions.size());
    }

    @Test
    public void testNoPartitionRetentionForReplTarget() throws TException, InterruptedException {
        String dbName = "db_repl2";
        String tableName = "tbl_repl2";
        Map<String, Column> colMap = this.buildAllColumns();
        ArrayList partKeys = Lists.newArrayList((Object[])new String[]{"state", "dt"});
        ArrayList partKeyTypes = Lists.newArrayList((Object[])new String[]{"string", "date"});
        ArrayList partVals = Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new String[]{"__HIVE_DEFAULT_PARTITION__", "1990-01-01"}), Lists.newArrayList((Object[])new String[]{"CA", "1986-04-28"}), Lists.newArrayList((Object[])new String[]{"MN", "2018-11-31"})});
        long partitionRetentionPeriodMs = 20000L;
        long waitingPeriodForTest = partitionRetentionPeriodMs + 10000L;
        this.createMetadata("hive", dbName, tableName, partKeys, partKeyTypes, partVals, colMap, false);
        Table table = this.client.getTable(dbName, tableName);
        List partitions = this.client.listPartitions(dbName, tableName, (short)-1);
        Assert.assertEquals((long)3L, (long)partitions.size());
        table.getParameters().put("discover.partitions", "true");
        table.getParameters().put("partition.retention.period", partitionRetentionPeriodMs + "ms");
        this.client.alter_table(dbName, tableName, table);
        Database db = this.client.getDatabase(table.getDbName());
        db.putToParameters("repl.target.for", "true");
        this.client.alterDatabase(table.getDbName(), db);
        this.runPartitionManagementTask(this.conf);
        partitions = this.client.listPartitions(dbName, tableName, (short)-1);
        Assert.assertEquals((long)3L, (long)partitions.size());
        Thread.sleep(waitingPeriodForTest);
        this.runPartitionManagementTask(this.conf);
        partitions = this.client.listPartitions(dbName, tableName, (short)-1);
        Assert.assertEquals((long)3L, (long)partitions.size());
        db = this.client.getDatabase(table.getDbName());
        db.putToParameters("repl.background.enable", "true");
        this.client.alterDatabase(table.getDbName(), db);
        Thread.sleep(waitingPeriodForTest);
        this.runPartitionManagementTask(this.conf);
        partitions = this.client.listPartitions(dbName, tableName, (short)-1);
        Assert.assertEquals((long)0L, (long)partitions.size());
    }

    @Test
    public void testPartitionExprFilter() throws TException, IOException {
        String dbName = "db10";
        String tableName = "tbl10";
        Map<String, Column> colMap = this.buildAllColumns();
        ArrayList partKeys = Lists.newArrayList((Object[])new String[]{"state", "dt", "modts"});
        ArrayList partKeyTypes = Lists.newArrayList((Object[])new String[]{"string", "date", "timestamp"});
        ArrayList partVals = Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new String[]{"__HIVE_DEFAULT_PARTITION__", "1990-01-01", "__HIVE_DEFAULT_PARTITION__"}), Lists.newArrayList((Object[])new String[]{"CA", "1986-04-28", "2020-02-21 08:30:01"}), Lists.newArrayList((Object[])new String[]{"MN", "2018-11-31", "2020-02-21 08:19:01"})});
        this.createMetadata("hive", dbName, tableName, partKeys, partKeyTypes, partVals, colMap, false);
        Table table = this.client.getTable(dbName, tableName);
        table.getParameters().put("discover.partitions", "true");
        table.getParameters().put("EXTERNAL", "true");
        table.setTableType(TableType.EXTERNAL_TABLE.name());
        this.client.alter_table(dbName, tableName, table);
        List partitions = this.client.listPartitions(dbName, tableName, (short)-1);
        Assert.assertEquals((long)3L, (long)partitions.size());
        String tableLocation = table.getSd().getLocation();
        URI location = URI.create(tableLocation);
        Path tablePath = new Path(location);
        FileSystem fs = FileSystem.get((URI)location, (Configuration)this.conf);
        String partPath = ((Partition)partitions.get(1)).getSd().getLocation();
        Path newPart1 = new Path(tablePath, partPath);
        fs.delete(newPart1);
        this.conf.set(MetastoreConf.ConfVars.PARTITION_MANAGEMENT_DATABASE_PATTERN.getVarname(), "*db10*");
        this.conf.set(MetastoreConf.ConfVars.PARTITION_MANAGEMENT_TABLE_TYPES.getVarname(), TableType.EXTERNAL_TABLE.name());
        this.runPartitionManagementTask(this.conf);
        partitions = this.client.listPartitions(dbName, tableName, (short)-1);
        Assert.assertEquals((long)2L, (long)partitions.size());
    }

    private void runPartitionManagementTask(Configuration conf) {
        PartitionManagementTask task = new PartitionManagementTask();
        task.setConf(conf);
        task.run();
    }

    private static class Column {
        private String colName;
        private String colType;

        public Column(String colName, String colType) {
            this.colName = colName;
            this.colType = colType;
        }
    }
}

