/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HMSHandler;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.ObjectStore;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.StatementVerifyingDerby;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class TestObjectStoreStatementVerify {
    private ObjectStore objectStore = null;
    private Configuration conf = null;
    private final String DB1 = "db1";
    private final String TBL1 = "db1_tbl1";

    @BeforeClass
    public static void oneTimeSetup() throws SQLException {
        DriverManager.registerDriver((Driver)((Object)new StatementVerifyingDerby()));
    }

    private ObjectStore createObjectStore() throws MetaException, InvalidOperationException {
        this.conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECTION_DRIVER, (String)StatementVerifyingDerby.class.getName());
        String jdbcUrl = MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECT_URL_KEY);
        jdbcUrl = jdbcUrl.replace("derby", "sderby");
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECT_URL_KEY, (String)jdbcUrl);
        MetaStoreTestUtils.setConfForStandloneMode(this.conf);
        ObjectStore objectStore = new ObjectStore();
        objectStore.setConf(this.conf);
        HMSHandler.createDefaultCatalog((RawStore)objectStore, (Warehouse)new Warehouse(this.conf));
        return objectStore;
    }

    static void verifySql(String sql) {
        if (sql.contains("SELECT DISTINCT 'org.apache.hadoop.hive.metastore.model.MTable' AS") || sql.contains("SELECT 'org.apache.hadoop.hive.metastore.model.MTable' AS")) {
            TestObjectStoreStatementVerify.verifyMTableDBFetchGroup(sql);
        }
    }

    private static void verifyMTableDBFetchGroup(String sql) {
        Pattern sqlPatternDb = Pattern.compile("JOIN\\ DBS\\ ([a-zA-Z0-9]+)\\ ON");
        Matcher matcher = sqlPatternDb.matcher(sql);
        ArrayList<String> dbIdentifiers = new ArrayList<String>();
        while (matcher.find()) {
            dbIdentifiers.add(matcher.group(1));
        }
        boolean confirmedDbNameRetrieval = false;
        for (String dbIdenfier : dbIdentifiers) {
            if (!sql.contains(dbIdenfier + ".\"NAME\"")) continue;
            confirmedDbNameRetrieval = true;
            break;
        }
        Assert.assertTrue((String)"The Db info should be retrieved as part of MTable fetch", (boolean)confirmedDbNameRetrieval);
    }

    @Test
    public void testGetTableMetaFetchGroup() throws MetaException, InvalidObjectException, InvalidOperationException {
        this.objectStore = this.createObjectStore();
        Database db = new Database("db1", "description", "locurl", null);
        db.setCatalogName("hive");
        this.objectStore.createDatabase(db);
        this.objectStore.createTable(this.makeTable("db1", "db1_tbl1"));
        List tableMeta = this.objectStore.getTableMeta("hive", "*", "*", Collections.emptyList());
        Assert.assertEquals((String)"Number of items for tableMeta is incorrect", (long)1L, (long)tableMeta.size());
        Assert.assertEquals((String)"Table name incorrect", (Object)"db1_tbl1", (Object)((TableMeta)tableMeta.get(0)).getTableName());
        Assert.assertEquals((String)"Db name incorrect", (Object)"db1", (Object)((TableMeta)tableMeta.get(0)).getDbName());
    }

    private Table makeTable(String dbName, String tblName) throws MetaException {
        return ((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)new TableBuilder().setTableName(tblName).setDbName(dbName).setOwner("owner").setCreateTime(1).setLastAccessTime(2).setRetention(3).addTableParam("EXTERNAL", "false").setType("MANAGED_TABLE").setLocation("location")).setCompressed(false)).setNumBuckets(0)).setSerdeName("SerDeName")).setSerdeLib("serializationLib")).addCol("some_col", "double", null)).build(this.conf);
    }
}

