/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.codahale.metrics.Counter;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.Callable;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jdo.Query;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.Deadline;
import org.apache.hadoop.hive.metastore.HMSHandler;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.ObjectStore;
import org.apache.hadoop.hive.metastore.PersistenceManagerProvider;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.StatisticsTestUtils;
import org.apache.hadoop.hive.metastore.TestHiveMetaStore;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.AddPackageRequest;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.CreationMetadata;
import org.apache.hadoop.hive.metastore.api.CurrentNotificationEventId;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.DropPackageRequest;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.GetPackageRequest;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.ListPackageRequest;
import org.apache.hadoop.hive.metastore.api.ListStoredProcedureRequest;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.NotificationEventRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEventResponse;
import org.apache.hadoop.hive.metastore.api.Package;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionListComposingSpec;
import org.apache.hadoop.hive.metastore.api.PartitionSpec;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.StoredProcedure;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.builder.CatalogBuilder;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.HiveObjectPrivilegeBuilder;
import org.apache.hadoop.hive.metastore.client.builder.HiveObjectRefBuilder;
import org.apache.hadoop.hive.metastore.client.builder.PartitionBuilder;
import org.apache.hadoop.hive.metastore.client.builder.PrivilegeGrantInfoBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.columnstats.ColStatsBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.messaging.EventMessage;
import org.apache.hadoop.hive.metastore.metrics.Metrics;
import org.apache.hadoop.hive.metastore.model.MNotificationLog;
import org.apache.hadoop.hive.metastore.model.MNotificationNextId;
import org.apache.hadoop.hive.metastore.model.MTable;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MetastoreUnitTest.class})
public class TestObjectStore {
    private ObjectStore objectStore = null;
    private Configuration conf;
    private static final String ENGINE = "hive";
    private static final String DB1 = "testobjectstoredb1";
    private static final String DB2 = "testobjectstoredb2";
    private static final String TABLE1 = "testobjectstoretable1";
    private static final String KEY1 = "testobjectstorekey1";
    private static final String KEY2 = "testobjectstorekey2";
    private static final String OWNER = "testobjectstoreowner";
    private static final String USER1 = "testobjectstoreuser1";
    private static final String ROLE1 = "testobjectstorerole1";
    private static final String ROLE2 = "testobjectstorerole2";
    private static final Logger LOG = LoggerFactory.getLogger((String)TestObjectStore.class.getName());

    @Before
    public void setUp() throws Exception {
        this.conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetastoreConf.setLongVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.EVENT_CLEAN_MAX_EVENTS, (long)1L);
        MetastoreConf.setBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.STATS_FETCH_BITVECTOR, (boolean)true);
        MetastoreConf.setBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.STATS_FETCH_KLL, (boolean)true);
        MetaStoreTestUtils.setConfForStandloneMode(this.conf);
        this.setupRandomObjectStoreUrl();
        this.objectStore = new ObjectStore();
        this.objectStore.setConf(this.conf);
        HMSHandler.createDefaultCatalog((RawStore)this.objectStore, (Warehouse)new Warehouse(this.conf));
    }

    private void setupRandomObjectStoreUrl() {
        String currentUrl = MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECT_URL_KEY);
        currentUrl = currentUrl.replace("junit_metastore_db", String.format("%s_%s", "junit_metastore_db", UUID.randomUUID().toString()));
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECT_URL_KEY, (String)currentUrl);
    }

    @After
    public void tearDown() throws Exception {
        System.clearProperty("javax.net.ssl.trustStore");
        System.clearProperty("javax.net.ssl.trustStorePassword");
        System.clearProperty("javax.net.ssl.trustStoreType");
    }

    @Test
    public void catalogs() throws MetaException, NoSuchObjectException {
        String[] names = new String[]{"cat1", "cat2"};
        String[] locations = new String[]{"loc1", "loc2"};
        String[] descriptions = new String[]{"description 1", "description 2"};
        for (int i = 0; i < names.length; ++i) {
            Catalog cat = new CatalogBuilder().setName(names[i]).setLocation(locations[i]).setDescription(descriptions[i]).build();
            this.objectStore.createCatalog(cat);
        }
        List fetchedNames = this.objectStore.getCatalogs();
        Assert.assertEquals((long)3L, (long)fetchedNames.size());
        for (int i = 0; i < names.length - 1; ++i) {
            Assert.assertEquals((Object)names[i], fetchedNames.get(i));
            Catalog cat = this.objectStore.getCatalog((String)fetchedNames.get(i));
            Assert.assertEquals((Object)names[i], (Object)cat.getName());
            Assert.assertEquals((Object)descriptions[i], (Object)cat.getDescription());
            Assert.assertEquals((Object)locations[i], (Object)cat.getLocationUri());
        }
        Catalog cat = this.objectStore.getCatalog((String)fetchedNames.get(2));
        Assert.assertEquals((Object)ENGINE, (Object)cat.getName());
        Assert.assertEquals((Object)"Default catalog, for Hive", (Object)cat.getDescription());
        for (int i = 0; i < names.length; ++i) {
            this.objectStore.dropCatalog(names[i]);
        }
        fetchedNames = this.objectStore.getCatalogs();
        Assert.assertEquals((long)1L, (long)fetchedNames.size());
    }

    @Test(expected=NoSuchObjectException.class)
    public void getNoSuchCatalog() throws MetaException, NoSuchObjectException {
        this.objectStore.getCatalog("no_such_catalog");
    }

    @Test(expected=NoSuchObjectException.class)
    public void dropNoSuchCatalog() throws MetaException, NoSuchObjectException {
        this.objectStore.dropCatalog("no_such_catalog");
    }

    @Test
    public void testDatabaseOps() throws MetaException, InvalidObjectException, NoSuchObjectException {
        String catName = "tdo1_cat";
        this.createTestCatalog(catName);
        Database db1 = new Database(DB1, "description", "locationurl", null);
        Database db2 = new Database(DB2, "description", "locationurl", null);
        db1.setCatalogName(catName);
        db2.setCatalogName(catName);
        this.objectStore.createDatabase(db1);
        this.objectStore.createDatabase(db2);
        List databases = this.objectStore.getAllDatabases(catName);
        LOG.info("databases: " + databases);
        Assert.assertEquals((long)2L, (long)databases.size());
        Assert.assertEquals((Object)DB1, databases.get(0));
        Assert.assertEquals((Object)DB2, databases.get(1));
        this.objectStore.dropDatabase(catName, DB1);
        databases = this.objectStore.getAllDatabases(catName);
        Assert.assertEquals((long)1L, (long)databases.size());
        Assert.assertEquals((Object)DB2, databases.get(0));
        this.objectStore.dropDatabase(catName, DB2);
    }

    @Test
    public void testTableOps() throws MetaException, InvalidObjectException, NoSuchObjectException, InvalidInputException {
        Database db1 = new DatabaseBuilder().setName(DB1).setDescription("description").setLocation("locationurl").build(this.conf);
        this.objectStore.createDatabase(db1);
        StorageDescriptor sd1 = new StorageDescriptor((List)ImmutableList.of((Object)new FieldSchema("pk_col", "double", null)), "location", null, null, false, 0, new SerDeInfo("SerDeName", "serializationLib", null), null, null, null);
        sd1.getSerdeInfo().setDescription("this is sd1 description");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("EXTERNAL", "false");
        Table tbl1 = new Table(TABLE1, DB1, "owner", 1, 2, 3, sd1, null, params, null, null, "MANAGED_TABLE");
        this.objectStore.createTable(tbl1);
        List tables = this.objectStore.getAllTables(ENGINE, DB1);
        Assert.assertEquals((long)1L, (long)tables.size());
        Assert.assertEquals((Object)TABLE1, tables.get(0));
        StorageDescriptor sd2 = new StorageDescriptor((List)ImmutableList.of((Object)new FieldSchema("fk_col", "double", null)), "location", null, null, false, 0, new SerDeInfo("SerDeName", "serializationLib", null), null, null, null);
        sd2.getSerdeInfo().setDescription("this is sd2 description");
        Table newTbl1 = new Table("newtestobjectstoretable1", DB1, "owner", 1, 2, 3, sd2, null, params, null, null, "MANAGED_TABLE");
        newTbl1.setOwner("role1");
        newTbl1.setOwnerType(PrincipalType.ROLE);
        this.objectStore.alterTable(ENGINE, DB1, TABLE1, newTbl1, null);
        tables = this.objectStore.getTables(ENGINE, DB1, "new*");
        Assert.assertEquals((long)1L, (long)tables.size());
        Assert.assertEquals((Object)"newtestobjectstoretable1", tables.get(0));
        Table alteredTable = this.objectStore.getTable(ENGINE, DB1, "newtestobjectstoretable1");
        Assert.assertEquals((String)"Owner of table was not altered", (Object)newTbl1.getOwner(), (Object)alteredTable.getOwner());
        Assert.assertEquals((String)"Owner type of table was not altered", (Object)newTbl1.getOwnerType(), (Object)alteredTable.getOwnerType());
        Assert.assertNotEquals((String)"Serde Description was not altered", (Object)tbl1.getSd().getSerdeInfo().getDescription(), (Object)alteredTable.getSd().getSerdeInfo().getDescription());
        Assert.assertEquals((String)"Serde Description was not altered", (Object)newTbl1.getSd().getSerdeInfo().getDescription(), (Object)alteredTable.getSd().getSerdeInfo().getDescription());
        this.objectStore.createTable(tbl1);
        tables = this.objectStore.getAllTables(ENGINE, DB1);
        Assert.assertEquals((long)2L, (long)tables.size());
        List foreignKeys = this.objectStore.getForeignKeys(ENGINE, DB1, TABLE1, null, null);
        Assert.assertEquals((long)0L, (long)foreignKeys.size());
        SQLPrimaryKey pk = new SQLPrimaryKey(DB1, TABLE1, "pk_col", 1, "pk_const_1", false, false, false);
        pk.setCatName(ENGINE);
        this.objectStore.addPrimaryKeys((List)ImmutableList.of((Object)pk));
        SQLForeignKey fk = new SQLForeignKey(DB1, TABLE1, "pk_col", DB1, "newtestobjectstoretable1", "fk_col", 1, 0, 0, "fk_const_1", "pk_const_1", false, false, false);
        this.objectStore.addForeignKeys((List)ImmutableList.of((Object)fk));
        foreignKeys = this.objectStore.getForeignKeys(ENGINE, null, null, DB1, "newtestobjectstoretable1");
        Assert.assertEquals((long)1L, (long)foreignKeys.size());
        List fks = this.objectStore.getForeignKeys(ENGINE, null, null, DB1, "newtestobjectstoretable1");
        if (fks != null) {
            for (SQLForeignKey fkcol : fks) {
                this.objectStore.dropConstraint(fkcol.getCatName(), fkcol.getFktable_db(), fkcol.getFktable_name(), fkcol.getFk_name());
            }
        }
        foreignKeys = this.objectStore.getForeignKeys(ENGINE, DB1, TABLE1, null, null);
        Assert.assertEquals((long)0L, (long)foreignKeys.size());
        foreignKeys = this.objectStore.getForeignKeys(ENGINE, null, null, DB1, "newtestobjectstoretable1");
        Assert.assertEquals((long)0L, (long)foreignKeys.size());
        this.objectStore.dropTable(ENGINE, DB1, TABLE1);
        tables = this.objectStore.getAllTables(ENGINE, DB1);
        Assert.assertEquals((long)1L, (long)tables.size());
        this.objectStore.dropTable(ENGINE, DB1, "newtestobjectstoretable1");
        tables = this.objectStore.getAllTables(ENGINE, DB1);
        Assert.assertEquals((long)0L, (long)tables.size());
        this.objectStore.dropDatabase(db1.getCatalogName(), DB1);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testTableOpsWhenTableDoesNotExist() throws NoSuchObjectException, MetaException {
        List<String> colNames = Arrays.asList("c0", "c1");
        this.objectStore.getTableColumnStatistics(ENGINE, DB1, "not_existed_table", colNames, ENGINE, "");
    }

    private StorageDescriptor createFakeSd(String location) {
        return new StorageDescriptor(null, location, null, null, false, 0, new SerDeInfo("SerDeName", "serializationLib", null), null, null, null);
    }

    @Test
    public void testPartitionOps() throws Exception {
        int numPartitions;
        List partitions;
        Database db1 = new DatabaseBuilder().setName(DB1).setDescription("description").setLocation("locationurl").build(this.conf);
        try (AutoCloseable c = this.deadline();){
            this.objectStore.createDatabase(db1);
        }
        StorageDescriptor sd = this.createFakeSd("location");
        HashMap<String, String> tableParams = new HashMap<String, String>();
        tableParams.put("EXTERNAL", "false");
        FieldSchema partitionKey1 = new FieldSchema("Country", "string", "");
        FieldSchema partitionKey2 = new FieldSchema("State", "string", "");
        Table tbl1 = new Table(TABLE1, DB1, "owner", 1, 2, 3, sd, Arrays.asList(partitionKey1, partitionKey2), tableParams, null, null, "MANAGED_TABLE");
        try (AutoCloseable c = this.deadline();){
            this.objectStore.createTable(tbl1);
        }
        HashMap<String, String> partitionParams = new HashMap<String, String>();
        partitionParams.put("PARTITION_LEVEL_PRIVILEGE", "true");
        List<String> value1 = Arrays.asList("US", "CA");
        Partition part1 = new Partition(value1, DB1, TABLE1, 111, 111, sd, partitionParams);
        part1.setCatName(ENGINE);
        try (AutoCloseable c = this.deadline();){
            this.objectStore.addPartition(part1);
        }
        List<String> value2 = Arrays.asList("US", "MA");
        Partition part2 = new Partition(value2, DB1, TABLE1, 222, 222, sd, partitionParams);
        part2.setCatName(ENGINE);
        try (AutoCloseable c = this.deadline();){
            this.objectStore.addPartition(part2);
        }
        try (AutoCloseable c = this.deadline();){
            partitions = this.objectStore.getPartitions(ENGINE, DB1, TABLE1, 10);
        }
        Assert.assertEquals((long)2L, (long)partitions.size());
        Assert.assertEquals((long)111L, (long)((Partition)partitions.get(0)).getCreateTime());
        Assert.assertEquals((long)222L, (long)((Partition)partitions.get(1)).getCreateTime());
        try (AutoCloseable c = this.deadline();){
            numPartitions = this.objectStore.getNumPartitionsByFilter(ENGINE, DB1, TABLE1, "");
        }
        Assert.assertEquals((long)partitions.size(), (long)numPartitions);
        List<String> partVal = Collections.singletonList("");
        try (AutoCloseable c = this.deadline();){
            numPartitions = this.objectStore.getNumPartitionsByPs(ENGINE, DB1, TABLE1, partVal);
        }
        Assert.assertEquals((long)partitions.size(), (long)numPartitions);
        c = this.deadline();
        var16_37 = null;
        try {
            numPartitions = this.objectStore.getNumPartitionsByFilter(ENGINE, DB1, TABLE1, "country = \"US\"");
        }
        catch (Throwable throwable) {
            var16_37 = throwable;
            throw throwable;
        }
        finally {
            if (c != null) {
                if (var16_37 != null) {
                    try {
                        c.close();
                    }
                    catch (Throwable throwable) {
                        var16_37.addSuppressed(throwable);
                    }
                } else {
                    c.close();
                }
            }
        }
        Assert.assertEquals((long)2L, (long)numPartitions);
        partVal = Collections.singletonList("US");
        c = this.deadline();
        var16_37 = null;
        try {
            numPartitions = this.objectStore.getNumPartitionsByPs(ENGINE, DB1, TABLE1, partVal);
        }
        catch (Throwable throwable) {
            var16_37 = throwable;
            throw throwable;
        }
        finally {
            if (c != null) {
                if (var16_37 != null) {
                    try {
                        c.close();
                    }
                    catch (Throwable throwable) {
                        var16_37.addSuppressed(throwable);
                    }
                } else {
                    c.close();
                }
            }
        }
        Assert.assertEquals((long)2L, (long)numPartitions);
        c = this.deadline();
        var16_37 = null;
        try {
            this.objectStore.dropPartition(ENGINE, DB1, TABLE1, value1);
            partitions = this.objectStore.getPartitions(ENGINE, DB1, TABLE1, 10);
        }
        catch (Throwable throwable) {
            var16_37 = throwable;
            throw throwable;
        }
        finally {
            if (c != null) {
                if (var16_37 != null) {
                    try {
                        c.close();
                    }
                    catch (Throwable throwable) {
                        var16_37.addSuppressed(throwable);
                    }
                } else {
                    c.close();
                }
            }
        }
        Assert.assertEquals((long)1L, (long)partitions.size());
        Assert.assertEquals((long)222L, (long)((Partition)partitions.get(0)).getCreateTime());
        c = this.deadline();
        var16_37 = null;
        try {
            this.objectStore.dropPartition(ENGINE, DB1, TABLE1, value2);
            this.objectStore.dropTable(ENGINE, DB1, TABLE1);
            this.objectStore.dropDatabase(db1.getCatalogName(), DB1);
        }
        catch (Throwable throwable) {
            var16_37 = throwable;
            throw throwable;
        }
        finally {
            if (c != null) {
                if (var16_37 != null) {
                    try {
                        c.close();
                    }
                    catch (Throwable throwable) {
                        var16_37.addSuppressed(throwable);
                    }
                } else {
                    c.close();
                }
            }
        }
    }

    @Test
    public void testPartitionOpsWhenTableDoesNotExist() throws InvalidObjectException, MetaException {
        List<String> value1 = Arrays.asList("US", "CA");
        StorageDescriptor sd1 = this.createFakeSd("location1");
        HashMap<String, String> partitionParams = new HashMap<String, String>();
        partitionParams.put("PARTITION_LEVEL_PRIVILEGE", "true");
        Partition part1 = new Partition(value1, DB1, "not_existed_table", 111, 111, sd1, partitionParams);
        try {
            this.objectStore.addPartition(part1);
        }
        catch (InvalidObjectException invalidObjectException) {
            // empty catch block
        }
        try {
            this.objectStore.getPartition(ENGINE, DB1, "not_existed_table", value1);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        List<String> value2 = Arrays.asList("US", "MA");
        StorageDescriptor sd2 = this.createFakeSd("location2");
        Partition part2 = new Partition(value2, DB1, "not_existed_table", 222, 222, sd2, partitionParams);
        List<Partition> parts = Arrays.asList(part1, part2);
        try {
            this.objectStore.addPartitions(ENGINE, DB1, "not_existed_table", parts);
        }
        catch (InvalidObjectException invalidObjectException) {
            // empty catch block
        }
        PartitionSpec partitionSpec1 = new PartitionSpec(DB1, "not_existed_table", "location1");
        partitionSpec1.setPartitionList(new PartitionListComposingSpec(parts));
        PartitionSpecProxy partitionSpecProxy = PartitionSpecProxy.Factory.get(Arrays.asList(partitionSpec1));
        try {
            this.objectStore.addPartitions(ENGINE, DB1, "not_existed_table", partitionSpecProxy, true);
        }
        catch (InvalidObjectException invalidObjectException) {
            // empty catch block
        }
        List<List> part_vals = Arrays.asList(Arrays.asList("US", "GA"), Arrays.asList("US", "WA"));
        try {
            this.objectStore.alterPartitions(ENGINE, DB1, "not_existed_table", part_vals, parts, 0L, "");
        }
        catch (MetaException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof NoSuchObjectException));
        }
    }

    @Test
    public void testDropPartitionByName() throws Exception {
        List partitions;
        Database db1 = new DatabaseBuilder().setName(DB1).setDescription("description").setLocation("locationurl").build(this.conf);
        try (AutoCloseable c = this.deadline();){
            this.objectStore.createDatabase(db1);
        }
        StorageDescriptor sd = this.createFakeSd("location");
        HashMap<String, String> tableParams = new HashMap<String, String>();
        tableParams.put("EXTERNAL", "false");
        FieldSchema partitionKey1 = new FieldSchema("Country", "string", "");
        FieldSchema partitionKey2 = new FieldSchema("State", "string", "");
        Table tbl1 = new Table(TABLE1, DB1, "owner", 1, 2, 3, sd, Arrays.asList(partitionKey1, partitionKey2), tableParams, null, null, "MANAGED_TABLE");
        try (AutoCloseable c = this.deadline();){
            this.objectStore.createTable(tbl1);
        }
        HashMap<String, String> partitionParams = new HashMap<String, String>();
        partitionParams.put("PARTITION_LEVEL_PRIVILEGE", "true");
        List<String> value1 = Arrays.asList("US", "CA");
        Partition part1 = new Partition(value1, DB1, TABLE1, 111, 111, sd, partitionParams);
        part1.setCatName(ENGINE);
        try (AutoCloseable c = this.deadline();){
            this.objectStore.addPartition(part1);
        }
        List<String> value2 = Arrays.asList("US", "MA");
        Partition part2 = new Partition(value2, DB1, TABLE1, 222, 222, sd, partitionParams);
        part2.setCatName(ENGINE);
        try (AutoCloseable c = this.deadline();){
            this.objectStore.addPartition(part2);
        }
        try (AutoCloseable c = this.deadline();){
            this.objectStore.dropPartition(ENGINE, DB1, TABLE1, "country=US/state=CA");
            partitions = this.objectStore.getPartitions(ENGINE, DB1, TABLE1, 10);
        }
        Assert.assertEquals((long)1L, (long)partitions.size());
        Assert.assertEquals((long)222L, (long)((Partition)partitions.get(0)).getCreateTime());
        c = this.deadline();
        var14_28 = null;
        try {
            this.objectStore.dropPartition(ENGINE, DB1, TABLE1, "country=US/state=MA");
            partitions = this.objectStore.getPartitions(ENGINE, DB1, TABLE1, 10);
        }
        catch (Throwable throwable) {
            var14_28 = throwable;
            throw throwable;
        }
        finally {
            if (c != null) {
                if (var14_28 != null) {
                    try {
                        c.close();
                    }
                    catch (Throwable throwable) {
                        var14_28.addSuppressed(throwable);
                    }
                } else {
                    c.close();
                }
            }
        }
        Assert.assertEquals((long)0L, (long)partitions.size());
        c = this.deadline();
        var14_28 = null;
        try {
            this.objectStore.dropPartition(ENGINE, DB1, TABLE1, "country=US/state=NON_EXIST");
            this.objectStore.dropPartition(ENGINE, DB1, TABLE1, "country=US/st=CA");
        }
        catch (Throwable throwable) {
            var14_28 = throwable;
            throw throwable;
        }
        finally {
            if (c != null) {
                if (var14_28 != null) {
                    try {
                        c.close();
                    }
                    catch (Throwable throwable) {
                        var14_28.addSuppressed(throwable);
                    }
                } else {
                    c.close();
                }
            }
        }
        c = this.deadline();
        var14_28 = null;
        try {
            this.objectStore.dropTable(ENGINE, DB1, TABLE1);
            this.objectStore.dropDatabase(db1.getCatalogName(), DB1);
        }
        catch (Throwable throwable) {
            var14_28 = throwable;
            throw throwable;
        }
        finally {
            if (c != null) {
                if (var14_28 != null) {
                    try {
                        c.close();
                    }
                    catch (Throwable throwable) {
                        var14_28.addSuppressed(throwable);
                    }
                } else {
                    c.close();
                }
            }
        }
    }

    @Test
    public void testConcurrentDropPartitions() throws MetaException, InvalidObjectException {
        Database db1 = new DatabaseBuilder().setName(DB1).setDescription("description").setLocation("locationurl").build(this.conf);
        this.objectStore.createDatabase(db1);
        StorageDescriptor sd = this.createFakeSd("location");
        HashMap<String, String> tableParams = new HashMap<String, String>();
        tableParams.put("EXTERNAL", "false");
        FieldSchema partitionKey1 = new FieldSchema("Country", "string", "");
        FieldSchema partitionKey2 = new FieldSchema("State", "string", "");
        Table tbl1 = new Table(TABLE1, DB1, "owner", 1, 2, 3, sd, Arrays.asList(partitionKey1, partitionKey2), tableParams, null, null, "MANAGED_TABLE");
        this.objectStore.createTable(tbl1);
        HashMap<String, String> partitionParams = new HashMap<String, String>();
        partitionParams.put("PARTITION_LEVEL_PRIVILEGE", "true");
        LinkedList<List<String>> partNames = new LinkedList<List<String>>();
        for (char c = 'A'; c < 'Z'; c = (char)(c + '\u0001')) {
            String string = "" + c;
            partNames.add(Arrays.asList(string, string));
        }
        for (List list : partNames) {
            Partition p = new Partition(list, DB1, TABLE1, 111, 111, sd, partitionParams);
            p.setCatName(ENGINE);
            this.objectStore.addPartition(p);
        }
        int numThreads = 2;
        ExecutorService executorService = Executors.newFixedThreadPool(numThreads);
        for (int i = 0; i < numThreads; ++i) {
            executorService.execute(() -> {
                ObjectStore threadObjectStore = new ObjectStore();
                threadObjectStore.setConf(this.conf);
                for (List p : partNames) {
                    try {
                        threadObjectStore.dropPartition(ENGINE, DB1, TABLE1, p);
                        System.out.println("Dropping partition: " + (String)p.get(0));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        executorService.shutdown();
        try {
            executorService.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            Assert.assertTrue((String)"Got interrupted.", (boolean)false);
        }
        Assert.assertTrue((String)"Expect no active transactions.", (!this.objectStore.isActiveTransaction() ? 1 : 0) != 0);
    }

    @Test
    public void testDirectSQLDropPartitionsCacheInSession() throws Exception {
        List partitions;
        this.createPartitionedTable(false, false);
        try (AutoCloseable c = this.deadline();){
            partitions = this.objectStore.getPartitionsInternal(ENGINE, DB1, TABLE1, 10, false, true);
        }
        Assert.assertEquals((long)3L, (long)partitions.size());
        c = this.deadline();
        var3_2 = null;
        try {
            this.objectStore.dropPartitionsInternal(ENGINE, DB1, TABLE1, Arrays.asList("test_part_col=a0", "test_part_col=a1"), true, false);
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (c != null) {
                if (var3_2 != null) {
                    try {
                        c.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    c.close();
                }
            }
        }
        c = this.deadline();
        var3_2 = null;
        try {
            partitions = this.objectStore.getPartitionsInternal(ENGINE, DB1, TABLE1, 10, false, true);
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (c != null) {
                if (var3_2 != null) {
                    try {
                        c.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    c.close();
                }
            }
        }
        Assert.assertEquals((long)1L, (long)partitions.size());
    }

    @Test
    public void testDirectSQLDropPartitionsCacheCrossSession() throws Exception {
        List partitions;
        ObjectStore objectStore2 = new ObjectStore();
        objectStore2.setConf(this.conf);
        this.createPartitionedTable(false, false);
        try (AutoCloseable c = this.deadline();){
            partitions = this.objectStore.getPartitionsInternal(ENGINE, DB1, TABLE1, 10, false, true);
        }
        Assert.assertEquals((long)3L, (long)partitions.size());
        c = this.deadline();
        var4_3 = null;
        try {
            partitions = objectStore2.getPartitionsInternal(ENGINE, DB1, TABLE1, 10, false, true);
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (c != null) {
                if (var4_3 != null) {
                    try {
                        c.close();
                    }
                    catch (Throwable throwable) {
                        var4_3.addSuppressed(throwable);
                    }
                } else {
                    c.close();
                }
            }
        }
        Assert.assertEquals((long)3L, (long)partitions.size());
        c = this.deadline();
        var4_3 = null;
        try {
            this.objectStore.dropPartitionsInternal(ENGINE, DB1, TABLE1, Arrays.asList("test_part_col=a0", "test_part_col=a1"), true, false);
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (c != null) {
                if (var4_3 != null) {
                    try {
                        c.close();
                    }
                    catch (Throwable throwable) {
                        var4_3.addSuppressed(throwable);
                    }
                } else {
                    c.close();
                }
            }
        }
        c = this.deadline();
        var4_3 = null;
        try {
            partitions = objectStore2.getPartitionsInternal(ENGINE, DB1, TABLE1, 10, false, true);
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (c != null) {
                if (var4_3 != null) {
                    try {
                        c.close();
                    }
                    catch (Throwable throwable) {
                        var4_3.addSuppressed(throwable);
                    }
                } else {
                    c.close();
                }
            }
        }
        Assert.assertEquals((long)1L, (long)partitions.size());
    }

    @Test
    public void testDirectSQLDropPartitionsCleanup() throws Exception {
        this.createPartitionedTable(true, true);
        this.checkBackendTableSize("PARTITIONS", 3);
        this.checkBackendTableSize("PART_PRIVS", 3);
        this.checkBackendTableSize("PART_COL_PRIVS", 3);
        this.checkBackendTableSize("PART_COL_STATS", 3);
        this.checkBackendTableSize("PARTITION_PARAMS", 3);
        this.checkBackendTableSize("PARTITION_KEY_VALS", 3);
        this.checkBackendTableSize("SD_PARAMS", 3);
        this.checkBackendTableSize("BUCKETING_COLS", 3);
        this.checkBackendTableSize("SKEWED_COL_NAMES", 3);
        this.checkBackendTableSize("SDS", 4);
        this.checkBackendTableSize("SORT_COLS", 3);
        this.checkBackendTableSize("SERDE_PARAMS", 3);
        this.checkBackendTableSize("SERDES", 4);
        try (AutoCloseable c = this.deadline();){
            this.objectStore.dropPartitionsInternal(ENGINE, DB1, TABLE1, Arrays.asList("test_part_col=a0", "test_part_col=a1", "test_part_col=a2"), true, false);
        }
        this.checkBackendTableSize("PARTITIONS", 0);
        this.checkBackendTableSize("PART_PRIVS", 0);
        this.checkBackendTableSize("PART_COL_PRIVS", 0);
        this.checkBackendTableSize("PART_COL_STATS", 0);
        this.checkBackendTableSize("PARTITION_PARAMS", 0);
        this.checkBackendTableSize("PARTITION_KEY_VALS", 0);
        this.checkBackendTableSize("SD_PARAMS", 0);
        this.checkBackendTableSize("BUCKETING_COLS", 0);
        this.checkBackendTableSize("SKEWED_COL_NAMES", 0);
        this.checkBackendTableSize("SDS", 1);
        this.checkBackendTableSize("SORT_COLS", 0);
        this.checkBackendTableSize("SERDE_PARAMS", 0);
        this.checkBackendTableSize("SERDES", 1);
    }

    @Test
    public void testDirectSQLCDsCleanup() throws Exception {
        this.createPartitionedTable(true, true);
        this.checkBackendTableSize("PARTITIONS", 3);
        this.checkBackendTableSize("CDS", 1);
        this.checkBackendTableSize("COLUMNS_V2", 5);
        List<String> partVals = Arrays.asList("a0");
        try (AutoCloseable c = this.deadline();){
            Partition part = this.objectStore.getPartition(ENGINE, DB1, TABLE1, partVals);
            StorageDescriptor newSd = part.getSd().deepCopy();
            newSd.addToCols(new FieldSchema("test_add_col", "int", null));
            Partition newPart = part.deepCopy();
            newPart.setSd(newSd);
            this.objectStore.alterPartition(ENGINE, DB1, TABLE1, partVals, newPart, null);
        }
        this.checkBackendTableSize("PARTITIONS", 3);
        this.checkBackendTableSize("CDS", 2);
        this.checkBackendTableSize("COLUMNS_V2", 11);
        c = this.deadline();
        var3_3 = null;
        try {
            this.objectStore.dropPartitionsInternal(ENGINE, DB1, TABLE1, Arrays.asList("test_part_col=a0", "test_part_col=a1", "test_part_col=a2"), true, false);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (c != null) {
                if (var3_3 != null) {
                    try {
                        c.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    c.close();
                }
            }
        }
        this.checkBackendTableSize("PARTITIONS", 0);
        this.checkBackendTableSize("CDS", 1);
        this.checkBackendTableSize("COLUMNS_V2", 5);
    }

    @Test
    public void testGetPartitionStatistics() throws Exception {
        List stat;
        this.createPartitionedTable(true, true);
        try (AutoCloseable c = this.deadline();){
            stat = this.objectStore.getPartitionColumnStatistics(ENGINE, DB1, TABLE1, Arrays.asList("test_part_col=a0", "test_part_col=a1", "test_part_col=a2"), Collections.singletonList("test_part_col"));
        }
        Assert.assertEquals((long)1L, (long)stat.size());
        Assert.assertEquals((long)3L, (long)((List)stat.get(0)).size());
        Assert.assertEquals((Object)ENGINE, (Object)((ColumnStatistics)((List)stat.get(0)).get(0)).getEngine());
        Assert.assertEquals((long)1L, (long)((ColumnStatistics)((List)stat.get(0)).get(0)).getStatsObj().size());
        ColumnStatisticsData computedStats = ((ColumnStatisticsObj)((ColumnStatistics)((List)stat.get(0)).get(0)).getStatsObj().get(0)).getStatsData();
        ColumnStatisticsData expectedStats = new ColStatsBuilder<Long>(Long.TYPE).numNulls(1L).numDVs(2L).low(3L).high(4L).hll(3L, 4L).kll(3L, 4L).build();
        StatisticsTestUtils.assertEqualStatistics(expectedStats, computedStats);
    }

    private void createPartitionedTable(boolean withPrivileges, boolean withStatistics) throws Exception {
        Database db1 = new DatabaseBuilder().setName(DB1).setDescription("description").setLocation("locationurl").build(this.conf);
        try (AutoCloseable c = this.deadline();){
            this.objectStore.createDatabase(db1);
        }
        Table tbl1 = ((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)new TableBuilder().setDbName(DB1).setTableName(TABLE1).addCol("test_col1", "int")).addCol("test_col2", "int")).addPartCol("test_part_col", "int").addCol("test_bucket_col", "int", "test bucket col comment")).addCol("test_skewed_col", "int", "test skewed col comment")).addCol("test_sort_col", "int", "test sort col comment")).build(this.conf);
        try (AutoCloseable c = this.deadline();){
            this.objectStore.createTable(tbl1);
        }
        MTable mTable1 = this.objectStore.ensureGetMTable(tbl1.getCatName(), tbl1.getDbName(), tbl1.getTableName());
        PrivilegeBag privilegeBag = new PrivilegeBag();
        for (int i = 0; i < 3; ++i) {
            Partition part = ((PartitionBuilder)((PartitionBuilder)((PartitionBuilder)((PartitionBuilder)((PartitionBuilder)new PartitionBuilder().inTable(tbl1).addValue("a" + i).addSerdeParam("serdeParam", "serdeParamValue")).addStorageDescriptorParam("sdParam", "sdParamValue")).addBucketCol("test_bucket_col")).addSkewedColName("test_skewed_col")).addSortCol("test_sort_col", 1)).build(this.conf);
            try (AutoCloseable c = this.deadline();){
                this.objectStore.addPartition(part);
            }
            if (withPrivileges) {
                HiveObjectRef partitionReference = new HiveObjectRefBuilder().buildPartitionReference(part);
                HiveObjectRef partitionColumnReference = new HiveObjectRefBuilder().buildPartitionColumnReference(tbl1, "test_part_col", part.getValues());
                PrivilegeGrantInfo privilegeGrantInfo = new PrivilegeGrantInfoBuilder().setPrivilege("a").build();
                HiveObjectPrivilege partitionPriv = new HiveObjectPrivilegeBuilder().setHiveObjectRef(partitionReference).setPrincipleName("a").setPrincipalType(PrincipalType.USER).setGrantInfo(privilegeGrantInfo).build();
                privilegeBag.addToPrivileges(partitionPriv);
                HiveObjectPrivilege partitionColPriv = new HiveObjectPrivilegeBuilder().setHiveObjectRef(partitionColumnReference).setPrincipleName("a").setPrincipalType(PrincipalType.USER).setGrantInfo(privilegeGrantInfo).build();
                privilegeBag.addToPrivileges(partitionColPriv);
            }
            if (!withStatistics) continue;
            ColumnStatistics stats = new ColumnStatistics();
            ColumnStatisticsDesc desc = new ColumnStatisticsDesc();
            desc.setCatName(tbl1.getCatName());
            desc.setDbName(tbl1.getDbName());
            desc.setTableName(tbl1.getTableName());
            desc.setPartName("test_part_col=a" + i);
            stats.setStatsDesc(desc);
            ArrayList<ColumnStatisticsObj> statsObjList = new ArrayList<ColumnStatisticsObj>(1);
            stats.setStatsObj(statsObjList);
            stats.setEngine(ENGINE);
            ColumnStatisticsData data = new ColStatsBuilder<Long>(Long.TYPE).numNulls(1L).numDVs(2L).low(3L).high(4L).hll(3L, 4L).kll(3L, 4L).build();
            ColumnStatisticsObj partStats = new ColumnStatisticsObj("test_part_col", "int", data);
            statsObjList.add(partStats);
            try (AutoCloseable c = this.deadline();){
                this.objectStore.updatePartitionColumnStatistics(tbl1, mTable1, stats, part.getValues(), null, -1L);
                continue;
            }
        }
        if (withPrivileges) {
            try (AutoCloseable c = this.deadline();){
                this.objectStore.grantPrivileges(privilegeBag);
            }
        }
    }

    private void checkBackendTableSize(String tableName, int size) throws SQLException {
        String connectionStr = MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECT_URL_KEY);
        Connection conn = DriverManager.getConnection(connectionStr);
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT COUNT(1) FROM " + tableName);
        rs.next();
        Assert.assertEquals((String)(tableName + " table should contain " + size + " rows"), (long)size, (long)rs.getLong(1));
    }

    @Test
    public void testMasterKeyOps() throws MetaException, NoSuchObjectException {
        int id1 = this.objectStore.addMasterKey(KEY1);
        int id2 = this.objectStore.addMasterKey(KEY2);
        String[] keys = this.objectStore.getMasterKeys();
        Assert.assertEquals((long)2L, (long)keys.length);
        Assert.assertEquals((Object)KEY1, (Object)keys[0]);
        Assert.assertEquals((Object)KEY2, (Object)keys[1]);
        this.objectStore.updateMasterKey(Integer.valueOf(id1), "newtestobjectstorekey1");
        this.objectStore.updateMasterKey(Integer.valueOf(id2), "newtestobjectstorekey2");
        keys = this.objectStore.getMasterKeys();
        Assert.assertEquals((long)2L, (long)keys.length);
        Assert.assertEquals((Object)"newtestobjectstorekey1", (Object)keys[0]);
        Assert.assertEquals((Object)"newtestobjectstorekey2", (Object)keys[1]);
        this.objectStore.removeMasterKey(Integer.valueOf(id1));
        keys = this.objectStore.getMasterKeys();
        Assert.assertEquals((long)1L, (long)keys.length);
        Assert.assertEquals((Object)"newtestobjectstorekey2", (Object)keys[0]);
        this.objectStore.removeMasterKey(Integer.valueOf(id2));
    }

    @Test
    public void testRoleOps() throws InvalidObjectException, MetaException, NoSuchObjectException {
        this.objectStore.addRole(ROLE1, OWNER);
        this.objectStore.addRole(ROLE2, OWNER);
        List roles = this.objectStore.listRoleNames();
        Assert.assertEquals((long)2L, (long)roles.size());
        Assert.assertEquals((Object)ROLE2, roles.get(1));
        Role role1 = this.objectStore.getRole(ROLE1);
        Assert.assertEquals((Object)OWNER, (Object)role1.getOwnerName());
        this.objectStore.grantRole(role1, USER1, PrincipalType.USER, OWNER, PrincipalType.ROLE, true);
        this.objectStore.revokeRole(role1, USER1, PrincipalType.USER, false);
        this.objectStore.removeRole(ROLE1);
    }

    @Test
    public void testDirectSqlErrorMetrics() throws Exception {
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METRICS_ENABLED, (boolean)true);
        Metrics.initialize((Configuration)conf);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_CODAHALE_METRICS_REPORTER_CLASSES, (String)"org.apache.hadoop.hive.common.metrics.metrics2.JsonFileMetricsReporter, org.apache.hadoop.hive.common.metrics.metrics2.JmxMetricsReporter");
        this.setUp();
        Counter directSqlErrors = (Counter)Metrics.getRegistry().getCounters().get("directsql_errors");
        ObjectStore objectStore = this.objectStore;
        objectStore.getClass();
        new ObjectStore.GetDbHelper(objectStore, ENGINE, "foo", true, true){
            {
                ObjectStore objectStore = x0;
                objectStore.getClass();
                super(objectStore, x1, x2, x3, x4);
            }

            protected Database getSqlResult(ObjectStore.GetHelper<Database> ctx) throws MetaException {
                return null;
            }

            protected Database getJdoResult(ObjectStore.GetHelper<Database> ctx) throws MetaException, NoSuchObjectException {
                return null;
            }
        }.run(false);
        Assert.assertEquals((long)0L, (long)directSqlErrors.getCount());
        ObjectStore objectStore2 = this.objectStore;
        objectStore2.getClass();
        new ObjectStore.GetDbHelper(objectStore2, ENGINE, "foo", true, true){
            {
                ObjectStore objectStore = x0;
                objectStore.getClass();
                super(objectStore, x1, x2, x3, x4);
            }

            protected Database getSqlResult(ObjectStore.GetHelper<Database> ctx) throws MetaException {
                throw new RuntimeException();
            }

            protected Database getJdoResult(ObjectStore.GetHelper<Database> ctx) throws MetaException, NoSuchObjectException {
                return null;
            }
        }.run(false);
        Assert.assertEquals((long)1L, (long)directSqlErrors.getCount());
    }

    @Deprecated
    private static void dropAllStoreObjects(RawStore store) throws MetaException, InvalidObjectException, InvalidInputException {
        try {
            List functions = store.getAllFunctions(ENGINE);
            for (Function func : functions) {
                store.dropFunction(ENGINE, func.getDbName(), func.getFunctionName());
            }
            for (String catName : store.getCatalogs()) {
                List dbs = store.getAllDatabases(catName);
                for (String db : dbs) {
                    List tbls = store.getAllTables(ENGINE, db);
                    for (String tbl : tbls) {
                        List fks;
                        List parts = store.getPartitions(ENGINE, db, tbl, 100);
                        for (Partition part : parts) {
                            store.dropPartition(ENGINE, db, tbl, part.getValues());
                        }
                        HashSet<String> constraints = new HashSet<String>();
                        List pk = store.getPrimaryKeys(ENGINE, db, tbl);
                        if (pk != null) {
                            for (SQLPrimaryKey pkcol : pk) {
                                constraints.add(pkcol.getPk_name());
                            }
                        }
                        if ((fks = store.getForeignKeys(ENGINE, null, null, db, tbl)) != null) {
                            for (SQLForeignKey fkcol : fks) {
                                constraints.add(fkcol.getFk_name());
                            }
                        }
                        for (String constraint : constraints) {
                            store.dropConstraint(ENGINE, db, tbl, constraint);
                        }
                        store.dropTable(ENGINE, db, tbl);
                    }
                    store.dropDatabase(catName, db);
                }
                store.dropCatalog(catName);
            }
            List roles = store.listRoleNames();
            for (String role : roles) {
                store.removeRole(role);
            }
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryCloseOnError() throws Exception {
        ObjectStore spy = (ObjectStore)Mockito.spy((Object)this.objectStore);
        spy.getAllDatabases(ENGINE);
        spy.getAllFunctions(ENGINE);
        spy.getAllTables(ENGINE, DB1);
        spy.getPartitionCount();
        ((ObjectStore)Mockito.verify((Object)spy, (VerificationMode)Mockito.times((int)3))).rollbackAndCleanup(Mockito.anyBoolean(), (Query)Mockito.anyObject());
    }

    @Test
    public void testRetryingExecutorSleep() throws Exception {
        ObjectStore.RetryingExecutor re = new ObjectStore.RetryingExecutor(MetastoreConf.newMetastoreConf(), null);
        Assert.assertTrue((String)"invalid sleep value", (re.getSleepInterval() >= 0L ? 1 : 0) != 0);
    }

    @Ignore
    @Test
    public void testNonConfDatanucleusValueSet() {
        String key = "datanucleus.no.such.key";
        String value = "test_value";
        String key1 = "blabla.no.such.key";
        String value1 = "another_value";
        Assume.assumeTrue((System.getProperty(key) == null ? 1 : 0) != 0);
        Configuration localConf = MetastoreConf.newMetastoreConf();
        MetaStoreTestUtils.setConfForStandloneMode(localConf);
        localConf.set(key, value);
        localConf.set(key1, value1);
        this.objectStore = new ObjectStore();
        this.objectStore.setConf(localConf);
        Assert.assertEquals((Object)value, (Object)PersistenceManagerProvider.getProperty((String)key));
        Assert.assertNull((Object)PersistenceManagerProvider.getProperty((String)key1));
    }

    @Test
    public void testNotificationOps() throws InterruptedException, MetaException {
        boolean NO_EVENT_ID = false;
        boolean FIRST_EVENT_ID = true;
        int SECOND_EVENT_ID = 2;
        NotificationEvent event = new NotificationEvent(0L, 0, EventMessage.EventType.CREATE_DATABASE.toString(), "");
        CurrentNotificationEventId eventId = this.objectStore.getCurrentNotificationEventId();
        Assert.assertEquals((long)0L, (long)eventId.getEventId());
        this.objectStore.addNotificationEvent(event);
        Assert.assertEquals((long)1L, (long)event.getEventId());
        this.objectStore.addNotificationEvent(event);
        Assert.assertEquals((long)2L, (long)event.getEventId());
        eventId = this.objectStore.getCurrentNotificationEventId();
        Assert.assertEquals((long)2L, (long)eventId.getEventId());
        NotificationEventResponse eventResponse = this.objectStore.getNextNotification(new NotificationEventRequest());
        Assert.assertEquals((long)2L, (long)eventResponse.getEventsSize());
        Assert.assertEquals((long)1L, (long)((NotificationEvent)eventResponse.getEvents().get(0)).getEventId());
        Assert.assertEquals((long)2L, (long)((NotificationEvent)eventResponse.getEvents().get(1)).getEventId());
        eventResponse = this.objectStore.getNextNotification(new NotificationEventRequest(1L));
        Assert.assertEquals((long)1L, (long)eventResponse.getEventsSize());
        Assert.assertEquals((long)2L, (long)((NotificationEvent)eventResponse.getEvents().get(0)).getEventId());
        eventResponse = this.objectStore.getNextNotification(new NotificationEventRequest(2L));
        Assert.assertEquals((long)0L, (long)eventResponse.getEventsSize());
        this.objectStore.cleanNotificationEvents(0);
        eventResponse = this.objectStore.getNextNotification(new NotificationEventRequest());
        Assert.assertEquals((long)0L, (long)eventResponse.getEventsSize());
    }

    @Test
    public void testMaxEventResponse() throws InterruptedException, MetaException {
        NotificationEvent event = new NotificationEvent(0L, 0, EventMessage.EventType.CREATE_DATABASE.toString(), "");
        MetastoreConf.setLongVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_MAX_EVENT_RESPONSE, (long)1L);
        ObjectStore objs = new ObjectStore();
        objs.setConf(this.conf);
        for (int i = 0; i < 3; ++i) {
            objs.addNotificationEvent(event);
        }
        NotificationEventResponse eventResponse = objs.getNextNotification(new NotificationEventRequest());
        Assert.assertEquals((long)1L, (long)eventResponse.getEventsSize());
    }

    @Ignore(value="This test is here to allow testing with other databases like mysql / postgres etc\n with  user changes to the code. This cannot be run on apache derby because of\n https://db.apache.org/derby/docs/10.10/devguide/cdevconcepts842385.html")
    @Test
    public void testConcurrentAddNotifications() throws ExecutionException, InterruptedException, MetaException {
        int NUM_THREADS = 10;
        CyclicBarrier cyclicBarrier = new CyclicBarrier(10, () -> LoggerFactory.getLogger((String)"test").debug("10 threads going to add notification"));
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        this.objectStore.getPersistenceManager().newQuery(MNotificationLog.class, "eventType==''").execute();
        this.objectStore.getPersistenceManager().newQuery(MNotificationNextId.class, "nextEventId==-1").execute();
        this.objectStore.addNotificationEvent(new NotificationEvent(0L, 0, EventMessage.EventType.CREATE_DATABASE.toString(), "CREATE DATABASE DB initial"));
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        int i = 0;
        while (i < 10) {
            int n = i++;
            executorService.execute(() -> {
                ObjectStore store = new ObjectStore();
                store.setConf(conf);
                String eventType = EventMessage.EventType.CREATE_DATABASE.toString();
                NotificationEvent dbEvent = new NotificationEvent(0L, 0, eventType, "CREATE DATABASE DB" + n);
                System.out.println("ADDING NOTIFICATION");
                try {
                    cyclicBarrier.await();
                    store.addNotificationEvent(dbEvent);
                }
                catch (InterruptedException | BrokenBarrierException | MetaException e) {
                    throw new RuntimeException(e);
                }
                System.out.println("FINISH NOTIFICATION");
            });
        }
        executorService.shutdown();
        Assert.assertTrue((boolean)executorService.awaitTermination(15L, TimeUnit.SECONDS));
        ObjectStore store = new ObjectStore();
        store.setConf(conf);
        NotificationEventResponse eventResponse = store.getNextNotification(new NotificationEventRequest());
        Assert.assertEquals((long)11L, (long)eventResponse.getEventsSize());
        long previousId = 0L;
        for (NotificationEvent event : eventResponse.getEvents()) {
            Assert.assertTrue((String)("previous:" + previousId + " current:" + event.getEventId()), (previousId < event.getEventId() ? 1 : 0) != 0);
            Assert.assertTrue((previousId + 1L == event.getEventId() ? 1 : 0) != 0);
            previousId = event.getEventId();
        }
    }

    @Test
    public void testConcurrentPMFInitialize() throws Exception {
        String dataSourceProp = "datanucleus.connectionPool.maxPoolSize";
        int numThreads = 10;
        int numIteration = 50;
        final CyclicBarrier barrier = new CyclicBarrier(10);
        final AtomicInteger counter = new AtomicInteger(0);
        ExecutorService executor = Executors.newFixedThreadPool(10);
        ArrayList<Future<Void>> results = new ArrayList<Future<Void>>(10);
        for (int i = 0; i < 10; ++i) {
            final Random random = new Random();
            final Configuration conf = MetastoreConf.newMetastoreConf();
            conf.set("datanucleus.connectionPool.maxPoolSize", Integer.toString(20));
            MetaStoreTestUtils.setConfForStandloneMode(conf);
            results.add(executor.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ObjectStore objectStore = new ObjectStore();
                    barrier.await();
                    for (int j = 0; j < 50; ++j) {
                        int randomNumber = random.nextInt(100);
                        if (randomNumber % 2 == 0) {
                            objectStore.setConf(conf);
                        } else {
                            Assert.assertNotNull((Object)objectStore.getPersistenceManager());
                        }
                        counter.getAndIncrement();
                    }
                    return null;
                }
            }));
        }
        for (Future future : results) {
            future.get(120L, TimeUnit.SECONDS);
        }
        Assert.assertEquals((String)"Unexpected number of setConf calls", (long)500L, (long)counter.get());
    }

    @Test
    public void testSSLPropertiesAreSet() {
        this.setAndCheckSSLProperties(true, "/tmp/truststore.p12", "password", "pkcs12");
    }

    @Test
    public void testUseSSLProperty() {
        this.setAndCheckSSLProperties(false, "/tmp/truststore.jks", "password", "jks");
    }

    @Test
    public void testDeprecatedConfigIsOverwritten() {
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DBACCESS_SSL_PROPS, (String)"javax.net.ssl.trustStore=/tmp/truststore.p12,javax.net.ssl.trustStorePassword=pwd,javax.net.ssl.trustStoreType=pkcs12");
        this.setAndCheckSSLProperties(true, "/tmp/truststore.jks", "password", "jks");
    }

    @Test
    public void testEmptyTrustStoreProps() {
        this.setAndCheckSSLProperties(true, "", "", "jks");
    }

    @Test
    public void testGetPrimaryKeys() throws Exception {
        Database db1 = new DatabaseBuilder().setName(DB1).setDescription("description").setLocation("locationurl").build(this.conf);
        this.objectStore.createDatabase(db1);
        StorageDescriptor sd1 = new StorageDescriptor((List)ImmutableList.of((Object)new FieldSchema("pk_col", "double", null)), "location", null, null, false, 0, new SerDeInfo("SerDeName", "serializationLib", null), null, null, null);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("EXTERNAL", "false");
        Table tbl1 = new Table(TABLE1, DB1, "owner", 1, 2, 3, sd1, null, params, null, null, "MANAGED_TABLE");
        this.objectStore.createTable(tbl1);
        SQLPrimaryKey pk = new SQLPrimaryKey(DB1, TABLE1, "pk_col", 1, "pk_const_1", false, false, false);
        pk.setCatName(ENGINE);
        this.objectStore.addPrimaryKeys((List)ImmutableList.of((Object)pk));
        Assert.assertEquals((Object)"pk_col", (Object)((SQLPrimaryKey)this.objectStore.getPrimaryKeys(ENGINE, null, TABLE1).get(0)).getColumn_name());
        this.objectStore.dropTable(ENGINE, DB1, TABLE1);
        this.objectStore.dropDatabase(db1.getCatalogName(), DB1);
    }

    private void setAndCheckSSLProperties(boolean useSSL, String trustStorePath, String trustStorePassword, String trustStoreType) {
        MetastoreConf.setBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DBACCESS_USE_SSL, (boolean)useSSL);
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DBACCESS_SSL_TRUSTSTORE_PATH, (String)trustStorePath);
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DBACCESS_SSL_TRUSTSTORE_PASSWORD, (String)trustStorePassword);
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DBACCESS_SSL_TRUSTSTORE_TYPE, (String)trustStoreType);
        this.objectStore.setConf(this.conf);
        this.checkSSLProperty(useSSL, "javax.net.ssl.trustStore", trustStorePath);
        this.checkSSLProperty(useSSL, "javax.net.ssl.trustStorePassword", trustStorePassword);
        this.checkSSLProperty(useSSL, "javax.net.ssl.trustStoreType", trustStoreType);
    }

    @Test
    public void testUpdateStoredProc() throws Exception {
        this.objectStore.createDatabase(new DatabaseBuilder().setName(DB1).setDescription("description").setLocation("locationurl").build(this.conf));
        StoredProcedure input = new StoredProcedure();
        input.setCatName(ENGINE);
        input.setSource("print 'Hello world'");
        input.setOwnerName("user1");
        input.setName("toBeUpdated");
        input.setDbName(DB1);
        this.objectStore.createOrUpdateStoredProcedure(input);
        input.setSource("print 'Hello world2'");
        this.objectStore.createOrUpdateStoredProcedure(input);
        StoredProcedure retrieved = this.objectStore.getStoredProcedure(ENGINE, DB1, "toBeUpdated");
        Assert.assertEquals((Object)input, (Object)retrieved);
    }

    @Test
    public void testStoredProcSaveAndRetrieve() throws Exception {
        this.objectStore.createDatabase(new DatabaseBuilder().setName(DB1).setDescription("description").setLocation("locationurl").build(this.conf));
        StoredProcedure input = new StoredProcedure();
        input.setSource("print 'Hello world'");
        input.setCatName(ENGINE);
        input.setOwnerName("user1");
        input.setName("greetings");
        input.setDbName(DB1);
        this.objectStore.createOrUpdateStoredProcedure(input);
        StoredProcedure retrieved = this.objectStore.getStoredProcedure(ENGINE, DB1, "greetings");
        Assert.assertEquals((Object)input, (Object)retrieved);
    }

    @Test
    public void testDropStoredProc() throws Exception {
        this.objectStore.createDatabase(new DatabaseBuilder().setName(DB1).setDescription("description").setLocation("locationurl").build(this.conf));
        StoredProcedure toBeDeleted = new StoredProcedure();
        toBeDeleted.setSource("print 'Hello world'");
        toBeDeleted.setCatName(ENGINE);
        toBeDeleted.setOwnerName("user1");
        toBeDeleted.setName("greetings");
        toBeDeleted.setDbName(DB1);
        this.objectStore.createOrUpdateStoredProcedure(toBeDeleted);
        Assert.assertNotNull((Object)this.objectStore.getStoredProcedure(ENGINE, DB1, "greetings"));
        this.objectStore.dropStoredProcedure(ENGINE, DB1, "greetings");
        Assert.assertNull((Object)this.objectStore.getStoredProcedure(ENGINE, DB1, "greetings"));
    }

    @Test
    public void testListStoredProc() throws Exception {
        this.objectStore.createDatabase(new DatabaseBuilder().setName(DB1).setDescription("description").setLocation("locationurl").build(this.conf));
        this.objectStore.createDatabase(new DatabaseBuilder().setName(DB2).setDescription("description").setLocation("locationurl").build(this.conf));
        StoredProcedure proc1 = new StoredProcedure();
        proc1.setSource("print 'Hello world'");
        proc1.setCatName(ENGINE);
        proc1.setOwnerName("user1");
        proc1.setName("proc1");
        proc1.setDbName(DB1);
        this.objectStore.createOrUpdateStoredProcedure(proc1);
        StoredProcedure proc2 = new StoredProcedure();
        proc2.setSource("print 'Hello world'");
        proc2.setCatName(ENGINE);
        proc2.setOwnerName("user2");
        proc2.setName("proc2");
        proc2.setDbName(DB2);
        this.objectStore.createOrUpdateStoredProcedure(proc2);
        List result = this.objectStore.getAllStoredProcedures(new ListStoredProcedureRequest(ENGINE));
        Assert.assertEquals((long)2L, (long)result.size());
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"proc1", "proc2"}));
        ListStoredProcedureRequest req = new ListStoredProcedureRequest(ENGINE);
        req.setDbName(DB1);
        result = this.objectStore.getAllStoredProcedures(req);
        Assert.assertEquals((long)1L, (long)result.size());
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"proc1"}));
    }

    @Test
    public void testUpdateCreationMetadataSetsMaterializationTime() throws Exception {
        Database db1 = new DatabaseBuilder().setName(DB1).setDescription("description").setLocation("locationurl").build(this.conf);
        this.objectStore.createDatabase(db1);
        StorageDescriptor sd1 = new StorageDescriptor((List)ImmutableList.of((Object)new FieldSchema("pk_col", "double", null)), "location", null, null, false, 0, new SerDeInfo("SerDeName", "serializationLib", null), null, null, null);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("EXTERNAL", "false");
        Table tbl1 = new Table(TABLE1, DB1, "owner", 1, 2, 3, sd1, null, params, null, null, "MANAGED_TABLE");
        tbl1.setCatName(db1.getCatalogName());
        this.objectStore.createTable(tbl1);
        Table matView1 = new Table("mat1", DB1, "owner", 1, 2, 3, sd1, null, params, null, null, "MATERIALIZED_VIEW");
        matView1.setCatName(db1.getCatalogName());
        CreationMetadata creationMetadata = new CreationMetadata();
        creationMetadata.setCatName(db1.getCatalogName());
        creationMetadata.setDbName(matView1.getDbName());
        creationMetadata.setTblName(matView1.getTableName());
        creationMetadata.setTablesUsed(Collections.singleton(tbl1.getDbName() + "." + tbl1.getTableName()));
        creationMetadata.setSourceTables(Collections.singletonList(TestHiveMetaStore.createSourceTable(tbl1)));
        matView1.setCreationMetadata(creationMetadata);
        this.objectStore.createTable(matView1);
        CreationMetadata newCreationMetadata = new CreationMetadata(matView1.getCatName(), matView1.getDbName(), matView1.getTableName(), (Set)ImmutableSet.copyOf((Collection)creationMetadata.getTablesUsed()));
        newCreationMetadata.setSourceTables(Collections.unmodifiableList(creationMetadata.getSourceTables()));
        this.objectStore.updateCreationMetadata(matView1.getCatName(), matView1.getDbName(), matView1.getTableName(), newCreationMetadata);
        MatcherAssert.assertThat((Object)creationMetadata.getMaterializationTime(), (Matcher)Is.is((Matcher)IsNot.not((Object)0)));
    }

    @Test
    public void testCreateAndFindPackage() throws Exception {
        this.objectStore.createDatabase(new DatabaseBuilder().setName(DB1).setDescription("description").setLocation("locationurl").build(this.conf));
        AddPackageRequest pkg = new AddPackageRequest(ENGINE, DB1, "pkg1", "user1", "src", "src");
        this.objectStore.addPackage(pkg);
        Package found = this.objectStore.findPackage(new GetPackageRequest(ENGINE, DB1, "pkg1"));
        Assert.assertEquals((Object)pkg.getBody(), (Object)found.getBody());
        Assert.assertEquals((Object)pkg.getHeader(), (Object)found.getHeader());
        Assert.assertEquals((Object)pkg.getCatName(), (Object)found.getCatName());
        Assert.assertEquals((Object)pkg.getDbName(), (Object)found.getDbName());
        Assert.assertEquals((Object)pkg.getOwnerName(), (Object)found.getOwnerName());
        Assert.assertEquals((Object)pkg.getPackageName(), (Object)found.getPackageName());
    }

    @Test
    public void testDropPackage() throws Exception {
        this.objectStore.createDatabase(new DatabaseBuilder().setName(DB1).setDescription("description").setLocation("locationurl").build(this.conf));
        AddPackageRequest pkg = new AddPackageRequest(ENGINE, DB1, "pkg1", "user1", "header", "body");
        this.objectStore.addPackage(pkg);
        Assert.assertNotNull((Object)this.objectStore.findPackage(new GetPackageRequest(ENGINE, DB1, "pkg1")));
        this.objectStore.dropPackage(new DropPackageRequest(ENGINE, DB1, "pkg1"));
        Assert.assertNull((Object)this.objectStore.findPackage(new GetPackageRequest(ENGINE, DB1, "pkg1")));
    }

    @Test
    public void testListPackage() throws Exception {
        this.objectStore.createDatabase(new DatabaseBuilder().setName(DB1).setDescription("description").setLocation("locationurl").build(this.conf));
        this.objectStore.createDatabase(new DatabaseBuilder().setName(DB2).setDescription("description").setLocation("locationurl").build(this.conf));
        AddPackageRequest pkg1 = new AddPackageRequest(ENGINE, DB1, "pkg1", "user1", "header1", "body1");
        AddPackageRequest pkg2 = new AddPackageRequest(ENGINE, DB2, "pkg2", "user1", "header2", "body2");
        this.objectStore.addPackage(pkg1);
        this.objectStore.addPackage(pkg2);
        List result = this.objectStore.listPackages(new ListPackageRequest(ENGINE));
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"pkg1", "pkg2"}));
        Assert.assertEquals((long)2L, (long)result.size());
        ListPackageRequest req = new ListPackageRequest(ENGINE);
        req.setDbName(DB1);
        result = this.objectStore.listPackages(req);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"pkg1"}));
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testSavePoint() throws Exception {
        final List<String> partNames = Arrays.asList("test_part_col=a0", "test_part_col=a1", "test_part_col=a2");
        this.createPartitionedTable(true, false);
        Assert.assertEquals((long)3L, (long)this.objectStore.getPartitionCount());
        this.objectStore.openTransaction();
        ObjectStore objectStore = this.objectStore;
        objectStore.getClass();
        new ObjectStore.GetHelper<Object>(objectStore, ENGINE, DB1, TABLE1, true, true){
            {
                ObjectStore objectStore = x0;
                objectStore.getClass();
                super(objectStore, x1, x2, x3, x4, x5);
            }

            protected String describeResult() {
                return "test savepoint";
            }

            protected Object getSqlResult(ObjectStore.GetHelper<Object> ctx) throws MetaException {
                try (AutoCloseable c = TestObjectStore.this.deadline();){
                    TestObjectStore.this.objectStore.dropPartitionsInternal(ctx.catName, ctx.dbName, ctx.tblName, partNames, true, false);
                    Assert.assertEquals((long)0L, (long)TestObjectStore.this.objectStore.getPartitionCount());
                }
                catch (Exception e) {
                    throw new MetaException(e.getMessage());
                }
                throw new MetaException("Throwing exception in direct SQL to test Savepoint");
            }

            protected Object getJdoResult(ObjectStore.GetHelper<Object> ctx) throws MetaException {
                try (AutoCloseable c = TestObjectStore.this.deadline();){
                    Assert.assertEquals((long)3L, (long)TestObjectStore.this.objectStore.getPartitionCount());
                    TestObjectStore.this.objectStore.dropPartitionsInternal(ctx.catName, ctx.dbName, ctx.tblName, partNames, false, true);
                }
                catch (Exception e) {
                    throw new MetaException(e.getMessage());
                }
                return null;
            }
        }.run(false);
        this.objectStore.commitTransaction();
        Assert.assertEquals((long)0L, (long)this.objectStore.getPartitionCount());
    }

    private void checkSSLProperty(boolean useSSL, String key, String value) {
        if (useSSL && !value.isEmpty()) {
            Assert.assertEquals((Object)value, (Object)System.getProperty(key));
        } else {
            Assert.assertNull((Object)System.getProperty(key));
        }
    }

    private void createTestCatalog(String catName) throws MetaException {
        Catalog cat = new CatalogBuilder().setName(catName).setLocation("/tmp").build();
        this.objectStore.createCatalog(cat);
    }

    AutoCloseable deadline() throws Exception {
        Deadline.registerIfNot((long)100000L);
        Deadline.startTimer((String)"some method");
        return new AutoCloseable(){

            @Override
            public void close() throws Exception {
                Deadline.stopTimer();
            }
        };
    }

    private static final class LongSupplier
    implements Supplier<Long> {
        public long value = 0L;

        private LongSupplier() {
        }

        public Long get() {
            return this.value;
        }
    }
}

