/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.io.File;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.util.StringUtils;
import org.apache.thrift.TException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestMetastoreTransformer {
    private static final Logger LOG = LoggerFactory.getLogger(TestMetastoreTransformer.class);
    protected static HiveMetaStoreClient client;
    protected static Configuration conf;
    protected static Warehouse warehouse;
    protected static boolean isThriftClient;

    @Before
    public void setUp() throws Exception {
        this.initConf();
        warehouse = new Warehouse(conf);
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METRICS_ENABLED, (boolean)true);
        conf.set("datanucleus.autoCreateTables", "false");
        conf.set("hive.in.test", "true");
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        warehouse = new Warehouse(conf);
        client = this.createClient();
    }

    @After
    public void tearDown() throws Exception {
        client.close();
    }

    protected HiveMetaStoreClient createClient() throws Exception {
        try {
            return new HiveMetaStoreClient(conf);
        }
        catch (Throwable e) {
            System.err.println("Unable to open the metastore");
            System.err.println(StringUtils.stringifyException((Throwable)e));
            throw new Exception(e);
        }
    }

    protected void initConf() {
        if (null == conf) {
            conf = MetastoreConf.newMetastoreConf();
        }
    }

    private static void silentDropDatabase(String dbName) throws TException {
        try {
            for (String tableName : client.getTables(dbName, "*")) {
                client.dropTable(dbName, tableName);
            }
            client.dropDatabase(dbName);
        }
        catch (InvalidOperationException | MetaException | NoSuchObjectException throwable) {
            // empty catch block
        }
    }

    @Test
    public void testAlterTableIsCaseInSensitive() throws Exception {
        String dbName = "alterdb";
        String tblName = "altertbl";
        client.dropTable(dbName, tblName);
        TestMetastoreTransformer.silentDropDatabase(dbName);
        String dbLocation = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.WAREHOUSE_EXTERNAL) + "/_testDB_table_create_";
        String mgdLocation = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.WAREHOUSE) + "/_testDB_table_create_";
        new DatabaseBuilder().setName(dbName).setLocation(dbLocation).setManagedLocation(mgdLocation).create((IMetaStoreClient)client, conf);
        ArrayList<FieldSchema> invCols = new ArrayList<FieldSchema>(2);
        invCols.add(new FieldSchema("n-ame", "string", ""));
        invCols.add(new FieldSchema("in.come", "int", ""));
        Table tbl = ((TableBuilder)new TableBuilder().setDbName(dbName).setTableName(tblName).setCols(invCols)).build(conf);
        client.createTable(tbl);
        tbl = client.getTable(tbl.getDbName(), tbl.getTableName());
        tbl.setTableName(tblName.toUpperCase());
        client.alter_table(tbl.getDbName(), tbl.getTableName().toUpperCase(), tbl);
        Table tbl2 = client.getTable(tbl.getDbName(), tbl.getTableName().toLowerCase());
        Assert.assertEquals((Object)tbl.getTableName().toLowerCase(), (Object)tbl2.getTableName());
    }

    @Test
    public void testLocationBlank() throws Exception {
        Table tbl = ((TableBuilder)((TableBuilder)new TableBuilder().setTableName("locationBlank").setCols(new ArrayList())).setLocation("")).build(conf);
        client.createTable(tbl);
        Table tbl2 = client.getTable(tbl.getDbName(), tbl.getTableName().toLowerCase());
        Assert.assertEquals((Object)"locationblank", (Object)new File(tbl2.getSd().getLocation()).getName());
    }

    static {
        conf = null;
        isThriftClient = false;
    }
}

