/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.IMetaStoreSchemaInfo;
import org.apache.hadoop.hive.metastore.MetaStoreSchemaInfoFactory;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class TestMetaStoreSchemaInfo {
    @Test
    public void testIsVersionCompatible() throws Exception {
        IMetaStoreSchemaInfo metastoreSchemaInfo = MetaStoreSchemaInfoFactory.get((Configuration)MetastoreConf.newMetastoreConf());
        Assert.assertTrue((boolean)metastoreSchemaInfo.isVersionCompatible("0.0.1", "0.0.1"));
        Assert.assertTrue((boolean)metastoreSchemaInfo.isVersionCompatible("0.0.1", "0.0.2"));
        Assert.assertTrue((boolean)metastoreSchemaInfo.isVersionCompatible("1.0.2", "2.0.1"));
        Assert.assertTrue((boolean)metastoreSchemaInfo.isVersionCompatible("0.0.9", "9.0.0"));
        Assert.assertTrue((boolean)metastoreSchemaInfo.isVersionCompatible("4.0.0-alpha-1", "4.0.0-alpha-2"));
        Assert.assertTrue((boolean)metastoreSchemaInfo.isVersionCompatible("4.0.0-alpha-1", "4.0.0-alpha"));
        Assert.assertTrue((boolean)metastoreSchemaInfo.isVersionCompatible("4.0.0-alpha-1", "4.0.0"));
        Assert.assertTrue((boolean)metastoreSchemaInfo.isVersionCompatible("4.0.0-alpha-1", "4.0.1"));
        Assert.assertTrue((boolean)metastoreSchemaInfo.isVersionCompatible("4.0.0-alpha-1", "4.0.0-beta"));
        Assert.assertTrue((boolean)metastoreSchemaInfo.isVersionCompatible("0.13.0", "0.13.1"));
        Assert.assertTrue((boolean)metastoreSchemaInfo.isVersionCompatible("0.13.1", "0.13.0"));
        Assert.assertFalse((boolean)metastoreSchemaInfo.isVersionCompatible("0.1.1", "0.1.0"));
        Assert.assertFalse((boolean)metastoreSchemaInfo.isVersionCompatible("4.0.1", "0.1.0"));
        Assert.assertFalse((boolean)metastoreSchemaInfo.isVersionCompatible("4.0.1", "4.0.0-alpha-1"));
        Assert.assertFalse((boolean)metastoreSchemaInfo.isVersionCompatible("4.0.0", "4.0.0-alpha-1"));
        Assert.assertFalse((boolean)metastoreSchemaInfo.isVersionCompatible("4.0.0-alpha-2", "4.0.0-alpha-1"));
        Assert.assertFalse((boolean)metastoreSchemaInfo.isVersionCompatible("4.0.0-alpha", "4.0.0-alpha-1"));
        Assert.assertFalse((boolean)metastoreSchemaInfo.isVersionCompatible("4.0.0-beta", "4.0.0-alpha-1"));
    }
}

