/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.ThrowingTxnHandler;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.util.StringUtils;
import org.apache.thrift.TException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class TestMetaStoreAcidCleanup {
    protected static HiveMetaStoreClient client;
    protected static Configuration conf;
    protected static Warehouse warehouse;
    private static final String dbName = "db";
    private String tableName;

    @BeforeClass
    public static void setUp() throws Exception {
        conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setClass((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TXN_STORE_IMPL, ThrowingTxnHandler.class, TxnStore.class);
        conf.set("hive.metastore.client.capabilities", "HIVEMANAGEDINSERTWRITE,HIVEMANAGESTATS,HIVECACHEINVALIDATE,CONNECTORWRITE");
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        warehouse = new Warehouse(conf);
        client = new HiveMetaStoreClient(conf);
        Database db = new DatabaseBuilder().setName(dbName).build(conf);
        client.createDatabase(db);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        try {
            ThrowingTxnHandler.doThrow = false;
            client.dropDatabase(dbName);
            client.close();
        }
        catch (Throwable e) {
            System.err.println("Unable to close metastore");
            System.err.println(StringUtils.stringifyException((Throwable)e));
            throw e;
        }
    }

    @After
    public void afterTest() throws TException {
        client.dropTable(dbName, this.tableName);
    }

    @Test
    public void testDropTableShouldRollback_whenAcidCleanupFails() throws Exception {
        this.tableName = "tableDropTable";
        this.createTable(dbName, this.tableName);
        ThrowingTxnHandler.doThrow = true;
        try {
            client.dropTable(dbName, this.tableName);
        }
        catch (Exception ex) {
            if (!ex.getMessage().contains("during transactional cleanup")) {
                TestCase.fail((String)("dropTable failed with unexpected exception: " + ex));
            }
        }
        finally {
            ThrowingTxnHandler.doThrow = false;
        }
        Table table = client.getTable(dbName, this.tableName);
        TestCase.assertNotNull((Object)table);
    }

    @Test
    public void testDropDatabaseShouldRollback_whenAcidCleanupFails() throws Exception {
        this.tableName = "tableDropDatabase";
        this.createTable(dbName, this.tableName);
        ThrowingTxnHandler.doThrow = true;
        try {
            client.dropDatabase(dbName, true, false, true);
        }
        catch (Exception ex) {
            if (!ex.getMessage().contains("during transactional cleanup")) {
                TestCase.fail((String)("dropTable failed with unexpected exception: " + ex));
            }
        }
        finally {
            ThrowingTxnHandler.doThrow = false;
        }
        Table table = client.getTable(dbName, this.tableName);
        TestCase.assertNotNull((Object)table);
    }

    private void createTable(String dbName, String tableName) throws TException {
        ((TableBuilder)((TableBuilder)new TableBuilder().setDbName(dbName).setTableName(tableName).addCol("foo", "string")).addCol("bar", "string")).addTableParam("transactional", "true").addTableParam("transactional_properties", "insert_only").create((IMetaStoreClient)client, conf);
    }
}

