/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.InvalidPartitionException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionEventType;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.PartitionBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.thrift.TException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreCheckinTest.class})
public class TestMarkPartition {
    protected Configuration conf;

    @Before
    public void setUp() throws Exception {
        System.setProperty("hive.metastore.event.clean.freq", "1s");
        System.setProperty("hive.metastore.event.expiry.duration", "2s");
        this.conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, (boolean)false);
        MetaStoreTestUtils.setConfForStandloneMode(this.conf);
    }

    @Test
    public void testMarkingPartitionSet() throws TException, InterruptedException {
        HiveMetaStoreClient msc = new HiveMetaStoreClient(this.conf);
        String dbName = "hive2215";
        msc.dropDatabase("hive2215", true, true, true);
        Database db = new DatabaseBuilder().setName("hive2215").create((IMetaStoreClient)msc, this.conf);
        String tableName = "tmptbl";
        msc.dropTable("hive2215", "tmptbl", true, true);
        Table table = ((TableBuilder)new TableBuilder().setDbName("hive2215").setTableName("tmptbl").addCol("a", "string")).addPartCol("b", "string").create((IMetaStoreClient)msc, this.conf);
        Partition part = new PartitionBuilder().inTable(table).addValue("2011").build(this.conf);
        msc.add_partition(part);
        HashMap<String, String> kvs = new HashMap<String, String>();
        kvs.put("b", "'2011'");
        msc.markPartitionForEvent("hive2215", "tmptbl", kvs, PartitionEventType.LOAD_DONE);
        Assert.assertTrue((boolean)msc.isPartitionMarkedForEvent("hive2215", "tmptbl", kvs, PartitionEventType.LOAD_DONE));
        Thread.sleep(10000L);
        Assert.assertFalse((boolean)msc.isPartitionMarkedForEvent("hive2215", "tmptbl", kvs, PartitionEventType.LOAD_DONE));
        kvs.put("b", "'2012'");
        Assert.assertFalse((boolean)msc.isPartitionMarkedForEvent("hive2215", "tmptbl", kvs, PartitionEventType.LOAD_DONE));
        try {
            msc.markPartitionForEvent("hive2215", "tmptbl2", kvs, PartitionEventType.LOAD_DONE);
            Assert.fail((String)"Expected UnknownTableException");
        }
        catch (UnknownTableException unknownTableException) {
        }
        catch (Exception e) {
            Assert.fail((String)"Expected UnknownTableException");
        }
        try {
            msc.isPartitionMarkedForEvent("hive2215", "tmptbl2", kvs, PartitionEventType.LOAD_DONE);
            Assert.fail((String)"Expected UnknownTableException");
        }
        catch (UnknownTableException e) {
        }
        catch (Exception e) {
            Assert.fail((String)("Expected UnknownTableException, received " + e.getClass().getName()));
        }
        kvs.put("a", "'2012'");
        try {
            msc.isPartitionMarkedForEvent("hive2215", "tmptbl", kvs, PartitionEventType.LOAD_DONE);
            Assert.fail((String)"Expected InvalidPartitionException");
        }
        catch (InvalidPartitionException e) {
        }
        catch (Exception e) {
            Assert.fail((String)("Expected InvalidPartitionException, received " + e.getClass().getName()));
        }
    }
}

