/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.DummyListener;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.builder.PartitionBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.events.AddPartitionEvent;
import org.apache.hadoop.hive.metastore.events.AlterTableEvent;
import org.apache.hadoop.hive.metastore.events.CreateDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.CreateTableEvent;
import org.apache.hadoop.hive.metastore.events.DropDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.DropPartitionEvent;
import org.apache.hadoop.hive.metastore.events.DropTableEvent;
import org.apache.hadoop.hive.metastore.events.ListenerEvent;
import org.apache.hadoop.hive.metastore.security.HadoopThriftAuthBridge;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class TestHiveMetaStoreWithEnvironmentContext {
    private Configuration conf;
    private HiveMetaStoreClient msc;
    private EnvironmentContext envContext;
    private final Database db = new Database();
    private Table table;
    private Partition partition;
    private static final String dbName = "hive3252";
    private static final String tblName = "tmptbl";
    private static final String renamed = "tmptbl2";

    @Before
    public void setUp() throws Exception {
        System.setProperty("hive.metastore.event.listeners", DummyListener.class.getName());
        this.conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setLongVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_CONNECTION_RETRIES, (long)3L);
        MetastoreConf.setBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, (boolean)false);
        MetaStoreTestUtils.setConfForStandloneMode(this.conf);
        MetaStoreTestUtils.startMetaStoreWithRetry(HadoopThriftAuthBridge.getBridge(), this.conf);
        this.msc = new HiveMetaStoreClient(this.conf);
        this.msc.dropDatabase(dbName, true, true);
        HashMap<String, String> envProperties = new HashMap<String, String>();
        envProperties.put("hadoop.job.ugi", "test_user");
        this.envContext = new EnvironmentContext(envProperties);
        this.db.setName(dbName);
        this.db.setCatalogName("hive");
        this.table = ((TableBuilder)((TableBuilder)new TableBuilder().setDbName(dbName).setTableName(tblName).addTableParam("a", "string").addPartCol("b", "string").addCol("a", "string")).addCol("b", "string")).build(this.conf);
        this.partition = new PartitionBuilder().inTable(this.table).addValue("2011").build(this.conf);
        DummyListener.notifyList.clear();
    }

    @Test
    public void testEnvironmentContext() throws Exception {
        int listSize = 0;
        List<ListenerEvent> notifyList = DummyListener.notifyList;
        Assert.assertEquals((long)notifyList.size(), (long)listSize);
        this.msc.createDatabase(this.db);
        Assert.assertEquals((long)(++listSize), (long)notifyList.size());
        CreateDatabaseEvent dbEvent = (CreateDatabaseEvent)notifyList.get(listSize - 1);
        assert (dbEvent.getStatus());
        this.msc.createTable(this.table, this.envContext);
        Assert.assertEquals((long)notifyList.size(), (long)(++listSize));
        CreateTableEvent tblEvent = (CreateTableEvent)notifyList.get(listSize - 1);
        assert (tblEvent.getStatus());
        Assert.assertEquals((Object)this.envContext, (Object)tblEvent.getEnvironmentContext());
        this.table = this.msc.getTable(dbName, tblName);
        this.partition.getSd().setLocation(this.table.getSd().getLocation() + "/part1");
        this.msc.add_partition(this.partition, this.envContext);
        Assert.assertEquals((long)notifyList.size(), (long)(++listSize));
        AddPartitionEvent partEvent = (AddPartitionEvent)notifyList.get(listSize - 1);
        assert (partEvent.getStatus());
        Assert.assertEquals((Object)this.envContext, (Object)partEvent.getEnvironmentContext());
        ArrayList<String> partVals = new ArrayList<String>();
        partVals.add("2012");
        this.msc.appendPartition(dbName, tblName, partVals, this.envContext);
        Assert.assertEquals((long)notifyList.size(), (long)(++listSize));
        AddPartitionEvent appendPartEvent = (AddPartitionEvent)notifyList.get(listSize - 1);
        assert (appendPartEvent.getStatus());
        Assert.assertEquals((Object)this.envContext, (Object)appendPartEvent.getEnvironmentContext());
        this.table.setTableName(renamed);
        this.msc.alter_table_with_environmentContext(dbName, tblName, this.table, this.envContext);
        Assert.assertEquals((long)notifyList.size(), (long)(++listSize));
        AlterTableEvent alterTableEvent = (AlterTableEvent)notifyList.get(listSize - 1);
        assert (alterTableEvent.getStatus());
        Assert.assertEquals((Object)this.envContext, (Object)alterTableEvent.getEnvironmentContext());
        this.table.setTableName(tblName);
        this.msc.alter_table_with_environmentContext(dbName, renamed, this.table, this.envContext);
        Assert.assertEquals((long)notifyList.size(), (long)(++listSize));
        ArrayList<String> dropPartVals = new ArrayList<String>();
        dropPartVals.add("2011");
        this.msc.dropPartition(dbName, tblName, dropPartVals, this.envContext);
        Assert.assertEquals((long)notifyList.size(), (long)(++listSize));
        DropPartitionEvent dropPartEvent = (DropPartitionEvent)notifyList.get(listSize - 1);
        assert (dropPartEvent.getStatus());
        Assert.assertEquals((Object)this.envContext, (Object)dropPartEvent.getEnvironmentContext());
        this.msc.dropPartition(dbName, tblName, "b=2012", true, this.envContext);
        Assert.assertEquals((long)notifyList.size(), (long)(++listSize));
        DropPartitionEvent dropPartByNameEvent = (DropPartitionEvent)notifyList.get(listSize - 1);
        assert (dropPartByNameEvent.getStatus());
        Assert.assertEquals((Object)this.envContext, (Object)dropPartByNameEvent.getEnvironmentContext());
        this.msc.dropTable("hive", dbName, tblName, true, false, this.envContext);
        Assert.assertEquals((long)notifyList.size(), (long)(++listSize));
        DropTableEvent dropTblEvent = (DropTableEvent)notifyList.get(listSize - 1);
        assert (dropTblEvent.getStatus());
        Assert.assertEquals((Object)this.envContext, (Object)dropTblEvent.getEnvironmentContext());
        this.msc.dropDatabase(dbName);
        Assert.assertEquals((long)notifyList.size(), (long)(++listSize));
        DropDatabaseEvent dropDB = (DropDatabaseEvent)notifyList.get(listSize - 1);
        assert (dropDB.getStatus());
    }
}

