/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ValidReadTxnList;
import org.apache.hadoop.hive.common.ValidReaderWriteIdList;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.LockComponentBuilder;
import org.apache.hadoop.hive.metastore.LockRequestBuilder;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.CompactionInfoStruct;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FindNextCompactRequest;
import org.apache.hadoop.hive.metastore.api.GetLatestCommittedCompactionInfoRequest;
import org.apache.hadoop.hive.metastore.api.GetLatestCommittedCompactionInfoResponse;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.OptionalCompactionInfoStruct;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableValidWriteIds;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.TxnCommonUtils;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.utils.TestTxnDbUtil;
import org.apache.thrift.TException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;

@Category(value={MetastoreUnitTest.class})
public class TestHiveMetaStoreTxns {
    private static Configuration conf;
    private static IMetaStoreClient client;
    private Connection conn;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testTxns() throws Exception {
        List tids = client.openTxns("me", 3).getTxn_ids();
        Assert.assertEquals((long)1L, (long)((Long)tids.get(0)));
        Assert.assertEquals((long)2L, (long)((Long)tids.get(1)));
        Assert.assertEquals((long)3L, (long)((Long)tids.get(2)));
        client.rollbackTxn(1L);
        client.commitTxn(2L);
        ValidTxnList validTxns = client.getValidTxns();
        Assert.assertFalse((boolean)validTxns.isTxnValid(1L));
        Assert.assertTrue((boolean)validTxns.isTxnValid(2L));
        Assert.assertFalse((boolean)validTxns.isTxnValid(3L));
        Assert.assertFalse((boolean)validTxns.isTxnValid(4L));
    }

    @Test
    public void testOpenTxnNotExcluded() throws Exception {
        List tids = client.openTxns("me", 3).getTxn_ids();
        Assert.assertEquals((long)1L, (long)((Long)tids.get(0)));
        Assert.assertEquals((long)2L, (long)((Long)tids.get(1)));
        Assert.assertEquals((long)3L, (long)((Long)tids.get(2)));
        client.rollbackTxn(1L);
        client.commitTxn(2L);
        ValidTxnList validTxns = client.getValidTxns(3L);
        Assert.assertFalse((boolean)validTxns.isTxnValid(1L));
        Assert.assertTrue((boolean)validTxns.isTxnValid(2L));
        Assert.assertTrue((boolean)validTxns.isTxnValid(3L));
        Assert.assertFalse((boolean)validTxns.isTxnValid(4L));
    }

    @Test
    public void testOpenReadOnlyTxnExcluded() throws Exception {
        client.openTxn("me", TxnType.READ_ONLY);
        client.openTxns("me", 3);
        client.rollbackTxn(2L);
        client.commitTxn(3L);
        ValidTxnList validTxns = client.getValidTxns(4L);
        Assert.assertTrue((boolean)validTxns.isTxnValid(1L));
        Assert.assertFalse((boolean)validTxns.isTxnValid(2L));
        Assert.assertTrue((boolean)validTxns.isTxnValid(3L));
        Assert.assertTrue((boolean)validTxns.isTxnValid(4L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTxNWithKeyValue() throws Exception {
        Statement stm = this.conn.createStatement();
        String dbName = "mydbKeyValue";
        String tblName = "mytable";
        Database db = new DatabaseBuilder().setName(dbName).build(conf);
        db.unsetCatalogName();
        Table tbl = ((TableBuilder)((TableBuilder)new TableBuilder().setDbName(dbName).setTableName(tblName).addCol("id", "int")).addCol("name", "string")).setType(TableType.MANAGED_TABLE.name()).build(conf);
        try {
            client.createDatabase(db);
            client.createTable(tbl);
            tbl = client.getTable(dbName, tblName);
            stm.executeUpdate("INSERT INTO TABLE_PARAMS(TBL_ID, PARAM_KEY) VALUES(" + tbl.getId() + String.format(", '%smykey')", "_meta"));
            List tids = client.openTxns("me", 1).getTxn_ids();
            Assert.assertEquals((long)1L, (long)((Long)tids.get(0)));
            client.commitTxnWithKeyValue(1L, tbl.getId(), "_metamykey", "myvalue");
            ValidTxnList validTxns = client.getValidTxns(1L);
            Assert.assertTrue((boolean)validTxns.isTxnValid(1L));
            ResultSet rs = stm.executeQuery("SELECT TBL_ID, PARAM_KEY, PARAM_VALUE FROM TABLE_PARAMS WHERE TBL_ID = " + tbl.getId());
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)rs.getLong(1), (long)tbl.getId());
            Assert.assertEquals((Object)rs.getString(2), (Object)"_metamykey");
            Assert.assertEquals((Object)rs.getString(3), (Object)"myvalue");
        }
        catch (Throwable throwable) {
            client.dropTable(dbName, tblName);
            client.dropDatabase(dbName);
            stm.execute("DELETE FROM TABLE_PARAMS WHERE TBL_ID = " + tbl.getId() + String.format(" AND PARAM_KEY = '%smykey'", "_meta"));
            throw throwable;
        }
        client.dropTable(dbName, tblName);
        client.dropDatabase(dbName);
        stm.execute("DELETE FROM TABLE_PARAMS WHERE TBL_ID = " + tbl.getId() + String.format(" AND PARAM_KEY = '%smykey'", "_meta"));
    }

    @Test
    public void testTxNWithKeyValueNoTableId() throws Exception {
        List tids = client.openTxns("me", 1).getTxn_ids();
        Assert.assertEquals((long)1L, (long)((Long)tids.get(0)));
        try {
            client.commitTxnWithKeyValue(1L, 10L, "_metamykey", "myvalue");
            Assert.fail((String)"Should have raised exception");
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("key=_metamykey"));
            Assert.assertTrue((boolean)e.getMessage().contains("value=myvalue"));
            Assert.assertTrue((boolean)e.getMessage().contains("Only one row should have been affected but"));
        }
        ValidTxnList validTxns = client.getValidTxns(1L);
        Assert.assertTrue((boolean)validTxns.isTxnValid(1L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTxNWithKeyWrongPrefix() throws Exception {
        String dbName = "mydbKeyValueWrongPrefix";
        String tblName = "mytable";
        List tids = client.openTxns("me", 1).getTxn_ids();
        Assert.assertEquals((long)1L, (long)((Long)tids.get(0)));
        try {
            Database db = new DatabaseBuilder().setName(dbName).build(conf);
            db.unsetCatalogName();
            client.createDatabase(db);
            Table tbl = ((TableBuilder)((TableBuilder)new TableBuilder().setDbName(dbName).setTableName(tblName).addCol("id", "int")).addCol("name", "string")).setType(TableType.MANAGED_TABLE.name()).build(conf);
            client.createTable(tbl);
            tbl = client.getTable(dbName, tblName);
            client.commitTxnWithKeyValue(1L, tbl.getId(), "mykey", "myvalue");
            Assert.fail((String)"Should have raised exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("key=mykey"));
            Assert.assertTrue((boolean)e.getMessage().contains("value=myvalue"));
            Assert.assertTrue((boolean)e.getMessage().contains("key should start with"));
        }
        finally {
            client.dropTable(dbName, tblName);
            client.dropDatabase(dbName);
        }
        ValidTxnList validTxns = client.getValidTxns(1L);
        Assert.assertTrue((boolean)validTxns.isTxnValid(1L));
    }

    @Test
    public void testLocks() throws Exception {
        LockRequestBuilder rqstBuilder = new LockRequestBuilder();
        rqstBuilder.addLockComponent(new LockComponentBuilder().setDbName("mydb").setTableName("mytable").setPartitionName("MyPartition=MyValue").setExclusive().setOperationType(DataOperationType.NO_TXN).build());
        rqstBuilder.addLockComponent(new LockComponentBuilder().setDbName("mydb").setTableName("yourtable").setSharedWrite().setOperationType(DataOperationType.NO_TXN).build());
        rqstBuilder.addLockComponent(new LockComponentBuilder().setDbName("yourdb").setOperationType(DataOperationType.NO_TXN).setSharedRead().build());
        rqstBuilder.setUser("fred");
        LockResponse res = client.lock(rqstBuilder.build());
        Assert.assertEquals((long)1L, (long)res.getLockid());
        Assert.assertEquals((Object)LockState.ACQUIRED, (Object)res.getState());
        res = client.checkLock(1L);
        Assert.assertEquals((long)1L, (long)res.getLockid());
        Assert.assertEquals((Object)LockState.ACQUIRED, (Object)res.getState());
        client.heartbeat(0L, 1L);
        client.unlock(1L);
    }

    @Test
    public void testLocksWithTxn() throws Exception {
        long txnid = client.openTxn("me");
        LockRequestBuilder rqstBuilder = new LockRequestBuilder();
        rqstBuilder.setTransactionId(txnid).addLockComponent(new LockComponentBuilder().setDbName("mydb").setTableName("mytable").setPartitionName("MyPartition=MyValue").setSharedWrite().setOperationType(DataOperationType.UPDATE).build()).addLockComponent(new LockComponentBuilder().setDbName("mydb").setTableName("yourtable").setSharedWrite().setOperationType(DataOperationType.UPDATE).build()).addLockComponent(new LockComponentBuilder().setDbName("yourdb").setSharedRead().setOperationType(DataOperationType.SELECT).build()).setUser("fred");
        LockResponse res = client.lock(rqstBuilder.build());
        Assert.assertEquals((long)1L, (long)res.getLockid());
        Assert.assertEquals((Object)LockState.ACQUIRED, (Object)res.getState());
        res = client.checkLock(1L);
        Assert.assertEquals((long)1L, (long)res.getLockid());
        Assert.assertEquals((Object)LockState.ACQUIRED, (Object)res.getState());
        client.heartbeat(txnid, 1L);
        client.commitTxn(txnid);
    }

    @Test
    public void stringifyValidTxns() throws Exception {
        ValidReadTxnList validTxns = new ValidReadTxnList("1:9223372036854775807::");
        String asString = validTxns.toString();
        Assert.assertEquals((Object)"1:9223372036854775807::", (Object)asString);
        validTxns = new ValidReadTxnList(asString);
        Assert.assertEquals((long)1L, (long)validTxns.getHighWatermark());
        Assert.assertNotNull((Object)validTxns.getInvalidTransactions());
        Assert.assertEquals((long)0L, (long)validTxns.getInvalidTransactions().length);
        asString = validTxns.toString();
        Assert.assertEquals((Object)"1:9223372036854775807::", (Object)asString);
        validTxns = new ValidReadTxnList(asString);
        Assert.assertEquals((long)1L, (long)validTxns.getHighWatermark());
        Assert.assertNotNull((Object)validTxns.getInvalidTransactions());
        Assert.assertEquals((long)0L, (long)validTxns.getInvalidTransactions().length);
        validTxns = new ValidReadTxnList("10:3:5:3");
        asString = validTxns.toString();
        if (!asString.equals("10:3:3:5") && !asString.equals("10:3:5:3")) {
            Assert.fail((String)("Unexpected string value " + asString));
        }
        validTxns = new ValidReadTxnList(asString);
        Assert.assertEquals((long)10L, (long)validTxns.getHighWatermark());
        Assert.assertNotNull((Object)validTxns.getInvalidTransactions());
        Assert.assertEquals((long)2L, (long)validTxns.getInvalidTransactions().length);
        boolean sawThree = false;
        boolean sawFive = false;
        for (long tid : validTxns.getInvalidTransactions()) {
            if (tid == 3L) {
                sawThree = true;
                continue;
            }
            if (tid == 5L) {
                sawFive = true;
                continue;
            }
            Assert.fail((String)("Unexpected value " + tid));
        }
        Assert.assertTrue((boolean)sawThree);
        Assert.assertTrue((boolean)sawFive);
    }

    @Test
    public void testOpenTxnWithType() throws Exception {
        long txnId = client.openTxn("me", TxnType.DEFAULT);
        client.commitTxn(txnId);
        ValidTxnList validTxns = client.getValidTxns();
        Assert.assertTrue((boolean)validTxns.isTxnValid(txnId));
    }

    @Test
    public void testTxnTypePersisted() throws Exception {
        long txnId = client.openTxn("me", TxnType.READ_ONLY);
        Statement stm = this.conn.createStatement();
        ResultSet rs = stm.executeQuery("SELECT txn_type FROM txns WHERE txn_id = " + txnId);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)TxnType.findByValue((int)rs.getInt(1)), (Object)TxnType.READ_ONLY);
    }

    @Test
    public void testAllocateTableWriteIdForReadOnlyTxn() throws Exception {
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("Write ID allocation failed on db.tbl as not all input txns in open state or read-only");
        long txnId = client.openTxn("me", TxnType.READ_ONLY);
        client.allocateTableWriteId(txnId, "db", "tbl");
    }

    @Test
    public void testGetValidWriteIds() throws TException {
        List tids = client.openTxns("me", 3).getTxn_ids();
        client.allocateTableWriteIdsBatch(tids, "db", "tbl");
        client.rollbackTxn(((Long)tids.get(0)).longValue());
        ValidTxnList validTxnList = client.getValidTxns();
        String fullTableName = TxnUtils.getFullTableName((String)"db", (String)"tbl");
        List tableValidWriteIds = client.getValidWriteIds(Collections.singletonList(fullTableName), validTxnList.writeToString());
        Assert.assertEquals((long)tableValidWriteIds.size(), (long)1L);
        TableValidWriteIds writeIds = (TableValidWriteIds)tableValidWriteIds.get(0);
        Assert.assertNotNull((Object)writeIds);
        ValidReaderWriteIdList writeIdList = TxnCommonUtils.createValidReaderWriteIdList((TableValidWriteIds)writeIds);
        Assert.assertNotNull((Object)writeIdList);
        Assert.assertEquals((long)writeIdList.getInvalidWriteIds().length, (long)1L);
        Assert.assertTrue((boolean)validTxnList.isTxnAborted(((Long)tids.get(0)).longValue()));
        Assert.assertEquals((long)writeIdList.getHighWatermark(), (long)1L);
        Assert.assertEquals((long)writeIdList.getMinOpenWriteId(), (long)2L);
        client.commitTxn(((Long)tids.get(2)).longValue());
        validTxnList = client.getValidTxns();
        tableValidWriteIds = client.getValidWriteIds(Collections.singletonList(fullTableName), validTxnList.writeToString());
        Assert.assertEquals((long)tableValidWriteIds.size(), (long)1L);
        writeIds = (TableValidWriteIds)tableValidWriteIds.get(0);
        Assert.assertNotNull((Object)writeIds);
        writeIdList = TxnCommonUtils.createValidReaderWriteIdList((TableValidWriteIds)writeIds);
        Assert.assertNotNull((Object)writeIdList);
        Assert.assertEquals((long)writeIdList.getInvalidWriteIds().length, (long)2L);
        Assert.assertTrue((boolean)validTxnList.isTxnAborted(((Long)tids.get(0)).longValue()));
        Assert.assertFalse((boolean)validTxnList.isTxnValid(((Long)tids.get(1)).longValue()));
        Assert.assertEquals((long)writeIdList.getHighWatermark(), (long)3L);
        Assert.assertEquals((long)writeIdList.getMinOpenWriteId(), (long)2L);
    }

    @Test
    public void testGetLatestCommittedCompactionInfo() throws Exception {
        String dbName = "mydb";
        String tblName = "mytable";
        Database db = new DatabaseBuilder().setName("mydb").build(conf);
        db.unsetCatalogName();
        client.createDatabase(db);
        Table tbl = ((TableBuilder)((TableBuilder)new TableBuilder().setDbName("mydb").setTableName("mytable").addCol("id", "int")).addCol("name", "string")).setType(TableType.MANAGED_TABLE.name()).build(conf);
        client.createTable(tbl);
        tbl = client.getTable("mydb", "mytable");
        client.compact2(tbl.getDbName(), tbl.getTableName(), null, CompactionType.MINOR, new HashMap());
        FindNextCompactRequest compactRequest = new FindNextCompactRequest();
        compactRequest.setWorkerId("myworker");
        OptionalCompactionInfoStruct optionalCi = client.findNextCompact(compactRequest);
        client.markCleaned(optionalCi.getCi());
        GetLatestCommittedCompactionInfoRequest rqst = new GetLatestCommittedCompactionInfoRequest();
        String invalidTblName = "invalid";
        rqst.setDbname("mydb");
        Assert.assertThrows(MetaException.class, () -> client.getLatestCommittedCompactionInfo(rqst));
        rqst.setTablename("invalid");
        GetLatestCommittedCompactionInfoResponse response = client.getLatestCommittedCompactionInfo(rqst);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)0L, (long)response.getCompactionsSize());
        rqst.setTablename("mytable");
        response = client.getLatestCommittedCompactionInfo(rqst);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)1L, (long)response.getCompactionsSize());
        CompactionInfoStruct lci = (CompactionInfoStruct)response.getCompactions().get(0);
        Assert.assertEquals((long)1L, (long)lci.getId());
        Assert.assertNull((Object)lci.getPartitionname());
        Assert.assertEquals((Object)CompactionType.MINOR, (Object)lci.getType());
    }

    @BeforeClass
    public static void setUpDB() throws Exception {
        conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_METADATA_TRANSFORMER_CLASS, (String)" ");
        conf.setBoolean(MetastoreConf.ConfVars.HIVE_IN_TEST.getVarname(), true);
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        TestTxnDbUtil.setConfValues(conf);
        TestTxnDbUtil.prepDb(conf);
        client = new HiveMetaStoreClient(conf);
    }

    @Before
    public void setUp() throws Exception {
        String connectionStr = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECT_URL_KEY);
        this.conn = DriverManager.getConnection(connectionStr);
    }

    @After
    public void tearDown() throws Exception {
        this.conn.close();
        TestTxnDbUtil.cleanDb(conf);
    }
}

