/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreEventListener;
import org.apache.hadoop.hive.metastore.MetaStorePreEventListener;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.FindSchemasByColsResp;
import org.apache.hadoop.hive.metastore.api.FindSchemasByColsRqst;
import org.apache.hadoop.hive.metastore.api.ISchema;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.SchemaCompatibility;
import org.apache.hadoop.hive.metastore.api.SchemaType;
import org.apache.hadoop.hive.metastore.api.SchemaValidation;
import org.apache.hadoop.hive.metastore.api.SchemaVersion;
import org.apache.hadoop.hive.metastore.api.SchemaVersionDescriptor;
import org.apache.hadoop.hive.metastore.api.SchemaVersionState;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.SerdeType;
import org.apache.hadoop.hive.metastore.client.builder.CatalogBuilder;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.ISchemaBuilder;
import org.apache.hadoop.hive.metastore.client.builder.SchemaVersionBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.events.AddSchemaVersionEvent;
import org.apache.hadoop.hive.metastore.events.AlterISchemaEvent;
import org.apache.hadoop.hive.metastore.events.AlterSchemaVersionEvent;
import org.apache.hadoop.hive.metastore.events.CreateISchemaEvent;
import org.apache.hadoop.hive.metastore.events.DropISchemaEvent;
import org.apache.hadoop.hive.metastore.events.DropSchemaVersionEvent;
import org.apache.hadoop.hive.metastore.events.PreEventContext;
import org.apache.hadoop.hive.metastore.messaging.EventMessage;
import org.apache.hadoop.hive.metastore.security.HadoopThriftAuthBridge;
import org.apache.thrift.TException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreCheckinTest.class})
public class TestHiveMetaStoreSchemaMethods {
    private static Map<EventMessage.EventType, Integer> events;
    private static Map<EventMessage.EventType, Integer> transactionalEvents;
    private static Map<PreEventContext.PreEventType, Integer> preEvents;
    private static IMetaStoreClient client;
    private static Configuration conf;
    private static int nextSchemaNum;

    @BeforeClass
    public static void startMetastore() throws Exception {
        conf = MetastoreConf.newMetastoreConf();
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        MetastoreConf.setClass((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.EVENT_LISTENERS, SchemaEventListener.class, MetaStoreEventListener.class);
        MetastoreConf.setClass((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TRANSACTIONAL_EVENT_LISTENERS, TransactionalSchemaEventListener.class, MetaStoreEventListener.class);
        MetastoreConf.setClass((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.PRE_EVENT_LISTENERS, SchemaPreEventListener.class, MetaStorePreEventListener.class);
        int port = MetaStoreTestUtils.startMetaStoreWithRetry(HadoopThriftAuthBridge.getBridge(), conf, false, false, false, false, false);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_URIS, (String)("thrift://localhost:" + port));
        client = new HiveMetaStoreClient(conf);
    }

    @Before
    public void newMaps() {
        events = new HashMap<EventMessage.EventType, Integer>();
        transactionalEvents = new HashMap<EventMessage.EventType, Integer>();
        preEvents = new HashMap<PreEventContext.PreEventType, Integer>();
    }

    @Test(expected=NoSuchObjectException.class)
    public void getNonExistentSchema() throws TException {
        client.getISchema("hive", "default", "no.such.schema");
    }

    @Test
    public void iSchema() throws TException {
        String schemaName = this.uniqueSchemaName();
        String schemaGroup = "group1";
        String description = "This is a description";
        ISchema schema = new ISchemaBuilder().setSchemaType(SchemaType.AVRO).setName(schemaName).setCompatibility(SchemaCompatibility.FORWARD).setValidationLevel(SchemaValidation.LATEST).setCanEvolve(false).setSchemaGroup(schemaGroup).setDescription(description).build();
        client.createISchema(schema);
        Assert.assertEquals((long)1L, (long)preEvents.get(PreEventContext.PreEventType.CREATE_ISCHEMA).intValue());
        Assert.assertEquals((long)1L, (long)events.get(EventMessage.EventType.CREATE_ISCHEMA).intValue());
        Assert.assertEquals((long)1L, (long)transactionalEvents.get(EventMessage.EventType.CREATE_ISCHEMA).intValue());
        schema = client.getISchema("hive", "default", schemaName);
        Assert.assertEquals((long)1L, (long)preEvents.get(PreEventContext.PreEventType.READ_ISCHEMA).intValue());
        Assert.assertEquals((Object)SchemaType.AVRO, (Object)schema.getSchemaType());
        Assert.assertEquals((Object)schemaName, (Object)schema.getName());
        Assert.assertEquals((Object)"hive", (Object)schema.getCatName());
        Assert.assertEquals((Object)"default", (Object)schema.getDbName());
        Assert.assertEquals((Object)SchemaCompatibility.FORWARD, (Object)schema.getCompatibility());
        Assert.assertEquals((Object)SchemaValidation.LATEST, (Object)schema.getValidationLevel());
        Assert.assertFalse((boolean)schema.isCanEvolve());
        Assert.assertEquals((Object)schemaGroup, (Object)schema.getSchemaGroup());
        Assert.assertEquals((Object)description, (Object)schema.getDescription());
        schemaGroup = "new group";
        description = "new description";
        schema.setCompatibility(SchemaCompatibility.BOTH);
        schema.setValidationLevel(SchemaValidation.ALL);
        schema.setCanEvolve(true);
        schema.setSchemaGroup(schemaGroup);
        schema.setDescription(description);
        client.alterISchema("hive", "default", schemaName, schema);
        Assert.assertEquals((long)1L, (long)preEvents.get(PreEventContext.PreEventType.ALTER_ISCHEMA).intValue());
        Assert.assertEquals((long)1L, (long)events.get(EventMessage.EventType.ALTER_ISCHEMA).intValue());
        Assert.assertEquals((long)1L, (long)transactionalEvents.get(EventMessage.EventType.ALTER_ISCHEMA).intValue());
        schema = client.getISchema("hive", "default", schemaName);
        Assert.assertEquals((long)2L, (long)preEvents.get(PreEventContext.PreEventType.READ_ISCHEMA).intValue());
        Assert.assertEquals((Object)SchemaType.AVRO, (Object)schema.getSchemaType());
        Assert.assertEquals((Object)schemaName, (Object)schema.getName());
        Assert.assertEquals((Object)SchemaCompatibility.BOTH, (Object)schema.getCompatibility());
        Assert.assertEquals((Object)SchemaValidation.ALL, (Object)schema.getValidationLevel());
        Assert.assertTrue((boolean)schema.isCanEvolve());
        Assert.assertEquals((Object)schemaGroup, (Object)schema.getSchemaGroup());
        Assert.assertEquals((Object)description, (Object)schema.getDescription());
        client.dropISchema("hive", "default", schemaName);
        Assert.assertEquals((long)1L, (long)preEvents.get(PreEventContext.PreEventType.DROP_ISCHEMA).intValue());
        Assert.assertEquals((long)1L, (long)events.get(EventMessage.EventType.DROP_ISCHEMA).intValue());
        Assert.assertEquals((long)1L, (long)transactionalEvents.get(EventMessage.EventType.DROP_ISCHEMA).intValue());
        try {
            client.getISchema("hive", "default", schemaName);
            Assert.fail();
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    @Test
    public void iSchemaOtherDatabase() throws TException {
        String catName = "other_cat";
        Catalog cat = new CatalogBuilder().setName(catName).setLocation(MetaStoreTestUtils.getTestWarehouseDir(catName)).build();
        client.createCatalog(cat);
        String dbName = "other_db";
        Database db = new DatabaseBuilder().setName(dbName).setCatalogName(catName).create(client, conf);
        String schemaName = this.uniqueSchemaName();
        String schemaGroup = "group1";
        String description = "This is a description";
        ISchema schema = new ISchemaBuilder().setSchemaType(SchemaType.AVRO).setName(schemaName).inDb(db).setCompatibility(SchemaCompatibility.FORWARD).setValidationLevel(SchemaValidation.LATEST).setCanEvolve(false).setSchemaGroup(schemaGroup).setDescription(description).build();
        client.createISchema(schema);
        schema = client.getISchema(catName, dbName, schemaName);
        Assert.assertEquals((Object)SchemaType.AVRO, (Object)schema.getSchemaType());
        Assert.assertEquals((Object)schemaName, (Object)schema.getName());
        Assert.assertEquals((Object)catName, (Object)schema.getCatName());
        Assert.assertEquals((Object)dbName, (Object)schema.getDbName());
        Assert.assertEquals((Object)SchemaCompatibility.FORWARD, (Object)schema.getCompatibility());
        Assert.assertEquals((Object)SchemaValidation.LATEST, (Object)schema.getValidationLevel());
        Assert.assertFalse((boolean)schema.isCanEvolve());
        Assert.assertEquals((Object)schemaGroup, (Object)schema.getSchemaGroup());
        Assert.assertEquals((Object)description, (Object)schema.getDescription());
        schemaGroup = "new group";
        description = "new description";
        schema.setCompatibility(SchemaCompatibility.BOTH);
        schema.setValidationLevel(SchemaValidation.ALL);
        schema.setCanEvolve(true);
        schema.setSchemaGroup(schemaGroup);
        schema.setDescription(description);
        client.alterISchema(catName, dbName, schemaName, schema);
        schema = client.getISchema(catName, dbName, schemaName);
        Assert.assertEquals((Object)SchemaType.AVRO, (Object)schema.getSchemaType());
        Assert.assertEquals((Object)schemaName, (Object)schema.getName());
        Assert.assertEquals((Object)catName, (Object)schema.getCatName());
        Assert.assertEquals((Object)dbName, (Object)schema.getDbName());
        Assert.assertEquals((Object)SchemaCompatibility.BOTH, (Object)schema.getCompatibility());
        Assert.assertEquals((Object)SchemaValidation.ALL, (Object)schema.getValidationLevel());
        Assert.assertTrue((boolean)schema.isCanEvolve());
        Assert.assertEquals((Object)schemaGroup, (Object)schema.getSchemaGroup());
        Assert.assertEquals((Object)description, (Object)schema.getDescription());
        client.dropISchema(catName, dbName, schemaName);
        try {
            client.getISchema(catName, dbName, schemaName);
            Assert.fail();
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    @Test(expected=NoSuchObjectException.class)
    public void schemaWithInvalidDatabase() throws TException {
        ISchema schema = new ISchemaBuilder().setName("thisSchemaDoesntHaveADb").setDbName("no.such.database").setSchemaType(SchemaType.AVRO).build();
        client.createISchema(schema);
    }

    @Test(expected=AlreadyExistsException.class)
    public void schemaAlreadyExists() throws TException {
        String schemaName = this.uniqueSchemaName();
        ISchema schema = new ISchemaBuilder().setSchemaType(SchemaType.HIVE).setName(schemaName).build();
        client.createISchema(schema);
        Assert.assertNotNull((Object)schema);
        Assert.assertEquals((Object)SchemaType.HIVE, (Object)schema.getSchemaType());
        Assert.assertEquals((Object)schemaName, (Object)schema.getName());
        Assert.assertEquals((Object)SchemaCompatibility.BACKWARD, (Object)schema.getCompatibility());
        Assert.assertEquals((Object)SchemaValidation.ALL, (Object)schema.getValidationLevel());
        Assert.assertTrue((boolean)schema.isCanEvolve());
        client.createISchema(schema);
    }

    @Test(expected=NoSuchObjectException.class)
    public void alterNonExistentSchema() throws TException {
        String schemaName = this.uniqueSchemaName();
        ISchema schema = new ISchemaBuilder().setSchemaType(SchemaType.HIVE).setName(schemaName).setDescription("a new description").build();
        client.alterISchema("hive", "default", schemaName, schema);
    }

    @Test(expected=NoSuchObjectException.class)
    public void dropNonExistentSchema() throws TException {
        client.dropISchema("hive", "default", "no_such_schema");
    }

    @Test(expected=NoSuchObjectException.class)
    public void createVersionOfNonExistentSchema() throws TException {
        SchemaVersion schemaVersion = ((SchemaVersionBuilder)new SchemaVersionBuilder().setSchemaName("noSchemaOfThisNameExists").setVersion(1).addCol("a", "string")).build();
        client.addSchemaVersion(schemaVersion);
    }

    @Test
    public void addSchemaVersion() throws TException {
        String schemaName = this.uniqueSchemaName();
        int version = 1;
        ISchema schema = new ISchemaBuilder().setSchemaType(SchemaType.AVRO).setName(schemaName).build();
        client.createISchema(schema);
        String description = "very descriptive";
        String schemaText = "this should look like json, but oh well";
        String fingerprint = "this should be an md5 string";
        String versionName = "why would I name a version?";
        long creationTime = 10L;
        String serdeName = "serde_for_schema37";
        String serializer = "org.apache.hadoop.hive.metastore.test.Serializer";
        String deserializer = "org.apache.hadoop.hive.metastore.test.Deserializer";
        String serdeDescription = "how do you describe a serde?";
        SchemaVersion schemaVersion = ((SchemaVersionBuilder)((SchemaVersionBuilder)((SchemaVersionBuilder)((SchemaVersionBuilder)((SchemaVersionBuilder)((SchemaVersionBuilder)new SchemaVersionBuilder().versionOf(schema).setVersion(version).addCol("a", "int")).addCol("b", "float")).setCreatedAt(creationTime).setState(SchemaVersionState.INITIATED).setDescription(description).setSchemaText(schemaText).setFingerprint(fingerprint).setName(versionName).setSerdeName(serdeName)).setSerdeSerializerClass(serializer)).setSerdeDeserializerClass(deserializer)).setSerdeDescription(serdeDescription)).build();
        client.addSchemaVersion(schemaVersion);
        Assert.assertEquals((long)1L, (long)preEvents.get(PreEventContext.PreEventType.ADD_SCHEMA_VERSION).intValue());
        Assert.assertEquals((long)1L, (long)events.get(EventMessage.EventType.ADD_SCHEMA_VERSION).intValue());
        Assert.assertEquals((long)1L, (long)transactionalEvents.get(EventMessage.EventType.ADD_SCHEMA_VERSION).intValue());
        schemaVersion = client.getSchemaVersion("hive", "default", schemaName, version);
        Assert.assertNotNull((Object)schemaVersion);
        Assert.assertEquals((Object)schemaName, (Object)schemaVersion.getSchema().getSchemaName());
        Assert.assertEquals((Object)"default", (Object)schemaVersion.getSchema().getDbName());
        Assert.assertEquals((Object)"hive", (Object)schemaVersion.getSchema().getCatName());
        Assert.assertEquals((long)version, (long)schemaVersion.getVersion());
        Assert.assertEquals((long)creationTime, (long)schemaVersion.getCreatedAt());
        Assert.assertEquals((Object)SchemaVersionState.INITIATED, (Object)schemaVersion.getState());
        Assert.assertEquals((Object)description, (Object)schemaVersion.getDescription());
        Assert.assertEquals((Object)schemaText, (Object)schemaVersion.getSchemaText());
        Assert.assertEquals((Object)fingerprint, (Object)schemaVersion.getFingerprint());
        Assert.assertEquals((Object)versionName, (Object)schemaVersion.getName());
        Assert.assertEquals((Object)serdeName, (Object)schemaVersion.getSerDe().getName());
        Assert.assertEquals((Object)serializer, (Object)schemaVersion.getSerDe().getSerializerClass());
        Assert.assertEquals((Object)deserializer, (Object)schemaVersion.getSerDe().getDeserializerClass());
        Assert.assertEquals((Object)serdeDescription, (Object)schemaVersion.getSerDe().getDescription());
        Assert.assertEquals((long)2L, (long)schemaVersion.getColsSize());
        List cols = schemaVersion.getCols();
        Collections.sort(cols);
        Assert.assertEquals((Object)"a", (Object)((FieldSchema)cols.get(0)).getName());
        Assert.assertEquals((Object)"int", (Object)((FieldSchema)cols.get(0)).getType());
        Assert.assertEquals((Object)"b", (Object)((FieldSchema)cols.get(1)).getName());
        Assert.assertEquals((Object)"float", (Object)((FieldSchema)cols.get(1)).getType());
        Assert.assertEquals((long)1L, (long)preEvents.get(PreEventContext.PreEventType.READ_SCHEMA_VERSION).intValue());
        client.dropSchemaVersion("hive", "default", schemaName, version);
        Assert.assertEquals((long)1L, (long)preEvents.get(PreEventContext.PreEventType.DROP_SCHEMA_VERSION).intValue());
        Assert.assertEquals((long)1L, (long)events.get(EventMessage.EventType.DROP_SCHEMA_VERSION).intValue());
        Assert.assertEquals((long)1L, (long)transactionalEvents.get(EventMessage.EventType.DROP_SCHEMA_VERSION).intValue());
        try {
            client.getSchemaVersion("hive", "default", schemaName, version);
            Assert.fail();
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    @Test
    public void addSchemaVersionOtherDb() throws TException {
        String catName = "other_cat_for_schema_version";
        Catalog cat = new CatalogBuilder().setName(catName).setLocation(MetaStoreTestUtils.getTestWarehouseDir(catName)).build();
        client.createCatalog(cat);
        String dbName = "other_db_for_schema_version";
        Database db = new DatabaseBuilder().setName(dbName).setCatalogName(catName).create(client, conf);
        String schemaName = this.uniqueSchemaName();
        int version = 1;
        ISchema schema = new ISchemaBuilder().inDb(db).setSchemaType(SchemaType.AVRO).setName(schemaName).build();
        client.createISchema(schema);
        String description = "very descriptive";
        String schemaText = "this should look like json, but oh well";
        String fingerprint = "this should be an md5 string";
        String versionName = "why would I name a version?";
        long creationTime = 10L;
        String serdeName = "serde_for_schema37";
        String serializer = "org.apache.hadoop.hive.metastore.test.Serializer";
        String deserializer = "org.apache.hadoop.hive.metastore.test.Deserializer";
        String serdeDescription = "how do you describe a serde?";
        SchemaVersion schemaVersion = ((SchemaVersionBuilder)((SchemaVersionBuilder)((SchemaVersionBuilder)((SchemaVersionBuilder)((SchemaVersionBuilder)((SchemaVersionBuilder)new SchemaVersionBuilder().versionOf(schema).setVersion(version).addCol("a", "int")).addCol("b", "float")).setCreatedAt(creationTime).setState(SchemaVersionState.INITIATED).setDescription(description).setSchemaText(schemaText).setFingerprint(fingerprint).setName(versionName).setSerdeName(serdeName)).setSerdeSerializerClass(serializer)).setSerdeDeserializerClass(deserializer)).setSerdeDescription(serdeDescription)).build();
        client.addSchemaVersion(schemaVersion);
        schemaVersion = client.getSchemaVersion(catName, dbName, schemaName, version);
        Assert.assertNotNull((Object)schemaVersion);
        Assert.assertEquals((Object)schemaName, (Object)schemaVersion.getSchema().getSchemaName());
        Assert.assertEquals((Object)dbName, (Object)schemaVersion.getSchema().getDbName());
        Assert.assertEquals((Object)catName, (Object)schemaVersion.getSchema().getCatName());
        Assert.assertEquals((long)version, (long)schemaVersion.getVersion());
        Assert.assertEquals((long)creationTime, (long)schemaVersion.getCreatedAt());
        Assert.assertEquals((Object)SchemaVersionState.INITIATED, (Object)schemaVersion.getState());
        Assert.assertEquals((Object)description, (Object)schemaVersion.getDescription());
        Assert.assertEquals((Object)schemaText, (Object)schemaVersion.getSchemaText());
        Assert.assertEquals((Object)fingerprint, (Object)schemaVersion.getFingerprint());
        Assert.assertEquals((Object)versionName, (Object)schemaVersion.getName());
        Assert.assertEquals((Object)serdeName, (Object)schemaVersion.getSerDe().getName());
        Assert.assertEquals((Object)serializer, (Object)schemaVersion.getSerDe().getSerializerClass());
        Assert.assertEquals((Object)deserializer, (Object)schemaVersion.getSerDe().getDeserializerClass());
        Assert.assertEquals((Object)serdeDescription, (Object)schemaVersion.getSerDe().getDescription());
        Assert.assertEquals((long)2L, (long)schemaVersion.getColsSize());
        List cols = schemaVersion.getCols();
        Collections.sort(cols);
        Assert.assertEquals((Object)"a", (Object)((FieldSchema)cols.get(0)).getName());
        Assert.assertEquals((Object)"int", (Object)((FieldSchema)cols.get(0)).getType());
        Assert.assertEquals((Object)"b", (Object)((FieldSchema)cols.get(1)).getName());
        Assert.assertEquals((Object)"float", (Object)((FieldSchema)cols.get(1)).getType());
        Assert.assertEquals((long)1L, (long)preEvents.get(PreEventContext.PreEventType.READ_SCHEMA_VERSION).intValue());
        client.dropSchemaVersion(catName, dbName, schemaName, version);
        try {
            client.getSchemaVersion(catName, dbName, schemaName, version);
            Assert.fail();
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    @Test
    public void multipleSchemaVersions() throws TException {
        String schemaName = this.uniqueSchemaName();
        ISchema schema = new ISchemaBuilder().setSchemaType(SchemaType.AVRO).setName(schemaName).build();
        client.createISchema(schema);
        SchemaVersion schemaVersion = ((SchemaVersionBuilder)new SchemaVersionBuilder().versionOf(schema).setVersion(1).addCol("a", "bigint")).build();
        client.addSchemaVersion(schemaVersion);
        schemaVersion = ((SchemaVersionBuilder)((SchemaVersionBuilder)new SchemaVersionBuilder().versionOf(schema).setVersion(2).addCol("a", "bigint")).addCol("b", "date")).build();
        client.addSchemaVersion(schemaVersion);
        schemaVersion = ((SchemaVersionBuilder)((SchemaVersionBuilder)((SchemaVersionBuilder)new SchemaVersionBuilder().versionOf(schema).setVersion(3).addCol("a", "bigint")).addCol("b", "date")).addCol("c", "timestamp")).build();
        client.addSchemaVersion(schemaVersion);
        Assert.assertEquals((long)3L, (long)preEvents.get(PreEventContext.PreEventType.ADD_SCHEMA_VERSION).intValue());
        Assert.assertEquals((long)3L, (long)events.get(EventMessage.EventType.ADD_SCHEMA_VERSION).intValue());
        Assert.assertEquals((long)3L, (long)transactionalEvents.get(EventMessage.EventType.ADD_SCHEMA_VERSION).intValue());
        schemaVersion = client.getSchemaLatestVersion("hive", "default", schemaName);
        Assert.assertEquals((long)3L, (long)schemaVersion.getVersion());
        Assert.assertEquals((long)3L, (long)schemaVersion.getColsSize());
        List cols = schemaVersion.getCols();
        Collections.sort(cols);
        Assert.assertEquals((Object)"a", (Object)((FieldSchema)cols.get(0)).getName());
        Assert.assertEquals((Object)"b", (Object)((FieldSchema)cols.get(1)).getName());
        Assert.assertEquals((Object)"c", (Object)((FieldSchema)cols.get(2)).getName());
        Assert.assertEquals((Object)"bigint", (Object)((FieldSchema)cols.get(0)).getType());
        Assert.assertEquals((Object)"date", (Object)((FieldSchema)cols.get(1)).getType());
        Assert.assertEquals((Object)"timestamp", (Object)((FieldSchema)cols.get(2)).getType());
        Assert.assertEquals((long)1L, (long)preEvents.get(PreEventContext.PreEventType.READ_SCHEMA_VERSION).intValue());
        List versions = client.getSchemaAllVersions("hive", "default", schemaName);
        Assert.assertEquals((long)2L, (long)preEvents.get(PreEventContext.PreEventType.READ_SCHEMA_VERSION).intValue());
        Assert.assertEquals((long)3L, (long)versions.size());
        versions.sort(Comparator.comparingInt(SchemaVersion::getVersion));
        Assert.assertEquals((long)1L, (long)((SchemaVersion)versions.get(0)).getVersion());
        Assert.assertEquals((long)1L, (long)((SchemaVersion)versions.get(0)).getColsSize());
        Assert.assertEquals((Object)"bigint", (Object)((FieldSchema)((SchemaVersion)versions.get(0)).getCols().get(0)).getType());
        Assert.assertEquals((long)2L, (long)((SchemaVersion)versions.get(1)).getVersion());
        Assert.assertEquals((long)2L, (long)((SchemaVersion)versions.get(1)).getColsSize());
        cols = ((SchemaVersion)versions.get(1)).getCols();
        Collections.sort(cols);
        Assert.assertEquals((Object)"a", (Object)((FieldSchema)cols.get(0)).getName());
        Assert.assertEquals((Object)"b", (Object)((FieldSchema)cols.get(1)).getName());
        Assert.assertEquals((Object)"bigint", (Object)((FieldSchema)cols.get(0)).getType());
        Assert.assertEquals((Object)"date", (Object)((FieldSchema)cols.get(1)).getType());
        Assert.assertEquals((long)3L, (long)((SchemaVersion)versions.get(2)).getVersion());
        Assert.assertEquals((long)3L, (long)((SchemaVersion)versions.get(2)).getColsSize());
        cols = ((SchemaVersion)versions.get(2)).getCols();
        Collections.sort(cols);
        Assert.assertEquals((Object)"a", (Object)((FieldSchema)cols.get(0)).getName());
        Assert.assertEquals((Object)"b", (Object)((FieldSchema)cols.get(1)).getName());
        Assert.assertEquals((Object)"c", (Object)((FieldSchema)cols.get(2)).getName());
        Assert.assertEquals((Object)"bigint", (Object)((FieldSchema)cols.get(0)).getType());
        Assert.assertEquals((Object)"date", (Object)((FieldSchema)cols.get(1)).getType());
        Assert.assertEquals((Object)"timestamp", (Object)((FieldSchema)cols.get(2)).getType());
    }

    @Test(expected=NoSuchObjectException.class)
    public void nonExistentSchemaVersion() throws TException {
        String schemaName = this.uniqueSchemaName();
        ISchema schema = new ISchemaBuilder().setSchemaType(SchemaType.AVRO).setName(schemaName).build();
        client.createISchema(schema);
        client.getSchemaVersion("hive", "default", schemaName, 1);
    }

    @Test(expected=NoSuchObjectException.class)
    public void schemaVersionBogusDb() throws TException {
        String schemaName = this.uniqueSchemaName();
        ISchema schema = new ISchemaBuilder().setSchemaType(SchemaType.AVRO).setName(schemaName).build();
        client.createISchema(schema);
        client.getSchemaVersion("hive", "bogus", schemaName, 1);
    }

    @Test(expected=NoSuchObjectException.class)
    public void schemaVersionBogusCatalog() throws TException {
        String schemaName = this.uniqueSchemaName();
        ISchema schema = new ISchemaBuilder().setSchemaType(SchemaType.AVRO).setName(schemaName).build();
        client.createISchema(schema);
        client.getSchemaVersion("bogus", "default", schemaName, 1);
    }

    @Test(expected=NoSuchObjectException.class)
    public void nonExistentSchemaVersionButOtherVersionsExist() throws TException {
        String schemaName = this.uniqueSchemaName();
        ISchema schema = new ISchemaBuilder().setSchemaType(SchemaType.AVRO).setName(schemaName).build();
        client.createISchema(schema);
        SchemaVersion schemaVersion = ((SchemaVersionBuilder)((SchemaVersionBuilder)new SchemaVersionBuilder().versionOf(schema).setVersion(1).addCol("a", "int")).addCol("b", "float")).build();
        client.addSchemaVersion(schemaVersion);
        client.getSchemaVersion("hive", "default", schemaName, 2);
    }

    @Test(expected=NoSuchObjectException.class)
    public void getLatestSchemaButNoVersions() throws TException {
        String schemaName = this.uniqueSchemaName();
        ISchema schema = new ISchemaBuilder().setSchemaType(SchemaType.AVRO).setName(schemaName).build();
        client.createISchema(schema);
        client.getSchemaLatestVersion("hive", "default", schemaName);
    }

    @Test(expected=NoSuchObjectException.class)
    public void getLatestSchemaNoSuchSchema() throws TException {
        client.getSchemaLatestVersion("hive", "default", "no.such.schema.with.this.name");
    }

    @Test(expected=NoSuchObjectException.class)
    public void latestSchemaVersionBogusDb() throws TException {
        String schemaName = this.uniqueSchemaName();
        ISchema schema = new ISchemaBuilder().setSchemaType(SchemaType.AVRO).setName(schemaName).build();
        client.createISchema(schema);
        client.getSchemaLatestVersion("hive", "bogus", schemaName);
    }

    @Test(expected=NoSuchObjectException.class)
    public void latestSchemaVersionBogusCatalog() throws TException {
        String schemaName = this.uniqueSchemaName();
        ISchema schema = new ISchemaBuilder().setSchemaType(SchemaType.AVRO).setName(schemaName).build();
        client.createISchema(schema);
        client.getSchemaLatestVersion("bogus", "default", schemaName);
    }

    @Test(expected=NoSuchObjectException.class)
    public void getAllSchemaButNoVersions() throws TException {
        String schemaName = this.uniqueSchemaName();
        ISchema schema = new ISchemaBuilder().setSchemaType(SchemaType.AVRO).setName(schemaName).build();
        client.createISchema(schema);
        client.getSchemaAllVersions("hive", "default", schemaName);
    }

    @Test(expected=NoSuchObjectException.class)
    public void getAllSchemaNoSuchSchema() throws TException {
        client.getSchemaAllVersions("hive", "default", "no.such.schema.with.this.name");
    }

    @Test(expected=NoSuchObjectException.class)
    public void allSchemaVersionBogusDb() throws TException {
        String schemaName = this.uniqueSchemaName();
        ISchema schema = new ISchemaBuilder().setSchemaType(SchemaType.AVRO).setName(schemaName).build();
        client.createISchema(schema);
        client.getSchemaAllVersions("hive", "bogus", schemaName);
    }

    @Test(expected=NoSuchObjectException.class)
    public void allSchemaVersionBogusCatalog() throws TException {
        String schemaName = this.uniqueSchemaName();
        ISchema schema = new ISchemaBuilder().setSchemaType(SchemaType.AVRO).setName(schemaName).build();
        client.createISchema(schema);
        client.getSchemaAllVersions("bogus", "default", schemaName);
    }

    @Test(expected=AlreadyExistsException.class)
    public void addDuplicateSchemaVersion() throws TException {
        String schemaName = this.uniqueSchemaName();
        int version = 1;
        ISchema schema = new ISchemaBuilder().setSchemaType(SchemaType.AVRO).setName(schemaName).build();
        client.createISchema(schema);
        SchemaVersion schemaVersion = ((SchemaVersionBuilder)((SchemaVersionBuilder)new SchemaVersionBuilder().versionOf(schema).setVersion(version).addCol("a", "int")).addCol("b", "float")).build();
        client.addSchemaVersion(schemaVersion);
        client.addSchemaVersion(schemaVersion);
    }

    @Test(expected=NoSuchObjectException.class)
    public void mapSerDeNoSuchSchema() throws TException {
        SerDeInfo serDeInfo = new SerDeInfo(this.uniqueSerdeName(), "lib", Collections.emptyMap());
        client.mapSchemaVersionToSerde("hive", "default", this.uniqueSchemaName(), 1, serDeInfo.getName());
    }

    @Test(expected=NoSuchObjectException.class)
    public void mapSerDeNoSuchSchemaVersion() throws TException {
        SerDeInfo serDeInfo = new SerDeInfo(this.uniqueSerdeName(), "lib", Collections.emptyMap());
        ISchema schema = new ISchemaBuilder().setSchemaType(SchemaType.AVRO).setName(this.uniqueSchemaName()).build();
        client.createISchema(schema);
        client.mapSchemaVersionToSerde("hive", "default", schema.getName(), 3, serDeInfo.getName());
    }

    @Test(expected=NoSuchObjectException.class)
    public void mapNonExistentSerdeToSchemaVersion() throws TException {
        ISchema schema = new ISchemaBuilder().setSchemaType(SchemaType.AVRO).setName(this.uniqueSchemaName()).build();
        client.createISchema(schema);
        SchemaVersion schemaVersion = ((SchemaVersionBuilder)new SchemaVersionBuilder().versionOf(schema).setVersion(1).addCol("x", "boolean")).build();
        client.addSchemaVersion(schemaVersion);
        client.mapSchemaVersionToSerde("hive", "default", schema.getName(), schemaVersion.getVersion(), this.uniqueSerdeName());
    }

    @Test
    public void mapSerdeToSchemaVersion() throws TException {
        ISchema schema = new ISchemaBuilder().setSchemaType(SchemaType.AVRO).setName(this.uniqueSchemaName()).build();
        client.createISchema(schema);
        SchemaVersion schemaVersion = ((SchemaVersionBuilder)new SchemaVersionBuilder().versionOf(schema).setVersion(1).addCol("x", "boolean")).build();
        client.addSchemaVersion(schemaVersion);
        SerDeInfo serDeInfo = new SerDeInfo(this.uniqueSerdeName(), "lib", Collections.emptyMap());
        client.addSerDe(serDeInfo);
        client.mapSchemaVersionToSerde("hive", "default", schema.getName(), schemaVersion.getVersion(), serDeInfo.getName());
        schemaVersion = client.getSchemaVersion("hive", "default", schema.getName(), schemaVersion.getVersion());
        Assert.assertEquals((Object)serDeInfo.getName(), (Object)schemaVersion.getSerDe().getName());
        String serDeName = this.uniqueSerdeName();
        schemaVersion = ((SchemaVersionBuilder)((SchemaVersionBuilder)((SchemaVersionBuilder)new SchemaVersionBuilder().versionOf(schema).setVersion(2).addCol("x", "boolean")).setSerdeName(serDeName)).setSerdeLib("x")).build();
        client.addSchemaVersion(schemaVersion);
        schemaVersion = client.getSchemaVersion("hive", "default", schema.getName(), 2);
        Assert.assertEquals((Object)serDeName, (Object)schemaVersion.getSerDe().getName());
        serDeInfo = new SerDeInfo(this.uniqueSerdeName(), "y", Collections.emptyMap());
        client.addSerDe(serDeInfo);
        client.mapSchemaVersionToSerde("hive", "default", schema.getName(), 2, serDeInfo.getName());
        schemaVersion = client.getSchemaVersion("hive", "default", schema.getName(), 2);
        Assert.assertEquals((Object)serDeInfo.getName(), (Object)schemaVersion.getSerDe().getName());
    }

    @Test
    public void mapSerdeToSchemaVersionOtherDb() throws TException {
        String catName = "other_cat_for_map_to";
        Catalog cat = new CatalogBuilder().setName(catName).setLocation(MetaStoreTestUtils.getTestWarehouseDir(catName)).build();
        client.createCatalog(cat);
        String dbName = "map_other_db";
        Database db = new DatabaseBuilder().setName(dbName).setCatalogName(catName).create(client, conf);
        ISchema schema = new ISchemaBuilder().setSchemaType(SchemaType.AVRO).inDb(db).setName(this.uniqueSchemaName()).build();
        client.createISchema(schema);
        SchemaVersion schemaVersion = ((SchemaVersionBuilder)new SchemaVersionBuilder().versionOf(schema).setVersion(1).addCol("x", "boolean")).build();
        client.addSchemaVersion(schemaVersion);
        SerDeInfo serDeInfo = new SerDeInfo(this.uniqueSerdeName(), "lib", Collections.emptyMap());
        client.addSerDe(serDeInfo);
        client.mapSchemaVersionToSerde(catName, dbName, schema.getName(), schemaVersion.getVersion(), serDeInfo.getName());
        schemaVersion = client.getSchemaVersion(catName, dbName, schema.getName(), schemaVersion.getVersion());
        Assert.assertEquals((Object)serDeInfo.getName(), (Object)schemaVersion.getSerDe().getName());
        String serDeName = this.uniqueSerdeName();
        schemaVersion = ((SchemaVersionBuilder)((SchemaVersionBuilder)((SchemaVersionBuilder)new SchemaVersionBuilder().versionOf(schema).setVersion(2).addCol("x", "boolean")).setSerdeName(serDeName)).setSerdeLib("x")).build();
        client.addSchemaVersion(schemaVersion);
        schemaVersion = client.getSchemaVersion(catName, dbName, schema.getName(), 2);
        Assert.assertEquals((Object)serDeName, (Object)schemaVersion.getSerDe().getName());
        serDeInfo = new SerDeInfo(this.uniqueSerdeName(), "y", Collections.emptyMap());
        client.addSerDe(serDeInfo);
        client.mapSchemaVersionToSerde(catName, dbName, schema.getName(), 2, serDeInfo.getName());
        schemaVersion = client.getSchemaVersion(catName, dbName, schema.getName(), 2);
        Assert.assertEquals((Object)serDeInfo.getName(), (Object)schemaVersion.getSerDe().getName());
    }

    @Test
    public void addSerde() throws TException {
        String serdeName = this.uniqueSerdeName();
        SerDeInfo serDeInfo = new SerDeInfo(serdeName, "serdeLib", Collections.singletonMap("a", "b"));
        serDeInfo.setSerializerClass("serializer");
        serDeInfo.setDeserializerClass("deserializer");
        serDeInfo.setDescription("description");
        serDeInfo.setSerdeType(SerdeType.SCHEMA_REGISTRY);
        client.addSerDe(serDeInfo);
        serDeInfo = client.getSerDe(serdeName);
        Assert.assertEquals((Object)serdeName, (Object)serDeInfo.getName());
        Assert.assertEquals((Object)"serdeLib", (Object)serDeInfo.getSerializationLib());
        Assert.assertEquals((long)1L, (long)serDeInfo.getParametersSize());
        Assert.assertEquals((Object)"b", serDeInfo.getParameters().get("a"));
        Assert.assertEquals((Object)"serializer", (Object)serDeInfo.getSerializerClass());
        Assert.assertEquals((Object)"deserializer", (Object)serDeInfo.getDeserializerClass());
        Assert.assertEquals((Object)"description", (Object)serDeInfo.getDescription());
        Assert.assertEquals((Object)SerdeType.SCHEMA_REGISTRY, (Object)serDeInfo.getSerdeType());
    }

    @Test(expected=AlreadyExistsException.class)
    public void duplicateSerde() throws TException {
        String serdeName = this.uniqueSerdeName();
        SerDeInfo serDeInfo = new SerDeInfo(serdeName, "x", Collections.emptyMap());
        client.addSerDe(serDeInfo);
        client.addSerDe(serDeInfo);
    }

    @Test(expected=NoSuchObjectException.class)
    public void noSuchSerDe() throws TException {
        client.getSerDe(this.uniqueSerdeName());
    }

    @Test(expected=NoSuchObjectException.class)
    public void setVersionStateNoSuchSchema() throws TException {
        client.setSchemaVersionState("hive", "default", "no.such.schema", 1, SchemaVersionState.INITIATED);
    }

    @Test(expected=NoSuchObjectException.class)
    public void setVersionStateNoSuchVersion() throws TException {
        String schemaName = this.uniqueSchemaName();
        ISchema schema = new ISchemaBuilder().setSchemaType(SchemaType.AVRO).setName(schemaName).build();
        client.createISchema(schema);
        client.setSchemaVersionState("hive", "default", schemaName, 1, SchemaVersionState.INITIATED);
    }

    @Test
    public void setVersionState() throws TException {
        String schemaName = this.uniqueSchemaName();
        ISchema schema = new ISchemaBuilder().setSchemaType(SchemaType.AVRO).setName(schemaName).build();
        client.createISchema(schema);
        SchemaVersion schemaVersion = ((SchemaVersionBuilder)new SchemaVersionBuilder().versionOf(schema).setVersion(1).addCol("a", "binary")).build();
        client.addSchemaVersion(schemaVersion);
        schemaVersion = client.getSchemaVersion("hive", "default", schemaName, 1);
        Assert.assertNull((Object)schemaVersion.getState());
        client.setSchemaVersionState("hive", "default", schemaName, 1, SchemaVersionState.INITIATED);
        Assert.assertEquals((long)1L, (long)preEvents.get(PreEventContext.PreEventType.ALTER_SCHEMA_VERSION).intValue());
        Assert.assertEquals((long)1L, (long)events.get(EventMessage.EventType.ALTER_SCHEMA_VERSION).intValue());
        Assert.assertEquals((long)1L, (long)transactionalEvents.get(EventMessage.EventType.ALTER_SCHEMA_VERSION).intValue());
        schemaVersion = client.getSchemaVersion("hive", "default", schemaName, 1);
        Assert.assertEquals((Object)SchemaVersionState.INITIATED, (Object)schemaVersion.getState());
        client.setSchemaVersionState("hive", "default", schemaName, 1, SchemaVersionState.REVIEWED);
        Assert.assertEquals((long)2L, (long)preEvents.get(PreEventContext.PreEventType.ALTER_SCHEMA_VERSION).intValue());
        Assert.assertEquals((long)2L, (long)events.get(EventMessage.EventType.ALTER_SCHEMA_VERSION).intValue());
        Assert.assertEquals((long)2L, (long)transactionalEvents.get(EventMessage.EventType.ALTER_SCHEMA_VERSION).intValue());
        schemaVersion = client.getSchemaVersion("hive", "default", schemaName, 1);
        Assert.assertEquals((Object)SchemaVersionState.REVIEWED, (Object)schemaVersion.getState());
    }

    @Test
    public void setVersionStateOtherDb() throws TException {
        String catName = "other_cat_for_set_version";
        Catalog cat = new CatalogBuilder().setName(catName).setLocation(MetaStoreTestUtils.getTestWarehouseDir(catName)).build();
        client.createCatalog(cat);
        String dbName = "other_db_set_state";
        Database db = new DatabaseBuilder().setName(dbName).setCatalogName(catName).create(client, conf);
        String schemaName = this.uniqueSchemaName();
        ISchema schema = new ISchemaBuilder().setSchemaType(SchemaType.AVRO).setName(schemaName).inDb(db).build();
        client.createISchema(schema);
        SchemaVersion schemaVersion = ((SchemaVersionBuilder)new SchemaVersionBuilder().versionOf(schema).setVersion(1).addCol("a", "binary")).build();
        client.addSchemaVersion(schemaVersion);
        schemaVersion = client.getSchemaVersion(catName, dbName, schemaName, 1);
        Assert.assertNull((Object)schemaVersion.getState());
        client.setSchemaVersionState(catName, dbName, schemaName, 1, SchemaVersionState.INITIATED);
        Assert.assertEquals((long)1L, (long)preEvents.get(PreEventContext.PreEventType.ALTER_SCHEMA_VERSION).intValue());
        Assert.assertEquals((long)1L, (long)events.get(EventMessage.EventType.ALTER_SCHEMA_VERSION).intValue());
        Assert.assertEquals((long)1L, (long)transactionalEvents.get(EventMessage.EventType.ALTER_SCHEMA_VERSION).intValue());
        schemaVersion = client.getSchemaVersion(catName, dbName, schemaName, 1);
        Assert.assertEquals((Object)SchemaVersionState.INITIATED, (Object)schemaVersion.getState());
        client.setSchemaVersionState(catName, dbName, schemaName, 1, SchemaVersionState.REVIEWED);
        Assert.assertEquals((long)2L, (long)preEvents.get(PreEventContext.PreEventType.ALTER_SCHEMA_VERSION).intValue());
        Assert.assertEquals((long)2L, (long)events.get(EventMessage.EventType.ALTER_SCHEMA_VERSION).intValue());
        Assert.assertEquals((long)2L, (long)transactionalEvents.get(EventMessage.EventType.ALTER_SCHEMA_VERSION).intValue());
        schemaVersion = client.getSchemaVersion(catName, dbName, schemaName, 1);
        Assert.assertEquals((Object)SchemaVersionState.REVIEWED, (Object)schemaVersion.getState());
    }

    @Test(expected=NoSuchObjectException.class)
    public void dropNonExistentSchemaVersion() throws TException {
        client.dropSchemaVersion("hive", "default", "ther is no schema named this", 23);
    }

    @Test
    public void schemaQuery() throws TException {
        String dbName = "schema_query_db";
        Database db = new DatabaseBuilder().setName(dbName).create(client, conf);
        String schemaName1 = this.uniqueSchemaName();
        ISchema schema1 = new ISchemaBuilder().setSchemaType(SchemaType.AVRO).setDbName(dbName).setName(schemaName1).build();
        client.createISchema(schema1);
        String schemaName2 = this.uniqueSchemaName();
        ISchema schema2 = new ISchemaBuilder().setSchemaType(SchemaType.AVRO).setDbName(dbName).setName(schemaName2).build();
        client.createISchema(schema2);
        SchemaVersion schemaVersion1_1 = ((SchemaVersionBuilder)((SchemaVersionBuilder)new SchemaVersionBuilder().versionOf(schema1).setVersion(1).addCol("alpha", "bigint")).addCol("beta", "date")).build();
        client.addSchemaVersion(schemaVersion1_1);
        SchemaVersion schemaVersion1_2 = ((SchemaVersionBuilder)((SchemaVersionBuilder)((SchemaVersionBuilder)new SchemaVersionBuilder().versionOf(schema1).setVersion(2).addCol("alpha", "bigint")).addCol("beta", "date")).addCol("gamma", "bigint", "namespace=x")).build();
        client.addSchemaVersion(schemaVersion1_2);
        SchemaVersion schemaVersion2_1 = ((SchemaVersionBuilder)((SchemaVersionBuilder)new SchemaVersionBuilder().versionOf(schema2).setVersion(1).addCol("ALPHA", "smallint")).addCol("delta", "double")).build();
        client.addSchemaVersion(schemaVersion2_1);
        SchemaVersion schemaVersion2_2 = ((SchemaVersionBuilder)((SchemaVersionBuilder)((SchemaVersionBuilder)new SchemaVersionBuilder().versionOf(schema2).setVersion(2).addCol("ALPHA", "smallint")).addCol("delta", "double")).addCol("epsilon", "string", "namespace=x")).build();
        client.addSchemaVersion(schemaVersion2_2);
        FindSchemasByColsRqst rqst = new FindSchemasByColsRqst();
        rqst.setColName("x");
        rqst.setColNamespace("y");
        rqst.setType("z");
        FindSchemasByColsResp rsp = client.getSchemaByCols(rqst);
        Assert.assertEquals((long)0L, (long)rsp.getSchemaVersionsSize());
        rqst = new FindSchemasByColsRqst();
        rqst.setColName("gamma");
        rsp = client.getSchemaByCols(rqst);
        Assert.assertEquals((long)1L, (long)rsp.getSchemaVersionsSize());
        Assert.assertEquals((Object)schemaName1, (Object)((SchemaVersionDescriptor)rsp.getSchemaVersions().get(0)).getSchema().getSchemaName());
        Assert.assertEquals((Object)dbName, (Object)((SchemaVersionDescriptor)rsp.getSchemaVersions().get(0)).getSchema().getDbName());
        Assert.assertEquals((long)2L, (long)((SchemaVersionDescriptor)rsp.getSchemaVersions().get(0)).getVersion());
        rqst = new FindSchemasByColsRqst();
        rqst.setColName("beta");
        rsp = client.getSchemaByCols(rqst);
        Assert.assertEquals((long)2L, (long)rsp.getSchemaVersionsSize());
        ArrayList results = new ArrayList(rsp.getSchemaVersions());
        Collections.sort(results);
        Assert.assertEquals((Object)schemaName1, (Object)((SchemaVersionDescriptor)results.get(0)).getSchema().getSchemaName());
        Assert.assertEquals((Object)dbName, (Object)((SchemaVersionDescriptor)results.get(0)).getSchema().getDbName());
        Assert.assertEquals((long)1L, (long)((SchemaVersionDescriptor)results.get(0)).getVersion());
        Assert.assertEquals((Object)schemaName1, (Object)((SchemaVersionDescriptor)results.get(1)).getSchema().getSchemaName());
        Assert.assertEquals((Object)dbName, (Object)((SchemaVersionDescriptor)results.get(1)).getSchema().getDbName());
        Assert.assertEquals((long)2L, (long)((SchemaVersionDescriptor)results.get(1)).getVersion());
        rqst = new FindSchemasByColsRqst();
        rqst.setColName("alpha");
        rsp = client.getSchemaByCols(rqst);
        Assert.assertEquals((long)4L, (long)rsp.getSchemaVersionsSize());
        results = new ArrayList(rsp.getSchemaVersions());
        Collections.sort(results);
        Assert.assertEquals((Object)schemaName1, (Object)((SchemaVersionDescriptor)results.get(0)).getSchema().getSchemaName());
        Assert.assertEquals((Object)dbName, (Object)((SchemaVersionDescriptor)results.get(0)).getSchema().getDbName());
        Assert.assertEquals((long)1L, (long)((SchemaVersionDescriptor)results.get(0)).getVersion());
        Assert.assertEquals((Object)schemaName1, (Object)((SchemaVersionDescriptor)results.get(1)).getSchema().getSchemaName());
        Assert.assertEquals((Object)dbName, (Object)((SchemaVersionDescriptor)results.get(1)).getSchema().getDbName());
        Assert.assertEquals((long)2L, (long)((SchemaVersionDescriptor)results.get(1)).getVersion());
        Assert.assertEquals((Object)schemaName2, (Object)((SchemaVersionDescriptor)results.get(2)).getSchema().getSchemaName());
        Assert.assertEquals((Object)dbName, (Object)((SchemaVersionDescriptor)results.get(2)).getSchema().getDbName());
        Assert.assertEquals((long)1L, (long)((SchemaVersionDescriptor)results.get(2)).getVersion());
        Assert.assertEquals((Object)schemaName2, (Object)((SchemaVersionDescriptor)results.get(3)).getSchema().getSchemaName());
        Assert.assertEquals((Object)dbName, (Object)((SchemaVersionDescriptor)results.get(3)).getSchema().getDbName());
        Assert.assertEquals((long)2L, (long)((SchemaVersionDescriptor)results.get(3)).getVersion());
        rqst = new FindSchemasByColsRqst();
        rqst.setColNamespace("namespace=x");
        rsp = client.getSchemaByCols(rqst);
        Assert.assertEquals((long)2L, (long)rsp.getSchemaVersionsSize());
        results = new ArrayList(rsp.getSchemaVersions());
        Collections.sort(results);
        Assert.assertEquals((Object)schemaName1, (Object)((SchemaVersionDescriptor)results.get(0)).getSchema().getSchemaName());
        Assert.assertEquals((Object)dbName, (Object)((SchemaVersionDescriptor)results.get(0)).getSchema().getDbName());
        Assert.assertEquals((long)2L, (long)((SchemaVersionDescriptor)results.get(0)).getVersion());
        Assert.assertEquals((Object)schemaName2, (Object)((SchemaVersionDescriptor)results.get(1)).getSchema().getSchemaName());
        Assert.assertEquals((Object)dbName, (Object)((SchemaVersionDescriptor)results.get(1)).getSchema().getDbName());
        Assert.assertEquals((long)2L, (long)((SchemaVersionDescriptor)results.get(1)).getVersion());
        rqst = new FindSchemasByColsRqst();
        rqst.setColName("alpha");
        rqst.setType("smallint");
        rsp = client.getSchemaByCols(rqst);
        Assert.assertEquals((long)2L, (long)rsp.getSchemaVersionsSize());
        results = new ArrayList(rsp.getSchemaVersions());
        Collections.sort(results);
        Assert.assertEquals((Object)schemaName2, (Object)((SchemaVersionDescriptor)results.get(0)).getSchema().getSchemaName());
        Assert.assertEquals((Object)dbName, (Object)((SchemaVersionDescriptor)results.get(0)).getSchema().getDbName());
        Assert.assertEquals((long)1L, (long)((SchemaVersionDescriptor)results.get(0)).getVersion());
        Assert.assertEquals((Object)schemaName2, (Object)((SchemaVersionDescriptor)results.get(1)).getSchema().getSchemaName());
        Assert.assertEquals((Object)dbName, (Object)((SchemaVersionDescriptor)results.get(1)).getSchema().getDbName());
        Assert.assertEquals((long)2L, (long)((SchemaVersionDescriptor)results.get(1)).getVersion());
        rqst = new FindSchemasByColsRqst();
        rqst.setColName("alpha");
        rqst.setType("string");
        rsp = client.getSchemaByCols(rqst);
        Assert.assertEquals((long)0L, (long)rsp.getSchemaVersionsSize());
    }

    @Test(expected=MetaException.class)
    public void schemaVersionQueryNoNameOrNamespace() throws TException {
        FindSchemasByColsRqst rqst = new FindSchemasByColsRqst();
        rqst.setType("string");
        client.getSchemaByCols(rqst);
    }

    private String uniqueSchemaName() {
        return "uniqueschema" + nextSchemaNum++;
    }

    private String uniqueSerdeName() {
        return "uniqueSerde" + nextSchemaNum++;
    }

    static {
        nextSchemaNum = 1;
    }

    public static class SchemaPreEventListener
    extends MetaStorePreEventListener {
        public SchemaPreEventListener(Configuration config) {
            super(config);
        }

        public void onEvent(PreEventContext context) throws MetaException, NoSuchObjectException, InvalidOperationException {
            Integer cnt = (Integer)preEvents.get(context.getEventType());
            preEvents.put(context.getEventType(), cnt == null ? 1 : cnt + 1);
        }
    }

    public static class TransactionalSchemaEventListener
    extends MetaStoreEventListener {
        public TransactionalSchemaEventListener(Configuration config) {
            super(config);
        }

        public void onCreateISchema(CreateISchemaEvent createISchemaEvent) throws MetaException {
            Integer cnt = (Integer)transactionalEvents.get(EventMessage.EventType.CREATE_ISCHEMA);
            transactionalEvents.put(EventMessage.EventType.CREATE_ISCHEMA, cnt == null ? 1 : cnt + 1);
        }

        public void onAlterISchema(AlterISchemaEvent alterISchemaEvent) throws MetaException {
            Integer cnt = (Integer)transactionalEvents.get(EventMessage.EventType.ALTER_ISCHEMA);
            transactionalEvents.put(EventMessage.EventType.ALTER_ISCHEMA, cnt == null ? 1 : cnt + 1);
        }

        public void onDropISchema(DropISchemaEvent dropISchemaEvent) throws MetaException {
            Integer cnt = (Integer)transactionalEvents.get(EventMessage.EventType.DROP_ISCHEMA);
            transactionalEvents.put(EventMessage.EventType.DROP_ISCHEMA, cnt == null ? 1 : cnt + 1);
        }

        public void onAddSchemaVersion(AddSchemaVersionEvent addSchemaVersionEvent) throws MetaException {
            Integer cnt = (Integer)transactionalEvents.get(EventMessage.EventType.ADD_SCHEMA_VERSION);
            transactionalEvents.put(EventMessage.EventType.ADD_SCHEMA_VERSION, cnt == null ? 1 : cnt + 1);
        }

        public void onAlterSchemaVersion(AlterSchemaVersionEvent alterSchemaVersionEvent) throws MetaException {
            Integer cnt = (Integer)transactionalEvents.get(EventMessage.EventType.ALTER_SCHEMA_VERSION);
            transactionalEvents.put(EventMessage.EventType.ALTER_SCHEMA_VERSION, cnt == null ? 1 : cnt + 1);
        }

        public void onDropSchemaVersion(DropSchemaVersionEvent dropSchemaVersionEvent) throws MetaException {
            Integer cnt = (Integer)transactionalEvents.get(EventMessage.EventType.DROP_SCHEMA_VERSION);
            transactionalEvents.put(EventMessage.EventType.DROP_SCHEMA_VERSION, cnt == null ? 1 : cnt + 1);
        }
    }

    public static class SchemaEventListener
    extends MetaStoreEventListener {
        public SchemaEventListener(Configuration config) {
            super(config);
        }

        public void onCreateISchema(CreateISchemaEvent createISchemaEvent) throws MetaException {
            Integer cnt = (Integer)events.get(EventMessage.EventType.CREATE_ISCHEMA);
            events.put(EventMessage.EventType.CREATE_ISCHEMA, cnt == null ? 1 : cnt + 1);
        }

        public void onAlterISchema(AlterISchemaEvent alterISchemaEvent) throws MetaException {
            Integer cnt = (Integer)events.get(EventMessage.EventType.ALTER_ISCHEMA);
            events.put(EventMessage.EventType.ALTER_ISCHEMA, cnt == null ? 1 : cnt + 1);
        }

        public void onDropISchema(DropISchemaEvent dropISchemaEvent) throws MetaException {
            Integer cnt = (Integer)events.get(EventMessage.EventType.DROP_ISCHEMA);
            events.put(EventMessage.EventType.DROP_ISCHEMA, cnt == null ? 1 : cnt + 1);
        }

        public void onAddSchemaVersion(AddSchemaVersionEvent addSchemaVersionEvent) throws MetaException {
            Integer cnt = (Integer)events.get(EventMessage.EventType.ADD_SCHEMA_VERSION);
            events.put(EventMessage.EventType.ADD_SCHEMA_VERSION, cnt == null ? 1 : cnt + 1);
        }

        public void onAlterSchemaVersion(AlterSchemaVersionEvent alterSchemaVersionEvent) throws MetaException {
            Integer cnt = (Integer)events.get(EventMessage.EventType.ALTER_SCHEMA_VERSION);
            events.put(EventMessage.EventType.ALTER_SCHEMA_VERSION, cnt == null ? 1 : cnt + 1);
        }

        public void onDropSchemaVersion(DropSchemaVersionEvent dropSchemaVersionEvent) throws MetaException {
            Integer cnt = (Integer)events.get(EventMessage.EventType.DROP_SCHEMA_VERSION);
            events.put(EventMessage.EventType.DROP_SCHEMA_VERSION, cnt == null ? 1 : cnt + 1);
        }
    }
}

