/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.GetPartitionsFilterSpec;
import org.apache.hadoop.hive.metastore.api.GetPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsResponse;
import org.apache.hadoop.hive.metastore.api.GetProjectionsSpec;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionFilterMode;
import org.apache.hadoop.hive.metastore.api.PartitionListComposingSpec;
import org.apache.hadoop.hive.metastore.api.PartitionSpec;
import org.apache.hadoop.hive.metastore.api.PartitionSpecWithSharedSD;
import org.apache.hadoop.hive.metastore.api.PartitionWithoutSD;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.PartitionBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.security.HadoopThriftAuthBridge;
import org.apache.thrift.TException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MetastoreCheckinTest.class})
public class TestGetPartitionsUsingProjectionAndFilterSpecs {
    private static final Logger LOG = LoggerFactory.getLogger(TestGetPartitionsUsingProjectionAndFilterSpecs.class);
    protected static Configuration conf = MetastoreConf.newMetastoreConf();
    private static int port;
    private static final String dbName = "test_projection_db";
    private static final String tblName = "test_projection_table";
    private List<Partition> origPartitions;
    private Table tbl;
    private static final String EXCLUDE_KEY_PREFIX = "exclude";
    private HiveMetaStoreClient client;

    @BeforeClass
    public static void startMetaStoreServer() throws Exception {
        conf.set("hive.in.test", "true");
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        MetastoreConf.setLongVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.BATCH_RETRIEVE_MAX, (long)2L);
        MetastoreConf.setLongVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.LIMIT_PARTITION_REQUEST, (long)100L);
        port = MetaStoreTestUtils.startMetaStoreWithRetry(HadoopThriftAuthBridge.getBridge(), conf);
        LOG.info("Starting MetaStore Server on port " + port);
        try (HiveMetaStoreClient client = TestGetPartitionsUsingProjectionAndFilterSpecs.createClient();){
            new DatabaseBuilder().setName(dbName).create((IMetaStoreClient)client, conf);
        }
    }

    @AfterClass
    public static void tearDown() throws Exception {
        try (HiveMetaStoreClient client = TestGetPartitionsUsingProjectionAndFilterSpecs.createClient();){
            client.dropDatabase(dbName, true, true, true);
        }
    }

    @Before
    public void setup() throws TException {
        this.client = TestGetPartitionsUsingProjectionAndFilterSpecs.createClient();
        this.createTestTables();
        this.origPartitions = this.client.listPartitions(dbName, tblName, (short)-1);
        this.tbl = this.client.getTable(dbName, tblName);
        this.client.setMetaConf(MetastoreConf.ConfVars.TRY_DIRECT_SQL.getVarname(), "true");
        this.client.setMetaConf(MetastoreConf.ConfVars.TRY_DIRECT_SQL_DDL.getVarname(), "true");
    }

    @After
    public void cleanup() {
        this.dropTestTables();
        this.client.close();
        this.client = null;
    }

    private void dropTestTables() {
        try {
            this.client.dropTable(dbName, tblName);
        }
        catch (TException tException) {
            // empty catch block
        }
    }

    private void createTestTables() throws TException {
        if (this.client.tableExists(dbName, tblName)) {
            LOG.info("Table is already existing. Dropping it and then recreating");
            this.client.dropTable(dbName, tblName);
        }
        ((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)new TableBuilder().setTableName(tblName).setDbName(dbName).setCols(Arrays.asList(new FieldSchema("col1", "string", "c1 comment"), new FieldSchema("col2", "int", "c2 comment")))).setPartCols(Arrays.asList(new FieldSchema("state", "string", "state comment"), new FieldSchema("city", "string", "city comment"))).setTableParams((Map)new HashMap<String, String>(2){
            {
                this.put("tableparam1", "tableval1");
                this.put("tableparam2", "tableval2");
            }
        }).setBucketCols(Collections.singletonList("col1"))).addSortCol("col2", 1)).addSerdeParam("serialization.format", "1")).setSerdeName(tblName)).setSerdeLib("org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe")).setInputFormat("org.apache.hadoop.hive.ql.io.HiveInputFormat")).setOutputFormat("org.apache.hadoop.hive.ql.io.HiveOutputFormat")).create((IMetaStoreClient)this.client, conf);
        Table table = this.client.getTable(dbName, tblName);
        Assert.assertTrue((String)"Table test_projection_db.test_projection_table does not exist", (boolean)this.client.tableExists(dbName, tblName));
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        partitions.add(this.createPartition(Arrays.asList("CA", "SanFrancisco"), table));
        partitions.add(this.createPartition(Arrays.asList("CA", "PaloAlto"), table));
        partitions.add(this.createPartition(Arrays.asList("WA", "Seattle"), table));
        partitions.add(this.createPartition(Arrays.asList("AZ", "Phoenix"), table));
        this.client.add_partitions(partitions);
    }

    private Partition createPartition(List<String> vals, Table table) throws MetaException {
        return ((PartitionBuilder)((PartitionBuilder)((PartitionBuilder)((PartitionBuilder)((PartitionBuilder)new PartitionBuilder().inTable(table).setValues(vals).addPartParam("key1", "S1").addPartParam("key2", "S2").addPartParam("excludekey1", "e1").addPartParam("excludekey2", "e2").setBucketCols(table.getSd().getBucketCols())).setSortCols(table.getSd().getSortCols())).setSerdeName(table.getSd().getSerdeInfo().getName())).setSerdeLib(table.getSd().getSerdeInfo().getSerializationLib())).setSerdeParams(table.getSd().getSerdeInfo().getParameters())).build(conf);
    }

    private static HiveMetaStoreClient createClient() throws MetaException {
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_URIS, (String)("thrift://localhost:" + port));
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.EXECUTE_SET_UGI, (boolean)false);
        return new HiveMetaStoreClient(conf);
    }

    @Test
    public void testGetPartitions() throws TException {
        GetPartitionsRequest request = this.getGetPartitionsRequest();
        GetPartitionsResponse response = this.client.getPartitionsWithSpecs(request);
        this.validateBasic(response);
    }

    @Test
    public void testPartitionProjectionEmptySpec() throws Throwable {
        GetPartitionsRequest request = this.getGetPartitionsRequest();
        GetProjectionsSpec projectSpec = request.getProjectionSpec();
        projectSpec.setFieldList(new ArrayList(0));
        projectSpec.setExcludeParamKeyPattern("exclude%");
        GetPartitionsResponse response = this.client.getPartitionsWithSpecs(request);
        Assert.assertEquals((long)1L, (long)response.getPartitionSpec().size());
        PartitionSpec partitionSpec = (PartitionSpec)response.getPartitionSpec().get(0);
        PartitionSpecWithSharedSD partitionSpecWithSharedSD = partitionSpec.getSharedSDPartitionSpec();
        StorageDescriptor sharedSD = partitionSpecWithSharedSD.getSd();
        Assert.assertNotNull((Object)sharedSD);
        StorageDescriptor origSd = this.origPartitions.get(0).getSd().deepCopy();
        origSd.unsetLocation();
        StorageDescriptor sharedSDCopy = sharedSD.deepCopy();
        sharedSDCopy.unsetLocation();
        Assert.assertEquals((Object)origSd, (Object)sharedSDCopy);
        List partitionWithoutSDS = partitionSpecWithSharedSD.getPartitions();
        Assert.assertNotNull((Object)partitionWithoutSDS);
        Assert.assertEquals((String)"Unexpected number of partitions returned", (long)this.origPartitions.size(), (long)partitionWithoutSDS.size());
        for (int i = 0; i < this.origPartitions.size(); ++i) {
            Partition origPartition = this.origPartitions.get(i);
            PartitionWithoutSD retPartition = (PartitionWithoutSD)partitionWithoutSDS.get(i);
            Assert.assertEquals((long)origPartition.getCreateTime(), (long)retPartition.getCreateTime());
            Assert.assertEquals((long)origPartition.getLastAccessTime(), (long)retPartition.getLastAccessTime());
            Assert.assertEquals((Object)origPartition.getSd().getLocation(), (Object)(sharedSD.getLocation() + retPartition.getRelativePath()));
            this.validateMap(origPartition.getParameters(), retPartition.getParameters());
            this.validateList(origPartition.getValues(), retPartition.getValues());
        }
    }

    @Test
    public void testPartitionProjectionAllSingleValuedFields() throws Throwable {
        GetPartitionsRequest request = this.getGetPartitionsRequest();
        GetProjectionsSpec projectSpec = request.getProjectionSpec();
        List<String> projectedFields = Arrays.asList("dbName", "tableName", "createTime", "lastAccessTime", "sd.location", "sd.inputFormat", "sd.outputFormat", "sd.compressed", "sd.numBuckets", "sd.serdeInfo.name", "sd.serdeInfo.serializationLib");
        projectSpec.setFieldList(projectedFields);
        GetPartitionsResponse response = this.client.getPartitionsWithSpecs(request);
        Assert.assertEquals((long)1L, (long)response.getPartitionSpec().size());
        PartitionSpec partitionSpec = (PartitionSpec)response.getPartitionSpec().get(0);
        Assert.assertTrue((String)"DbName is not set", (boolean)partitionSpec.isSetDbName());
        Assert.assertTrue((String)"tableName is not set", (boolean)partitionSpec.isSetTableName());
        PartitionSpecWithSharedSD partitionSpecWithSharedSD = partitionSpec.getSharedSDPartitionSpec();
        StorageDescriptor sharedSD = partitionSpecWithSharedSD.getSd();
        Assert.assertNotNull((Object)sharedSD);
        List partitionWithoutSDS = partitionSpecWithSharedSD.getPartitions();
        Assert.assertNotNull((Object)partitionWithoutSDS);
        Assert.assertEquals((long)partitionWithoutSDS.size(), (long)this.origPartitions.size());
        this.comparePartitionForSingleValuedFields(projectedFields, sharedSD, partitionWithoutSDS, 0);
    }

    @Test
    public void testProjectionUsingJDO() throws Throwable {
        this.client.setMetaConf(MetastoreConf.ConfVars.TRY_DIRECT_SQL.getVarname(), "false");
        GetPartitionsRequest request = this.getGetPartitionsRequest();
        GetProjectionsSpec projectSpec = request.getProjectionSpec();
        List<String> projectedFields = Collections.singletonList("sd.location");
        projectSpec.setFieldList(projectedFields);
        GetPartitionsResponse response = this.client.getPartitionsWithSpecs(request);
        Assert.assertEquals((long)1L, (long)response.getPartitionSpec().size());
        PartitionSpec partitionSpec = (PartitionSpec)response.getPartitionSpec().get(0);
        Assert.assertTrue((String)"DbName is not set", (boolean)partitionSpec.isSetDbName());
        Assert.assertTrue((String)"tableName is not set", (boolean)partitionSpec.isSetTableName());
        PartitionSpecWithSharedSD partitionSpecWithSharedSD = partitionSpec.getSharedSDPartitionSpec();
        StorageDescriptor sharedSD = partitionSpecWithSharedSD.getSd();
        Assert.assertNotNull((Object)sharedSD);
        List partitionWithoutSDS = partitionSpecWithSharedSD.getPartitions();
        Assert.assertNotNull((Object)partitionWithoutSDS);
        Assert.assertEquals((long)partitionWithoutSDS.size(), (long)this.origPartitions.size());
        this.comparePartitionForSingleValuedFields(projectedFields, sharedSD, partitionWithoutSDS, 0);
        request = this.getGetPartitionsRequest();
        projectSpec = request.getProjectionSpec();
        projectedFields = Arrays.asList("dbName", "tableName", "createTime", "lastAccessTime", "sd.location", "sd.inputFormat", "sd.outputFormat", "sd.compressed", "sd.numBuckets", "sd.serdeInfo.name", "sd.serdeInfo.serializationLib", "sd.serdeInfo.serdeType", "sd.serdeInfo.serializerClass", "sd.serdeInfo.deserializerClass");
        projectSpec.setFieldList(projectedFields);
        response = this.client.getPartitionsWithSpecs(request);
        Assert.assertEquals((long)1L, (long)response.getPartitionSpec().size());
        partitionSpec = (PartitionSpec)response.getPartitionSpec().get(0);
        Assert.assertTrue((String)"DbName is not set", (boolean)partitionSpec.isSetDbName());
        Assert.assertTrue((String)"tableName is not set", (boolean)partitionSpec.isSetTableName());
        partitionSpecWithSharedSD = partitionSpec.getSharedSDPartitionSpec();
        sharedSD = partitionSpecWithSharedSD.getSd();
        Assert.assertNotNull((Object)sharedSD);
        partitionWithoutSDS = partitionSpecWithSharedSD.getPartitions();
        Assert.assertNotNull((Object)partitionWithoutSDS);
        Assert.assertEquals((long)partitionWithoutSDS.size(), (long)this.origPartitions.size());
        this.comparePartitionForSingleValuedFields(projectedFields, sharedSD, partitionWithoutSDS, 0);
    }

    private void comparePartitionForSingleValuedFields(List<String> projectedFields, StorageDescriptor sharedSD, List<PartitionWithoutSD> partitionWithoutSDS, int partitionWithoutSDSIndex) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        for (Partition origPart : this.origPartitions) {
            for (String projectField : projectedFields) {
                if (projectField.equals("dbName") || projectField.equals("tableName") || projectField.equals("catName")) continue;
                if (projectField.startsWith("sd")) {
                    String sdPropertyName = projectField.substring(projectField.indexOf("sd.") + 3);
                    if (sdPropertyName.equals("location")) {
                        Assert.assertEquals((String)"Location does not match", (Object)origPart.getSd().getLocation(), (Object)(sharedSD.getLocation() + partitionWithoutSDS.get(partitionWithoutSDSIndex).getRelativePath()));
                        continue;
                    }
                    Assert.assertEquals((Object)PropertyUtils.getNestedProperty((Object)origPart, (String)projectField), (Object)PropertyUtils.getNestedProperty((Object)sharedSD, (String)sdPropertyName));
                    continue;
                }
                Assert.assertEquals((Object)PropertyUtils.getNestedProperty((Object)origPart, (String)projectField), (Object)PropertyUtils.getNestedProperty((Object)partitionWithoutSDS.get(partitionWithoutSDSIndex), (String)projectField));
            }
            ++partitionWithoutSDSIndex;
        }
    }

    @Test
    public void testPartitionProjectionAllMultiValuedFields() throws Throwable {
        GetPartitionsRequest request = this.getGetPartitionsRequest();
        GetProjectionsSpec projectSpec = request.getProjectionSpec();
        List<String> projectedFields = Arrays.asList("values", "parameters", "sd.cols", "sd.bucketCols", "sd.sortCols", "sd.parameters", "sd.skewedInfo", "sd.serdeInfo.parameters");
        projectSpec.setFieldList(projectedFields);
        GetPartitionsResponse response = this.client.getPartitionsWithSpecs(request);
        Assert.assertEquals((long)1L, (long)response.getPartitionSpec().size());
        PartitionSpec partitionSpec = (PartitionSpec)response.getPartitionSpec().get(0);
        PartitionSpecWithSharedSD partitionSpecWithSharedSD = partitionSpec.getSharedSDPartitionSpec();
        Assert.assertEquals((long)this.origPartitions.size(), (long)partitionSpecWithSharedSD.getPartitions().size());
        StorageDescriptor sharedSD = partitionSpecWithSharedSD.getSd();
        for (int i = 0; i < this.origPartitions.size(); ++i) {
            Partition origPartition = this.origPartitions.get(i);
            PartitionWithoutSD retPartition = (PartitionWithoutSD)partitionSpecWithSharedSD.getPartitions().get(i);
            Iterator<String> iterator = projectedFields.iterator();
            block21: while (iterator.hasNext()) {
                String projectedField;
                switch (projectedField = iterator.next()) {
                    case "values": {
                        this.validateList(origPartition.getValues(), retPartition.getValues());
                        continue block21;
                    }
                    case "parameters": {
                        this.validateMap(origPartition.getParameters(), retPartition.getParameters());
                        continue block21;
                    }
                    case "sd.cols": {
                        this.validateList(origPartition.getSd().getCols(), sharedSD.getCols());
                        continue block21;
                    }
                    case "sd.bucketCols": {
                        this.validateList(origPartition.getSd().getBucketCols(), sharedSD.getBucketCols());
                        continue block21;
                    }
                    case "sd.sortCols": {
                        this.validateList(origPartition.getSd().getSortCols(), sharedSD.getSortCols());
                        continue block21;
                    }
                    case "sd.parameters": {
                        this.validateMap(origPartition.getSd().getParameters(), sharedSD.getParameters());
                        continue block21;
                    }
                    case "sd.skewedInfo": {
                        if (!origPartition.getSd().getSkewedInfo().getSkewedColNames().isEmpty()) {
                            this.validateList(origPartition.getSd().getSkewedInfo().getSkewedColNames(), sharedSD.getSkewedInfo().getSkewedColNames());
                        }
                        if (!origPartition.getSd().getSkewedInfo().getSkewedColValues().isEmpty()) {
                            for (int i1 = 0; i1 < origPartition.getSd().getSkewedInfo().getSkewedColValuesSize(); ++i1) {
                                this.validateList((List)origPartition.getSd().getSkewedInfo().getSkewedColValues().get(i1), (List)sharedSD.getSkewedInfo().getSkewedColValues().get(i1));
                            }
                        }
                        if (origPartition.getSd().getSkewedInfo().getSkewedColValueLocationMaps().isEmpty()) continue block21;
                        this.validateMap(origPartition.getSd().getSkewedInfo().getSkewedColValueLocationMaps(), sharedSD.getSkewedInfo().getSkewedColValueLocationMaps());
                        continue block21;
                    }
                    case "sd.serdeInfo.parameters": {
                        this.validateMap(origPartition.getSd().getSerdeInfo().getParameters(), sharedSD.getSerdeInfo().getParameters());
                        continue block21;
                    }
                }
                throw new IllegalArgumentException("Invalid field " + projectedField);
            }
        }
    }

    @Test
    public void testPartitionProjectionIncludeParameters() throws Throwable {
        GetPartitionsRequest request = this.getGetPartitionsRequest();
        GetProjectionsSpec projectSpec = request.getProjectionSpec();
        projectSpec.setFieldList(Arrays.asList("dbName", "tableName", "catName", "parameters", "values"));
        projectSpec.setIncludeParamKeyPattern("exclude%");
        GetPartitionsResponse response = this.client.getPartitionsWithSpecs(request);
        PartitionSpecWithSharedSD partitionSpecWithSharedSD = ((PartitionSpec)response.getPartitionSpec().get(0)).getSharedSDPartitionSpec();
        Assert.assertNotNull((String)"All the partitions should be returned in sharedSD spec", (Object)partitionSpecWithSharedSD);
        PartitionListComposingSpec partitionListComposingSpec = ((PartitionSpec)response.getPartitionSpec().get(0)).getPartitionList();
        Assert.assertNull((String)"Partition list composing spec should be null since all the partitions are expected to be in sharedSD spec", (Object)partitionListComposingSpec);
        for (PartitionWithoutSD retPartion : partitionSpecWithSharedSD.getPartitions()) {
            Assert.assertTrue((String)"included parameter key is not found in the response", (boolean)retPartion.getParameters().containsKey("excludekey1"));
            Assert.assertTrue((String)"included parameter key is not found in the response", (boolean)retPartion.getParameters().containsKey("excludekey2"));
            Assert.assertEquals((String)"Additional parameters returned other than inclusion keys", (long)2L, (long)retPartion.getParameters().size());
        }
    }

    @Test
    public void testPartitionProjectionIncludeExcludeParameters() throws Throwable {
        GetPartitionsRequest request = this.getGetPartitionsRequest();
        GetProjectionsSpec projectSpec = request.getProjectionSpec();
        projectSpec.setFieldList(Arrays.asList("dbName", "tableName", "catName", "parameters", "values"));
        projectSpec.setIncludeParamKeyPattern("exclude%");
        projectSpec.setExcludeParamKeyPattern("%key1%");
        GetPartitionsResponse response = this.client.getPartitionsWithSpecs(request);
        PartitionSpecWithSharedSD partitionSpecWithSharedSD = ((PartitionSpec)response.getPartitionSpec().get(0)).getSharedSDPartitionSpec();
        Assert.assertNotNull((String)"All the partitions should be returned in sharedSD spec", (Object)partitionSpecWithSharedSD);
        PartitionListComposingSpec partitionListComposingSpec = ((PartitionSpec)response.getPartitionSpec().get(0)).getPartitionList();
        Assert.assertNull((String)"Partition list composing spec should be null since all the partitions are expected to be in sharedSD spec", (Object)partitionListComposingSpec);
        for (PartitionWithoutSD retPartion : partitionSpecWithSharedSD.getPartitions()) {
            Assert.assertFalse((String)"excluded parameter key is found in the response", (boolean)retPartion.getParameters().containsKey("excludekey1"));
            Assert.assertTrue((String)"included parameter key is not found in the response", (boolean)retPartion.getParameters().containsKey("excludekey2"));
            Assert.assertEquals((String)"Additional parameters returned other than inclusion keys", (long)1L, (long)retPartion.getParameters().size());
        }
    }

    @Test
    public void testPartitionProjectionExcludeParameters() throws Throwable {
        GetPartitionsRequest request = this.getGetPartitionsRequest();
        GetProjectionsSpec projectSpec = request.getProjectionSpec();
        projectSpec.setFieldList(Arrays.asList("dbName", "tableName", "catName", "parameters", "values"));
        projectSpec.setExcludeParamKeyPattern("exclude%");
        GetPartitionsResponse response = this.client.getPartitionsWithSpecs(request);
        PartitionSpecWithSharedSD partitionSpecWithSharedSD = ((PartitionSpec)response.getPartitionSpec().get(0)).getSharedSDPartitionSpec();
        Assert.assertNotNull((String)"All the partitions should be returned in sharedSD spec", (Object)partitionSpecWithSharedSD);
        PartitionListComposingSpec partitionListComposingSpec = ((PartitionSpec)response.getPartitionSpec().get(0)).getPartitionList();
        Assert.assertNull((String)"Partition list composing spec should be null", (Object)partitionListComposingSpec);
        for (PartitionWithoutSD retPartion : partitionSpecWithSharedSD.getPartitions()) {
            Assert.assertFalse((String)"excluded parameter key is found in the response", (boolean)retPartion.getParameters().containsKey("excludekey1"));
            Assert.assertFalse((String)"excluded parameter key is found in the response", (boolean)retPartion.getParameters().containsKey("excludekey2"));
        }
    }

    @Test
    public void testNestedMultiValuedFieldProjection() throws TException {
        GetPartitionsRequest request = this.getGetPartitionsRequest();
        GetProjectionsSpec projectSpec = request.getProjectionSpec();
        projectSpec.setFieldList(Arrays.asList("sd.cols.name", "sd.cols.type"));
        GetPartitionsResponse response = this.client.getPartitionsWithSpecs(request);
        PartitionSpecWithSharedSD partitionSpecWithSharedSD = ((PartitionSpec)response.getPartitionSpec().get(0)).getSharedSDPartitionSpec();
        StorageDescriptor sharedSD = partitionSpecWithSharedSD.getSd();
        Assert.assertNotNull((String)"sd.cols were requested but was not returned", (Object)sharedSD.getCols());
        for (FieldSchema col : sharedSD.getCols()) {
            Assert.assertTrue((String)"sd.cols.name was requested but was not returned", (boolean)col.isSetName());
            Assert.assertTrue((String)"sd.cols.type was requested but was not returned", (boolean)col.isSetType());
            Assert.assertFalse((String)"sd.cols.comment was not requested but was returned", (boolean)col.isSetComment());
        }
    }

    @Test
    public void testParameterExpansion() throws TException {
        GetPartitionsRequest request = this.getGetPartitionsRequest();
        GetProjectionsSpec projectSpec = request.getProjectionSpec();
        projectSpec.setFieldList(Arrays.asList("sd.cols", "sd.serdeInfo"));
        GetPartitionsResponse response = this.client.getPartitionsWithSpecs(request);
        PartitionSpecWithSharedSD partitionSpecWithSharedSD = ((PartitionSpec)response.getPartitionSpec().get(0)).getSharedSDPartitionSpec();
        StorageDescriptor sharedSD = partitionSpecWithSharedSD.getSd();
        Assert.assertNotNull((String)"sd.cols were requested but was not returned", (Object)sharedSD.getCols());
        Assert.assertEquals((String)"Returned serdeInfo does not match with original serdeInfo", (Object)this.origPartitions.get(0).getSd().getCols(), (Object)sharedSD.getCols());
        Assert.assertNotNull((String)"sd.serdeInfo were requested but was not returned", (Object)sharedSD.getSerdeInfo());
        Assert.assertEquals((String)"Returned serdeInfo does not match with original serdeInfo", (Object)this.origPartitions.get(0).getSd().getSerdeInfo(), (Object)sharedSD.getSerdeInfo());
    }

    @Test
    public void testNonStandardPartitions() throws TException {
        String testTblName = "test_non_standard";
        ((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)new TableBuilder().setTableName(testTblName).setDbName(dbName).addCol("ns_c1", "string", "comment 1")).addCol("ns_c2", "int", "comment 2")).addPartCol("part", "string").addPartCol("city", "string").addBucketCol("ns_c1")).addSortCol("ns_c2", 1)).addTableParam("tblparamKey", "Partitions of this table are not located within table directory").create((IMetaStoreClient)this.client, conf);
        Table table = this.client.getTable(dbName, testTblName);
        Assert.assertNotNull((String)"Unable to create a test table ", (Object)table);
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        partitions.add(this.createPartition(Arrays.asList("p1", "SanFrancisco"), table));
        partitions.add(this.createPartition(Arrays.asList("p1", "PaloAlto"), table));
        partitions.add(this.createPartition(Arrays.asList("p2", "Seattle"), table));
        partitions.add(this.createPartition(Arrays.asList("p2", "Phoenix"), table));
        this.client.add_partitions(partitions);
        List testPartitions = this.client.listPartitions(dbName, testTblName, (short)-1);
        Assert.assertEquals((long)4L, (long)testPartitions.size());
        Partition p1 = (Partition)testPartitions.get(2);
        p1.getSd().setLocation("/tmp/some_other_location/part=p2/city=Seattle");
        Partition p2 = (Partition)testPartitions.get(3);
        p2.getSd().setLocation("/tmp/some_other_location/part=p2/city=Phoenix");
        this.client.alter_partitions(dbName, testTblName, Arrays.asList(p1, p2));
        GetPartitionsRequest request = this.getGetPartitionsRequest();
        request.getProjectionSpec().setFieldList(Arrays.asList("values", "sd"));
        request.setDbName(dbName);
        request.setTblName(testTblName);
        GetPartitionsResponse response = this.client.getPartitionsWithSpecs(request);
        Assert.assertNotNull((String)"Response should have returned partition specs", (Object)response.getPartitionSpec());
        Assert.assertEquals((String)"We should have two partition specs", (long)2L, (long)response.getPartitionSpec().size());
        Assert.assertNotNull((String)"One SharedSD spec is expected", (Object)((PartitionSpec)response.getPartitionSpec().get(0)).getSharedSDPartitionSpec());
        Assert.assertNotNull((String)"One composing spec is expected", (Object)((PartitionSpec)response.getPartitionSpec().get(1)).getPartitionList());
        PartitionSpecWithSharedSD partitionSpecWithSharedSD = ((PartitionSpec)response.getPartitionSpec().get(0)).getSharedSDPartitionSpec();
        Assert.assertNotNull((String)"sd was requested but not returned", (Object)partitionSpecWithSharedSD.getSd());
        Assert.assertEquals((String)"shared SD should have table location", (Object)table.getSd().getLocation(), (Object)partitionSpecWithSharedSD.getSd().getLocation());
        ArrayList<List<String>> expectedVals = new ArrayList<List<String>>(2);
        expectedVals.add(Arrays.asList("p1", "PaloAlto"));
        expectedVals.add(Arrays.asList("p1", "SanFrancisco"));
        for (int i = 0; i < partitionSpecWithSharedSD.getPartitions().size(); ++i) {
            PartitionWithoutSD retPartition = (PartitionWithoutSD)partitionSpecWithSharedSD.getPartitions().get(i);
            Assert.assertEquals((long)2L, (long)retPartition.getValuesSize());
            this.validateList((List)expectedVals.get(i), retPartition.getValues());
            Assert.assertNull((String)"parameters were not requested so should have been null", (Object)retPartition.getParameters());
        }
        PartitionListComposingSpec composingSpec = ((PartitionSpec)response.getPartitionSpec().get(1)).getPartitionList();
        Assert.assertNotNull((String)"composing spec should have returned 2 partitions", (Object)composingSpec.getPartitions());
        Assert.assertEquals((String)"composing spec should have returned 2 partitions", (long)2L, (long)composingSpec.getPartitionsSize());
        expectedVals.clear();
        expectedVals.add(Arrays.asList("p2", "Phoenix"));
        expectedVals.add(Arrays.asList("p2", "Seattle"));
        for (int i = 0; i < composingSpec.getPartitions().size(); ++i) {
            Partition partition = (Partition)composingSpec.getPartitions().get(i);
            Assert.assertEquals((long)2L, (long)partition.getValuesSize());
            this.validateList((List)expectedVals.get(i), partition.getValues());
            Assert.assertNull((String)"parameters were not requested so should have been null", (Object)partition.getParameters());
        }
    }

    @Test
    public void testGetPartitionsWithFilterExpr() throws TException {
        this.runGetPartitionsUsingExpr();
    }

    @Test
    public void testGetPartitionsUsingNames() throws Exception {
        this.runGetPartitionsUsingNames();
    }

    @Test
    public void testGetPartitionsUsingValues() throws Exception {
        this.runGetPartitionsUsingVals();
    }

    @Test
    public void testGetPartitionsUsingExprWithJDO() throws Exception {
        this.client.setMetaConf(MetastoreConf.ConfVars.TRY_DIRECT_SQL.getVarname(), "false");
        this.runGetPartitionsUsingExpr();
    }

    @Test
    public void testGetPartitionsUsingValuesWithJDO() throws Exception {
        this.client.setMetaConf(MetastoreConf.ConfVars.TRY_DIRECT_SQL.getVarname(), "false");
        this.runGetPartitionsUsingVals();
    }

    @Test
    public void testGetPartitionsUsingNamesWithJDO() throws Exception {
        this.client.setMetaConf(MetastoreConf.ConfVars.TRY_DIRECT_SQL.getVarname(), "false");
        this.runGetPartitionsUsingNames();
    }

    @Test(expected=MetaException.class)
    public void testInvalidFilterByNames() throws Exception {
        this.runWithInvalidFilterByNames();
    }

    @Test(expected=MetaException.class)
    public void testInvalidFilterByNamesWithJDO() throws Exception {
        this.client.setMetaConf(MetastoreConf.ConfVars.TRY_DIRECT_SQL.getVarname(), "false");
        this.runWithInvalidFilterByNames();
    }

    @Test(expected=MetaException.class)
    public void testInvalidProjectFieldNames() throws TException {
        this.runWithInvalidFieldNames(Arrays.asList("values", "invalid.field.name"));
    }

    @Test(expected=MetaException.class)
    public void testInvalidProjectFieldNames2() throws TException {
        this.runWithInvalidFieldNames(Arrays.asList(""));
    }

    @Test(expected=MetaException.class)
    public void testInvalidProjectFieldNamesWithJDO() throws TException {
        this.client.setMetaConf(MetastoreConf.ConfVars.TRY_DIRECT_SQL.getVarname(), "false");
        this.runWithInvalidFieldNames(Arrays.asList("values", "invalid.field.name"));
    }

    @Test(expected=MetaException.class)
    public void testInvalidProjectFieldNames2WithJDO() throws TException {
        this.client.setMetaConf(MetastoreConf.ConfVars.TRY_DIRECT_SQL.getVarname(), "false");
        this.runWithInvalidFieldNames(Arrays.asList(""));
    }

    private void runWithInvalidFilterByNames() throws TException {
        GetPartitionsRequest request = this.getGetPartitionsRequest();
        GetProjectionsSpec projectSpec = request.getProjectionSpec();
        projectSpec.setFieldList(Arrays.asList("sd.location"));
        request.getFilterSpec().setFilterMode(PartitionFilterMode.BY_NAMES);
        this.client.getPartitionsWithSpecs(request);
    }

    private void runWithInvalidFieldNames(List<String> values) throws TException {
        GetPartitionsRequest request = this.getGetPartitionsRequest();
        GetProjectionsSpec projectSpec = request.getProjectionSpec();
        projectSpec.setFieldList(values);
        this.client.getPartitionsWithSpecs(request);
    }

    private void runGetPartitionsUsingExpr() throws TException {
        this.getPartitionsWithExpr(Arrays.asList("state=\"CA\""), 2);
        this.getPartitionsWithExpr(Arrays.asList("state=\"CA\" AND city=\"PaloAlto\""), 1);
        this.getPartitionsWithExpr(Arrays.asList("state=\"CA\" AND city=\"Seattle\""), 0);
        this.getPartitionsWithExpr(Arrays.asList("state=\"CA\" AND city !=\"PaloAlto\""), 1);
        this.getPartitionsWithExpr(Arrays.asList("(state=\"CA\" AND city !=\"PaloAlto\") OR (state=\"WA\" AND city = \"Seattle\")"), 2);
        this.getPartitionsWithExpr(Arrays.asList("state=\"CA\"", "city=\"PaloAlto\""), 1);
        this.getPartitionsWithExpr(Arrays.asList("state=\"CA\" OR state=\"WA\"", "city=\"PaloAlto\" OR city=\"Seattle\""), 2);
        this.getPartitionsWithExpr(Arrays.asList("state=\"AZ\"", "city=\"Tucson\""), 0);
    }

    private void getPartitionsWithExpr(List<String> filters, int expectedPartition) throws TException {
        GetPartitionsRequest request = this.getGetPartitionsRequest();
        GetProjectionsSpec projectSpec = request.getProjectionSpec();
        projectSpec.setFieldList(Arrays.asList("sd.location"));
        request.getFilterSpec().setFilterMode(PartitionFilterMode.BY_EXPR);
        request.getFilterSpec().setFilters(filters);
        GetPartitionsResponse response = this.client.getPartitionsWithSpecs(request);
        Assert.assertNotNull((Object)response);
        if (expectedPartition > 0) {
            PartitionSpecWithSharedSD partitionSpecWithSharedSD = ((PartitionSpec)response.getPartitionSpec().get(0)).getSharedSDPartitionSpec();
            Assert.assertNotNull((Object)partitionSpecWithSharedSD);
            Assert.assertEquals((String)"Invalid number of partitions returned", (long)expectedPartition, (long)partitionSpecWithSharedSD.getPartitionsSize());
        } else {
            Assert.assertTrue((String)"Partition spec should have been empty since filter doesn't match with any partitions", (boolean)response.getPartitionSpec().isEmpty());
        }
    }

    private void getPartitionsWithVals(List<String> filters, int expectedPartitions) throws TException {
        List partitions = this.client.listPartitions(dbName, tblName, filters, (short)-1);
        GetPartitionsRequest request = this.getGetPartitionsRequest();
        GetProjectionsSpec projectSpec = request.getProjectionSpec();
        projectSpec.setFieldList(Arrays.asList("sd.location"));
        request.getFilterSpec().setFilterMode(PartitionFilterMode.BY_VALUES);
        request.getFilterSpec().setFilters(filters);
        GetPartitionsResponse response = this.client.getPartitionsWithSpecs(request);
        Assert.assertNotNull((Object)response);
        if (expectedPartitions > 0) {
            PartitionSpecWithSharedSD partitionSpecWithSharedSD = ((PartitionSpec)response.getPartitionSpec().get(0)).getSharedSDPartitionSpec();
            Assert.assertNotNull((Object)partitionSpecWithSharedSD);
            Assert.assertEquals((String)"Invalid number of partitions returned", (long)expectedPartitions, (long)partitionSpecWithSharedSD.getPartitionsSize());
            this.verifyLocations(partitions, partitionSpecWithSharedSD.getSd(), partitionSpecWithSharedSD.getPartitions());
        } else {
            Assert.assertTrue((String)"Partition spec should have been empty since filter doesn't match with any partitions", (boolean)response.getPartitionSpec().isEmpty());
        }
    }

    private void runGetPartitionsUsingVals() throws TException {
        this.getPartitionsWithVals(Arrays.asList("CA"), 2);
        this.getPartitionsWithVals(Arrays.asList("CA", "PaloAlto"), 1);
        this.getPartitionsWithVals(Arrays.asList("CA", "CityDoesNotExist"), 0);
    }

    private void getPartitionsWithNames(List<String> names, int expectedPartitionCount) throws TException {
        GetPartitionsRequest request = this.getGetPartitionsRequest();
        GetProjectionsSpec projectSpec = request.getProjectionSpec();
        projectSpec.setFieldList(Arrays.asList("sd.location"));
        request.getFilterSpec().setFilterMode(PartitionFilterMode.BY_NAMES);
        request.getFilterSpec().setFilters(names);
        GetPartitionsResponse response = this.client.getPartitionsWithSpecs(request);
        Assert.assertNotNull((Object)response);
        if (expectedPartitionCount > 0) {
            PartitionSpecWithSharedSD partitionSpecWithSharedSD = ((PartitionSpec)response.getPartitionSpec().get(0)).getSharedSDPartitionSpec();
            Assert.assertNotNull((Object)partitionSpecWithSharedSD);
            Assert.assertEquals((String)"Invalid number of partitions returned", (long)expectedPartitionCount, (long)partitionSpecWithSharedSD.getPartitionsSize());
            List origPartitions = this.client.getPartitionsByNames(dbName, tblName, names);
            this.verifyLocations(origPartitions, partitionSpecWithSharedSD.getSd(), partitionSpecWithSharedSD.getPartitions());
        } else {
            Assert.assertTrue((String)"Partition spec should have been empty since filter doesn't match with any partitions", (boolean)response.getPartitionSpec().isEmpty());
        }
    }

    private void runGetPartitionsUsingNames() throws TException {
        List names = this.client.listPartitionNames(dbName, tblName, (short)-1);
        names.remove(names.size() - 1);
        this.getPartitionsWithNames(names, 3);
        this.getPartitionsWithNames(Arrays.asList(""), 0);
        this.getPartitionsWithNames(Arrays.asList("invalidPartitionName"), 0);
    }

    private void validateBasic(GetPartitionsResponse response) throws TException {
        Assert.assertNotNull((String)"Response is null", (Object)response);
        Assert.assertNotNull((String)"Returned partition spec is null", (Object)response.getPartitionSpec());
        Assert.assertEquals((long)1L, (long)response.getPartitionSpecSize());
        PartitionSpecWithSharedSD partitionSpecWithSharedSD = ((PartitionSpec)response.getPartitionSpec().get(0)).getSharedSDPartitionSpec();
        Assert.assertNotNull((Object)partitionSpecWithSharedSD.getSd());
        StorageDescriptor sharedSD = partitionSpecWithSharedSD.getSd();
        Assert.assertEquals((String)"Root location should be set to table location", (Object)this.tbl.getSd().getLocation(), (Object)sharedSD.getLocation());
        List partitionWithoutSDS = partitionSpecWithSharedSD.getPartitions();
        Assert.assertEquals((long)this.origPartitions.size(), (long)partitionWithoutSDS.size());
        for (int i = 0; i < this.origPartitions.size(); ++i) {
            Partition origPartition = this.origPartitions.get(i);
            PartitionWithoutSD returnedPartitionWithoutSD = (PartitionWithoutSD)partitionWithoutSDS.get(i);
            Assert.assertEquals((String)String.format("Location returned for Partition %d is not correct", i), (Object)origPartition.getSd().getLocation(), (Object)(sharedSD.getLocation() + returnedPartitionWithoutSD.getRelativePath()));
        }
    }

    private GetPartitionsRequest getGetPartitionsRequest() {
        GetPartitionsRequest request = new GetPartitionsRequest();
        request.setProjectionSpec(new GetProjectionsSpec());
        request.setFilterSpec(new GetPartitionsFilterSpec());
        request.setTblName(tblName);
        request.setDbName(dbName);
        return request;
    }

    private void verifyLocations(List<Partition> origPartitions, StorageDescriptor sharedSD, List<PartitionWithoutSD> partitionWithoutSDS) {
        int i = 0;
        for (Partition origPart : origPartitions) {
            Assert.assertEquals((String)"Location does not match", (Object)origPart.getSd().getLocation(), (Object)(sharedSD.getLocation() + partitionWithoutSDS.get(i).getRelativePath()));
            Assert.assertNull((String)"values were not requested but are still set", (Object)partitionWithoutSDS.get(i).getValues());
            Assert.assertNull((String)"Parameters were not requested but are still set", (Object)partitionWithoutSDS.get(i).getParameters());
            ++i;
        }
    }

    private <K, V> void validateMap(Map<K, V> aMap, Map<K, V> bMap) {
        if ((aMap == null || aMap.isEmpty()) && (bMap == null || bMap.isEmpty())) {
            return;
        }
        Assert.assertTrue((bMap.size() >= aMap.size() ? 1 : 0) != 0);
        for (Map.Entry<K, V> entries : aMap.entrySet()) {
            Assert.assertTrue((String)("Expected " + entries.getKey() + " is missing from the map"), (boolean)bMap.containsKey(entries.getKey()));
            Assert.assertEquals((String)("Expected value to be " + aMap.get(entries.getKey()) + " found" + bMap.get(entries.getKey())), aMap.get(entries.getKey()), bMap.get(entries.getKey()));
        }
    }

    private <T> void validateList(List<T> aList, List<T> bList) {
        if ((aList == null || aList.isEmpty()) && (bList == null || bList.isEmpty())) {
            return;
        }
        Assert.assertEquals((long)aList.size(), (long)bList.size());
        Iterator<T> origValuesIt = aList.iterator();
        Iterator<T> retValuesIt = bList.iterator();
        while (origValuesIt.hasNext()) {
            Assert.assertTrue((boolean)retValuesIt.hasNext());
            Assert.assertEquals(origValuesIt.next(), retValuesIt.next());
        }
    }
}

