/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreFilterHook;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.DataConnector;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionSpec;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.PartitionBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.utils.TestTxnDbUtil;
import org.apache.hadoop.util.StringUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class TestFilterHooks {
    protected static HiveMetaStoreClient client;
    protected static Configuration conf;
    protected static Warehouse warehouse;
    private static final int DEFAULT_LIMIT_PARTITION_REQUEST = 100;
    private static String DBNAME1;
    private static String DBNAME2;
    private static final String TAB1 = "tab1";
    private static final String TAB2 = "tab2";
    private static String DCNAME1;
    private static String DCNAME2;
    private static String mysql_type;
    private static String mysql_url;
    private static String postgres_type;
    private static String postgres_url;

    protected HiveMetaStoreClient createClient(Configuration metaStoreConf) throws Exception {
        try {
            return new HiveMetaStoreClient(metaStoreConf);
        }
        catch (Throwable e) {
            System.err.println("Unable to open the metastore");
            System.err.println(StringUtils.stringifyException((Throwable)e));
            throw new Exception(e);
        }
    }

    @BeforeClass
    public static void setUp() throws Exception {
        DummyMetaStoreFilterHookImpl.blockResults = true;
    }

    @Before
    public void setUpForTest() throws Exception {
        conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setLongVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_CONNECTION_RETRIES, (long)3L);
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, (boolean)false);
        MetastoreConf.setClass((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.FILTER_HOOK, DummyMetaStoreFilterHookImpl.class, MetaStoreFilterHook.class);
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METRICS_ENABLED, (boolean)true);
        conf.set("hive.key1", "value1");
        conf.set("hive.key2", "http://www.example.com");
        conf.set("hive.key3", "");
        conf.set("hive.key4", "0");
        conf.set("datanucleus.autoCreateTables", "false");
        conf.set("hive.in.test", "true");
        MetastoreConf.setLongVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.BATCH_RETRIEVE_MAX, (long)2L);
        MetastoreConf.setLongVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.LIMIT_PARTITION_REQUEST, (long)100L);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.STORAGE_SCHEMA_READER_IMPL, (String)"no.such.class");
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        warehouse = new Warehouse(conf);
    }

    @After
    public void tearDown() throws Exception {
        if (client != null) {
            client.close();
        }
    }

    protected void creatEnv(Configuration conf) throws Exception {
        client = this.createClient(conf);
        client.dropDatabase(DBNAME1, true, true, true);
        client.dropDatabase(DBNAME2, true, true, true);
        client.dropDataConnector(DCNAME1, true, true);
        client.dropDataConnector(DCNAME2, true, true);
        Database db1 = new DatabaseBuilder().setName(DBNAME1).setCatalogName("hive").create((IMetaStoreClient)client, conf);
        Database db2 = new DatabaseBuilder().setName(DBNAME2).setCatalogName("hive").create((IMetaStoreClient)client, conf);
        ((TableBuilder)((TableBuilder)new TableBuilder().setDbName(DBNAME1).setTableName(TAB1).addCol("id", "int")).addCol("name", "string")).create((IMetaStoreClient)client, conf);
        Table tab2 = ((TableBuilder)new TableBuilder().setDbName(DBNAME1).setTableName(TAB2).addCol("id", "int")).addPartCol("name", "string").create((IMetaStoreClient)client, conf);
        new PartitionBuilder().inTable(tab2).addValue("value1").addToTable((IMetaStoreClient)client, conf);
        new PartitionBuilder().inTable(tab2).addValue("value2").addToTable((IMetaStoreClient)client, conf);
        DataConnector dc1 = new DataConnector(DCNAME1, mysql_type, mysql_url);
        DataConnector dc2 = new DataConnector(DCNAME2, postgres_type, postgres_url);
        client.createDataConnector(dc1);
        client.createDataConnector(dc2);
        TestTxnDbUtil.cleanDb(conf);
        TestTxnDbUtil.prepDb(conf);
        client.compact2(DBNAME1, TAB1, null, CompactionType.MAJOR, new HashMap());
        client.compact2(DBNAME1, TAB2, "name=value1", CompactionType.MINOR, new HashMap());
    }

    @Test
    public void testHMSServerWithoutFilter() throws Exception {
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_CLIENT_FILTER_ENABLED, (boolean)false);
        DBNAME1 = "db_testHMSServerWithoutFilter_1";
        DBNAME2 = "db_testHMSServerWithoutFilter_2";
        this.creatEnv(conf);
        Assert.assertNotNull((Object)client.getTable(DBNAME1, TAB1));
        Assert.assertEquals((long)2L, (long)client.getTables(DBNAME1, "*").size());
        Assert.assertEquals((long)2L, (long)client.getAllTables(DBNAME1).size());
        Assert.assertEquals((long)1L, (long)client.getTables(DBNAME1, TAB2).size());
        Assert.assertEquals((long)0L, (long)client.getAllTables(DBNAME2).size());
        Assert.assertNotNull((Object)client.getDatabase(DBNAME1));
        Assert.assertEquals((long)2L, (long)client.getDatabases("*testHMSServerWithoutFilter*").size());
        Assert.assertEquals((long)1L, (long)client.getDatabases(DBNAME1).size());
        Assert.assertNotNull((Object)client.getPartition(DBNAME1, TAB2, "name=value1"));
        Assert.assertEquals((long)1L, (long)client.getPartitionsByNames(DBNAME1, TAB2, (List)Lists.newArrayList((Object[])new String[]{"name=value1"})).size());
        Assert.assertEquals((long)2L, (long)client.showCompactions().getCompacts().size());
        Assert.assertEquals((long)2L, (long)client.getAllDataConnectorNames().size());
    }

    @Test
    public void testHMSServerWithFilter() throws Exception {
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_CLIENT_FILTER_ENABLED, (boolean)false);
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_SERVER_FILTER_ENABLED, (boolean)true);
        DBNAME1 = "db_testHMSServerWithFilter_1";
        DBNAME2 = "db_testHMSServerWithFilter_2";
        this.creatEnv(conf);
        this.testFilterForDb(true);
        this.testFilterForTables(true);
        this.testFilterForPartition(true);
        this.testFilterForCompaction();
        this.testFilterForDataConnector();
    }

    @Test
    public void testHMSClientWithoutFilter() throws Exception {
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_CLIENT_FILTER_ENABLED, (boolean)false);
        DBNAME1 = "db_testHMSClientWithoutFilter_1";
        DBNAME2 = "db_testHMSClientWithoutFilter_2";
        this.creatEnv(conf);
        Assert.assertNotNull((Object)client.getTable(DBNAME1, TAB1));
        Assert.assertEquals((long)2L, (long)client.getTables(DBNAME1, "*").size());
        Assert.assertEquals((long)2L, (long)client.getAllTables(DBNAME1).size());
        Assert.assertEquals((long)1L, (long)client.getTables(DBNAME1, TAB2).size());
        Assert.assertEquals((long)0L, (long)client.getAllTables(DBNAME2).size());
        Assert.assertNotNull((Object)client.getDatabase(DBNAME1));
        Assert.assertEquals((long)2L, (long)client.getDatabases("*testHMSClientWithoutFilter*").size());
        Assert.assertEquals((long)1L, (long)client.getDatabases(DBNAME1).size());
        Assert.assertNotNull((Object)client.getPartition(DBNAME1, TAB2, "name=value1"));
        Assert.assertEquals((long)1L, (long)client.getPartitionsByNames(DBNAME1, TAB2, (List)Lists.newArrayList((Object[])new String[]{"name=value1"})).size());
        Assert.assertEquals((long)2L, (long)client.showCompactions().getCompacts().size());
        Assert.assertEquals((long)2L, (long)client.getAllDataConnectorNames().size());
    }

    @Test
    public void testHMSClientWithFilter() throws Exception {
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_SERVER_FILTER_ENABLED, (boolean)false);
        DBNAME1 = "db_testHMSClientWithFilter_1";
        DBNAME2 = "db_testHMSClientWithFilter_2";
        this.creatEnv(conf);
        this.testFilterForDb(false);
        this.testFilterForTables(false);
        this.testFilterForPartition(false);
        this.testFilterForCompaction();
        this.testFilterForDataConnector();
    }

    protected void testFilterForDb(boolean filterAtServer) throws Exception {
        if (!filterAtServer) {
            try {
                Assert.assertNotNull((Object)client.getDatabase(DBNAME1));
                Assert.fail((String)"getDatabase() should fail with blocking mode");
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
        }
        Assert.assertEquals((long)0L, (long)client.getDatabases("*").size());
        Assert.assertEquals((long)0L, (long)client.getAllDatabases().size());
        Assert.assertEquals((long)0L, (long)client.getDatabases(DBNAME1).size());
    }

    protected void testFilterForTables(boolean filterAtServer) throws Exception {
        if (!filterAtServer) {
            try {
                client.getTable(DBNAME1, TAB1);
                Assert.fail((String)"getTable() should fail with blocking mode");
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
        }
        Assert.assertEquals((long)0L, (long)client.getTables(DBNAME1, "*").size());
        Assert.assertEquals((long)0L, (long)client.getTables(DBNAME1, "*", TableType.MANAGED_TABLE).size());
        Assert.assertEquals((long)0L, (long)client.getAllTables(DBNAME1).size());
        Assert.assertEquals((long)0L, (long)client.getTables(DBNAME1, TAB2).size());
    }

    protected void testFilterForPartition(boolean filterAtServer) throws Exception {
        try {
            Assert.assertNotNull((Object)client.getPartition(DBNAME1, TAB2, "name=value1"));
            Assert.fail((String)"getPartition() should fail with blocking mode");
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        if (filterAtServer) {
            try {
                client.getPartitionsByNames(DBNAME1, TAB2, (List)Lists.newArrayList((Object[])new String[]{"name=value1"})).size();
                Assert.fail((String)"getPartitionsByNames() should fail with blocking mode at server side");
            }
            catch (NoSuchObjectException noSuchObjectException) {}
        } else {
            Assert.assertEquals((long)0L, (long)client.getPartitionsByNames(DBNAME1, TAB2, (List)Lists.newArrayList((Object[])new String[]{"name=value1"})).size());
        }
    }

    protected void testFilterForCompaction() throws Exception {
        Assert.assertEquals((long)0L, (long)client.showCompactions().getCompacts().size());
    }

    protected void testFilterForDataConnector() throws Exception {
        Assert.assertNotNull((Object)client.getDataConnector(DCNAME1));
        Assert.assertEquals((long)0L, (long)client.getAllDataConnectorNames().size());
    }

    static {
        DBNAME1 = "testdb1";
        DBNAME2 = "testdb2";
        DCNAME1 = "test_connector1";
        DCNAME2 = "test_connector2";
        mysql_type = "mysql";
        mysql_url = "jdbc:mysql://localhost:3306/hive";
        postgres_type = "postgres";
        postgres_url = "jdbc:postgresql://localhost:5432";
    }

    public static class DummyMetaStoreFilterHookImpl
    implements MetaStoreFilterHook {
        private static boolean blockResults = false;

        public DummyMetaStoreFilterHookImpl(Configuration conf) {
        }

        public List<String> filterDatabases(List<String> dbList) throws MetaException {
            if (blockResults) {
                return new ArrayList<String>();
            }
            return dbList;
        }

        public Database filterDatabase(Database dataBase) throws NoSuchObjectException {
            if (blockResults) {
                throw new NoSuchObjectException("Blocked access");
            }
            return dataBase;
        }

        public List<String> filterTableNames(String catName, String dbName, List<String> tableList) throws MetaException {
            if (blockResults) {
                return new ArrayList<String>();
            }
            return tableList;
        }

        public Table filterTable(Table table) throws NoSuchObjectException {
            if (blockResults) {
                throw new NoSuchObjectException("Blocked access");
            }
            return table;
        }

        public List<Table> filterTables(List<Table> tableList) throws MetaException {
            if (blockResults) {
                return new ArrayList<Table>();
            }
            return tableList;
        }

        @Deprecated
        public List<TableMeta> filterTableMetas(String catName, String dbName, List<TableMeta> tableMetas) throws MetaException {
            return this.filterTableMetas(tableMetas);
        }

        public List<TableMeta> filterTableMetas(List<TableMeta> tableMetas) throws MetaException {
            return tableMetas;
        }

        public List<Partition> filterPartitions(List<Partition> partitionList) throws MetaException {
            if (blockResults) {
                return new ArrayList<Partition>();
            }
            return partitionList;
        }

        public List<PartitionSpec> filterPartitionSpecs(List<PartitionSpec> partitionSpecList) throws MetaException {
            if (blockResults) {
                return new ArrayList<PartitionSpec>();
            }
            return partitionSpecList;
        }

        public Partition filterPartition(Partition partition) throws NoSuchObjectException {
            if (blockResults) {
                throw new NoSuchObjectException("Blocked access");
            }
            return partition;
        }

        public List<String> filterPartitionNames(String catName, String dbName, String tblName, List<String> partitionNames) throws MetaException {
            if (blockResults) {
                return new ArrayList<String>();
            }
            return partitionNames;
        }

        public List<String> filterDataConnectors(List<String> dcList) throws MetaException {
            if (blockResults) {
                return new ArrayList<String>();
            }
            return dcList;
        }
    }
}

