/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.io.IOException;
import org.apache.hadoop.hive.metastore.ExceptionHandler;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.thrift.TException;
import org.junit.Assert;
import org.junit.Test;

public class TestExceptionHandler {
    @Test
    public void testThrowIfInstance() {
        MetaException me = new MetaException("MetaException test");
        try {
            ExceptionHandler.handleException((Exception)((Object)me)).throwIfInstance(RuntimeException.class);
        }
        catch (Exception e) {
            Assert.fail((String)("Exception should not happen:" + e.getMessage()));
        }
        try {
            ExceptionHandler.handleException((Exception)((Object)me)).throwIfInstance(MetaException.class);
            Assert.fail((String)"Should throw a exception here");
        }
        catch (Exception e) {
            Assert.assertTrue((e == me ? 1 : 0) != 0);
        }
        InvalidOperationException ioe = new InvalidOperationException("InvalidOperationException test");
        try {
            ExceptionHandler.handleException((Exception)((Object)ioe)).throwIfInstance(MetaException.class, InvalidOperationException.class);
            Assert.fail((String)"Should throw a exception here");
        }
        catch (Exception e) {
            Assert.assertTrue((e == ioe ? 1 : 0) != 0);
        }
        TException te = new TException("TException");
        try {
            ExceptionHandler.handleException((Exception)((Object)te)).throwIfInstance(MetaException.class, InvalidOperationException.class).throwIfInstance(TException.class).defaultMetaException();
        }
        catch (Exception e) {
            Assert.assertTrue((e == te ? 1 : 0) != 0);
        }
        RuntimeException re = new RuntimeException("RuntimeException test");
        try {
            RuntimeException e = ExceptionHandler.handleException((Exception)re).throwIfInstance(MetaException.class, InvalidOperationException.class).throwIfInstance(TException.class).defaultRuntimeException();
            Assert.assertTrue((e == re ? 1 : 0) != 0);
        }
        catch (Exception e) {
            Assert.fail((String)("Exception should not happen:" + e.getMessage()));
        }
        NullPointerException npe = new NullPointerException();
        try {
            MetaException e = ExceptionHandler.handleException((Exception)npe).throwIfInstance(MetaException.class, InvalidOperationException.class).throwIfInstance(TException.class).defaultMetaException();
            Assert.assertTrue((boolean)(e instanceof MetaException));
            Assert.assertTrue((boolean)e.getMessage().equals(npe.toString()));
        }
        catch (Exception e) {
            Assert.fail((String)("Exception should not happen:" + e.getMessage()));
        }
        try {
            ExceptionHandler.handleException((Exception)((Object)me)).throwIfInstance(MetaException.class, InvalidOperationException.class).throwIfInstance(TException.class).defaultMetaException();
            Assert.fail((String)"Should throw a exception here");
        }
        catch (Exception e) {
            Assert.assertTrue((e == me ? 1 : 0) != 0);
        }
    }

    @Test
    public void testConvertIfInstance() {
        IOException ix = new IOException("IOException test");
        try {
            ExceptionHandler.handleException((Exception)ix).convertIfInstance(NoSuchObjectException.class, MetaException.class);
        }
        catch (Exception e) {
            Assert.fail((String)("Exception should not happen:" + e.getMessage()));
        }
        try {
            ExceptionHandler.handleException((Exception)ix).convertIfInstance(IOException.class, MetaException.class);
            Assert.fail((String)"Should throw a exception here");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof MetaException));
            Assert.assertTrue((boolean)e.getMessage().equals(ix.getMessage()));
        }
        try {
            ExceptionHandler.handleException((Exception)ix).convertIfInstance(NoSuchObjectException.class, MetaException.class).convertIfInstance(IOException.class, MetaException.class);
            Assert.fail((String)"Should throw a exception here");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof MetaException));
            Assert.assertTrue((boolean)e.getMessage().equals(ix.getMessage()));
        }
    }
}

