/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.metastore.DefaultHiveMetaHook;
import org.apache.hadoop.hive.metastore.DefaultMetaStoreFilterHookImpl;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.HiveMetaHookLoader;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreFilterHook;
import org.apache.hadoop.hive.metastore.PartitionDropOptions;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.AbortCompactResponse;
import org.apache.hadoop.hive.metastore.api.AbortCompactionRequest;
import org.apache.hadoop.hive.metastore.api.AbortTxnRequest;
import org.apache.hadoop.hive.metastore.api.AbortTxnsRequest;
import org.apache.hadoop.hive.metastore.api.AddCheckConstraintRequest;
import org.apache.hadoop.hive.metastore.api.AddDefaultConstraintRequest;
import org.apache.hadoop.hive.metastore.api.AddDynamicPartitions;
import org.apache.hadoop.hive.metastore.api.AddForeignKeyRequest;
import org.apache.hadoop.hive.metastore.api.AddNotNullConstraintRequest;
import org.apache.hadoop.hive.metastore.api.AddPackageRequest;
import org.apache.hadoop.hive.metastore.api.AddPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.AddPartitionsResult;
import org.apache.hadoop.hive.metastore.api.AddPrimaryKeyRequest;
import org.apache.hadoop.hive.metastore.api.AddUniqueConstraintRequest;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.AllTableConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.AllocateTableWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.AlterPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.CacheFileMetadataRequest;
import org.apache.hadoop.hive.metastore.api.CacheFileMetadataResult;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.CheckConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.CheckLockRequest;
import org.apache.hadoop.hive.metastore.api.ClearFileMetadataRequest;
import org.apache.hadoop.hive.metastore.api.ClientCapabilities;
import org.apache.hadoop.hive.metastore.api.ClientCapability;
import org.apache.hadoop.hive.metastore.api.CmRecycleRequest;
import org.apache.hadoop.hive.metastore.api.CmRecycleResponse;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.CommitTxnKeyValue;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.CompactionInfoStruct;
import org.apache.hadoop.hive.metastore.api.CompactionMetricsDataRequest;
import org.apache.hadoop.hive.metastore.api.CompactionMetricsDataStruct;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.CompactionResponse;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.ConfigValSecurityException;
import org.apache.hadoop.hive.metastore.api.CreateTableRequest;
import org.apache.hadoop.hive.metastore.api.CreationMetadata;
import org.apache.hadoop.hive.metastore.api.CurrentNotificationEventId;
import org.apache.hadoop.hive.metastore.api.DataConnector;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.DefaultConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.DropConstraintRequest;
import org.apache.hadoop.hive.metastore.api.DropDatabaseRequest;
import org.apache.hadoop.hive.metastore.api.DropPackageRequest;
import org.apache.hadoop.hive.metastore.api.DropPartitionsExpr;
import org.apache.hadoop.hive.metastore.api.DropPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.ExtendedTableInfo;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.FindNextCompactRequest;
import org.apache.hadoop.hive.metastore.api.FindSchemasByColsResp;
import org.apache.hadoop.hive.metastore.api.FindSchemasByColsRqst;
import org.apache.hadoop.hive.metastore.api.FireEventRequest;
import org.apache.hadoop.hive.metastore.api.FireEventResponse;
import org.apache.hadoop.hive.metastore.api.ForeignKeysRequest;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.GetAllFunctionsResponse;
import org.apache.hadoop.hive.metastore.api.GetAllWriteEventInfoRequest;
import org.apache.hadoop.hive.metastore.api.GetDataConnectorRequest;
import org.apache.hadoop.hive.metastore.api.GetFieldsRequest;
import org.apache.hadoop.hive.metastore.api.GetFieldsResponse;
import org.apache.hadoop.hive.metastore.api.GetFileMetadataByExprRequest;
import org.apache.hadoop.hive.metastore.api.GetFileMetadataByExprResult;
import org.apache.hadoop.hive.metastore.api.GetFileMetadataRequest;
import org.apache.hadoop.hive.metastore.api.GetFileMetadataResult;
import org.apache.hadoop.hive.metastore.api.GetLatestCommittedCompactionInfoRequest;
import org.apache.hadoop.hive.metastore.api.GetLatestCommittedCompactionInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsRequest;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.GetPackageRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionNamesPsRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionNamesPsResponse;
import org.apache.hadoop.hive.metastore.api.GetPartitionRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionResponse;
import org.apache.hadoop.hive.metastore.api.GetPartitionsByNamesRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsByNamesResult;
import org.apache.hadoop.hive.metastore.api.GetPartitionsPsWithAuthRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsPsWithAuthResponse;
import org.apache.hadoop.hive.metastore.api.GetPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsResponse;
import org.apache.hadoop.hive.metastore.api.GetPrincipalsInRoleRequest;
import org.apache.hadoop.hive.metastore.api.GetPrincipalsInRoleResponse;
import org.apache.hadoop.hive.metastore.api.GetProjectionsSpec;
import org.apache.hadoop.hive.metastore.api.GetReplicationMetricsRequest;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalRequest;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalResponse;
import org.apache.hadoop.hive.metastore.api.GetSchemaRequest;
import org.apache.hadoop.hive.metastore.api.GetSchemaResponse;
import org.apache.hadoop.hive.metastore.api.GetTableRequest;
import org.apache.hadoop.hive.metastore.api.GetTablesExtRequest;
import org.apache.hadoop.hive.metastore.api.GetTablesRequest;
import org.apache.hadoop.hive.metastore.api.GetValidWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.GetValidWriteIdsResponse;
import org.apache.hadoop.hive.metastore.api.GrantRevokePrivilegeRequest;
import org.apache.hadoop.hive.metastore.api.GrantRevokePrivilegeResponse;
import org.apache.hadoop.hive.metastore.api.GrantRevokeRoleRequest;
import org.apache.hadoop.hive.metastore.api.GrantRevokeRoleResponse;
import org.apache.hadoop.hive.metastore.api.GrantRevokeType;
import org.apache.hadoop.hive.metastore.api.HeartbeatRequest;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeRequest;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeResponse;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.ISchema;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.InvalidPartitionException;
import org.apache.hadoop.hive.metastore.api.ListPackageRequest;
import org.apache.hadoop.hive.metastore.api.ListStoredProcedureRequest;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.Materialization;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.MetadataPpdResult;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.NotNullConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.NotificationEventRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEventResponse;
import org.apache.hadoop.hive.metastore.api.NotificationEventsCountRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEventsCountResponse;
import org.apache.hadoop.hive.metastore.api.OpenTxnRequest;
import org.apache.hadoop.hive.metastore.api.OpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.OptionalCompactionInfoStruct;
import org.apache.hadoop.hive.metastore.api.Package;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionEventType;
import org.apache.hadoop.hive.metastore.api.PartitionSpec;
import org.apache.hadoop.hive.metastore.api.PartitionValuesRequest;
import org.apache.hadoop.hive.metastore.api.PartitionValuesResponse;
import org.apache.hadoop.hive.metastore.api.PartitionsByExprRequest;
import org.apache.hadoop.hive.metastore.api.PartitionsByExprResult;
import org.apache.hadoop.hive.metastore.api.PartitionsRequest;
import org.apache.hadoop.hive.metastore.api.PartitionsResponse;
import org.apache.hadoop.hive.metastore.api.PartitionsSpecByExprResult;
import org.apache.hadoop.hive.metastore.api.PartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.PrimaryKeysRequest;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.PutFileMetadataRequest;
import org.apache.hadoop.hive.metastore.api.ReplTblWriteIdStateRequest;
import org.apache.hadoop.hive.metastore.api.ReplicationMetricList;
import org.apache.hadoop.hive.metastore.api.RequestPartsSpec;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.RuntimeStat;
import org.apache.hadoop.hive.metastore.api.SQLAllTableConstraints;
import org.apache.hadoop.hive.metastore.api.SQLCheckConstraint;
import org.apache.hadoop.hive.metastore.api.SQLDefaultConstraint;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.metastore.api.ScheduledQuery;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryKey;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryMaintenanceRequest;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryPollRequest;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryPollResponse;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryProgressInfo;
import org.apache.hadoop.hive.metastore.api.SchemaVersion;
import org.apache.hadoop.hive.metastore.api.SchemaVersionState;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.SetPartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.StoredProcedure;
import org.apache.hadoop.hive.metastore.api.StoredProcedureRequest;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.metastore.api.TableStatsRequest;
import org.apache.hadoop.hive.metastore.api.TableValidWriteIds;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.api.TxnOpenException;
import org.apache.hadoop.hive.metastore.api.TxnToWriteId;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.api.Type;
import org.apache.hadoop.hive.metastore.api.UniqueConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownPartitionException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.hadoop.hive.metastore.api.UnlockRequest;
import org.apache.hadoop.hive.metastore.api.UpdateTransactionalStatsRequest;
import org.apache.hadoop.hive.metastore.api.WMAlterPoolRequest;
import org.apache.hadoop.hive.metastore.api.WMAlterResourcePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMAlterResourcePlanResponse;
import org.apache.hadoop.hive.metastore.api.WMAlterTriggerRequest;
import org.apache.hadoop.hive.metastore.api.WMCreateOrDropTriggerToPoolMappingRequest;
import org.apache.hadoop.hive.metastore.api.WMCreateOrUpdateMappingRequest;
import org.apache.hadoop.hive.metastore.api.WMCreatePoolRequest;
import org.apache.hadoop.hive.metastore.api.WMCreateResourcePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMCreateTriggerRequest;
import org.apache.hadoop.hive.metastore.api.WMDropMappingRequest;
import org.apache.hadoop.hive.metastore.api.WMDropPoolRequest;
import org.apache.hadoop.hive.metastore.api.WMDropResourcePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMDropTriggerRequest;
import org.apache.hadoop.hive.metastore.api.WMFullResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMGetActiveResourcePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMGetAllResourcePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMGetResourcePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMGetTriggersForResourePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMMapping;
import org.apache.hadoop.hive.metastore.api.WMNullablePool;
import org.apache.hadoop.hive.metastore.api.WMNullableResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMPool;
import org.apache.hadoop.hive.metastore.api.WMResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMTrigger;
import org.apache.hadoop.hive.metastore.api.WMValidateResourcePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMValidateResourcePlanResponse;
import org.apache.hadoop.hive.metastore.api.WriteEventInfo;
import org.apache.hadoop.hive.metastore.api.WriteNotificationLogBatchRequest;
import org.apache.hadoop.hive.metastore.api.WriteNotificationLogRequest;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.hooks.URIResolverHook;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;
import org.apache.hadoop.hive.metastore.security.HadoopThriftAuthBridge;
import org.apache.hadoop.hive.metastore.txn.TxnCommonUtils;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.utils.SecurityUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TConfiguration;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.layered.TFramedTransport;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class HiveMetaStoreClientPreCatalog
implements IMetaStoreClient,
AutoCloseable {
    public static final ClientCapabilities VERSION = new ClientCapabilities((List)Lists.newArrayList((Object[])new ClientCapability[]{ClientCapability.INSERT_ONLY_TABLES}));
    public static final ClientCapabilities TEST_VERSION = new ClientCapabilities((List)Lists.newArrayList((Object[])new ClientCapability[]{ClientCapability.INSERT_ONLY_TABLES, ClientCapability.TEST_CAPABILITY}));
    ThriftHiveMetastore.Iface client = null;
    private TTransport transport = null;
    private boolean isConnected = false;
    private URI[] metastoreUris;
    private final HiveMetaHookLoader hookLoader;
    protected final Configuration conf;
    protected boolean fastpath = false;
    private String tokenStrForm;
    private final boolean localMetaStore;
    private final MetaStoreFilterHook filterHook;
    private final URIResolverHook uriResolverHook;
    private final int fileMetadataBatchSize;
    private Map<String, String> currentMetaVars;
    private static final AtomicInteger connCount = new AtomicInteger(0);
    private int retries = 5;
    private long retryDelaySeconds = 0L;
    private final ClientCapabilities version;
    protected static final Logger LOG = LoggerFactory.getLogger(HiveMetaStoreClientPreCatalog.class);

    public HiveMetaStoreClientPreCatalog(Configuration conf) throws MetaException {
        this(conf, null, true);
    }

    public HiveMetaStoreClientPreCatalog(Configuration conf, HiveMetaHookLoader hookLoader) throws MetaException {
        this(conf, hookLoader, true);
    }

    public HiveMetaStoreClientPreCatalog(Configuration conf, HiveMetaHookLoader hookLoader, Boolean allowEmbedded) throws MetaException {
        this.hookLoader = hookLoader;
        this.conf = conf == null ? (conf = MetastoreConf.newMetastoreConf()) : new Configuration(conf);
        this.version = MetastoreConf.getBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST) ? TEST_VERSION : VERSION;
        this.filterHook = this.loadFilterHooks();
        this.uriResolverHook = this.loadUriResolverHook();
        this.fileMetadataBatchSize = MetastoreConf.getIntVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.BATCH_RETRIEVE_OBJECTS_MAX);
        String msUri = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_URIS);
        this.localMetaStore = MetastoreConf.isEmbeddedMetaStore((String)msUri);
        if (this.localMetaStore) {
            if (!allowEmbedded.booleanValue()) {
                throw new MetaException("Embedded metastore is not allowed here. Please configure " + MetastoreConf.ConfVars.THRIFT_URIS.toString() + "; it is currently set to [" + msUri + "]");
            }
            this.client = HiveMetaStoreClient.callEmbeddedMetastore((Configuration)this.conf);
            this.isConnected = true;
            this.snapshotActiveConf();
            return;
        }
        this.retries = MetastoreConf.getIntVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_CONNECTION_RETRIES);
        this.retryDelaySeconds = MetastoreConf.getTimeVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CLIENT_CONNECT_RETRY_DELAY, (TimeUnit)TimeUnit.SECONDS);
        if (MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_URIS) == null) {
            LOG.error("NOT getting uris from conf");
            throw new MetaException("MetaStoreURIs not found in conf file");
        }
        this.resolveUris();
        String HADOOP_PROXY_USER = "HADOOP_PROXY_USER";
        String proxyUser = System.getenv(HADOOP_PROXY_USER);
        if (proxyUser == null) {
            proxyUser = System.getProperty(HADOOP_PROXY_USER);
        }
        if (proxyUser != null) {
            LOG.info(HADOOP_PROXY_USER + " is set. Using delegation token for HiveMetaStore connection.");
            try {
                UserGroupInformation.getLoginUser().getRealUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        HiveMetaStoreClientPreCatalog.this.open();
                        return null;
                    }
                });
                String delegationTokenPropString = "DelegationTokenForHiveMetaStoreServer";
                String delegationTokenStr = this.getDelegationToken(proxyUser, proxyUser);
                SecurityUtils.setTokenStr((UserGroupInformation)UserGroupInformation.getCurrentUser(), (String)delegationTokenStr, (String)delegationTokenPropString);
                MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TOKEN_SIGNATURE, (String)delegationTokenPropString);
                this.close();
            }
            catch (Exception e) {
                LOG.error("Error while setting delegation token for " + proxyUser, (Throwable)e);
                if (e instanceof MetaException) {
                    throw (MetaException)e;
                }
                throw new MetaException(e.getMessage());
            }
        }
        this.open();
    }

    private void resolveUris() throws MetaException {
        String[] metastoreUrisString = MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_URIS).split(",");
        ArrayList<URI> metastoreURIArray = new ArrayList<URI>();
        try {
            for (String s : metastoreUrisString) {
                URI tmpUri = new URI(s);
                if (tmpUri.getScheme() == null) {
                    throw new IllegalArgumentException("URI: " + s + " does not have a scheme");
                }
                if (this.uriResolverHook != null) {
                    metastoreURIArray.addAll(this.uriResolverHook.resolveURI(tmpUri));
                    continue;
                }
                metastoreURIArray.add(new URI(tmpUri.getScheme(), tmpUri.getUserInfo(), HadoopThriftAuthBridge.getBridge().getCanonicalHostName(tmpUri.getHost()), tmpUri.getPort(), tmpUri.getPath(), tmpUri.getQuery(), tmpUri.getFragment()));
            }
            this.metastoreUris = new URI[metastoreURIArray.size()];
            for (int j = 0; j < metastoreURIArray.size(); ++j) {
                this.metastoreUris[j] = (URI)metastoreURIArray.get(j);
            }
            if (MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_URI_SELECTION).equalsIgnoreCase("RANDOM")) {
                List<URI> uriList = Arrays.asList(this.metastoreUris);
                Collections.shuffle(uriList);
                this.metastoreUris = (URI[])uriList.toArray();
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            MetaStoreUtils.throwMetaException((Exception)e);
        }
    }

    private MetaStoreFilterHook loadFilterHooks() throws IllegalStateException {
        Class authProviderClass = MetastoreConf.getClass((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.FILTER_HOOK, DefaultMetaStoreFilterHookImpl.class, MetaStoreFilterHook.class);
        String msg = "Unable to create instance of " + authProviderClass.getName() + ": ";
        try {
            Constructor constructor = authProviderClass.getConstructor(Configuration.class);
            return (MetaStoreFilterHook)constructor.newInstance(this.conf);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalStateException(msg + e.getMessage(), e);
        }
    }

    private synchronized URIResolverHook loadUriResolverHook() throws IllegalStateException {
        String uriResolverClassName = MetastoreConf.getAsString((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.URI_RESOLVER);
        if (uriResolverClassName.equals("")) {
            return null;
        }
        LOG.info("Loading uri resolver" + uriResolverClassName);
        try {
            Class<?> uriResolverClass = Class.forName(uriResolverClassName, true, JavaUtils.getClassLoader());
            return (URIResolverHook)ReflectionUtils.newInstance(uriResolverClass, null);
        }
        catch (Exception e) {
            LOG.error("Exception loading uri resolver hook" + e);
            return null;
        }
    }

    private void promoteRandomMetaStoreURI() {
        if (this.metastoreUris.length <= 1) {
            return;
        }
        Random rng = new Random();
        int index = rng.nextInt(this.metastoreUris.length - 1) + 1;
        URI tmp = this.metastoreUris[0];
        this.metastoreUris[0] = this.metastoreUris[index];
        this.metastoreUris[index] = tmp;
    }

    @VisibleForTesting
    public TTransport getTTransport() {
        return this.transport;
    }

    public boolean isLocalMetaStore() {
        return this.localMetaStore;
    }

    public boolean isCompatibleWith(Configuration conf) {
        Map<String, String> currentMetaVarsCopy = this.currentMetaVars;
        if (currentMetaVarsCopy == null) {
            return false;
        }
        boolean compatible = true;
        for (MetastoreConf.ConfVars oneVar : MetastoreConf.metaVars) {
            String oldVar = currentMetaVarsCopy.get(oneVar.getVarname());
            String newVar = MetastoreConf.getAsString((Configuration)conf, (MetastoreConf.ConfVars)oneVar);
            if (oldVar != null && !(oneVar.isCaseSensitive() ? !oldVar.equals(newVar) : !oldVar.equalsIgnoreCase(newVar))) continue;
            LOG.info("Mestastore configuration " + oneVar.toString() + " changed from " + oldVar + " to " + newVar);
            compatible = false;
        }
        return compatible;
    }

    public void setHiveAddedJars(String addedJars) {
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.ADDED_JARS, (String)addedJars);
    }

    public void reconnect() throws MetaException {
        if (this.localMetaStore) {
            throw new MetaException("For direct MetaStore DB connections, we don't support retries at the client level.");
        }
        this.close();
        if (this.uriResolverHook != null) {
            this.resolveUris();
        }
        if (MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_URI_SELECTION).equalsIgnoreCase("RANDOM")) {
            this.promoteRandomMetaStoreURI();
        }
        this.open();
    }

    public void alter_table(String dbname, String tbl_name, Table new_tbl) throws InvalidOperationException, MetaException, TException {
        this.alter_table_with_environmentContext(dbname, tbl_name, new_tbl, null);
    }

    public void alter_table(String defaultDatabaseName, String tblName, Table table, boolean cascade) throws InvalidOperationException, MetaException, TException {
        EnvironmentContext environmentContext = new EnvironmentContext();
        if (cascade) {
            environmentContext.putToProperties("CASCADE", "true");
        }
        this.alter_table_with_environmentContext(defaultDatabaseName, tblName, table, environmentContext);
    }

    public void alter_table_with_environmentContext(String dbname, String tbl_name, Table new_tbl, EnvironmentContext envContext) throws InvalidOperationException, MetaException, TException {
        this.client.alter_table_with_environment_context(dbname, tbl_name, new_tbl, envContext);
    }

    public void renamePartition(String dbname, String name, List<String> part_vals, Partition newPart) throws InvalidOperationException, MetaException, TException {
        this.client.rename_partition(dbname, name, part_vals, newPart);
    }

    private void open() throws MetaException {
        this.isConnected = false;
        TTransportException tte = null;
        boolean useSSL = MetastoreConf.getBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.USE_SSL);
        boolean useSasl = MetastoreConf.getBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.USE_THRIFT_SASL);
        boolean useFramedTransport = MetastoreConf.getBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.USE_THRIFT_FRAMED_TRANSPORT);
        boolean useCompactProtocol = MetastoreConf.getBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.USE_THRIFT_COMPACT_PROTOCOL);
        int clientSocketTimeout = (int)MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CLIENT_SOCKET_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS);
        int connectionTimeout = (int)MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CLIENT_CONNECTION_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS);
        for (int attempt = 0; !this.isConnected && attempt < this.retries; ++attempt) {
            for (URI store : this.metastoreUris) {
                LOG.info("Trying to connect to metastore with URI " + store);
                try {
                    if (useSSL) {
                        try {
                            String trustStorePath = MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.SSL_TRUSTSTORE_PATH).trim();
                            if (trustStorePath.isEmpty()) {
                                throw new IllegalArgumentException(MetastoreConf.ConfVars.SSL_TRUSTSTORE_PATH.toString() + " Not configured for SSL connection");
                            }
                            String trustStorePassword = MetastoreConf.getPassword((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.SSL_TRUSTSTORE_PASSWORD);
                            String trustStoreType = MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.SSL_TRUSTSTORE_TYPE).trim();
                            String trustStoreAlgorithm = MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.SSL_TRUSTMANAGERFACTORY_ALGORITHM).trim();
                            this.transport = SecurityUtils.getSSLSocket((String)store.getHost(), (int)store.getPort(), (int)clientSocketTimeout, (int)connectionTimeout, (String)trustStorePath, (String)trustStorePassword, (String)trustStoreType, (String)trustStoreAlgorithm);
                            LOG.info("Opened an SSL connection to metastore, current connections: " + connCount.incrementAndGet());
                        }
                        catch (IOException e) {
                            throw new IllegalArgumentException(e);
                        }
                        catch (TTransportException e) {
                            tte = e;
                            throw new MetaException(e.toString());
                        }
                    }
                    try {
                        this.transport = new TSocket(new TConfiguration(), store.getHost(), store.getPort(), clientSocketTimeout, connectionTimeout);
                    }
                    catch (TTransportException e) {
                        tte = e;
                        throw new MetaException(e.toString());
                    }
                    if (useSasl) {
                        try {
                            HadoopThriftAuthBridge.Client authBridge = HadoopThriftAuthBridge.getBridge().createClient();
                            String tokenSig = MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TOKEN_SIGNATURE);
                            this.tokenStrForm = SecurityUtils.getTokenStrForm((String)tokenSig);
                            if (this.tokenStrForm != null) {
                                LOG.info("HMSC::open(): Found delegation token. Creating DIGEST-based thrift connection.");
                                this.transport = authBridge.createClientTransport(null, store.getHost(), "DIGEST", this.tokenStrForm, this.transport, MetaStoreUtils.getMetaStoreSaslProperties((Configuration)this.conf, (boolean)useSSL));
                            }
                            LOG.info("HMSC::open(): Could not find delegation token. Creating KERBEROS-based thrift connection.");
                            String principalConfig = MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.KERBEROS_PRINCIPAL);
                            this.transport = authBridge.createClientTransport(principalConfig, store.getHost(), "KERBEROS", null, this.transport, MetaStoreUtils.getMetaStoreSaslProperties((Configuration)this.conf, (boolean)useSSL));
                        }
                        catch (IOException ioe) {
                            LOG.error("Couldn't create client transport", (Throwable)ioe);
                            throw new MetaException(ioe.toString());
                        }
                    } else if (useFramedTransport) {
                        try {
                            this.transport = new TFramedTransport(this.transport);
                        }
                        catch (TTransportException e) {
                            LOG.error("Couldn't create client transport", (Throwable)e);
                            throw new MetaException(e.toString());
                        }
                    }
                    Object protocol = useCompactProtocol ? new TCompactProtocol(this.transport) : new TBinaryProtocol(this.transport);
                    this.client = new ThriftHiveMetastore.Client((TProtocol)protocol);
                    try {
                        if (!this.transport.isOpen()) {
                            this.transport.open();
                            LOG.info("Opened a connection to metastore, current connections: " + connCount.incrementAndGet());
                        }
                        this.isConnected = true;
                    }
                    catch (TTransportException e) {
                        tte = e;
                        if (LOG.isDebugEnabled()) {
                            LOG.warn("Failed to connect to the MetaStore Server...", (Throwable)e);
                        }
                        LOG.warn("Failed to connect to the MetaStore Server...");
                    }
                    if (this.isConnected && !useSasl && MetastoreConf.getBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.EXECUTE_SET_UGI)) {
                        try {
                            UserGroupInformation ugi = SecurityUtils.getUGI();
                            this.client.set_ugi(ugi.getUserName(), Arrays.asList(ugi.getGroupNames()));
                        }
                        catch (LoginException e) {
                            LOG.warn("Failed to do login. set_ugi() is not successful, Continuing without it.", (Throwable)e);
                        }
                        catch (IOException e) {
                            LOG.warn("Failed to find ugi of client set_ugi() is not successful, Continuing without it.", (Throwable)e);
                        }
                        catch (TException e) {
                            LOG.warn("set_ugi() not successful, Likely cause: new client talking to old server. Continuing without it.", (Throwable)e);
                        }
                    }
                }
                catch (MetaException e) {
                    LOG.error("Unable to connect to metastore with URI " + store + " in attempt " + attempt, (Throwable)e);
                }
                if (this.isConnected) break;
            }
            if (this.isConnected || this.retryDelaySeconds <= 0L) continue;
            try {
                LOG.info("Waiting " + this.retryDelaySeconds + " seconds before next connection attempt.");
                Thread.sleep(this.retryDelaySeconds * 1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!this.isConnected) {
            throw new MetaException("Could not connect to meta store using any of the URIs provided. Most recent failure: " + StringUtils.stringifyException(tte));
        }
        this.snapshotActiveConf();
        LOG.info("Connected to metastore.");
    }

    private void snapshotActiveConf() {
        this.currentMetaVars = new HashMap<String, String>(MetastoreConf.metaVars.length);
        for (MetastoreConf.ConfVars oneVar : MetastoreConf.metaVars) {
            this.currentMetaVars.put(oneVar.getVarname(), MetastoreConf.getAsString((Configuration)this.conf, (MetastoreConf.ConfVars)oneVar));
        }
    }

    public String getTokenStrForm() throws IOException {
        return this.tokenStrForm;
    }

    @Override
    public void close() {
        this.isConnected = false;
        this.currentMetaVars = null;
        try {
            if (null != this.client) {
                this.client.shutdown();
                if (this.transport == null || !this.transport.isOpen()) {
                    LOG.info("Closed a connection to metastore, current connections: " + connCount.decrementAndGet());
                }
            }
        }
        catch (TException e) {
            LOG.debug("Unable to shutdown metastore client. Will try closing transport directly.", (Throwable)e);
        }
        if (this.transport != null && this.transport.isOpen()) {
            this.transport.close();
            LOG.info("Closed a connection to metastore, current connections: " + connCount.decrementAndGet());
        }
    }

    public void setMetaConf(String key, String value) throws TException {
        this.client.setMetaConf(key, value);
    }

    public String getMetaConf(String key) throws TException {
        return this.client.getMetaConf(key);
    }

    public Partition add_partition(Partition new_part) throws TException {
        return this.add_partition(new_part, null);
    }

    public Partition add_partition(Partition new_part, EnvironmentContext envContext) throws TException {
        Partition p = this.client.add_partition_with_environment_context(new_part, envContext);
        return this.fastpath ? p : this.deepCopy(p);
    }

    public int add_partitions(List<Partition> new_parts) throws TException {
        return this.client.add_partitions(new_parts);
    }

    public List<Partition> add_partitions(List<Partition> parts, boolean ifNotExists, boolean needResults) throws TException {
        if (parts.isEmpty()) {
            return needResults ? new ArrayList() : null;
        }
        Partition part = parts.get(0);
        AddPartitionsRequest req = new AddPartitionsRequest(part.getDbName(), part.getTableName(), parts, ifNotExists);
        req.setNeedResult(needResults);
        AddPartitionsResult result = this.client.add_partitions_req(req);
        return needResults ? this.filterHook.filterPartitions(result.getPartitions()) : null;
    }

    public int add_partitions_pspec(PartitionSpecProxy partitionSpec) throws TException {
        return this.client.add_partitions_pspec(partitionSpec.toPartitionSpec());
    }

    public Partition appendPartition(String db_name, String table_name, List<String> part_vals) throws TException {
        return this.appendPartition(db_name, table_name, part_vals, null);
    }

    public Partition appendPartition(String db_name, String table_name, List<String> part_vals, EnvironmentContext envContext) throws TException {
        Partition p = this.client.append_partition_with_environment_context(db_name, table_name, part_vals, envContext);
        return this.fastpath ? p : this.deepCopy(p);
    }

    public Partition appendPartition(String dbName, String tableName, String partName) throws TException {
        return this.appendPartition(dbName, tableName, partName, (EnvironmentContext)null);
    }

    public Partition appendPartition(String dbName, String tableName, String partName, EnvironmentContext envContext) throws TException {
        Partition p = this.client.append_partition_by_name_with_environment_context(dbName, tableName, partName, envContext);
        return this.fastpath ? p : this.deepCopy(p);
    }

    public Partition exchange_partition(Map<String, String> partitionSpecs, String sourceDb, String sourceTable, String destDb, String destinationTableName) throws MetaException, NoSuchObjectException, InvalidObjectException, TException {
        return this.client.exchange_partition(partitionSpecs, sourceDb, sourceTable, destDb, destinationTableName);
    }

    public List<Partition> exchange_partitions(Map<String, String> partitionSpecs, String sourceDb, String sourceTable, String destDb, String destinationTableName) throws MetaException, NoSuchObjectException, InvalidObjectException, TException {
        return this.client.exchange_partitions(partitionSpecs, sourceDb, sourceTable, destDb, destinationTableName);
    }

    public void validatePartitionNameCharacters(List<String> partVals) throws TException, MetaException {
        this.client.partition_name_has_valid_characters(partVals, true);
    }

    public void createDatabase(Database connector) throws AlreadyExistsException, InvalidObjectException, MetaException, TException {
        this.client.create_database(connector);
    }

    public void createDataConnector(DataConnector connector) throws AlreadyExistsException, InvalidObjectException, MetaException, TException {
        this.client.create_dataconnector(connector);
    }

    public Table getTranslateTableDryrun(Table tbl) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        CreateTableRequest request = new CreateTableRequest(tbl);
        return this.client.translate_table_dryrun(request);
    }

    public void createTable(Table tbl) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        CreateTableRequest request = new CreateTableRequest(tbl);
        this.createTable(request);
    }

    public void createTable(Table tbl, EnvironmentContext envContext) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        CreateTableRequest request = new CreateTableRequest(tbl);
        request.setEnvContext(envContext);
        this.createTable(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTable(CreateTableRequest request) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        Table tbl = request.getTable();
        HiveMetaHook hook = this.getHook(tbl);
        if (hook != null) {
            hook.preCreateTable(tbl);
        }
        boolean success = false;
        try {
            this.client.create_table_req(request);
            if (hook != null) {
                hook.commitCreateTable(tbl);
            }
            success = true;
        }
        finally {
            if (!success && hook != null) {
                try {
                    hook.rollbackCreateTable(tbl);
                }
                catch (Exception e) {
                    LOG.error("Create rollback failed with", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTableWithConstraints(Table tbl, List<SQLPrimaryKey> primaryKeys, List<SQLForeignKey> foreignKeys, List<SQLUniqueConstraint> uniqueConstraints, List<SQLNotNullConstraint> notNullConstraints, List<SQLDefaultConstraint> defaultConstraints, List<SQLCheckConstraint> checkConstraints) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        HiveMetaHook hook = this.getHook(tbl);
        if (hook != null) {
            hook.preCreateTable(tbl);
        }
        boolean success = false;
        try {
            this.client.create_table_with_constraints(tbl, primaryKeys, foreignKeys, uniqueConstraints, notNullConstraints, defaultConstraints, checkConstraints);
            if (hook != null) {
                hook.commitCreateTable(tbl);
            }
            success = true;
        }
        finally {
            if (!success && hook != null) {
                hook.rollbackCreateTable(tbl);
            }
        }
    }

    public void dropConstraint(String dbName, String tableName, String constraintName) throws NoSuchObjectException, MetaException, TException {
        this.client.drop_constraint(new DropConstraintRequest(dbName, tableName, constraintName));
    }

    public void addPrimaryKey(List<SQLPrimaryKey> primaryKeyCols) throws NoSuchObjectException, MetaException, TException {
        this.client.add_primary_key(new AddPrimaryKeyRequest(primaryKeyCols));
    }

    public void addForeignKey(List<SQLForeignKey> foreignKeyCols) throws NoSuchObjectException, MetaException, TException {
        this.client.add_foreign_key(new AddForeignKeyRequest(foreignKeyCols));
    }

    public void addUniqueConstraint(List<SQLUniqueConstraint> uniqueConstraintCols) throws NoSuchObjectException, MetaException, TException {
        this.client.add_unique_constraint(new AddUniqueConstraintRequest(uniqueConstraintCols));
    }

    public void addNotNullConstraint(List<SQLNotNullConstraint> notNullConstraintCols) throws NoSuchObjectException, MetaException, TException {
        this.client.add_not_null_constraint(new AddNotNullConstraintRequest(notNullConstraintCols));
    }

    public void addDefaultConstraint(List<SQLDefaultConstraint> defaultConstraints) throws NoSuchObjectException, MetaException, TException {
        this.client.add_default_constraint(new AddDefaultConstraintRequest(defaultConstraints));
    }

    public void addCheckConstraint(List<SQLCheckConstraint> checkConstraints) throws MetaException, NoSuchObjectException, TException {
        this.client.add_check_constraint(new AddCheckConstraintRequest(checkConstraints));
    }

    public boolean createType(Type type) throws AlreadyExistsException, InvalidObjectException, MetaException, TException {
        return this.client.create_type(type);
    }

    public void dropDatabase(String name) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        this.dropDatabase(name, true, false, false);
    }

    public void dropDatabase(String name, boolean deleteData, boolean ignoreUnknownDb) throws TException {
        this.dropDatabase(name, deleteData, ignoreUnknownDb, false);
    }

    public void dropDatabase(String name, boolean deleteData, boolean ignoreUnknownDb, boolean cascade) throws TException {
        try {
            this.getDatabase(name);
        }
        catch (NoSuchObjectException e) {
            if (!ignoreUnknownDb) {
                throw e;
            }
            return;
        }
        if (cascade) {
            List<String> tableList = this.getAllTables(name);
            for (String table : tableList) {
                try {
                    this.dropTable(name, table, deleteData, true);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
            }
        }
        this.client.drop_database(name, deleteData, cascade);
    }

    public void dropDataConnector(String name, boolean ifNotExists, boolean checkReferences) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        this.client.drop_dataconnector(name, ifNotExists, checkReferences);
    }

    public boolean dropPartition(String db_name, String tbl_name, List<String> part_vals) throws NoSuchObjectException, MetaException, TException {
        return this.dropPartition(db_name, tbl_name, part_vals, true, null);
    }

    public boolean dropPartition(String db_name, String tbl_name, List<String> part_vals, EnvironmentContext env_context) throws NoSuchObjectException, MetaException, TException {
        return this.dropPartition(db_name, tbl_name, part_vals, true, env_context);
    }

    public boolean dropPartition(String dbName, String tableName, String partName, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        return this.dropPartition(dbName, tableName, partName, deleteData, null);
    }

    private static EnvironmentContext getEnvironmentContextWithIfPurgeSet() {
        HashMap<String, String> warehouseOptions = new HashMap<String, String>();
        warehouseOptions.put("ifPurge", "TRUE");
        return new EnvironmentContext(warehouseOptions);
    }

    public boolean dropPartition(String dbName, String tableName, String partName, boolean deleteData, EnvironmentContext envContext) throws NoSuchObjectException, MetaException, TException {
        return this.client.drop_partition_by_name_with_environment_context(dbName, tableName, partName, deleteData, envContext);
    }

    public boolean dropPartition(String db_name, String tbl_name, List<String> part_vals, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        return this.dropPartition(db_name, tbl_name, part_vals, deleteData, null);
    }

    public boolean dropPartition(String db_name, String tbl_name, List<String> part_vals, PartitionDropOptions options) throws TException {
        return this.dropPartition(db_name, tbl_name, part_vals, options.deleteData, (EnvironmentContext)(options.purgeData ? HiveMetaStoreClientPreCatalog.getEnvironmentContextWithIfPurgeSet() : null));
    }

    public boolean dropPartition(String db_name, String tbl_name, List<String> part_vals, boolean deleteData, EnvironmentContext envContext) throws NoSuchObjectException, MetaException, TException {
        return this.client.drop_partition_with_environment_context(db_name, tbl_name, part_vals, deleteData, envContext);
    }

    public List<Partition> dropPartitions(String dbName, String tblName, List<Pair<Integer, byte[]>> partExprs, PartitionDropOptions options) throws TException {
        RequestPartsSpec rps = new RequestPartsSpec();
        ArrayList<DropPartitionsExpr> exprs = new ArrayList<DropPartitionsExpr>(partExprs.size());
        for (Pair<Integer, byte[]> partExpr : partExprs) {
            DropPartitionsExpr dpe = new DropPartitionsExpr();
            dpe.setExpr((byte[])partExpr.getRight());
            dpe.setPartArchiveLevel(((Integer)partExpr.getLeft()).intValue());
            exprs.add(dpe);
        }
        rps.setExprs(exprs);
        DropPartitionsRequest req = new DropPartitionsRequest(dbName, tblName, rps);
        req.setDeleteData(options.deleteData);
        req.setNeedResult(options.returnResults);
        req.setIfExists(options.ifExists);
        if (options.purgeData) {
            LOG.info("Dropped partitions will be purged!");
            req.setEnvironmentContext(HiveMetaStoreClientPreCatalog.getEnvironmentContextWithIfPurgeSet());
        }
        return this.client.drop_partitions_req(req).getPartitions();
    }

    public List<Partition> dropPartitions(String dbName, String tblName, List<Pair<Integer, byte[]>> partExprs, boolean deleteData, boolean ifExists, boolean needResult) throws NoSuchObjectException, MetaException, TException {
        return this.dropPartitions(dbName, tblName, partExprs, PartitionDropOptions.instance().deleteData(deleteData).ifExists(ifExists).returnResults(needResult));
    }

    public List<Partition> dropPartitions(String dbName, String tblName, List<Pair<Integer, byte[]>> partExprs, boolean deleteData, boolean ifExists) throws NoSuchObjectException, MetaException, TException {
        return this.dropPartitions(dbName, tblName, partExprs, PartitionDropOptions.instance().deleteData(deleteData).ifExists(ifExists));
    }

    public void dropTable(String dbname, String name, boolean deleteData, boolean ignoreUnknownTab) throws MetaException, TException, NoSuchObjectException, UnsupportedOperationException {
        this.dropTable(dbname, name, deleteData, ignoreUnknownTab, null);
    }

    public void dropTable(String dbname, String name, boolean deleteData, boolean ignoreUnknownTab, boolean ifPurge) throws MetaException, TException, NoSuchObjectException, UnsupportedOperationException {
        EnvironmentContext envContext = null;
        if (ifPurge) {
            HashMap<String, String> warehouseOptions = new HashMap<String, String>();
            warehouseOptions.put("ifPurge", "TRUE");
            envContext = new EnvironmentContext(warehouseOptions);
        }
        this.dropTable(dbname, name, deleteData, ignoreUnknownTab, envContext);
    }

    public void dropTable(Table table, boolean deleteData, boolean ignoreUnknownTab, boolean ifPurge) throws TException {
        this.dropTable(table.getDbName(), table.getTableName(), deleteData, ignoreUnknownTab, ifPurge);
    }

    public void dropTable(String dbname, String name) throws NoSuchObjectException, MetaException, TException {
        this.dropTable(dbname, name, true, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTable(String dbname, String name, boolean deleteData, boolean ignoreUnknownTab, EnvironmentContext envContext) throws MetaException, TException, NoSuchObjectException, UnsupportedOperationException {
        Table tbl;
        try {
            tbl = this.getTable(dbname, name);
        }
        catch (NoSuchObjectException e) {
            if (!ignoreUnknownTab) {
                throw e;
            }
            return;
        }
        HiveMetaHook hook = this.getHook(tbl);
        if (hook != null) {
            hook.preDropTable(tbl);
        }
        boolean success = false;
        try {
            this.drop_table_with_environment_context(dbname, name, deleteData, envContext);
            if (hook != null) {
                hook.commitDropTable(tbl, deleteData || envContext != null && "TRUE".equals(envContext.getProperties().get("ifPurge")));
            }
            success = true;
        }
        catch (NoSuchObjectException e) {
            if (!ignoreUnknownTab) {
                throw e;
            }
        }
        finally {
            if (!success && hook != null) {
                hook.rollbackDropTable(tbl);
            }
        }
    }

    public void truncateTable(String dbName, String tableName, List<String> partNames) throws MetaException, TException {
        this.client.truncate_table(dbName, tableName, partNames);
    }

    public CmRecycleResponse recycleDirToCmPath(CmRecycleRequest request) throws MetaException, TException {
        return this.client.cm_recycle(request);
    }

    public boolean dropType(String type) throws NoSuchObjectException, MetaException, TException {
        return this.client.drop_type(type);
    }

    public Map<String, Type> getTypeAll(String name) throws MetaException, TException {
        LinkedHashMap<String, Type> result = null;
        Map fromClient = this.client.get_type_all(name);
        if (fromClient != null) {
            result = new LinkedHashMap<String, Type>();
            for (String key : fromClient.keySet()) {
                result.put(key, this.deepCopy((Type)fromClient.get(key)));
            }
        }
        return result;
    }

    public List<String> getDatabases(String databasePattern) throws MetaException {
        try {
            return this.filterHook.filterDatabases(this.client.get_databases(databasePattern));
        }
        catch (Exception e) {
            MetaStoreUtils.throwMetaException((Exception)e);
            return null;
        }
    }

    public List<String> getAllDatabases() throws MetaException {
        try {
            return this.filterHook.filterDatabases(this.client.get_all_databases());
        }
        catch (Exception e) {
            MetaStoreUtils.throwMetaException((Exception)e);
            return null;
        }
    }

    public List<String> getAllDataConnectorNames() throws MetaException {
        try {
            this.client.get_dataconnectors();
        }
        catch (Exception e) {
            MetaStoreUtils.throwMetaException((Exception)e);
        }
        return null;
    }

    public List<Partition> listPartitions(String db_name, String tbl_name, short max_parts) throws NoSuchObjectException, MetaException, TException {
        List<Partition> parts = this.client.get_partitions(db_name, tbl_name, max_parts);
        return this.fastpath ? parts : this.deepCopyPartitions(this.filterHook.filterPartitions((List)parts));
    }

    public PartitionSpecProxy listPartitionSpecs(String dbName, String tableName, int maxParts) throws TException {
        return PartitionSpecProxy.Factory.get((List)this.filterHook.filterPartitionSpecs(this.client.get_partitions_pspec(dbName, tableName, maxParts)));
    }

    public List<Partition> listPartitions(String db_name, String tbl_name, List<String> part_vals, short max_parts) throws NoSuchObjectException, MetaException, TException {
        List<Partition> parts = this.client.get_partitions_ps(db_name, tbl_name, part_vals, max_parts);
        return this.fastpath ? parts : this.deepCopyPartitions(this.filterHook.filterPartitions((List)parts));
    }

    public List<Partition> listPartitionsWithAuthInfo(String db_name, String tbl_name, short max_parts, String user_name, List<String> group_names) throws NoSuchObjectException, MetaException, TException {
        List<Partition> parts = this.client.get_partitions_with_auth(db_name, tbl_name, max_parts, user_name, group_names);
        return this.fastpath ? parts : this.deepCopyPartitions(this.filterHook.filterPartitions((List)parts));
    }

    public GetPartitionsPsWithAuthResponse listPartitionsWithAuthInfoRequest(GetPartitionsPsWithAuthRequest req) throws MetaException, TException, NoSuchObjectException {
        GetPartitionsPsWithAuthResponse res = this.client.get_partitions_ps_with_auth_req(req);
        List<Partition> parts = this.fastpath ? res.getPartitions() : this.deepCopyPartitions(this.filterHook.filterPartitions(res.getPartitions()));
        res.setPartitions((List)parts);
        return res;
    }

    public List<Partition> listPartitionsWithAuthInfo(String db_name, String tbl_name, List<String> part_vals, short max_parts, String user_name, List<String> group_names) throws NoSuchObjectException, MetaException, TException {
        List<Partition> parts = this.client.get_partitions_ps_with_auth(db_name, tbl_name, part_vals, max_parts, user_name, group_names);
        return this.fastpath ? parts : this.deepCopyPartitions(this.filterHook.filterPartitions((List)parts));
    }

    public List<Partition> listPartitionsByFilter(String db_name, String tbl_name, String filter, short max_parts) throws MetaException, NoSuchObjectException, TException {
        List<Partition> parts = this.client.get_partitions_by_filter(db_name, tbl_name, filter, max_parts);
        return this.fastpath ? parts : this.deepCopyPartitions(this.filterHook.filterPartitions((List)parts));
    }

    public PartitionSpecProxy listPartitionSpecsByFilter(String db_name, String tbl_name, String filter, int max_parts) throws MetaException, NoSuchObjectException, TException {
        return PartitionSpecProxy.Factory.get((List)this.filterHook.filterPartitionSpecs(this.client.get_part_specs_by_filter(db_name, tbl_name, filter, max_parts)));
    }

    public boolean listPartitionsByExpr(String db_name, String tbl_name, byte[] expr, String default_partition_name, short max_parts, List<Partition> result) throws TException {
        PartitionsByExprResult r;
        assert (result != null);
        PartitionsByExprRequest req = new PartitionsByExprRequest(db_name, tbl_name, ByteBuffer.wrap(expr));
        if (default_partition_name != null) {
            req.setDefaultPartitionName(default_partition_name);
        }
        if (max_parts >= 0) {
            req.setMaxParts(max_parts);
        }
        try {
            r = this.client.get_partitions_by_expr(req);
        }
        catch (TApplicationException te) {
            if (te.getType() != 1 && te.getType() != 3) {
                throw te;
            }
            throw new IMetaStoreClient.IncompatibleMetastoreException("Metastore doesn't support listPartitionsByExpr: " + te.getMessage());
        }
        if (this.fastpath) {
            result.addAll(r.getPartitions());
        } else {
            r.setPartitions(this.filterHook.filterPartitions(r.getPartitions()));
            this.deepCopyPartitions(r.getPartitions(), result);
        }
        return !r.isSetHasUnknownPartitions() || r.isHasUnknownPartitions();
    }

    public boolean listPartitionsSpecByExpr(PartitionsByExprRequest req, List<PartitionSpec> result) throws TException {
        PartitionsSpecByExprResult r;
        assert (result != null);
        try {
            r = this.client.get_partitions_spec_by_expr(req);
        }
        catch (TApplicationException te) {
            if (te.getType() != 1 && te.getType() != 3) {
                throw te;
            }
            throw new IMetaStoreClient.IncompatibleMetastoreException("Metastore doesn't support listPartitionsByExpr: " + te.getMessage());
        }
        r.setPartitionsSpec(this.filterHook.filterPartitionSpecs(r.getPartitionsSpec()));
        result.addAll(r.getPartitionsSpec());
        return !r.isSetHasUnknownPartitions() || r.isHasUnknownPartitions();
    }

    public Database getDatabase(String name) throws NoSuchObjectException, MetaException, TException {
        Database d = this.client.get_database(name);
        return this.fastpath ? d : this.deepCopy(this.filterHook.filterDatabase(d));
    }

    public DataConnector getDataConnector(String name) throws NoSuchObjectException, MetaException, TException {
        GetDataConnectorRequest request = new GetDataConnectorRequest();
        request.setConnectorName(name);
        return this.client.get_dataconnector_req(request);
    }

    public Partition getPartition(String db_name, String tbl_name, List<String> part_vals) throws NoSuchObjectException, MetaException, TException {
        Partition p = this.client.get_partition(db_name, tbl_name, part_vals);
        return this.fastpath ? p : this.deepCopy(this.filterHook.filterPartition(p));
    }

    public GetPartitionResponse getPartitionRequest(GetPartitionRequest req) throws NoSuchObjectException, MetaException, TException {
        return this.client.get_partition_req(req);
    }

    public List<Partition> getPartitionsByNames(String db_name, String tbl_name, List<String> part_names) throws NoSuchObjectException, MetaException, TException {
        GetPartitionsByNamesRequest gpbnr = new GetPartitionsByNamesRequest(db_name, tbl_name);
        gpbnr.setNames(part_names);
        List<Partition> parts = this.client.get_partitions_by_names_req(gpbnr).getPartitions();
        return this.fastpath ? parts : this.deepCopyPartitions(this.filterHook.filterPartitions((List)parts));
    }

    public PartitionsResponse getPartitionsRequest(PartitionsRequest req) throws NoSuchObjectException, MetaException, TException {
        return this.client.get_partitions_req(req);
    }

    public List<String> listPartitionNames(PartitionsByExprRequest request) throws MetaException, TException, NoSuchObjectException {
        throw new UnsupportedOperationException();
    }

    public PartitionValuesResponse listPartitionValues(PartitionValuesRequest request) throws MetaException, TException, NoSuchObjectException {
        return this.client.get_partition_values(request);
    }

    public Partition getPartitionWithAuthInfo(String db_name, String tbl_name, List<String> part_vals, String user_name, List<String> group_names) throws MetaException, UnknownTableException, NoSuchObjectException, TException {
        Partition p = this.client.get_partition_with_auth(db_name, tbl_name, part_vals, user_name, group_names);
        return this.fastpath ? p : this.deepCopy(this.filterHook.filterPartition(p));
    }

    public Table getTable(String dbname, String name) throws MetaException, TException, NoSuchObjectException {
        GetTableRequest req = new GetTableRequest(dbname, name);
        req.setCapabilities(this.version);
        Table t = this.client.get_table_req(req).getTable();
        return this.fastpath ? t : this.deepCopy(this.filterHook.filterTable(t));
    }

    public List<Table> getTableObjectsByName(String dbName, List<String> tableNames) throws MetaException, InvalidOperationException, UnknownDBException, TException {
        GetTablesRequest req = new GetTablesRequest(dbName);
        req.setTblNames(tableNames);
        req.setCapabilities(this.version);
        List<Table> tabs = this.client.get_table_objects_by_name_req(req).getTables();
        return this.fastpath ? tabs : this.deepCopyTables(this.filterHook.filterTables((List)tabs));
    }

    public List<ExtendedTableInfo> getTablesExt(String catName, String dbName, String tablePattern, int requestedFields, int limit) throws MetaException, TException {
        GetTablesExtRequest req = new GetTablesExtRequest(catName, dbName, tablePattern, requestedFields);
        req.setLimit(limit);
        return this.client.get_tables_ext(req);
    }

    public Materialization getMaterializationInvalidationInfo(CreationMetadata cm, String validTxnList) throws MetaException, InvalidOperationException, UnknownDBException, TException {
        return this.client.get_materialization_invalidation_info(cm, validTxnList);
    }

    public void updateCreationMetadata(String dbName, String tableName, CreationMetadata cm) throws MetaException, InvalidOperationException, UnknownDBException, TException {
        this.client.update_creation_metadata(null, dbName, tableName, cm);
    }

    public List<String> listTableNamesByFilter(String dbName, String filter, short maxTables) throws MetaException, TException, InvalidOperationException, UnknownDBException {
        return this.filterHook.filterTableNames(null, dbName, this.client.get_table_names_by_filter(dbName, filter, maxTables));
    }

    public Type getType(String name) throws NoSuchObjectException, MetaException, TException {
        return this.deepCopy(this.client.get_type(name));
    }

    public List<String> getTables(String dbname, String tablePattern) throws MetaException {
        try {
            return this.filterHook.filterTableNames(null, dbname, this.client.get_tables(dbname, tablePattern));
        }
        catch (Exception e) {
            MetaStoreUtils.throwMetaException((Exception)e);
            return null;
        }
    }

    public List<String> getTables(String dbname, String tablePattern, TableType tableType) throws MetaException {
        try {
            return this.filterHook.filterTableNames(null, dbname, this.client.get_tables_by_type(dbname, tablePattern, tableType.toString()));
        }
        catch (Exception e) {
            MetaStoreUtils.throwMetaException((Exception)e);
            return null;
        }
    }

    public List<Table> getAllMaterializedViewObjectsForRewriting() throws MetaException {
        try {
            return this.filterHook.filterTables(this.client.get_all_materialized_view_objects_for_rewriting());
        }
        catch (Exception e) {
            MetaStoreUtils.throwMetaException((Exception)e);
            return null;
        }
    }

    public List<String> getMaterializedViewsForRewriting(String dbname) throws MetaException {
        try {
            return this.filterHook.filterTableNames(null, dbname, this.client.get_materialized_views_for_rewriting(dbname));
        }
        catch (Exception e) {
            MetaStoreUtils.throwMetaException((Exception)e);
            return null;
        }
    }

    public List<TableMeta> getTableMeta(String dbPatterns, String tablePatterns, List<String> tableTypes) throws MetaException {
        try {
            return this.filterNames(this.client.get_table_meta(dbPatterns, tablePatterns, tableTypes));
        }
        catch (Exception e) {
            MetaStoreUtils.throwMetaException((Exception)e);
            return null;
        }
    }

    private List<TableMeta> filterNames(List<TableMeta> metas) throws MetaException {
        LinkedHashMap<String, TableMeta> sources = new LinkedHashMap<String, TableMeta>();
        LinkedHashMap<String, ArrayList<String>> dbTables = new LinkedHashMap<String, ArrayList<String>>();
        for (TableMeta meta : metas) {
            sources.put(meta.getDbName() + "." + meta.getTableName(), meta);
            ArrayList<String> tables = (ArrayList<String>)dbTables.get(meta.getDbName());
            if (tables == null) {
                tables = new ArrayList<String>();
                dbTables.put(meta.getDbName(), tables);
            }
            tables.add(meta.getTableName());
        }
        ArrayList<TableMeta> filtered = new ArrayList<TableMeta>();
        for (Map.Entry entry : dbTables.entrySet()) {
            for (String table : this.filterHook.filterTableNames(null, (String)entry.getKey(), (List)entry.getValue())) {
                filtered.add((TableMeta)sources.get((String)entry.getKey() + "." + table));
            }
        }
        return filtered;
    }

    public List<String> getAllTables(String dbname) throws MetaException {
        try {
            return this.filterHook.filterTableNames(null, dbname, this.client.get_all_tables(dbname));
        }
        catch (Exception e) {
            MetaStoreUtils.throwMetaException((Exception)e);
            return null;
        }
    }

    public boolean tableExists(String databaseName, String tableName) throws MetaException, TException, UnknownDBException {
        try {
            GetTableRequest req = new GetTableRequest(databaseName, tableName);
            req.setCapabilities(this.version);
            return this.filterHook.filterTable(this.client.get_table_req(req).getTable()) != null;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
    }

    public List<String> listPartitionNames(String dbName, String tblName, short max) throws NoSuchObjectException, MetaException, TException {
        return this.filterHook.filterPartitionNames(null, dbName, tblName, this.client.get_partition_names(dbName, tblName, max));
    }

    public GetPartitionNamesPsResponse listPartitionNamesRequest(GetPartitionNamesPsRequest req) throws NoSuchObjectException, MetaException, TException {
        return this.client.get_partition_names_ps_req(req);
    }

    public List<String> listPartitionNames(String db_name, String tbl_name, List<String> part_vals, short max_parts) throws MetaException, TException, NoSuchObjectException {
        return this.filterHook.filterPartitionNames(null, db_name, tbl_name, this.client.get_partition_names_ps(db_name, tbl_name, part_vals, max_parts));
    }

    public int getNumPartitionsByFilter(String db_name, String tbl_name, String filter) throws MetaException, NoSuchObjectException, TException {
        return this.client.get_num_partitions_by_filter(db_name, tbl_name, filter);
    }

    public void alter_partition(String dbName, String tblName, Partition newPart) throws InvalidOperationException, MetaException, TException {
        this.client.alter_partition_with_environment_context(dbName, tblName, newPart, null);
    }

    public void alter_partition(String dbName, String tblName, Partition newPart, EnvironmentContext environmentContext) throws InvalidOperationException, MetaException, TException {
        this.client.alter_partition_with_environment_context(dbName, tblName, newPart, environmentContext);
    }

    public void alter_partitions(String dbName, String tblName, List<Partition> newParts) throws InvalidOperationException, MetaException, TException {
        this.client.alter_partitions(dbName, tblName, newParts);
    }

    public void alter_partitions(String dbName, String tblName, List<Partition> newParts, EnvironmentContext environmentContext) throws InvalidOperationException, MetaException, TException {
        AlterPartitionsRequest req = new AlterPartitionsRequest();
        req.setDbName(dbName);
        req.setTableName(tblName);
        req.setPartitions(newParts);
        req.setEnvironmentContext(environmentContext);
        this.client.alter_partitions_req(req);
    }

    public void alter_partitions(String dbName, String tblName, List<Partition> newParts, EnvironmentContext environmentContext, String writeIdList, long writeId) throws InvalidOperationException, MetaException, TException {
        AlterPartitionsRequest req = new AlterPartitionsRequest();
        req.setDbName(dbName);
        req.setTableName(tblName);
        req.setPartitions(newParts);
        req.setEnvironmentContext(environmentContext);
        req.setValidWriteIdList(writeIdList);
        this.client.alter_partitions_req(req);
    }

    public void alterDatabase(String dbName, Database db) throws MetaException, NoSuchObjectException, TException {
        this.client.alter_database(dbName, db);
    }

    public void alterDataConnector(String dcName, DataConnector connector) throws MetaException, NoSuchObjectException, TException {
        this.client.alter_dataconnector(dcName, connector);
    }

    public List<FieldSchema> getFields(String db, String tableName) throws MetaException, TException, UnknownTableException, UnknownDBException {
        List<FieldSchema> fields = this.client.get_fields(db, tableName);
        return this.fastpath ? fields : this.deepCopyFieldSchemas(fields);
    }

    public List<SQLPrimaryKey> getPrimaryKeys(PrimaryKeysRequest req) throws MetaException, NoSuchObjectException, TException {
        return this.client.get_primary_keys(req).getPrimaryKeys();
    }

    public List<SQLForeignKey> getForeignKeys(ForeignKeysRequest req) throws MetaException, NoSuchObjectException, TException {
        return this.client.get_foreign_keys(req).getForeignKeys();
    }

    public List<SQLUniqueConstraint> getUniqueConstraints(UniqueConstraintsRequest req) throws MetaException, NoSuchObjectException, TException {
        return this.client.get_unique_constraints(req).getUniqueConstraints();
    }

    public List<SQLNotNullConstraint> getNotNullConstraints(NotNullConstraintsRequest req) throws MetaException, NoSuchObjectException, TException {
        return this.client.get_not_null_constraints(req).getNotNullConstraints();
    }

    public List<SQLDefaultConstraint> getDefaultConstraints(DefaultConstraintsRequest req) throws MetaException, NoSuchObjectException, TException {
        return this.client.get_default_constraints(req).getDefaultConstraints();
    }

    public List<SQLCheckConstraint> getCheckConstraints(CheckConstraintsRequest request) throws MetaException, NoSuchObjectException, TException {
        return this.client.get_check_constraints(request).getCheckConstraints();
    }

    public SQLAllTableConstraints getAllTableConstraints(AllTableConstraintsRequest request) throws MetaException, NoSuchObjectException, TException {
        return this.client.get_all_table_constraints(request).getAllTableConstraints();
    }

    @Deprecated
    public boolean updateTableColumnStatistics(ColumnStatistics statsObj) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException {
        return this.client.update_table_column_statistics(statsObj);
    }

    @Deprecated
    public boolean updatePartitionColumnStatistics(ColumnStatistics statsObj) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException {
        return this.client.update_partition_column_statistics(statsObj);
    }

    public boolean setPartitionColumnStatistics(SetPartitionsStatsRequest request) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException {
        return this.client.set_aggr_stats_for(request);
    }

    public void flushCache() {
        try {
            this.client.flushCache();
        }
        catch (TException e) {
            LOG.warn("Got error flushing the cache", (Throwable)e);
        }
    }

    public List<ColumnStatisticsObj> getTableColumnStatistics(String dbName, String tableName, List<String> colNames, String engine) throws NoSuchObjectException, MetaException, TException, InvalidInputException, InvalidObjectException {
        return this.client.get_table_statistics_req(new TableStatsRequest(dbName, tableName, colNames, engine)).getTableStats();
    }

    public List<ColumnStatisticsObj> getTableColumnStatistics(String dbName, String tableName, List<String> colNames, String engine, String validWriteIdList) throws NoSuchObjectException, MetaException, TException {
        TableStatsRequest tsr = new TableStatsRequest(dbName, tableName, colNames, engine);
        tsr.setValidWriteIdList(validWriteIdList);
        return this.client.get_table_statistics_req(tsr).getTableStats();
    }

    public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String dbName, String tableName, List<String> partNames, List<String> colNames, String engine) throws NoSuchObjectException, MetaException, TException {
        return this.client.get_partitions_statistics_req(new PartitionsStatsRequest(dbName, tableName, colNames, partNames, engine)).getPartStats();
    }

    public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String dbName, String tableName, List<String> partNames, List<String> colNames, String engine, String validWriteIdList) throws NoSuchObjectException, MetaException, TException {
        PartitionsStatsRequest psr = new PartitionsStatsRequest(dbName, tableName, colNames, partNames, engine);
        psr.setValidWriteIdList(validWriteIdList);
        return this.client.get_partitions_statistics_req(psr).getPartStats();
    }

    public boolean deletePartitionColumnStatistics(String dbName, String tableName, String partName, String colName, String engine) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException {
        return this.client.delete_partition_column_statistics(dbName, tableName, partName, colName, engine);
    }

    public boolean deleteTableColumnStatistics(String dbName, String tableName, String colName, String engine) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException {
        return this.client.delete_table_column_statistics(dbName, tableName, colName, engine);
    }

    public void updateTransactionalStatistics(UpdateTransactionalStatsRequest req) throws TException {
        this.client.update_transaction_statistics(req);
    }

    public List<FieldSchema> getSchema(String db, String tableName) throws MetaException, TException, UnknownTableException, UnknownDBException {
        EnvironmentContext envCxt = null;
        String addedJars = MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.ADDED_JARS);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)addedJars)) {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("hive.added.jars.path", addedJars);
            envCxt = new EnvironmentContext(props);
        }
        List<FieldSchema> fields = this.client.get_schema_with_environment_context(db, tableName, envCxt);
        return this.fastpath ? fields : this.deepCopyFieldSchemas(fields);
    }

    public String getConfigValue(String name, String defaultValue) throws TException, ConfigValSecurityException {
        return this.client.get_config_value(name, defaultValue);
    }

    public Partition getPartition(String db, String tableName, String partName) throws MetaException, TException, UnknownTableException, NoSuchObjectException {
        Partition p = this.client.get_partition_by_name(db, tableName, partName);
        return this.fastpath ? p : this.deepCopy(this.filterHook.filterPartition(p));
    }

    public Partition appendPartitionByName(String dbName, String tableName, String partName) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        return this.appendPartitionByName(dbName, tableName, partName, null);
    }

    public Partition appendPartitionByName(String dbName, String tableName, String partName, EnvironmentContext envContext) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        Partition p = this.client.append_partition_by_name_with_environment_context(dbName, tableName, partName, envContext);
        return this.fastpath ? p : this.deepCopy(p);
    }

    public boolean dropPartitionByName(String dbName, String tableName, String partName, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        return this.dropPartitionByName(dbName, tableName, partName, deleteData, null);
    }

    public boolean dropPartitionByName(String dbName, String tableName, String partName, boolean deleteData, EnvironmentContext envContext) throws NoSuchObjectException, MetaException, TException {
        return this.client.drop_partition_by_name_with_environment_context(dbName, tableName, partName, deleteData, envContext);
    }

    private HiveMetaHook getHook(Table tbl) throws MetaException {
        if (this.hookLoader == null) {
            return null;
        }
        return this.hookLoader.getHook(tbl);
    }

    public List<String> partitionNameToVals(String name) throws MetaException, TException {
        return this.client.partition_name_to_vals(name);
    }

    public Map<String, String> partitionNameToSpec(String name) throws MetaException, TException {
        return this.client.partition_name_to_spec(name);
    }

    private Partition deepCopy(Partition partition) {
        Partition copy = null;
        if (partition != null) {
            copy = new Partition(partition);
        }
        return copy;
    }

    private Database deepCopy(Database database) {
        Database copy = null;
        if (database != null) {
            copy = new Database(database);
        }
        return copy;
    }

    protected Table deepCopy(Table table) {
        Table copy = null;
        if (table != null) {
            copy = new Table(table);
        }
        return copy;
    }

    private Type deepCopy(Type type) {
        Type copy = null;
        if (type != null) {
            copy = new Type(type);
        }
        return copy;
    }

    private FieldSchema deepCopy(FieldSchema schema) {
        FieldSchema copy = null;
        if (schema != null) {
            copy = new FieldSchema(schema);
        }
        return copy;
    }

    private Function deepCopy(Function func) {
        Function copy = null;
        if (func != null) {
            copy = new Function(func);
        }
        return copy;
    }

    protected PrincipalPrivilegeSet deepCopy(PrincipalPrivilegeSet pps) {
        PrincipalPrivilegeSet copy = null;
        if (pps != null) {
            copy = new PrincipalPrivilegeSet(pps);
        }
        return copy;
    }

    private List<Partition> deepCopyPartitions(List<Partition> partitions) {
        return this.deepCopyPartitions(partitions, null);
    }

    private List<Partition> deepCopyPartitions(Collection<Partition> src, List<Partition> dest) {
        if (src == null) {
            return dest;
        }
        if (dest == null) {
            dest = new ArrayList<Partition>(src.size());
        }
        for (Partition part : src) {
            dest.add(this.deepCopy(part));
        }
        return dest;
    }

    private List<Table> deepCopyTables(List<Table> tables) {
        ArrayList<Table> copy = null;
        if (tables != null) {
            copy = new ArrayList<Table>();
            for (Table tab : tables) {
                copy.add(this.deepCopy(tab));
            }
        }
        return copy;
    }

    protected List<FieldSchema> deepCopyFieldSchemas(List<FieldSchema> schemas) {
        ArrayList<FieldSchema> copy = null;
        if (schemas != null) {
            copy = new ArrayList<FieldSchema>();
            for (FieldSchema schema : schemas) {
                copy.add(this.deepCopy(schema));
            }
        }
        return copy;
    }

    public boolean grant_role(String roleName, String userName, PrincipalType principalType, String grantor, PrincipalType grantorType, boolean grantOption) throws MetaException, TException {
        GrantRevokeRoleRequest req = new GrantRevokeRoleRequest();
        req.setRequestType(GrantRevokeType.GRANT);
        req.setRoleName(roleName);
        req.setPrincipalName(userName);
        req.setPrincipalType(principalType);
        req.setGrantor(grantor);
        req.setGrantorType(grantorType);
        req.setGrantOption(grantOption);
        GrantRevokeRoleResponse res = this.client.grant_revoke_role(req);
        if (!res.isSetSuccess()) {
            throw new MetaException("GrantRevokeResponse missing success field");
        }
        return res.isSuccess();
    }

    public boolean create_role(Role role) throws MetaException, TException {
        return this.client.create_role(role);
    }

    public boolean drop_role(String roleName) throws MetaException, TException {
        return this.client.drop_role(roleName);
    }

    public List<Role> list_roles(String principalName, PrincipalType principalType) throws MetaException, TException {
        return this.client.list_roles(principalName, principalType);
    }

    public List<String> listRoleNames() throws MetaException, TException {
        return this.client.get_role_names();
    }

    public GetPrincipalsInRoleResponse get_principals_in_role(GetPrincipalsInRoleRequest req) throws MetaException, TException {
        return this.client.get_principals_in_role(req);
    }

    public GetRoleGrantsForPrincipalResponse get_role_grants_for_principal(GetRoleGrantsForPrincipalRequest getRolePrincReq) throws MetaException, TException {
        return this.client.get_role_grants_for_principal(getRolePrincReq);
    }

    public boolean grant_privileges(PrivilegeBag privileges) throws MetaException, TException {
        GrantRevokePrivilegeRequest req = new GrantRevokePrivilegeRequest();
        req.setRequestType(GrantRevokeType.GRANT);
        req.setPrivileges(privileges);
        GrantRevokePrivilegeResponse res = this.client.grant_revoke_privileges(req);
        if (!res.isSetSuccess()) {
            throw new MetaException("GrantRevokePrivilegeResponse missing success field");
        }
        return res.isSuccess();
    }

    public boolean revoke_role(String roleName, String userName, PrincipalType principalType, boolean grantOption) throws MetaException, TException {
        GrantRevokeRoleRequest req = new GrantRevokeRoleRequest();
        req.setRequestType(GrantRevokeType.REVOKE);
        req.setRoleName(roleName);
        req.setPrincipalName(userName);
        req.setPrincipalType(principalType);
        req.setGrantOption(grantOption);
        GrantRevokeRoleResponse res = this.client.grant_revoke_role(req);
        if (!res.isSetSuccess()) {
            throw new MetaException("GrantRevokeResponse missing success field");
        }
        return res.isSuccess();
    }

    public boolean revoke_privileges(PrivilegeBag privileges, boolean grantOption) throws MetaException, TException {
        GrantRevokePrivilegeRequest req = new GrantRevokePrivilegeRequest();
        req.setRequestType(GrantRevokeType.REVOKE);
        req.setPrivileges(privileges);
        req.setRevokeGrantOption(grantOption);
        GrantRevokePrivilegeResponse res = this.client.grant_revoke_privileges(req);
        if (!res.isSetSuccess()) {
            throw new MetaException("GrantRevokePrivilegeResponse missing success field");
        }
        return res.isSuccess();
    }

    public boolean refresh_privileges(HiveObjectRef objToRefresh, String authorizer, PrivilegeBag grantPrivileges) throws MetaException, TException {
        String defaultCat = MetaStoreUtils.getDefaultCatalog((Configuration)this.conf);
        objToRefresh.setCatName(defaultCat);
        if (grantPrivileges.getPrivileges() != null) {
            for (HiveObjectPrivilege priv : grantPrivileges.getPrivileges()) {
                if (priv.getHiveObject().isSetCatName()) continue;
                priv.getHiveObject().setCatName(defaultCat);
            }
        }
        GrantRevokePrivilegeRequest grantReq = new GrantRevokePrivilegeRequest();
        grantReq.setRequestType(GrantRevokeType.GRANT);
        grantReq.setPrivileges(grantPrivileges);
        GrantRevokePrivilegeResponse res = this.client.refresh_privileges(objToRefresh, authorizer, grantReq);
        if (!res.isSetSuccess()) {
            throw new MetaException("GrantRevokePrivilegeResponse missing success field");
        }
        return res.isSuccess();
    }

    public PrincipalPrivilegeSet get_privilege_set(HiveObjectRef hiveObject, String userName, List<String> groupNames) throws MetaException, TException {
        return this.client.get_privilege_set(hiveObject, userName, groupNames);
    }

    public List<HiveObjectPrivilege> list_privileges(String principalName, PrincipalType principalType, HiveObjectRef hiveObject) throws MetaException, TException {
        return this.client.list_privileges(principalName, principalType, hiveObject);
    }

    public String getDelegationToken(String renewerKerberosPrincipalName) throws MetaException, TException, IOException {
        String owner = SecurityUtils.getUser();
        return this.getDelegationToken(owner, renewerKerberosPrincipalName);
    }

    public String getDelegationToken(String owner, String renewerKerberosPrincipalName) throws MetaException, TException {
        if (this.localMetaStore) {
            return null;
        }
        return this.client.get_delegation_token(owner, renewerKerberosPrincipalName);
    }

    public long renewDelegationToken(String tokenStrForm) throws MetaException, TException {
        if (this.localMetaStore) {
            return 0L;
        }
        return this.client.renew_delegation_token(tokenStrForm);
    }

    public void cancelDelegationToken(String tokenStrForm) throws MetaException, TException {
        if (this.localMetaStore) {
            return;
        }
        this.client.cancel_delegation_token(tokenStrForm);
    }

    public boolean addToken(String tokenIdentifier, String delegationToken) throws TException {
        return this.client.add_token(tokenIdentifier, delegationToken);
    }

    public boolean removeToken(String tokenIdentifier) throws TException {
        return this.client.remove_token(tokenIdentifier);
    }

    public String getToken(String tokenIdentifier) throws TException {
        return this.client.get_token(tokenIdentifier);
    }

    public List<String> getAllTokenIdentifiers() throws TException {
        return this.client.get_all_token_identifiers();
    }

    public int addMasterKey(String key) throws MetaException, TException {
        return this.client.add_master_key(key);
    }

    public void updateMasterKey(Integer seqNo, String key) throws NoSuchObjectException, MetaException, TException {
        this.client.update_master_key(seqNo.intValue(), key);
    }

    public boolean removeMasterKey(Integer keySeq) throws TException {
        return this.client.remove_master_key(keySeq.intValue());
    }

    public String[] getMasterKeys() throws TException {
        List keyList = this.client.get_master_keys();
        return keyList.toArray(new String[keyList.size()]);
    }

    public GetOpenTxnsResponse getOpenTxns() throws TException {
        GetOpenTxnsRequest getOpenTxnsRequest = new GetOpenTxnsRequest();
        getOpenTxnsRequest.setExcludeTxnTypes(Arrays.asList(TxnType.READ_ONLY));
        return this.client.get_open_txns_req(getOpenTxnsRequest);
    }

    public ValidTxnList getValidTxns() throws TException {
        GetOpenTxnsRequest getOpenTxnsRequest = new GetOpenTxnsRequest();
        getOpenTxnsRequest.setExcludeTxnTypes(Arrays.asList(TxnType.READ_ONLY));
        return TxnCommonUtils.createValidReadTxnList((GetOpenTxnsResponse)this.client.get_open_txns_req(getOpenTxnsRequest), (long)0L);
    }

    public ValidTxnList getValidTxns(long currentTxn) throws TException {
        GetOpenTxnsRequest getOpenTxnsRequest = new GetOpenTxnsRequest();
        getOpenTxnsRequest.setExcludeTxnTypes(Arrays.asList(TxnType.READ_ONLY));
        return TxnCommonUtils.createValidReadTxnList((GetOpenTxnsResponse)this.client.get_open_txns_req(getOpenTxnsRequest), (long)currentTxn);
    }

    public ValidTxnList getValidTxns(long currentTxn, List<TxnType> excludeTxnTypes) throws TException {
        GetOpenTxnsRequest getOpenTxnsRequest = new GetOpenTxnsRequest();
        getOpenTxnsRequest.setExcludeTxnTypes(excludeTxnTypes);
        return TxnCommonUtils.createValidReadTxnList((GetOpenTxnsResponse)this.client.get_open_txns_req(getOpenTxnsRequest), (long)currentTxn);
    }

    public ValidWriteIdList getValidWriteIds(String fullTableName) throws TException {
        GetValidWriteIdsRequest rqst = new GetValidWriteIdsRequest(Collections.singletonList(fullTableName));
        GetValidWriteIdsResponse validWriteIds = this.client.get_valid_write_ids(rqst);
        return TxnCommonUtils.createValidReaderWriteIdList((TableValidWriteIds)((TableValidWriteIds)validWriteIds.getTblValidWriteIds().get(0)));
    }

    public ValidWriteIdList getValidWriteIds(String fullTableName, Long writeId) throws TException {
        GetValidWriteIdsRequest rqst = new GetValidWriteIdsRequest(Collections.singletonList(fullTableName));
        rqst.setWriteId(writeId.longValue());
        GetValidWriteIdsResponse validWriteIds = this.client.get_valid_write_ids(rqst);
        return TxnCommonUtils.createValidReaderWriteIdList((TableValidWriteIds)((TableValidWriteIds)validWriteIds.getTblValidWriteIds().get(0)));
    }

    public List<TableValidWriteIds> getValidWriteIds(List<String> tablesList, String validTxnList) throws TException {
        GetValidWriteIdsRequest rqst = new GetValidWriteIdsRequest(tablesList);
        rqst.setValidTxnList(validTxnList);
        return this.client.get_valid_write_ids(rqst).getTblValidWriteIds();
    }

    public void addWriteIdsToMinHistory(long txnId, Map<String, Long> writeIds) throws TException {
        this.client.add_write_ids_to_min_history(txnId, writeIds);
    }

    public long openTxn(String user) throws TException {
        OpenTxnsResponse txns = this.openTxns(user, 1);
        return (Long)txns.getTxn_ids().get(0);
    }

    public long openTxn(String user, TxnType txnType) throws TException {
        OpenTxnsResponse txns = this.openTxnsIntr(user, 1, null, null, txnType);
        return (Long)txns.getTxn_ids().get(0);
    }

    public OpenTxnsResponse openTxns(String user, int numTxns) throws TException {
        return this.openTxnsIntr(user, numTxns, null, null, null);
    }

    public List<Long> replOpenTxn(String replPolicy, List<Long> srcTxnIds, String user, TxnType txnType) throws TException {
        OpenTxnsResponse txns = this.openTxnsIntr(user, srcTxnIds != null ? srcTxnIds.size() : 1, replPolicy, srcTxnIds, txnType);
        return txns.getTxn_ids();
    }

    private OpenTxnsResponse openTxnsIntr(String user, int numTxns, String replPolicy, List<Long> srcTxnIds, TxnType txnType) throws TException {
        String hostname;
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOG.error("Unable to resolve my host name " + e.getMessage());
            throw new RuntimeException(e);
        }
        OpenTxnRequest rqst = new OpenTxnRequest(numTxns, user, hostname);
        if (replPolicy != null) {
            rqst.setReplPolicy(replPolicy);
            if (txnType == TxnType.REPL_CREATED) {
                assert (srcTxnIds != null);
                assert (numTxns == srcTxnIds.size());
                rqst.setReplSrcTxnIds(srcTxnIds);
            }
        } else assert (srcTxnIds == null);
        if (txnType != null) {
            rqst.setTxn_type(txnType);
        }
        return this.client.open_txns(rqst);
    }

    public void rollbackTxn(long txnid) throws NoSuchTxnException, TException {
        this.client.abort_txn(new AbortTxnRequest(txnid));
    }

    public void rollbackTxn(AbortTxnRequest abortTxnRequest) throws NoSuchTxnException, TException {
        this.client.abort_txn(abortTxnRequest);
    }

    public void replRollbackTxn(long srcTxnId, String replPolicy, TxnType txnType) throws NoSuchTxnException, TException {
        AbortTxnRequest rqst = new AbortTxnRequest(srcTxnId);
        rqst.setReplPolicy(replPolicy);
        rqst.setTxn_type(txnType);
        this.client.abort_txn(rqst);
    }

    public void commitTxn(long txnid) throws NoSuchTxnException, TxnAbortedException, TException {
        this.client.commit_txn(new CommitTxnRequest(txnid));
    }

    public void commitTxnWithKeyValue(long txnid, long tableId, String key, String value) throws NoSuchTxnException, TxnAbortedException, TException {
        CommitTxnRequest ctr = new CommitTxnRequest(txnid);
        Preconditions.checkNotNull((Object)key, (Object)"The key to commit together with the transaction can't be null");
        Preconditions.checkNotNull((Object)value, (Object)"The value to commit together with the transaction can't be null");
        ctr.setKeyValue(new CommitTxnKeyValue(tableId, key, value));
        this.client.commit_txn(ctr);
    }

    public void commitTxn(CommitTxnRequest rqst) throws NoSuchTxnException, TxnAbortedException, TException {
        this.client.commit_txn(rqst);
    }

    public GetOpenTxnsInfoResponse showTxns() throws TException {
        return this.client.get_open_txns_info();
    }

    public void abortTxns(List<Long> txnids) throws NoSuchTxnException, TException {
        this.client.abort_txns(new AbortTxnsRequest(txnids));
    }

    public void abortTxns(AbortTxnsRequest abortTxnsRequest) throws NoSuchTxnException, TException {
        this.client.abort_txns(abortTxnsRequest);
    }

    public void replTableWriteIdState(String validWriteIdList, String dbName, String tableName, List<String> partNames) throws TException {
        String hostName;
        String user;
        try {
            user = UserGroupInformation.getCurrentUser().getUserName();
        }
        catch (IOException e) {
            LOG.error("Unable to resolve current user name " + e.getMessage());
            throw new RuntimeException(e);
        }
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOG.error("Unable to resolve my host name " + e.getMessage());
            throw new RuntimeException(e);
        }
        ReplTblWriteIdStateRequest rqst = new ReplTblWriteIdStateRequest(validWriteIdList, user, hostName, dbName, tableName);
        if (partNames != null) {
            rqst.setPartNames(partNames);
        }
        this.client.repl_tbl_writeid_state(rqst);
    }

    public long allocateTableWriteId(long txnId, String dbName, String tableName, boolean shouldRealloc) throws TException {
        return this.allocateTableWriteIdsBatch(Collections.singletonList(txnId), dbName, tableName, shouldRealloc).get(0).getWriteId();
    }

    public long allocateTableWriteId(long txnId, String dbName, String tableName) throws TException {
        return this.allocateTableWriteIdsBatch(Collections.singletonList(txnId), dbName, tableName, false).get(0).getWriteId();
    }

    public List<TxnToWriteId> allocateTableWriteIdsBatch(List<Long> txnIds, String dbName, String tableName) throws TException {
        return this.allocateTableWriteIdsBatch(txnIds, dbName, tableName, false);
    }

    public List<TxnToWriteId> allocateTableWriteIdsBatch(List<Long> txnIds, String dbName, String tableName, boolean shouldRealloc) throws TException {
        AllocateTableWriteIdsRequest rqst = new AllocateTableWriteIdsRequest(dbName, tableName);
        rqst.setTxnIds(txnIds);
        rqst.setReallocate(shouldRealloc);
        return this.allocateTableWriteIdsBatchIntr(rqst);
    }

    public List<TxnToWriteId> replAllocateTableWriteIdsBatch(String dbName, String tableName, String replPolicy, List<TxnToWriteId> srcTxnToWriteIdList) throws TException {
        AllocateTableWriteIdsRequest rqst = new AllocateTableWriteIdsRequest(dbName, tableName);
        rqst.setReplPolicy(replPolicy);
        rqst.setSrcTxnToWriteIdList(srcTxnToWriteIdList);
        return this.allocateTableWriteIdsBatchIntr(rqst);
    }

    private List<TxnToWriteId> allocateTableWriteIdsBatchIntr(AllocateTableWriteIdsRequest rqst) throws TException {
        return this.client.allocate_table_write_ids(rqst).getTxnToWriteIds();
    }

    public LockResponse lock(LockRequest request) throws NoSuchTxnException, TxnAbortedException, TException {
        return this.client.lock(request);
    }

    public LockResponse checkLock(long lockid) throws NoSuchTxnException, TxnAbortedException, NoSuchLockException, TException {
        return this.client.check_lock(new CheckLockRequest(lockid));
    }

    public void unlock(long lockid) throws NoSuchLockException, TxnOpenException, TException {
        this.client.unlock(new UnlockRequest(lockid));
    }

    @Deprecated
    public ShowLocksResponse showLocks() throws TException {
        return this.client.show_locks(new ShowLocksRequest());
    }

    public ShowLocksResponse showLocks(ShowLocksRequest request) throws TException {
        return this.client.show_locks(request);
    }

    public void heartbeat(long txnid, long lockid) throws NoSuchLockException, NoSuchTxnException, TxnAbortedException, TException {
        HeartbeatRequest hb = new HeartbeatRequest();
        hb.setLockid(lockid);
        hb.setTxnid(txnid);
        this.client.heartbeat(hb);
    }

    public HeartbeatTxnRangeResponse heartbeatTxnRange(long min, long max) throws NoSuchTxnException, TxnAbortedException, TException {
        HeartbeatTxnRangeRequest rqst = new HeartbeatTxnRangeRequest(min, max);
        return this.client.heartbeat_txn_range(rqst);
    }

    @Deprecated
    public void compact(String dbname, String tableName, String partitionName, CompactionType type) throws TException {
        CompactionRequest cr = new CompactionRequest();
        if (dbname == null) {
            cr.setDbname("default");
        } else {
            cr.setDbname(dbname);
        }
        cr.setTablename(tableName);
        if (partitionName != null) {
            cr.setPartitionname(partitionName);
        }
        cr.setType(type);
        this.client.compact(cr);
    }

    @Deprecated
    public void compact(String dbname, String tableName, String partitionName, CompactionType type, Map<String, String> tblproperties) throws TException {
        this.compact2(dbname, tableName, partitionName, type, tblproperties);
    }

    public CompactionResponse compact2(String dbname, String tableName, String partitionName, CompactionType type, Map<String, String> tblproperties) throws TException {
        CompactionRequest cr = new CompactionRequest();
        if (dbname == null) {
            cr.setDbname("default");
        } else {
            cr.setDbname(dbname);
        }
        cr.setTablename(tableName);
        if (partitionName != null) {
            cr.setPartitionname(partitionName);
        }
        cr.setType(type);
        cr.setProperties(tblproperties);
        return this.client.compact2(cr);
    }

    public CompactionResponse compact2(CompactionRequest request) throws TException {
        return this.client.compact2(request);
    }

    public ShowCompactResponse showCompactions() throws TException {
        return this.client.show_compact(new ShowCompactRequest());
    }

    public AbortCompactResponse abortCompactions(AbortCompactionRequest request) throws TException {
        return this.client.abort_Compactions(request);
    }

    public ShowCompactResponse showCompactions(ShowCompactRequest request) throws TException {
        return this.client.show_compact(request);
    }

    public boolean submitForCleanup(CompactionRequest rqst, long highestWriteId, long txnId) throws TException {
        return this.client.submit_for_cleanup(rqst, highestWriteId, txnId);
    }

    public GetLatestCommittedCompactionInfoResponse getLatestCommittedCompactionInfo(GetLatestCommittedCompactionInfoRequest request) throws TException {
        return this.client.get_latest_committed_compaction_info(request);
    }

    @Deprecated
    public void addDynamicPartitions(long txnId, long writeId, String dbName, String tableName, List<String> partNames) throws TException {
        this.client.add_dynamic_partitions(new AddDynamicPartitions(txnId, writeId, dbName, tableName, partNames));
    }

    public void addDynamicPartitions(long txnId, long writeId, String dbName, String tableName, List<String> partNames, DataOperationType operationType) throws TException {
        AddDynamicPartitions adp = new AddDynamicPartitions(txnId, writeId, dbName, tableName, partNames);
        adp.setOperationType(operationType);
        this.client.add_dynamic_partitions(adp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertTable(Table table, boolean overwrite) throws MetaException {
        boolean failed = true;
        HiveMetaHook hook = this.getHook(table);
        if (hook == null || !(hook instanceof DefaultHiveMetaHook)) {
            return;
        }
        DefaultHiveMetaHook hiveMetaHook = (DefaultHiveMetaHook)hook;
        try {
            hiveMetaHook.commitInsertTable(table, overwrite);
            failed = false;
        }
        finally {
            if (failed) {
                hiveMetaHook.rollbackInsertTable(table, overwrite);
            }
        }
    }

    public long getLatestTxnIdInConflict(long txnId) throws MetaException {
        return 0L;
    }

    @InterfaceAudience.LimitedPrivate(value={"HCatalog"})
    public NotificationEventResponse getNextNotification(long lastEventId, int maxEvents, IMetaStoreClient.NotificationFilter filter) throws TException {
        NotificationEventRequest rqst = new NotificationEventRequest(lastEventId);
        rqst.setMaxEvents(maxEvents);
        return this.getNextNotificationEventsInternal(rqst, false, filter);
    }

    public NotificationEventResponse getNextNotification(NotificationEventRequest request, boolean allowGapsInEventIds, IMetaStoreClient.NotificationFilter filter) throws TException {
        return this.getNextNotificationEventsInternal(request, allowGapsInEventIds, filter);
    }

    @NotNull
    private NotificationEventResponse getNextNotificationEventsInternal(NotificationEventRequest request, boolean allowGapsInEventIds, IMetaStoreClient.NotificationFilter filter) throws TException {
        long lastEventId = request.getLastEvent();
        NotificationEventResponse rsp = this.client.get_next_notification(request);
        LOG.debug("Got back " + rsp.getEventsSize() + " events");
        NotificationEventResponse filtered = new NotificationEventResponse();
        if (rsp != null && rsp.getEvents() != null) {
            long nextEventId = lastEventId + 1L;
            for (NotificationEvent e : rsp.getEvents()) {
                if (!allowGapsInEventIds && e.getEventId() != nextEventId) {
                    LOG.error("Requested events are found missing in NOTIFICATION_LOG table. Expected: {}, Actual: {}. Probably, cleaner would've cleaned it up. Try setting higher value for hive.metastore.event.db.listener.timetolive. Also, bootstrap the system again to get back the consistent replicated state.", (Object)nextEventId, (Object)e.getEventId());
                    throw new IllegalStateException("Notification events are missing.");
                }
                if (filter != null && filter.accept(e)) {
                    filtered.addToEvents(e);
                }
                ++nextEventId;
            }
        }
        return filter != null ? filtered : rsp;
    }

    @InterfaceAudience.LimitedPrivate(value={"HCatalog"})
    public CurrentNotificationEventId getCurrentNotificationEventId() throws TException {
        return this.client.get_current_notificationEventId();
    }

    @InterfaceAudience.LimitedPrivate(value={"HCatalog"})
    public NotificationEventsCountResponse getNotificationEventsCount(NotificationEventsCountRequest rqst) throws TException {
        return this.client.get_notification_events_count(rqst);
    }

    @InterfaceAudience.LimitedPrivate(value={"Apache Hive, HCatalog"})
    public FireEventResponse fireListenerEvent(FireEventRequest rqst) throws TException {
        return this.client.fire_listener_event(rqst);
    }

    @InterfaceAudience.LimitedPrivate(value={"Apache Hive, HCatalog"})
    public void addWriteNotificationLog(WriteNotificationLogRequest rqst) throws TException {
        this.client.add_write_notification_log(rqst);
    }

    @InterfaceAudience.LimitedPrivate(value={"Apache Hive, HCatalog"})
    public void addWriteNotificationLogInBatch(WriteNotificationLogBatchRequest rqst) throws TException {
        this.client.add_write_notification_log_in_batch(rqst);
    }

    public static IMetaStoreClient newSynchronizedClient(IMetaStoreClient client) {
        return (IMetaStoreClient)Proxy.newProxyInstance(HiveMetaStoreClientPreCatalog.class.getClassLoader(), new Class[]{IMetaStoreClient.class}, (InvocationHandler)new SynchronizedHandler(client));
    }

    public void markPartitionForEvent(String db_name, String tbl_name, Map<String, String> partKVs, PartitionEventType eventType) throws MetaException, TException, NoSuchObjectException, UnknownDBException, UnknownTableException, InvalidPartitionException, UnknownPartitionException {
        assert (db_name != null);
        assert (tbl_name != null);
        assert (partKVs != null);
        this.client.markPartitionForEvent(db_name, tbl_name, partKVs, eventType);
    }

    public boolean isPartitionMarkedForEvent(String db_name, String tbl_name, Map<String, String> partKVs, PartitionEventType eventType) throws MetaException, NoSuchObjectException, UnknownTableException, UnknownDBException, TException, InvalidPartitionException, UnknownPartitionException {
        assert (db_name != null);
        assert (tbl_name != null);
        assert (partKVs != null);
        return this.client.isPartitionMarkedForEvent(db_name, tbl_name, partKVs, eventType);
    }

    public void createFunction(Function func) throws InvalidObjectException, MetaException, TException {
        this.client.create_function(func);
    }

    public void alterFunction(String dbName, String funcName, Function newFunction) throws InvalidObjectException, MetaException, TException {
        this.client.alter_function(dbName, funcName, newFunction);
    }

    public void dropFunction(String dbName, String funcName) throws MetaException, NoSuchObjectException, InvalidObjectException, InvalidInputException, TException {
        this.client.drop_function(dbName, funcName);
    }

    public Function getFunction(String dbName, String funcName) throws MetaException, TException {
        Function f = this.client.get_function(dbName, funcName);
        return this.fastpath ? f : this.deepCopy(f);
    }

    public List<String> getFunctions(String dbName, String pattern) throws MetaException, TException {
        return this.client.get_functions(dbName, pattern);
    }

    public GetAllFunctionsResponse getAllFunctions() throws MetaException, TException {
        return this.client.get_all_functions();
    }

    protected void create_table_with_environment_context(Table tbl, EnvironmentContext envContext) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        this.client.create_table_with_environment_context(tbl, envContext);
    }

    protected void drop_table_with_environment_context(String dbname, String name, boolean deleteData, EnvironmentContext envContext) throws MetaException, TException, NoSuchObjectException, UnsupportedOperationException {
        this.client.drop_table_with_environment_context(dbname, name, deleteData, envContext);
    }

    public AggrStats getAggrColStatsFor(String dbName, String tblName, List<String> colNames, List<String> partNames, String engine) throws NoSuchObjectException, MetaException, TException {
        if (colNames.isEmpty() || partNames.isEmpty()) {
            LOG.debug("Columns is empty or partNames is empty : Short-circuiting stats eval on client side.");
            return new AggrStats(new ArrayList(), 0L);
        }
        PartitionsStatsRequest req = new PartitionsStatsRequest(dbName, tblName, colNames, partNames, engine);
        return this.client.get_aggr_stats_for(req);
    }

    public AggrStats getAggrColStatsFor(String dbName, String tblName, List<String> colNames, List<String> partName, String engine, String writeIdList) throws NoSuchObjectException, MetaException, TException {
        if (colNames.isEmpty() || partName.isEmpty()) {
            LOG.debug("Columns is empty or partNames is empty : Short-circuiting stats eval on client side.");
            return new AggrStats(new ArrayList(), 0L);
        }
        PartitionsStatsRequest req = new PartitionsStatsRequest(dbName, tblName, colNames, partName, engine);
        req.setValidWriteIdList(writeIdList);
        return this.client.get_aggr_stats_for(req);
    }

    public Iterable<Map.Entry<Long, ByteBuffer>> getFileMetadata(final List<Long> fileIds) throws TException {
        return new MetastoreMapIterable<Long, ByteBuffer>(){
            private int listIndex = 0;

            @Override
            protected Map<Long, ByteBuffer> fetchNextBatch() throws TException {
                if (this.listIndex == fileIds.size()) {
                    return null;
                }
                int endIndex = Math.min(this.listIndex + HiveMetaStoreClientPreCatalog.this.fileMetadataBatchSize, fileIds.size());
                List subList = fileIds.subList(this.listIndex, endIndex);
                GetFileMetadataResult resp = HiveMetaStoreClientPreCatalog.this.sendGetFileMetadataReq(subList);
                if (!resp.isIsSupported()) {
                    return null;
                }
                this.listIndex = endIndex;
                return resp.getMetadata();
            }
        };
    }

    private GetFileMetadataResult sendGetFileMetadataReq(List<Long> fileIds) throws TException {
        return this.client.get_file_metadata(new GetFileMetadataRequest(fileIds));
    }

    public Iterable<Map.Entry<Long, MetadataPpdResult>> getFileMetadataBySarg(final List<Long> fileIds, final ByteBuffer sarg, final boolean doGetFooters) throws TException {
        return new MetastoreMapIterable<Long, MetadataPpdResult>(){
            private int listIndex = 0;

            @Override
            protected Map<Long, MetadataPpdResult> fetchNextBatch() throws TException {
                if (this.listIndex == fileIds.size()) {
                    return null;
                }
                int endIndex = Math.min(this.listIndex + HiveMetaStoreClientPreCatalog.this.fileMetadataBatchSize, fileIds.size());
                List subList = fileIds.subList(this.listIndex, endIndex);
                GetFileMetadataByExprResult resp = HiveMetaStoreClientPreCatalog.this.sendGetFileMetadataBySargReq(sarg, subList, doGetFooters);
                if (!resp.isIsSupported()) {
                    return null;
                }
                this.listIndex = endIndex;
                return resp.getMetadata();
            }
        };
    }

    private GetFileMetadataByExprResult sendGetFileMetadataBySargReq(ByteBuffer sarg, List<Long> fileIds, boolean doGetFooters) throws TException {
        GetFileMetadataByExprRequest req = new GetFileMetadataByExprRequest(fileIds, sarg);
        req.setDoGetFooters(doGetFooters);
        return this.client.get_file_metadata_by_expr(req);
    }

    public void clearFileMetadata(List<Long> fileIds) throws TException {
        ClearFileMetadataRequest req = new ClearFileMetadataRequest();
        req.setFileIds(fileIds);
        this.client.clear_file_metadata(req);
    }

    public void putFileMetadata(List<Long> fileIds, List<ByteBuffer> metadata) throws TException {
        PutFileMetadataRequest req = new PutFileMetadataRequest();
        req.setFileIds(fileIds);
        req.setMetadata(metadata);
        this.client.put_file_metadata(req);
    }

    public boolean isSameConfObj(Configuration c) {
        return this.conf == c;
    }

    public boolean cacheFileMetadata(String dbName, String tableName, String partName, boolean allParts) throws TException {
        CacheFileMetadataRequest req = new CacheFileMetadataRequest();
        req.setDbName(dbName);
        req.setTblName(tableName);
        if (partName != null) {
            req.setPartName(partName);
        } else {
            req.setIsAllParts(allParts);
        }
        CacheFileMetadataResult result = this.client.cache_file_metadata(req);
        return result.isIsSupported();
    }

    public String getMetastoreDbUuid() throws TException {
        return this.client.get_metastore_db_uuid();
    }

    public void createResourcePlan(WMResourcePlan resourcePlan, String copyFromName) throws InvalidObjectException, MetaException, TException {
        WMCreateResourcePlanRequest request = new WMCreateResourcePlanRequest();
        request.setResourcePlan(resourcePlan);
        request.setCopyFrom(copyFromName);
        this.client.create_resource_plan(request);
    }

    public WMFullResourcePlan getResourcePlan(String resourcePlanName, String ns) throws NoSuchObjectException, MetaException, TException {
        WMGetResourcePlanRequest request = new WMGetResourcePlanRequest();
        request.setResourcePlanName(resourcePlanName);
        request.setNs(ns);
        return this.client.get_resource_plan(request).getResourcePlan();
    }

    public List<WMResourcePlan> getAllResourcePlans(String ns) throws NoSuchObjectException, MetaException, TException {
        WMGetAllResourcePlanRequest request = new WMGetAllResourcePlanRequest();
        request.setNs(ns);
        return this.client.get_all_resource_plans(request).getResourcePlans();
    }

    public void dropResourcePlan(String resourcePlanName, String ns) throws NoSuchObjectException, MetaException, TException {
        WMDropResourcePlanRequest request = new WMDropResourcePlanRequest();
        request.setResourcePlanName(resourcePlanName);
        request.setNs(ns);
        this.client.drop_resource_plan(request);
    }

    public WMFullResourcePlan alterResourcePlan(String resourcePlanName, String ns, WMNullableResourcePlan resourcePlan, boolean canActivateDisabled, boolean isForceDeactivate, boolean isReplace) throws NoSuchObjectException, InvalidObjectException, MetaException, TException {
        WMAlterResourcePlanRequest request = new WMAlterResourcePlanRequest();
        request.setResourcePlanName(resourcePlanName);
        request.setNs(ns);
        request.setResourcePlan(resourcePlan);
        request.setIsEnableAndActivate(canActivateDisabled);
        request.setIsForceDeactivate(isForceDeactivate);
        request.setIsReplace(isReplace);
        WMAlterResourcePlanResponse resp = this.client.alter_resource_plan(request);
        return resp.isSetFullResourcePlan() ? resp.getFullResourcePlan() : null;
    }

    public WMFullResourcePlan getActiveResourcePlan(String ns) throws MetaException, TException {
        WMGetActiveResourcePlanRequest request = new WMGetActiveResourcePlanRequest();
        request.setNs(ns);
        return this.client.get_active_resource_plan(request).getResourcePlan();
    }

    public WMValidateResourcePlanResponse validateResourcePlan(String resourcePlanName, String ns) throws NoSuchObjectException, InvalidObjectException, MetaException, TException {
        WMValidateResourcePlanRequest request = new WMValidateResourcePlanRequest();
        request.setResourcePlanName(resourcePlanName);
        request.setNs(ns);
        return this.client.validate_resource_plan(request);
    }

    public void createWMTrigger(WMTrigger trigger) throws InvalidObjectException, MetaException, TException {
        WMCreateTriggerRequest request = new WMCreateTriggerRequest();
        request.setTrigger(trigger);
        this.client.create_wm_trigger(request);
    }

    public void alterWMTrigger(WMTrigger trigger) throws NoSuchObjectException, InvalidObjectException, MetaException, TException {
        WMAlterTriggerRequest request = new WMAlterTriggerRequest();
        request.setTrigger(trigger);
        this.client.alter_wm_trigger(request);
    }

    public void dropWMTrigger(String resourcePlanName, String triggerName, String ns) throws NoSuchObjectException, MetaException, TException {
        WMDropTriggerRequest request = new WMDropTriggerRequest();
        request.setResourcePlanName(resourcePlanName);
        request.setTriggerName(triggerName);
        request.setNs(ns);
        this.client.drop_wm_trigger(request);
    }

    public List<WMTrigger> getTriggersForResourcePlan(String resourcePlan, String ns) throws NoSuchObjectException, MetaException, TException {
        WMGetTriggersForResourePlanRequest request = new WMGetTriggersForResourePlanRequest();
        request.setResourcePlanName(resourcePlan);
        request.setNs(ns);
        return this.client.get_triggers_for_resourceplan(request).getTriggers();
    }

    public void createWMPool(WMPool pool) throws NoSuchObjectException, InvalidObjectException, MetaException, TException {
        WMCreatePoolRequest request = new WMCreatePoolRequest();
        request.setPool(pool);
        this.client.create_wm_pool(request);
    }

    public void alterWMPool(WMNullablePool pool, String poolPath) throws NoSuchObjectException, InvalidObjectException, MetaException, TException {
        WMAlterPoolRequest request = new WMAlterPoolRequest();
        request.setPool(pool);
        request.setPoolPath(poolPath);
        this.client.alter_wm_pool(request);
    }

    public void dropWMPool(String resourcePlanName, String poolPath, String ns) throws NoSuchObjectException, MetaException, TException {
        WMDropPoolRequest request = new WMDropPoolRequest();
        request.setResourcePlanName(resourcePlanName);
        request.setPoolPath(poolPath);
        request.setNs(ns);
        this.client.drop_wm_pool(request);
    }

    public void createOrUpdateWMMapping(WMMapping mapping, boolean isUpdate) throws NoSuchObjectException, InvalidObjectException, MetaException, TException {
        WMCreateOrUpdateMappingRequest request = new WMCreateOrUpdateMappingRequest();
        request.setMapping(mapping);
        request.setUpdate(isUpdate);
        this.client.create_or_update_wm_mapping(request);
    }

    public void dropWMMapping(WMMapping mapping) throws NoSuchObjectException, MetaException, TException {
        WMDropMappingRequest request = new WMDropMappingRequest();
        request.setMapping(mapping);
        this.client.drop_wm_mapping(request);
    }

    public void createOrDropTriggerToPoolMapping(String resourcePlanName, String triggerName, String poolPath, boolean shouldDrop, String ns) throws AlreadyExistsException, NoSuchObjectException, InvalidObjectException, MetaException, TException {
        WMCreateOrDropTriggerToPoolMappingRequest request = new WMCreateOrDropTriggerToPoolMappingRequest();
        request.setResourcePlanName(resourcePlanName);
        request.setTriggerName(triggerName);
        request.setPoolPath(poolPath);
        request.setDrop(shouldDrop);
        request.setNs(ns);
        this.client.create_or_drop_wm_trigger_to_pool_mapping(request);
    }

    public void createCatalog(Catalog catalog) throws AlreadyExistsException, InvalidObjectException, MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public Catalog getCatalog(String catName) throws TException {
        throw new UnsupportedOperationException();
    }

    public void alterCatalog(String catalogName, Catalog newCatalog) throws NoSuchObjectException, InvalidObjectException, MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public List<String> getCatalogs() throws TException {
        throw new UnsupportedOperationException();
    }

    public void dropCatalog(String catName) throws TException {
        throw new UnsupportedOperationException();
    }

    public List<String> getDatabases(String catName, String databasePattern) throws MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public List<String> getAllDatabases(String catName) throws MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public List<String> getTables(String catName, String dbName, String tablePattern) throws MetaException, TException, UnknownDBException {
        throw new UnsupportedOperationException();
    }

    public List<String> getTables(String catName, String dbName, String tablePattern, TableType tableType) throws MetaException, TException, UnknownDBException {
        throw new UnsupportedOperationException();
    }

    public List<String> getMaterializedViewsForRewriting(String catName, String dbName) throws MetaException, TException, UnknownDBException {
        throw new UnsupportedOperationException();
    }

    public List<TableMeta> getTableMeta(String catName, String dbPatterns, String tablePatterns, List<String> tableTypes) throws MetaException, TException, UnknownDBException {
        throw new UnsupportedOperationException();
    }

    public List<String> getAllTables(String catName, String dbName) throws MetaException, TException, UnknownDBException {
        throw new UnsupportedOperationException();
    }

    public List<String> listTableNamesByFilter(String catName, String dbName, String filter, int maxTables) throws TException, InvalidOperationException, UnknownDBException {
        throw new UnsupportedOperationException();
    }

    public void dropTable(String catName, String dbName, String tableName, boolean deleteData, boolean ignoreUnknownTable, boolean ifPurge) throws MetaException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException();
    }

    public void truncateTable(String catName, String dbName, String tableName, List<String> partNames) throws MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public boolean tableExists(String catName, String dbName, String tableName) throws MetaException, TException, UnknownDBException {
        throw new UnsupportedOperationException();
    }

    public Database getDatabase(String catalogName, String databaseName) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public Table getTable(String catName, String dbName, String tableName) throws MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public Table getTable(String catName, String dbName, boolean getColumnStats, String engine) throws MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public Table getTable(String catName, String dbName, String tableName, String validWriteIdList) throws TException {
        throw new UnsupportedOperationException();
    }

    public Table getTable(String catName, String dbName, String tableName, String validWriteIdList, boolean getColumnStats, String engine) throws TException {
        throw new UnsupportedOperationException();
    }

    public Table getTable(GetTableRequest getTableRequest) throws MetaException, TException, NoSuchObjectException {
        throw new UnsupportedOperationException();
    }

    public List<Table> getTableObjectsByName(String catName, String dbName, List<String> tableNames) throws MetaException, InvalidOperationException, UnknownDBException, TException {
        throw new UnsupportedOperationException();
    }

    public List<Table> getTables(String catName, String dbName, List<String> tableNames, GetProjectionsSpec projectionsSpec) throws MetaException, InvalidOperationException, UnknownDBException, TException {
        throw new UnsupportedOperationException();
    }

    public void updateCreationMetadata(String catName, String dbName, String tableName, CreationMetadata cm) throws MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public Partition appendPartition(String catName, String dbName, String tableName, List<String> partVals) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public Partition appendPartition(String catName, String dbName, String tableName, String name) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public Partition getPartition(String catName, String dbName, String tblName, List<String> partVals) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public Partition exchange_partition(Map<String, String> partitionSpecs, String sourceCat, String sourceDb, String sourceTable, String destCat, String destdb, String destTableName) throws MetaException, NoSuchObjectException, InvalidObjectException, TException {
        throw new UnsupportedOperationException();
    }

    public List<Partition> exchange_partitions(Map<String, String> partitionSpecs, String sourceCat, String sourceDb, String sourceTable, String destCat, String destdb, String destTableName) throws MetaException, NoSuchObjectException, InvalidObjectException, TException {
        throw new UnsupportedOperationException();
    }

    public Partition getPartition(String catName, String dbName, String tblName, String name) throws MetaException, UnknownTableException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException();
    }

    public Partition getPartitionWithAuthInfo(String catName, String dbName, String tableName, List<String> pvals, String userName, List<String> groupNames) throws MetaException, UnknownTableException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException();
    }

    public List<Partition> listPartitions(String catName, String db_name, String tbl_name, int max_parts) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public PartitionSpecProxy listPartitionSpecs(String catName, String dbName, String tableName, int maxParts) throws TException {
        throw new UnsupportedOperationException();
    }

    public List<Partition> listPartitions(String catName, String db_name, String tbl_name, List<String> part_vals, int max_parts) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public List<String> listPartitionNames(String catName, String db_name, String tbl_name, int max_parts) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public List<String> listPartitionNames(String catName, String db_name, String tbl_name, List<String> part_vals, int max_parts) throws MetaException, TException, NoSuchObjectException {
        throw new UnsupportedOperationException();
    }

    public int getNumPartitionsByFilter(String catName, String dbName, String tableName, String filter) throws MetaException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException();
    }

    public List<Partition> listPartitionsByFilter(String catName, String db_name, String tbl_name, String filter, int max_parts) throws MetaException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException();
    }

    public PartitionSpecProxy listPartitionSpecsByFilter(String catName, String db_name, String tbl_name, String filter, int max_parts) throws MetaException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException();
    }

    public boolean listPartitionsByExpr(String catName, String db_name, String tbl_name, byte[] expr, String default_partition_name, int max_parts, List<Partition> result) throws TException {
        throw new UnsupportedOperationException();
    }

    public List<Partition> listPartitionsWithAuthInfo(String catName, String dbName, String tableName, int maxParts, String userName, List<String> groupNames) throws MetaException, TException, NoSuchObjectException {
        throw new UnsupportedOperationException();
    }

    public List<Partition> getPartitionsByNames(String catName, String db_name, String tbl_name, List<String> part_names) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public GetPartitionsByNamesResult getPartitionsByNames(GetPartitionsByNamesRequest req) throws TException {
        throw new UnsupportedOperationException();
    }

    public List<Partition> listPartitionsWithAuthInfo(String catName, String dbName, String tableName, List<String> partialPvals, int maxParts, String userName, List<String> groupNames) throws MetaException, TException, NoSuchObjectException {
        throw new UnsupportedOperationException();
    }

    public void markPartitionForEvent(String catName, String db_name, String tbl_name, Map<String, String> partKVs, PartitionEventType eventType) throws MetaException, NoSuchObjectException, TException, UnknownTableException, UnknownDBException, UnknownPartitionException, InvalidPartitionException {
        throw new UnsupportedOperationException();
    }

    public boolean isPartitionMarkedForEvent(String catName, String db_name, String tbl_name, Map<String, String> partKVs, PartitionEventType eventType) throws MetaException, NoSuchObjectException, TException, UnknownTableException, UnknownDBException, UnknownPartitionException, InvalidPartitionException {
        throw new UnsupportedOperationException();
    }

    public void alter_table(String catName, String dbName, String tblName, Table newTable, EnvironmentContext envContext) throws InvalidOperationException, MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public void dropDatabase(DropDatabaseRequest req) throws TException {
        throw new UnsupportedOperationException();
    }

    public void alterDatabase(String catName, String dbName, Database newDb) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public boolean dropPartition(String catName, String db_name, String tbl_name, List<String> part_vals, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public boolean dropPartition(String catName, String db_name, String tbl_name, List<String> part_vals, PartitionDropOptions options) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public List<Partition> dropPartitions(String catName, String dbName, String tblName, List<Pair<Integer, byte[]>> partExprs, PartitionDropOptions options) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public boolean dropPartition(String catName, String db_name, String tbl_name, String name, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public void alter_partition(String catName, String dbName, String tblName, Partition newPart, EnvironmentContext environmentContext) throws InvalidOperationException, MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public void alter_partitions(String catName, String dbName, String tblName, List<Partition> newParts, EnvironmentContext environmentContext, String writeIdList, long writeId) throws InvalidOperationException, MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public void renamePartition(String catName, String dbname, String tableName, List<String> part_vals, Partition newPart, String validWriteIds, long txnId, boolean makeCopy) throws TException {
        throw new UnsupportedOperationException();
    }

    public List<FieldSchema> getFields(String catName, String db, String tableName) throws MetaException, TException, UnknownTableException, UnknownDBException {
        throw new UnsupportedOperationException();
    }

    public GetFieldsResponse getFieldsRequest(GetFieldsRequest req) throws MetaException, TException, UnknownTableException, UnknownDBException {
        throw new UnsupportedOperationException("getFieldsRequest is not supported in HiveMetastoreClientPreCatalog. Use HiveMetastoreClient instead");
    }

    public List<FieldSchema> getSchema(String catName, String db, String tableName) throws MetaException, TException, UnknownTableException, UnknownDBException {
        throw new UnsupportedOperationException();
    }

    public GetSchemaResponse getSchemaRequest(GetSchemaRequest req) throws MetaException, TException, UnknownTableException, UnknownDBException {
        throw new UnsupportedOperationException("getSchemaRequest is not supported in HiveMetastoreClientPreCatalog. Use HiveMetastoreClient instead");
    }

    public List<ColumnStatisticsObj> getTableColumnStatistics(String catName, String dbName, String tableName, List<String> colNames, String engine) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public List<ColumnStatisticsObj> getTableColumnStatistics(String catName, String dbName, String tableName, List<String> colNames, String engine, String validWriteIdList) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String catName, String dbName, String tableName, List<String> partNames, List<String> colNames, String engine) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String catName, String dbName, String tableName, List<String> partNames, List<String> colNames, String engine, String validWriteIdList) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public boolean deletePartitionColumnStatistics(String catName, String dbName, String tableName, String partName, String colName, String engine) throws NoSuchObjectException, MetaException, InvalidObjectException, TException, InvalidInputException {
        throw new UnsupportedOperationException();
    }

    public boolean deleteTableColumnStatistics(String catName, String dbName, String tableName, String colName, String engine) throws NoSuchObjectException, MetaException, InvalidObjectException, TException, InvalidInputException {
        throw new UnsupportedOperationException();
    }

    public void alterFunction(String catName, String dbName, String funcName, Function newFunction) throws InvalidObjectException, MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public void dropFunction(String catName, String dbName, String funcName) throws MetaException, NoSuchObjectException, InvalidObjectException, InvalidInputException, TException {
        throw new UnsupportedOperationException();
    }

    public Function getFunction(String catName, String dbName, String funcName) throws MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public List<String> getFunctions(String catName, String dbName, String pattern) throws MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public AggrStats getAggrColStatsFor(String catName, String dbName, String tblName, List<String> colNames, List<String> partNames, String engine) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public AggrStats getAggrColStatsFor(String catName, String dbName, String tblName, List<String> colNames, List<String> partNames, String engine, String writeIdList) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public void dropConstraint(String catName, String dbName, String tableName, String constraintName) throws MetaException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException();
    }

    public void createISchema(ISchema schema) throws TException {
        throw new UnsupportedOperationException();
    }

    public void alterISchema(String catName, String dbName, String schemaName, ISchema newSchema) throws TException {
        throw new UnsupportedOperationException();
    }

    public ISchema getISchema(String catName, String dbName, String name) throws TException {
        throw new UnsupportedOperationException();
    }

    public void dropISchema(String catName, String dbName, String name) throws TException {
        throw new UnsupportedOperationException();
    }

    public void addSchemaVersion(SchemaVersion schemaVersion) throws TException {
        throw new UnsupportedOperationException();
    }

    public SchemaVersion getSchemaVersion(String catName, String dbName, String schemaName, int version) throws TException {
        throw new UnsupportedOperationException();
    }

    public SchemaVersion getSchemaLatestVersion(String catName, String dbName, String schemaName) throws TException {
        throw new UnsupportedOperationException();
    }

    public List<SchemaVersion> getSchemaAllVersions(String catName, String dbName, String schemaName) throws TException {
        throw new UnsupportedOperationException();
    }

    public void dropSchemaVersion(String catName, String dbName, String schemaName, int version) throws TException {
        throw new UnsupportedOperationException();
    }

    public FindSchemasByColsResp getSchemaByCols(FindSchemasByColsRqst rqst) throws TException {
        throw new UnsupportedOperationException();
    }

    public void mapSchemaVersionToSerde(String catName, String dbName, String schemaName, int version, String serdeName) throws TException {
        throw new UnsupportedOperationException();
    }

    public void setSchemaVersionState(String catName, String dbName, String schemaName, int version, SchemaVersionState state) throws TException {
        throw new UnsupportedOperationException();
    }

    public void addSerDe(SerDeInfo serDeInfo) throws TException {
        throw new UnsupportedOperationException();
    }

    public SerDeInfo getSerDe(String serDeName) throws TException {
        throw new UnsupportedOperationException();
    }

    public LockResponse lockMaterializationRebuild(String dbName, String tableName, long txnId) throws TException {
        throw new UnsupportedOperationException();
    }

    public boolean heartbeatLockMaterializationRebuild(String dbName, String tableName, long txnId) throws TException {
        throw new UnsupportedOperationException();
    }

    public void addRuntimeStat(RuntimeStat stat) throws TException {
        throw new UnsupportedOperationException();
    }

    public List<RuntimeStat> getRuntimeStats(int maxWeight, int maxCreateTime) throws TException {
        throw new UnsupportedOperationException();
    }

    public void alter_table(String catName, String databaseName, String tblName, Table table, EnvironmentContext environmentContext, String validWriteIdList) throws InvalidOperationException, MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public void alter_partition(String catName, String dbName, String tblName, Partition newPart, EnvironmentContext environmentContext, String writeIdList) throws InvalidOperationException, MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public void truncateTable(String dbName, String tableName, List<String> partNames, String validWriteIds, long writeId) throws TException {
        throw new UnsupportedOperationException();
    }

    public void truncateTable(String dbName, String tableName, List<String> partNames, String validWriteIds, long writeId, boolean deleteData) throws TException {
        throw new UnsupportedOperationException();
    }

    public GetPartitionsResponse getPartitionsWithSpecs(GetPartitionsRequest request) throws TException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public OptionalCompactionInfoStruct findNextCompact(String workerId) throws MetaException, TException {
        return this.client.find_next_compact(workerId);
    }

    public OptionalCompactionInfoStruct findNextCompact(FindNextCompactRequest rqst) throws MetaException, TException {
        return this.client.find_next_compact2(rqst);
    }

    public void updateCompactorState(CompactionInfoStruct cr, long txnId) throws TException {
        this.client.update_compactor_state(cr, txnId);
    }

    public List<String> findColumnsWithStats(CompactionInfoStruct cr) throws TException {
        return this.client.find_columns_with_stats(cr);
    }

    public void markCleaned(CompactionInfoStruct cr) throws MetaException, TException {
        this.client.mark_cleaned(cr);
    }

    public void markCompacted(CompactionInfoStruct cr) throws MetaException, TException {
        this.client.mark_compacted(cr);
    }

    public void markFailed(CompactionInfoStruct cr) throws MetaException, TException {
        this.client.mark_failed(cr);
    }

    public void markRefused(CompactionInfoStruct cr) throws MetaException, TException {
        this.client.mark_refused(cr);
    }

    public boolean updateCompactionMetricsData(CompactionMetricsDataStruct struct) throws MetaException, TException {
        return this.client.update_compaction_metrics_data(struct);
    }

    public void removeCompactionMetricsData(CompactionMetricsDataRequest request) throws MetaException, TException {
        this.client.remove_compaction_metrics_data(request);
    }

    public void setHadoopJobid(String jobId, long cqId) throws MetaException, TException {
        this.client.set_hadoop_jobid(jobId, cqId);
    }

    public String getServerVersion() throws TException {
        return this.client.getVersion();
    }

    public ScheduledQuery getScheduledQuery(ScheduledQueryKey key) throws TException {
        return this.client.get_scheduled_query(key);
    }

    public void scheduledQueryProgress(ScheduledQueryProgressInfo info) throws TException {
        this.client.scheduled_query_progress(info);
    }

    public void addReplicationMetrics(ReplicationMetricList replicationMetricList) throws MetaException, TException {
        this.client.add_replication_metrics(replicationMetricList);
    }

    public ReplicationMetricList getReplicationMetrics(GetReplicationMetricsRequest replicationMetricsRequest) throws MetaException, TException {
        return this.client.get_replication_metrics(replicationMetricsRequest);
    }

    public void createStoredProcedure(StoredProcedure proc) throws NoSuchObjectException, MetaException, TException {
        this.client.create_stored_procedure(proc);
    }

    public StoredProcedure getStoredProcedure(StoredProcedureRequest request) throws MetaException, NoSuchObjectException, TException {
        return this.client.get_stored_procedure(request);
    }

    public void dropStoredProcedure(StoredProcedureRequest request) throws MetaException, NoSuchObjectException, TException {
        this.client.drop_stored_procedure(request);
    }

    public List<String> getAllStoredProcedures(ListStoredProcedureRequest request) throws MetaException, TException {
        return this.client.get_all_stored_procedures(request);
    }

    public void addPackage(AddPackageRequest request) throws NoSuchObjectException, MetaException, TException {
        this.client.add_package(request);
    }

    public Package findPackage(GetPackageRequest request) throws TException {
        return this.client.find_package(request);
    }

    public List<String> listPackages(ListPackageRequest request) throws TException {
        return this.client.get_all_packages(request);
    }

    public void dropPackage(DropPackageRequest request) throws TException {
        this.client.drop_package(request);
    }

    public List<WriteEventInfo> getAllWriteEventInfo(GetAllWriteEventInfoRequest request) throws TException {
        return this.client.get_all_write_event_info(request);
    }

    public ScheduledQueryPollResponse scheduledQueryPoll(ScheduledQueryPollRequest request) throws MetaException, TException {
        return this.client.scheduled_query_poll(request);
    }

    public void scheduledQueryMaintenance(ScheduledQueryMaintenanceRequest request) throws MetaException, TException {
        this.client.scheduled_query_maintenance(request);
    }

    public long getMaxAllocatedWriteId(String dbName, String tableName) throws TException {
        throw new NotImplementedException("");
    }

    public void seedWriteId(String dbName, String tableName, long seedWriteId) throws TException {
        throw new NotImplementedException("");
    }

    public void seedTxnId(long seedTxnId) throws TException {
        throw new NotImplementedException("");
    }

    public static abstract class MetastoreMapIterable<K, V>
    implements Iterable<Map.Entry<K, V>>,
    Iterator<Map.Entry<K, V>> {
        private Iterator<Map.Entry<K, V>> currentIter;

        protected abstract Map<K, V> fetchNextBatch() throws TException;

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            this.ensureCurrentBatch();
            return this.currentIter != null;
        }

        private void ensureCurrentBatch() {
            Map<K, V> currentBatch;
            if (this.currentIter != null && this.currentIter.hasNext()) {
                return;
            }
            this.currentIter = null;
            do {
                try {
                    currentBatch = this.fetchNextBatch();
                }
                catch (TException ex) {
                    throw new RuntimeException(ex);
                }
                if (currentBatch != null) continue;
                return;
            } while (currentBatch.isEmpty());
            this.currentIter = currentBatch.entrySet().iterator();
        }

        @Override
        public Map.Entry<K, V> next() {
            this.ensureCurrentBatch();
            if (this.currentIter == null) {
                throw new NoSuchElementException();
            }
            return this.currentIter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class SynchronizedHandler
    implements InvocationHandler {
        private final IMetaStoreClient client;

        SynchronizedHandler(IMetaStoreClient client) {
            this.client = client;
        }

        @Override
        public synchronized Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return method.invoke((Object)this.client, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }
}

