/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.LogUtils;
import org.apache.hadoop.hive.common.io.SessionStream;
import org.apache.hadoop.hive.common.metrics.common.Metrics;
import org.apache.hadoop.hive.common.metrics.common.MetricsFactory;
import org.apache.hadoop.hive.common.metrics.common.MetricsScope;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hadoop.hive.ql.DriverFactory;
import org.apache.hadoop.hive.ql.IDriver;
import org.apache.hadoop.hive.ql.QueryDisplay;
import org.apache.hadoop.hive.ql.QueryInfo;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.processors.CommandProcessorException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.RowSetFactory;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.operation.ExecuteStatementOperation;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.hive.service.server.ThreadWithGarbageCleanup;

public class SQLOperation
extends ExecuteStatementOperation {
    private IDriver driver = null;
    private Optional<TableSchema> resultSchema;
    private AbstractSerDe serde = null;
    private boolean fetchStarted = false;
    private volatile MetricsScope currentSQLStateScope;
    private final QueryInfo queryInfo;
    private final long queryTimeout;
    private ScheduledExecutorService timeoutExecutor;
    private final boolean runAsync;
    private final long operationLogCleanupDelayMs;
    private final ArrayList<Object> convey = new ArrayList();
    private static final Map<String, AtomicInteger> USER_QUERIES = new ConcurrentHashMap<String, AtomicInteger>();
    private static final String ACTIVE_SQL_USER = "hs2_sql_operation_active_user";
    private final Optional<MetricsScope> submittedQryScp;

    public SQLOperation(HiveSession parentSession, String statement, Map<String, String> confOverlay, boolean runInBackground, long queryTimeout) {
        this(parentSession, statement, confOverlay, runInBackground, queryTimeout, false);
    }

    public SQLOperation(HiveSession parentSession, String statement, Map<String, String> confOverlay, boolean runInBackground, long queryTimeout, boolean embedded) {
        super(parentSession, statement, confOverlay, runInBackground, embedded);
        this.runAsync = runInBackground;
        this.resultSchema = Optional.empty();
        long timeout = HiveConf.getTimeVar((Configuration)this.queryState.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_QUERY_TIMEOUT_SECONDS, (TimeUnit)TimeUnit.SECONDS);
        this.queryTimeout = timeout > 0L && (queryTimeout <= 0L || timeout < queryTimeout) ? timeout : queryTimeout;
        this.operationLogCleanupDelayMs = HiveConf.getTimeVar((Configuration)this.queryState.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_OPERATION_LOG_CLEANUP_DELAY, (TimeUnit)TimeUnit.MILLISECONDS);
        this.setupSessionIO(parentSession.getSessionState());
        this.queryInfo = new QueryInfo(this.getState().toString(), this.getParentSession().getUserName(), this.getExecutionEngine(), this.getParentSession().getSessionHandle().getHandleIdentifier().toString(), this.getHandle().getHandleIdentifier().toString());
        Metrics metrics = MetricsFactory.getInstance();
        this.submittedQryScp = metrics == null ? Optional.empty() : Optional.of(metrics.createScope("hs2_submitted_queries"));
    }

    @Override
    public boolean shouldRunAsync() {
        return this.runAsync;
    }

    private void setupSessionIO(SessionState sessionState) {
        try {
            sessionState.in = null;
            sessionState.out = new SessionStream((OutputStream)System.out, true, StandardCharsets.UTF_8.name());
            sessionState.info = new SessionStream((OutputStream)System.err, true, StandardCharsets.UTF_8.name());
            sessionState.err = new SessionStream((OutputStream)System.err, true, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            this.log.error("Error creating PrintStream", (Throwable)e);
            sessionState.out = null;
            sessionState.info = null;
            sessionState.err = null;
        }
    }

    private void prepare(QueryState queryState) throws HiveSQLException {
        this.setState(OperationState.RUNNING);
        try {
            this.driver = DriverFactory.newDriver((QueryState)queryState, (QueryInfo)this.queryInfo);
            if (this.queryTimeout > 0L) {
                this.timeoutExecutor = Executors.newSingleThreadScheduledExecutor();
                this.timeoutExecutor.schedule(() -> {
                    try {
                        String queryId = queryState.getQueryId();
                        this.log.info("Query timed out after: {} seconds. Cancelling the execution now: {}", (Object)this.queryTimeout, (Object)queryId);
                        this.cancel(OperationState.TIMEDOUT);
                    }
                    catch (HiveSQLException e) {
                        this.log.error("Error cancelling the query after timeout: {} seconds", (Object)this.queryTimeout, (Object)e);
                    }
                    return null;
                }, this.queryTimeout, TimeUnit.SECONDS);
            }
            this.queryInfo.setQueryDisplay(this.driver.getQueryDisplay());
            if (this.operationLog != null) {
                this.queryInfo.setOperationLogLocation(this.operationLog.toString());
            }
            String guid64 = Base64.getUrlEncoder().withoutPadding().encodeToString(this.getHandle().getHandleIdentifier().toTHandleIdentifier().getGuid());
            this.driver.setOperationId(guid64);
            this.driver.compileAndRespond(this.statement);
            if (queryState.getQueryTag() != null && queryState.getQueryId() != null) {
                this.parentSession.updateQueryTag(queryState.getQueryId(), queryState.getQueryTag());
            }
            this.setHasResultSet(this.driver.hasResultSet());
        }
        catch (CommandProcessorException e) {
            this.setState(OperationState.ERROR);
            throw this.toSQLException("Error while compiling statement", e);
        }
        catch (Throwable e) {
            this.setState(OperationState.ERROR);
            if (e instanceof OutOfMemoryError) {
                throw e;
            }
            throw new HiveSQLException("Error running query", e);
        }
    }

    private void runQuery() throws HiveSQLException {
        try {
            OperationState opState = this.getState();
            if (opState.isTerminal()) {
                this.log.info("Not running the query. Operation is already in terminal state: " + (Object)((Object)opState) + ", perhaps cancelled due to query timeout or by another thread.");
                return;
            }
            this.driver.run();
        }
        catch (Throwable e) {
            if (this.getState().isTerminal()) {
                this.log.warn("Ignore exception in terminal state: {}", (Object)this.getState(), (Object)e);
                return;
            }
            this.setState(OperationState.ERROR);
            if (e instanceof CommandProcessorException) {
                throw this.toSQLException("Error while compiling statement", (CommandProcessorException)e);
            }
            if (e instanceof HiveSQLException) {
                throw (HiveSQLException)e;
            }
            if (e instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)e;
            }
            throw new HiveSQLException("Error running query", e);
        }
        this.setState(OperationState.FINISHED);
    }

    @Override
    public void runInternal() throws HiveSQLException {
        boolean asyncPrepare;
        this.setState(OperationState.PENDING);
        boolean doRunAsync = this.shouldRunAsync();
        boolean bl = asyncPrepare = doRunAsync && HiveConf.getBoolVar((Configuration)this.queryState.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_ASYNC_EXEC_ASYNC_COMPILE);
        if (!asyncPrepare) {
            this.prepare(this.queryState);
        }
        if (!doRunAsync) {
            this.runQuery();
        } else {
            BackgroundWork work = new BackgroundWork(this.getCurrentUGI(), this.parentSession.getSessionHive(), SessionState.get(), asyncPrepare);
            try {
                Future<?> backgroundHandle = this.getParentSession().submitBackgroundOperation(work);
                this.setBackgroundHandle(backgroundHandle);
            }
            catch (RejectedExecutionException rejected) {
                this.setState(OperationState.ERROR);
                throw new HiveSQLException("The background threadpool cannot accept new task for execution, please retry the operation", rejected);
            }
        }
    }

    private UserGroupInformation getCurrentUGI() throws HiveSQLException {
        try {
            return Utils.getUGI();
        }
        catch (Exception e) {
            throw new HiveSQLException("Unable to get current user", e);
        }
    }

    private synchronized void cleanup(OperationState state) throws HiveSQLException {
        Future<?> backgroundHandle;
        this.setState(state);
        if (this.shouldRunAsync() && state != OperationState.CANCELED && state != OperationState.TIMEDOUT && (backgroundHandle = this.getBackgroundHandle()) != null) {
            boolean success = backgroundHandle.cancel(true);
            String queryId = this.queryState.getQueryId();
            if (success) {
                this.log.info("The running operation has been successfully interrupted: {}", (Object)queryId);
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("The running operation could not be cancelled, typically because it has already completed normally: {}", (Object)queryId);
            }
        }
        if (this.driver != null) {
            this.driver.close();
            this.driver.destroy();
        }
        this.driver = null;
        SessionState ss = SessionState.get();
        if (ss == null) {
            this.log.warn("Operation seems to be in invalid state, SessionState is null");
        } else {
            ss.deleteTmpOutputFile();
            ss.deleteTmpErrOutputFile();
        }
        if (this.timeoutExecutor != null && state != OperationState.TIMEDOUT && state.isTerminal()) {
            this.timeoutExecutor.shutdownNow();
        }
    }

    @Override
    public void cancel(OperationState stateAfterCancel) throws HiveSQLException {
        String queryId = null;
        if (stateAfterCancel == OperationState.CANCELED) {
            queryId = this.queryState.getQueryId();
            this.log.info("Cancelling the query execution: {}", (Object)queryId);
        }
        this.cleanup(stateAfterCancel);
        this.cleanupOperationLog(this.operationLogCleanupDelayMs);
        if (stateAfterCancel == OperationState.CANCELED) {
            this.log.info("Successfully cancelled the query: {}", (Object)queryId);
        }
    }

    @Override
    public void close() throws HiveSQLException {
        if (!this.embedded) {
            this.cleanup(OperationState.CLOSED);
            this.cleanupOperationLog(0L);
        }
    }

    @Override
    public TableSchema getResultSetSchema() throws HiveSQLException {
        this.assertState(Arrays.asList(OperationState.RUNNING, OperationState.FINISHED));
        if (!this.resultSchema.isPresent()) {
            this.resultSchema = Optional.of(new TableSchema(this.driver.getSchema()));
        }
        return this.resultSchema.get();
    }

    @Override
    public RowSet getNextRowSet(FetchOrientation orientation, long maxRows) throws HiveSQLException {
        this.validateDefaultFetchOrientation(orientation);
        this.assertState(Collections.singleton(OperationState.FINISHED));
        FetchTask fetchTask = this.driver.getFetchTask();
        boolean isBlobBased = false;
        if (fetchTask != null && ((FetchWork)fetchTask.getWork()).isUsingThriftJDBCBinarySerDe()) {
            maxRows = 1L;
            isBlobBased = true;
        }
        RowSet rowSet = RowSetFactory.create(this.getResultSetSchema(), this.getProtocolVersion(), isBlobBased);
        try {
            if (orientation.equals((Object)FetchOrientation.FETCH_FIRST) && this.fetchStarted) {
                this.driver.resetFetch();
            }
            this.fetchStarted = true;
            int capacity = Math.toIntExact(maxRows);
            this.convey.ensureCapacity(capacity);
            this.driver.setMaxRows(capacity);
            if (this.driver.getResults(this.convey)) {
                if (this.convey.size() == capacity) {
                    this.log.info("Result set buffer filled to capacity [{}]", (Object)capacity);
                }
                RowSet rowSet2 = this.decode(this.convey, rowSet);
                return rowSet2;
            }
            RowSet rowSet3 = rowSet;
            return rowSet3;
        }
        catch (Exception e) {
            throw new HiveSQLException("Unable to get the next row set with exception: " + e.getMessage(), e);
        }
        finally {
            this.convey.clear();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getTaskStatus() throws HiveSQLException {
        if (this.driver == null) return null;
        List statuses = this.driver.getQueryDisplay().getTaskDisplays();
        if (statuses == null) return null;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            QueryDisplay.OBJECT_MAPPER.writeValue((OutputStream)out, (Object)statuses);
            String string = out.toString(StandardCharsets.UTF_8.name());
            return string;
        }
        catch (Exception e) {
            throw new HiveSQLException(e);
        }
    }

    private RowSet decode(List<Object> rows, RowSet rowSet) throws Exception {
        return this.driver.isFetchingTable() ? this.prepareFromRow(rows, rowSet) : this.decodeFromString(rows, rowSet);
    }

    private RowSet prepareFromRow(List<Object> rows, RowSet rowSet) throws Exception {
        rows.forEach(row -> rowSet.addRow((Object[])row));
        return rowSet;
    }

    private RowSet decodeFromString(List<Object> rows, RowSet rowSet) throws SQLException, SerDeException {
        this.getSerDe();
        StructObjectInspector soi = (StructObjectInspector)this.serde.getObjectInspector();
        List fieldRefs = soi.getAllStructFieldRefs();
        Object[] deserializedFields = new Object[fieldRefs.size()];
        int protocol = this.getProtocolVersion().getValue();
        for (Object rowString : rows) {
            Object rowObj = this.serde.deserialize((Writable)new BytesWritable(((String)rowString).getBytes(StandardCharsets.UTF_8)));
            for (int i = 0; i < fieldRefs.size(); ++i) {
                StructField fieldRef = (StructField)fieldRefs.get(i);
                ObjectInspector fieldOI = fieldRef.getFieldObjectInspector();
                Object fieldData = soi.getStructFieldData(rowObj, fieldRef);
                deserializedFields[i] = SerDeUtils.toThriftPayload((Object)fieldData, (ObjectInspector)fieldOI, (int)protocol);
            }
            rowSet.addRow(deserializedFields);
        }
        return rowSet;
    }

    private AbstractSerDe getSerDe() throws SQLException {
        if (this.serde == null) {
            try {
                this.serde = new LazySimpleSerDe();
                Schema mResultSchema = this.driver.getSchema();
                List fieldSchemas = mResultSchema.getFieldSchemas();
                Properties props = new Properties();
                if (!fieldSchemas.isEmpty()) {
                    String names = fieldSchemas.stream().map(i -> i.getName()).collect(Collectors.joining(","));
                    String types = fieldSchemas.stream().map(i -> i.getType()).collect(Collectors.joining(","));
                    this.log.debug("Column names: {}", (Object)names);
                    this.log.debug("Column types: {}", (Object)types);
                    props.setProperty("columns", names);
                    props.setProperty("columns.types", types);
                }
                this.serde.initialize((Configuration)this.queryState.getConf(), props, null);
            }
            catch (Exception ex) {
                throw new SQLException("Could not create ResultSet: " + ex.getMessage(), ex);
            }
        }
        return this.serde;
    }

    public QueryInfo getQueryInfo() {
        return this.queryInfo;
    }

    @Override
    protected void onNewState(OperationState state, OperationState prevState) {
        super.onNewState(state, prevState);
        this.currentSQLStateScope = this.updateOperationStateMetrics(this.currentSQLStateScope, "hs2_sql_operation_", "hs2_completed_sql_operation_", state);
        Optional<Metrics> metrics = Optional.ofNullable(MetricsFactory.getInstance());
        if (metrics.isPresent()) {
            if (state == OperationState.RUNNING && prevState != state) {
                this.incrementUserQueries(metrics.get());
            }
            if (prevState == OperationState.RUNNING && prevState != state) {
                this.decrementUserQueries(metrics.get());
            }
        }
        switch (state) {
            case CANCELED: {
                this.queryInfo.setRuntime(this.getOperationComplete() - this.getOperationStart());
                if (metrics.isPresent() && this.submittedQryScp.isPresent()) {
                    metrics.get().endScope(this.submittedQryScp.get());
                }
                this.queryInfo.updateState(state.toString());
                break;
            }
            case CLOSED: {
                this.queryInfo.setEndTime();
                break;
            }
            case ERROR: {
                this.queryInfo.setRuntime(this.getOperationComplete() - this.getOperationStart());
                if (metrics.isPresent() && this.submittedQryScp.isPresent()) {
                    metrics.get().endScope(this.submittedQryScp.get());
                }
                this.markQueryMetric(MetricsFactory.getInstance(), "hs2_failed_queries");
                this.queryInfo.updateState(state.toString());
                break;
            }
            case FINISHED: {
                this.queryInfo.setRuntime(this.getOperationComplete() - this.getOperationStart());
                if (metrics.isPresent() && this.submittedQryScp.isPresent()) {
                    metrics.get().endScope(this.submittedQryScp.get());
                }
                this.markQueryMetric(MetricsFactory.getInstance(), "hs2_succeeded_queries");
                this.queryInfo.updateState(state.toString());
                break;
            }
            default: {
                this.queryInfo.updateState(state.toString());
            }
        }
    }

    private void incrementUserQueries(Metrics metrics) {
        String username = this.parentSession.getUserName();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            USER_QUERIES.compute(username, (key, value) -> {
                if (value == null) {
                    metrics.incrementCounter(ACTIVE_SQL_USER);
                    return new AtomicInteger(1);
                }
                value.incrementAndGet();
                return value;
            });
        }
    }

    private void decrementUserQueries(Metrics metrics) {
        String username = this.parentSession.getUserName();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            USER_QUERIES.compute(username, (key, value) -> {
                if (value == null) {
                    return null;
                }
                int newValue = value.decrementAndGet();
                if (newValue == 0) {
                    metrics.decrementCounter(ACTIVE_SQL_USER);
                    return null;
                }
                return value;
            });
        }
    }

    private void markQueryMetric(Metrics metric, String name) {
        if (metric != null) {
            metric.markMeter(name);
        }
    }

    public String getExecutionEngine() {
        return this.queryState.getConf().getVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE);
    }

    private final class BackgroundWork
    implements Runnable {
        private final UserGroupInformation currentUGI;
        private final Hive parentHive;
        private final SessionState parentSessionState;
        private final boolean asyncPrepare;

        private BackgroundWork(UserGroupInformation currentUGI, Hive parentHive, SessionState parentSessionState, boolean asyncPrepare) {
            this.currentUGI = currentUGI;
            this.parentHive = parentHive;
            this.parentSessionState = parentSessionState;
            this.asyncPrepare = asyncPrepare;
        }

        @Override
        public void run() {
            PrivilegedExceptionAction<Object> doAsAction = new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws HiveSQLException {
                    assert (!BackgroundWork.this.parentHive.allowClose());
                    Hive.set((Hive)BackgroundWork.this.parentHive);
                    SessionState.setCurrentSessionState((SessionState)BackgroundWork.this.parentSessionState);
                    PerfLogger.setPerfLogger((PerfLogger)SessionState.getPerfLogger());
                    if (!SQLOperation.this.embedded) {
                        LogUtils.registerLoggingContext((Configuration)SQLOperation.this.queryState.getConf());
                    }
                    ShimLoader.getHadoopShims().setHadoopQueryContext(String.format("%s_User:%s", SQLOperation.this.queryState.getQueryId(), BackgroundWork.this.parentSessionState.getUserName()));
                    try {
                        if (BackgroundWork.this.asyncPrepare) {
                            SQLOperation.this.prepare(SQLOperation.this.queryState);
                        }
                        SQLOperation.this.runQuery();
                    }
                    catch (HiveSQLException e) {
                        SQLOperation.this.setOperationException(e);
                        SQLOperation.this.log.error("Error running hive query", (Throwable)e);
                    }
                    finally {
                        if (!SQLOperation.this.embedded) {
                            LogUtils.unregisterLoggingContext();
                        }
                        Hive.closeCurrent();
                    }
                    return null;
                }
            };
            try {
                this.currentUGI.doAs((PrivilegedExceptionAction)doAsAction);
            }
            catch (Exception e) {
                SQLOperation.this.setOperationException(new HiveSQLException(e));
                SQLOperation.this.log.error("Error running hive query as user : {}", (Object)this.currentUGI.getShortUserName(), (Object)e);
            }
            finally {
                if (ThreadWithGarbageCleanup.currentThread() instanceof ThreadWithGarbageCleanup) {
                    ThreadWithGarbageCleanup currentThread = (ThreadWithGarbageCleanup)ThreadWithGarbageCleanup.currentThread();
                    currentThread.cacheThreadLocalRawStore();
                }
            }
        }
    }
}

