/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import java.sql.SQLException;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorFactory;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.common.util.HiveStringUtils;
import org.apache.hive.hplsql.Conf;
import org.apache.hive.hplsql.Console;
import org.apache.hive.hplsql.Exec;
import org.apache.hive.hplsql.HplSqlSessionState;
import org.apache.hive.hplsql.executor.QueryExecutor;
import org.apache.hive.hplsql.udf.Udf;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationType;
import org.apache.hive.service.cli.operation.HiveCommandOperation;
import org.apache.hive.service.cli.operation.Operation;
import org.apache.hive.service.cli.operation.SQLOperation;
import org.apache.hive.service.cli.operation.hplsql.BeelineConsole;
import org.apache.hive.service.cli.operation.hplsql.HplSqlOperation;
import org.apache.hive.service.cli.operation.hplsql.HplSqlQueryExecutor;
import org.apache.hive.service.cli.session.HiveSession;

public abstract class ExecuteStatementOperation
extends Operation {
    protected String statement = null;

    public ExecuteStatementOperation(HiveSession parentSession, String statement, Map<String, String> confOverlay) {
        super(parentSession, confOverlay, OperationType.EXECUTE_STATEMENT);
        this.statement = statement;
    }

    public ExecuteStatementOperation(HiveSession parentSession, String statement, Map<String, String> confOverlay, boolean runInBackground, boolean generateNewQueryId) {
        super(parentSession, confOverlay, OperationType.EXECUTE_STATEMENT, generateNewQueryId);
        this.statement = statement;
    }

    public String getStatement() {
        return this.statement;
    }

    public static ExecuteStatementOperation newExecuteStatementOperation(HiveSession parentSession, String statement, Map<String, String> confOverlay, boolean runAsync, long queryTimeout) throws HiveSQLException {
        String cleanStatement = HiveStringUtils.removeComments((String)statement);
        if (ExecuteStatementOperation.proceduralMode(confOverlay) && ExecuteStatementOperation.hplSqlMode()) {
            if (SessionState.get().getDynamicVar(Exec.class) == null) {
                Exec interpreter = new Exec(new Conf(), (Console)new BeelineConsole(), (QueryExecutor)new HplSqlQueryExecutor(parentSession), parentSession.getMetaStoreClient(), (HplSqlSessionState)new HiveHplSqlSessionState(SessionState.get()));
                interpreter.init();
                ExecuteStatementOperation.registerUdf();
                SessionState.get().addDynamicVar((Object)interpreter);
            }
            return new HplSqlOperation(parentSession, statement, confOverlay, runAsync, (Exec)SessionState.get().getDynamicVar(Exec.class));
        }
        String[] tokens = cleanStatement.trim().split("\\s+");
        CommandProcessor processor = null;
        try {
            processor = CommandProcessorFactory.getForHiveCommand((String[])tokens, (HiveConf)parentSession.getHiveConf());
        }
        catch (SQLException e) {
            throw new HiveSQLException(e.getMessage(), e.getSQLState(), e);
        }
        if (processor == null) {
            return new SQLOperation(parentSession, statement, confOverlay, runAsync, queryTimeout, ExecuteStatementOperation.hplSqlMode());
        }
        return new HiveCommandOperation(parentSession, cleanStatement, processor, confOverlay);
    }

    private static void registerUdf() throws HiveSQLException {
        try {
            if (FunctionRegistry.getTemporaryFunctionInfo((String)Udf.NAME) == null) {
                FunctionRegistry.registerTemporaryUDF((String)Udf.NAME, Udf.class, (FunctionInfo.FunctionResource[])new FunctionInfo.FunctionResource[0]);
            }
        }
        catch (SemanticException e) {
            throw new HiveSQLException(e);
        }
    }

    private static boolean proceduralMode(Map<String, String> confOverlay) {
        return confOverlay != null && !"HPLSQL".equals(confOverlay.get("QUERY_EXECUTOR"));
    }

    public static boolean hplSqlMode() {
        return "HPLSQL".equalsIgnoreCase(SessionState.get().getHiveVariables().getOrDefault("mode", ""));
    }

    private static class HiveHplSqlSessionState
    implements HplSqlSessionState {
        private final SessionState sessionState;

        public HiveHplSqlSessionState(SessionState sessionState) {
            this.sessionState = sessionState;
        }

        public String currentUser() {
            return this.sessionState.getUserName();
        }

        public String currentDatabase() {
            return this.sessionState.getCurrentDatabase();
        }

        public String currentCatalog() {
            return this.sessionState.getCurrentCatalog();
        }
    }
}

