/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth.saml;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.auth.saml.HttpSamlAuthenticationException;

public class HiveSamlUtils {
    public static final String SSO_TOKEN_RESPONSE_PORT = "X-Hive-Token-Response-Port";
    public static final String SSO_CLIENT_IDENTIFIER = "X-Hive-Client-Identifier";
    public static final String TOKEN_KEY = "token";
    public static final String STATUS_KEY = "status";
    public static final String MESSAGE_KEY = "message";
    public static final String LOOP_BACK_INTERFACE = "127.0.0.1";

    public static String getCallBackPath(HiveConf conf) throws Exception {
        URI callbackURI = HiveSamlUtils.getCallBackUri(conf);
        return callbackURI.getPath();
    }

    public static URI getCallBackUri(HiveConf conf) throws Exception {
        String callbackUrl = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SAML_CALLBACK_URL);
        try {
            URI uri = new URI(callbackUrl);
            int port = uri.getPort();
            int httpPort = conf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_PORT);
            Preconditions.checkArgument((port == -1 || port == httpPort ? 1 : 0) != 0, (Object)("Callback url " + callbackUrl + " must be at the same port " + httpPort + " defined by " + HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_PORT.varname));
            return uri;
        }
        catch (URISyntaxException e) {
            throw new Exception("Invalid callback url configuration: " + HiveConf.ConfVars.HIVE_SERVER2_SAML_CALLBACK_URL.varname + " = " + callbackUrl);
        }
    }

    public static String getLoopBackAddress(int port) {
        return String.format("http://%s:%s", LOOP_BACK_INTERFACE, port);
    }

    public static int validateSamlResponsePort(HttpServletRequest request) throws HttpSamlAuthenticationException {
        String responsePort = request.getHeader(SSO_TOKEN_RESPONSE_PORT);
        if (responsePort == null || responsePort.isEmpty()) {
            throw new HttpSamlAuthenticationException("No response port specified");
        }
        try {
            return Integer.parseInt(responsePort);
        }
        catch (NumberFormatException e) {
            throw new HttpSamlAuthenticationException("Invalid response port received", e);
        }
    }
}

