/**
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
lexer grammar HiveLexerParent;

// Keywords

KW_TRUE : 'TRUE';
KW_FALSE : 'FALSE';
KW_UNKNOWN : 'UNKNOWN';
KW_ALL : 'ALL';
KW_SOME : 'SOME';
KW_NONE: 'NONE';
KW_AND : 'AND';
KW_OR : 'OR';
KW_NOT : 'NOT' | '!';
KW_LIKE : 'LIKE';
KW_ANY : 'ANY';

KW_IF : 'IF';
KW_EXISTS : 'EXISTS';

KW_ASC : 'ASC';
KW_DESC : 'DESC';
KW_NULLS : 'NULLS';
KW_LAST : 'LAST';
KW_ORDER : 'ORDER';
KW_GROUP : 'GROUP';
KW_BY : 'BY';
KW_HAVING : 'HAVING';
KW_WHERE : 'WHERE';
KW_FROM : 'FROM';
KW_AS : 'AS';
KW_SELECT : 'SELECT';
KW_DISTINCT : 'DISTINCT';
KW_INSERT : 'INSERT';
KW_OVERWRITE : 'OVERWRITE';
KW_OUTER : 'OUTER';
KW_UNIQUEJOIN : 'UNIQUEJOIN';
KW_PRESERVE : 'PRESERVE';
KW_JOIN : 'JOIN';
KW_LEFT : 'LEFT';
KW_RIGHT : 'RIGHT';
KW_FULL : 'FULL';
KW_ON : 'ON';
KW_PARTITION : 'PARTITION';
KW_PARTITIONS : 'PARTITIONS';
KW_TABLE: 'TABLE';
KW_TABLES: 'TABLES';
KW_COLUMNS: 'COLUMNS';
KW_INDEX: 'INDEX';
KW_INDEXES: 'INDEXES';
KW_REBUILD: 'REBUILD';
KW_FUNCTIONS: 'FUNCTIONS';
KW_SHOW: 'SHOW';
KW_MSCK: 'MSCK';
KW_REPAIR: 'REPAIR';
KW_DIRECTORY: 'DIRECTORY';
KW_LOCAL: 'LOCAL';
KW_TRANSFORM : 'TRANSFORM';
KW_USING: 'USING';
KW_CLUSTER: 'CLUSTER';
KW_DISTRIBUTE: 'DISTRIBUTE';
KW_SORT: 'SORT';
KW_UNION: 'UNION';
KW_EXCEPT: 'EXCEPT';
KW_LOAD: 'LOAD';
KW_PREPARE: 'PREPARE';
KW_EXPORT: 'EXPORT';
KW_IMPORT: 'IMPORT';
KW_REPLICATION: 'REPLICATION';
KW_METADATA: 'METADATA';
KW_DATA: 'DATA';
KW_INPATH: 'INPATH';
KW_IS: 'IS';
KW_NULL: 'NULL';
KW_CREATE: 'CREATE';
KW_EXTERNAL: 'EXTERNAL';
KW_ALTER: 'ALTER';
KW_CHANGE: 'CHANGE';
KW_COLUMN: 'COLUMN';
KW_FIRST: 'FIRST';
KW_AFTER: 'AFTER';
KW_DESCRIBE: 'DESCRIBE';
KW_DROP: 'DROP';
KW_RENAME: 'RENAME';
KW_TO: 'TO';
KW_COMMENT: 'COMMENT';
KW_BOOLEAN: 'BOOLEAN';
KW_TINYINT: 'TINYINT';
KW_SMALLINT: 'SMALLINT';
KW_INT: 'INT' | 'INTEGER';
KW_BIGINT: 'BIGINT';
KW_FLOAT: 'FLOAT';
KW_REAL: 'REAL';
KW_DOUBLE: 'DOUBLE';
KW_PRECISION: 'PRECISION';
KW_DATE: 'DATE';
KW_DATETIME: 'DATETIME';
KW_TIMESTAMP: 'TIMESTAMP';
KW_TIMESTAMPLOCALTZ: 'TIMESTAMPLOCALTZ';
KW_TIME: 'TIME';
KW_ZONE: 'ZONE';
KW_INTERVAL: 'INTERVAL';
KW_DECIMAL: 'DECIMAL' | 'DEC' | 'NUMERIC';
KW_STRING: 'STRING';
KW_CHAR: 'CHAR';
KW_VARCHAR: 'VARCHAR';
KW_ARRAY: 'ARRAY';
KW_STRUCT: 'STRUCT';
KW_MAP: 'MAP';
KW_UNIONTYPE: 'UNIONTYPE';
KW_REDUCE: 'REDUCE';
KW_PARTITIONED: 'PARTITIONED';
KW_CLUSTERED: 'CLUSTERED';
KW_DISTRIBUTED: 'DISTRIBUTED';
KW_SORTED: 'SORTED';
KW_INTO: 'INTO';
KW_BUCKETS: 'BUCKETS';
KW_ROW: 'ROW';
KW_ROWS: 'ROWS';
KW_FORMAT: 'FORMAT';
KW_DELIMITED: 'DELIMITED';
KW_FIELDS: 'FIELDS';
KW_TERMINATED: 'TERMINATED';
KW_ESCAPED: 'ESCAPED';
KW_COLLECTION: 'COLLECTION';
KW_ITEMS: 'ITEMS';
KW_KEYS: 'KEYS';
KW_KEY_TYPE: '$KEY$';
KW_KILL: 'KILL';
KW_LINES: 'LINES';
KW_STORED: 'STORED';
KW_FILEFORMAT: 'FILEFORMAT';
KW_INPUTFORMAT: 'INPUTFORMAT';
KW_OUTPUTFORMAT: 'OUTPUTFORMAT';
KW_INPUTDRIVER: 'INPUTDRIVER';
KW_OUTPUTDRIVER: 'OUTPUTDRIVER';
KW_ENABLE: 'ENABLE' | 'ENABLED';
KW_DISABLE: 'DISABLE' | 'DISABLED';
KW_EXECUTED: 'EXECUTED';
KW_EXECUTE: 'EXECUTE';
KW_LOCATION: 'LOCATION';
KW_MANAGED: 'MANAGED';
KW_MANAGEDLOCATION: 'MANAGEDLOCATION';
KW_TABLESAMPLE: 'TABLESAMPLE';
KW_BUCKET: 'BUCKET';
KW_OUT: 'OUT';
KW_OF: 'OF';
KW_PERCENT: 'PERCENT';
KW_CAST: 'CAST';
KW_ADD: 'ADD';
KW_REPLACE: 'REPLACE';
KW_RLIKE: 'RLIKE';
KW_REGEXP: 'REGEXP';
KW_TEMPORARY: 'TEMPORARY';
KW_FUNCTION: 'FUNCTION';
KW_MACRO: 'MACRO';
KW_FILE: 'FILE';
KW_JAR: 'JAR';
KW_EXPLAIN: 'EXPLAIN';
KW_DDL: 'DDL';
KW_EXTENDED: 'EXTENDED';
KW_DEBUG: 'DEBUG';
KW_FORMATTED: 'FORMATTED';
KW_DEPENDENCY: 'DEPENDENCY';
KW_LOGICAL: 'LOGICAL';
KW_CBO: 'CBO';
KW_SERDE: 'SERDE';
KW_WITH: 'WITH';
KW_DEFERRED: 'DEFERRED';
KW_SERDEPROPERTIES: 'SERDEPROPERTIES';
KW_DBPROPERTIES: 'DBPROPERTIES';
KW_DCPROPERTIES: 'DCPROPERTIES';
KW_LIMIT: 'LIMIT';
KW_OFFSET: 'OFFSET';
KW_SET: 'SET';
KW_UNSET: 'UNSET';
KW_TBLPROPERTIES: 'TBLPROPERTIES';
KW_IDXPROPERTIES: 'IDXPROPERTIES';
KW_VALUE_TYPE: '$VALUE$';
KW_ELEM_TYPE: '$ELEM$';
KW_DEFINED: 'DEFINED';
KW_CASE: 'CASE';
KW_WHEN: 'WHEN';
KW_THEN: 'THEN';
KW_ELSE: 'ELSE';
KW_END: 'END';
KW_MAPJOIN: 'MAPJOIN';
KW_STREAMTABLE: 'STREAMTABLE';
KW_CLUSTERSTATUS: 'CLUSTERSTATUS';
KW_UTC: 'UTC';
KW_UTCTIMESTAMP: 'UTC_TMESTAMP';
KW_LONG: 'LONG';
KW_DELETE: 'DELETE';
KW_PLUS: 'PLUS';
KW_MINUS: 'MINUS';
KW_FETCH: 'FETCH';
KW_INTERSECT: 'INTERSECT';
KW_VIEW: 'VIEW';
KW_VIEWS: 'VIEWS';
KW_IN: 'IN';
KW_DATABASE: 'DATABASE';
KW_DATABASES: 'DATABASES';
KW_MATERIALIZED: 'MATERIALIZED';
KW_SCHEMA: 'SCHEMA';
KW_SCHEMAS: 'SCHEMAS';
KW_GRANT: 'GRANT';
KW_REVOKE: 'REVOKE';
KW_SSL: 'SSL';
KW_UNDO: 'UNDO';
KW_LOCK: 'LOCK';
KW_LOCKS: 'LOCKS';
KW_UNLOCK: 'UNLOCK';
KW_SHARED: 'SHARED';
KW_EXCLUSIVE: 'EXCLUSIVE';
KW_PROCEDURE: 'PROCEDURE';
KW_UNSIGNED: 'UNSIGNED';
KW_WHILE: 'WHILE';
KW_READ: 'READ';
KW_READS: 'READS';
KW_PURGE: 'PURGE';
KW_RANGE: 'RANGE';
KW_ANALYZE: 'ANALYZE';
KW_BEFORE: 'BEFORE';
KW_BETWEEN: 'BETWEEN';
KW_BOTH: 'BOTH';
KW_BINARY: 'BINARY';
KW_CROSS: 'CROSS';
KW_CONTINUE: 'CONTINUE';
KW_CURSOR: 'CURSOR';
KW_TRIGGER: 'TRIGGER';
KW_RECORDREADER: 'RECORDREADER';
KW_RECORDWRITER: 'RECORDWRITER';
KW_SEMI: 'SEMI';
KW_LATERAL: 'LATERAL';
KW_TOUCH: 'TOUCH';
KW_ARCHIVE: 'ARCHIVE';
KW_UNARCHIVE: 'UNARCHIVE';
KW_COMPUTE: 'COMPUTE';
KW_STATISTICS: 'STATISTICS';
KW_USE: 'USE';
KW_OPTION: 'OPTION';
KW_CONCATENATE: 'CONCATENATE';
KW_SHOW_DATABASE: 'SHOW_DATABASE';
KW_UPDATE: 'UPDATE';
KW_RESTRICT: 'RESTRICT';
KW_CASCADE: 'CASCADE';
KW_SKEWED: 'SKEWED';
KW_ROLLUP: 'ROLLUP';
KW_CUBE: 'CUBE';
KW_DIRECTORIES: 'DIRECTORIES';
KW_FOR: 'FOR';
KW_WINDOW: 'WINDOW';
KW_UNBOUNDED: 'UNBOUNDED';
KW_PRECEDING: 'PRECEDING';
KW_FOLLOWING: 'FOLLOWING';
KW_CURRENT: 'CURRENT';
KW_CURRENT_DATE: 'CURRENT_DATE';
KW_CURRENT_TIMESTAMP: 'CURRENT_TIMESTAMP';
KW_LESS: 'LESS';
KW_MORE: 'MORE';
KW_OVER: 'OVER';
KW_GROUPING: 'GROUPING';
KW_SETS: 'SETS';
KW_TRUNCATE: 'TRUNCATE';
KW_NOSCAN: 'NOSCAN';
KW_USER: 'USER';
KW_ROLE: 'ROLE';
KW_ROLES: 'ROLES';
KW_INNER: 'INNER';
KW_EXCHANGE: 'EXCHANGE';
KW_URI: 'URI';
KW_SERVER : 'SERVER';
KW_ADMIN: 'ADMIN';
KW_OWNER: 'OWNER';
KW_PRINCIPALS: 'PRINCIPALS';
KW_COMPACT: 'COMPACT';
KW_COMPACTIONS: 'COMPACTIONS';
KW_TRANSACTIONS: 'TRANSACTIONS';
KW_TRANSACTIONAL: 'TRANSACTIONAL';
KW_REWRITE : 'REWRITE';
KW_AUTHORIZATION: 'AUTHORIZATION';
KW_REOPTIMIZATION: 'REOPTIMIZATION';
KW_CONF: 'CONF';
KW_VALUES: 'VALUES';
KW_RELOAD: 'RELOAD';
KW_YEAR: 'YEAR' | 'YEARS';
KW_QUERY: 'QUERY';
KW_QUARTER: 'QUARTER';
KW_MONTH: 'MONTH' | 'MONTHS';
KW_WEEK: 'WEEK' | 'WEEKS';
KW_DAY: 'DAY' | 'DAYS';
KW_DOW: 'DAYOFWEEK';
KW_HOUR: 'HOUR' | 'HOURS';
KW_MINUTE: 'MINUTE' | 'MINUTES';
KW_SECOND: 'SECOND' | 'SECONDS';
KW_START: 'START';
KW_TRANSACTION: 'TRANSACTION';
KW_COMMIT: 'COMMIT';
KW_ROLLBACK: 'ROLLBACK';
KW_WORK: 'WORK';
KW_ONLY: 'ONLY';
KW_WRITE: 'WRITE';
KW_ISOLATION: 'ISOLATION';
KW_LEVEL: 'LEVEL';
KW_SNAPSHOT: 'SNAPSHOT';
KW_AUTOCOMMIT: 'AUTOCOMMIT';
KW_CACHE: 'CACHE';
KW_PRIMARY: 'PRIMARY';
KW_FOREIGN: 'FOREIGN';
KW_REFERENCES: 'REFERENCES';
KW_CONSTRAINT: 'CONSTRAINT';
KW_FORCE: 'FORCE';
KW_ENFORCED: 'ENFORCED';
KW_VALIDATE: 'VALIDATE';
KW_NOVALIDATE: 'NOVALIDATE';
KW_RELY: 'RELY';
KW_NORELY: 'NORELY';
KW_UNIQUE: 'UNIQUE';
KW_KEY: 'KEY';
KW_ABORT: 'ABORT';
KW_EXTRACT: 'EXTRACT';
KW_FLOOR: 'FLOOR';
KW_MERGE: 'MERGE';
KW_MATCHED: 'MATCHED';
KW_REPL: 'REPL';
KW_DUMP: 'DUMP';
KW_STATUS: 'STATUS';
KW_VECTORIZATION: 'VECTORIZATION';
KW_SUMMARY: 'SUMMARY';
KW_OPERATOR: 'OPERATOR';
KW_EXPRESSION: 'EXPRESSION';
KW_DETAIL: 'DETAIL';
KW_WAIT: 'WAIT';
KW_RESOURCE: 'RESOURCE';
KW_PLAN: 'PLAN';
KW_QUERY_PARALLELISM: 'QUERY_PARALLELISM';
KW_PLANS: 'PLANS';
KW_ACTIVATE: 'ACTIVATE';
KW_DEFAULT: 'DEFAULT';
KW_CHECK: 'CHECK';
KW_POOL: 'POOL';
KW_MOVE: 'MOVE';
KW_DO: 'DO';
KW_ALLOC_FRACTION: 'ALLOC_FRACTION';
KW_SCHEDULING_POLICY: 'SCHEDULING_POLICY';
KW_SCHEDULED: 'SCHEDULED';
KW_EVERY: 'EVERY';
KW_AT: 'AT';
KW_CRON: 'CRON';
KW_PATH: 'PATH';
KW_MAPPING: 'MAPPING';
KW_WORKLOAD: 'WORKLOAD';
KW_MANAGEMENT: 'MANAGEMENT';
KW_ACTIVE: 'ACTIVE';
KW_UNMANAGED: 'UNMANAGED';
KW_APPLICATION: 'APPLICATION';
KW_SYNC: 'SYNC';
KW_AST: 'AST';
KW_COST: 'COST';
KW_JOINCOST: 'JOINCOST';
KW_WITHIN: 'WITHIN';
KW_PKFK_JOIN: 'PKFK_JOIN';
KW_LEADING: 'LEADING';
KW_TRAILING: 'TRAILING';
KW_TRIM: 'TRIM';
KW_IGNORE: 'IGNORE';
KW_RESPECT: 'RESPECT';
KW_DATACONNECTOR: 'CONNECTOR';
KW_DATACONNECTORS: 'CONNECTORS';
KW_TYPE: 'TYPE';
KW_URL: 'URL';
KW_REMOTE: 'REMOTE';
KW_SPEC: 'SPEC';
KW_SYSTEM_TIME: 'SYSTEM_TIME';
KW_SYSTEM_VERSION: 'SYSTEM_VERSION';


// Operators
// NOTE: if you add a new function/operator, add it to sysFuncNames so that describe function _FUNC_ will work.

DOT : '.'; // generated as a part of Number rule
COLON : ':' ;
COMMA : ',' ;
SEMICOLON : ';' ;

LPAREN : '(' ;
RPAREN : ')' ;
LSQUARE : '[' ;
RSQUARE : ']' ;
LCURLY : '{';
RCURLY : '}';

EQUAL : '=' | '==';
EQUAL_NS : '<=>';
NOTEQUAL : '<>' | '!=';
LESSTHANOREQUALTO : '<=';
LESSTHAN : '<';
GREATERTHANOREQUALTO : '>=';
GREATERTHAN : '>';

DIVIDE : '/';
PLUS : '+';
MINUS : '-';
STAR : '*';
MOD : '%';
DIV : 'DIV';

AMPERSAND : '&';
TILDE : '~';
BITWISEOR : '|';
CONCATENATE : '||';
BITWISEXOR : '^';
QUESTION : '?';
DOLLAR : '$';

// LITERALS
fragment
Letter
    : 'a'..'z' | 'A'..'Z'
    ;

fragment
HexDigit
    : 'a'..'f' | 'A'..'F'
    ;

fragment
Digit
    :
    '0'..'9'
    ;

fragment
Exponent
    :
    ('e' | 'E') ( PLUS|MINUS )? (Digit)+
    ;

fragment
RegexComponent
    : 'a'..'z' | 'A'..'Z' | '0'..'9' | '_'
    | PLUS | STAR | QUESTION | MINUS | DOT
    | LPAREN | RPAREN | LSQUARE | RSQUARE | LCURLY | RCURLY
    | BITWISEXOR | BITWISEOR | DOLLAR | '!'
    ;

StringLiteral
    :
    // This is implemented by subclass.
    ;

CharSetLiteral
    :
    StringLiteral
    | '0' 'X' (HexDigit|Digit)+
    ;

IntegralLiteral
    :
    (Digit)+ ('L' | 'S' | 'Y')
    ;

NumberLiteral
    :
    Number ('D' | 'B' 'D')
    ;

ByteLengthLiteral
    :
    (Digit)+ ('b' | 'B' | 'k' | 'K' | 'm' | 'M' | 'g' | 'G')
    ;

Number
    :
    (Digit)+ ( DOT (Digit)* (Exponent)? | Exponent)?
    ;

/*
An Identifier can be:
- tableName
- columnName
- select expr alias
- lateral view aliases
- database name
- view name
- subquery alias
- function name
- ptf argument identifier
- index name
- property name for: db,tbl,partition...
- fileFormat
- role name
- privilege name
- principal name
- macro name
- hint name
- window name
*/
Identifier
    :
    (Letter | Digit) (Letter | Digit | '_')*
    | {allowQuotedId() != Quotation.NONE}? QuotedIdentifier
    | '`' RegexComponent+ '`'
    ;

fragment
QuotedIdentifier
    :
    // This is implemented by subclass.
    ;

CharSetName
    :
    '_' (Letter | Digit | '_' | '-' | '.' | ':' )+
    ;

WS  :  (' '|'\r'|'\t'|'\n') {$channel=HIDDEN;}
    ;

LINE_COMMENT
    : '--' (~('\n'|'\r'))* { $channel=HIDDEN; }
    ;

QUERY_HINT
    : '/*' (options { greedy=false; } : QUERY_HINT|.)* '*/' { if(getText().charAt(2) != '+') { $channel=HIDDEN; } else { setText(getText().substring(3, getText().length() - 2)); } }
    ;
