/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon.impl;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.google.protobuf.BlockingService;
import com.google.protobuf.ByteString;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.DaemonId;
import org.apache.hadoop.hive.llap.LlapUtil;
import org.apache.hadoop.hive.llap.daemon.ContainerRunner;
import org.apache.hadoop.hive.llap.daemon.impl.DumpingMetricsCollector;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;
import org.apache.hadoop.hive.llap.io.api.LlapIo;
import org.apache.hadoop.hive.llap.io.api.LlapProxy;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonExecutorMetrics;
import org.apache.hadoop.hive.llap.protocol.LlapManagementProtocolPB;
import org.apache.hadoop.hive.llap.protocol.LlapProtocolBlockingPB;
import org.apache.hadoop.hive.llap.security.LlapDaemonPolicyProvider;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.service.AbstractService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapProtocolServerImpl
extends AbstractService
implements LlapProtocolBlockingPB,
LlapManagementProtocolPB {
    private static final Logger LOG = LoggerFactory.getLogger(LlapProtocolServerImpl.class);
    private final int numHandlers;
    private final ContainerRunner containerRunner;
    private final int srvPort;
    private final int mngPort;
    private final int externalClientsRpcPort;
    private RPC.Server server;
    private RPC.Server mngServer;
    private RPC.Server externalClientsRpcServer;
    private final AtomicReference<InetSocketAddress> srvAddress;
    private final AtomicReference<InetSocketAddress> mngAddress;
    private final org.apache.hadoop.hive.llap.security.SecretManager secretManager;
    private String clusterUser = null;
    private boolean isRestrictedToClusterUser = false;
    private final DaemonId daemonId;
    private final LlapDaemonExecutorMetrics executorMetrics;
    private TokenRequiresSigning isSigningRequiredConfig = TokenRequiresSigning.TRUE;

    public LlapProtocolServerImpl(org.apache.hadoop.hive.llap.security.SecretManager secretManager, int numHandlers, ContainerRunner containerRunner, AtomicReference<InetSocketAddress> srvAddress, AtomicReference<InetSocketAddress> mngAddress, int srvPort, int externalClientsRpcPort, int mngPort, DaemonId daemonId, LlapDaemonExecutorMetrics executorMetrics) {
        super("LlapDaemonProtocolServerImpl");
        this.numHandlers = numHandlers;
        this.containerRunner = containerRunner;
        this.secretManager = secretManager;
        this.srvAddress = srvAddress;
        this.srvPort = srvPort;
        this.mngAddress = mngAddress;
        this.externalClientsRpcPort = externalClientsRpcPort;
        this.mngPort = mngPort;
        this.daemonId = daemonId;
        this.executorMetrics = executorMetrics;
        LOG.info("Creating: " + LlapProtocolServerImpl.class.getSimpleName() + " with port configured to: " + srvPort);
    }

    public LlapDaemonProtocolProtos.RegisterDagResponseProto registerDag(RpcController controller, LlapDaemonProtocolProtos.RegisterDagRequestProto request) throws ServiceException {
        try {
            return this.containerRunner.registerDag(request);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public LlapDaemonProtocolProtos.SubmitWorkResponseProto submitWork(RpcController controller, LlapDaemonProtocolProtos.SubmitWorkRequestProto request) throws ServiceException {
        try {
            return this.containerRunner.submitWork(request);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public LlapDaemonProtocolProtos.SourceStateUpdatedResponseProto sourceStateUpdated(RpcController controller, LlapDaemonProtocolProtos.SourceStateUpdatedRequestProto request) throws ServiceException {
        try {
            return this.containerRunner.sourceStateUpdated(request);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public LlapDaemonProtocolProtos.QueryCompleteResponseProto queryComplete(RpcController controller, LlapDaemonProtocolProtos.QueryCompleteRequestProto request) throws ServiceException {
        try {
            return this.containerRunner.queryComplete(request);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public LlapDaemonProtocolProtos.TerminateFragmentResponseProto terminateFragment(RpcController controller, LlapDaemonProtocolProtos.TerminateFragmentRequestProto request) throws ServiceException {
        try {
            return this.containerRunner.terminateFragment(request);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public LlapDaemonProtocolProtos.UpdateFragmentResponseProto updateFragment(RpcController controller, LlapDaemonProtocolProtos.UpdateFragmentRequestProto request) throws ServiceException {
        try {
            return this.containerRunner.updateFragment(request);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public void serviceStart() {
        final Configuration conf = this.getConfig();
        this.isSigningRequiredConfig = LlapProtocolServerImpl.getSigningConfig(conf);
        final BlockingService daemonImpl = LlapDaemonProtocolProtos.LlapDaemonProtocol.newReflectiveBlockingService((LlapDaemonProtocolProtos.LlapDaemonProtocol.BlockingInterface)this);
        final BlockingService managementImpl = LlapDaemonProtocolProtos.LlapManagementProtocol.newReflectiveBlockingService((LlapDaemonProtocolProtos.LlapManagementProtocol.BlockingInterface)this);
        if (!UserGroupInformation.isSecurityEnabled()) {
            this.startProtocolServers(conf, daemonImpl, managementImpl);
            return;
        }
        try {
            this.clusterUser = UserGroupInformation.getCurrentUser().getShortUserName();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (LlapProtocolServerImpl.isPermissiveManagementAcl(conf)) {
            LOG.warn("Management protocol has a '*' ACL.");
            this.isRestrictedToClusterUser = true;
        }
        String llapPrincipal = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_KERBEROS_PRINCIPAL);
        String llapKeytab = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_KERBEROS_KEYTAB_FILE);
        UserGroupInformation daemonUgi = null;
        try {
            daemonUgi = LlapUtil.loginWithKerberos((String)llapPrincipal, (String)llapKeytab);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        daemonUgi.doAs((PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                LlapProtocolServerImpl.this.startProtocolServers(conf, daemonImpl, managementImpl);
                return null;
            }
        });
    }

    private static TokenRequiresSigning getSigningConfig(Configuration conf) {
        String signSetting;
        switch (signSetting = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_REMOTE_TOKEN_REQUIRES_SIGNING).toLowerCase()) {
            case "true": {
                return TokenRequiresSigning.TRUE;
            }
            case "except_llap_owner": {
                return TokenRequiresSigning.EXCEPT_OWNER;
            }
            case "false": {
                return TokenRequiresSigning.FALSE;
            }
        }
        throw new RuntimeException("Invalid value for " + HiveConf.ConfVars.LLAP_REMOTE_TOKEN_REQUIRES_SIGNING.varname + ": " + signSetting);
    }

    private static boolean isPermissiveManagementAcl(Configuration conf) {
        return HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_VALIDATE_ACLS) && "*".equals(HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_MANAGEMENT_ACL)) && "".equals(HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_MANAGEMENT_ACL_DENY));
    }

    private void startProtocolServers(Configuration conf, BlockingService daemonImpl, BlockingService managementImpl) {
        LlapDaemonPolicyProvider pp = new LlapDaemonPolicyProvider();
        this.server = LlapUtil.startProtocolServer((int)this.srvPort, (int)this.numHandlers, this.srvAddress, (Configuration)conf, (BlockingService)daemonImpl, LlapProtocolBlockingPB.class, (SecretManager)this.secretManager, (PolicyProvider)pp, (HiveConf.ConfVars[])new HiveConf.ConfVars[]{HiveConf.ConfVars.LLAP_SECURITY_ACL, HiveConf.ConfVars.LLAP_SECURITY_ACL_DENY});
        if (LlapUtil.isCloudDeployment((Configuration)conf)) {
            this.externalClientsRpcServer = LlapUtil.startProtocolServer((int)this.externalClientsRpcPort, (int)this.numHandlers, null, (Configuration)conf, (BlockingService)daemonImpl, LlapProtocolBlockingPB.class, (SecretManager)this.secretManager, (PolicyProvider)pp, (HiveConf.ConfVars[])new HiveConf.ConfVars[]{HiveConf.ConfVars.LLAP_SECURITY_ACL, HiveConf.ConfVars.LLAP_SECURITY_ACL_DENY});
            LOG.info("Started externalClientsRpcServer for cloud based deployments : {}, {}", (Object)this.externalClientsRpcServer.getListenerAddress(), (Object)this.externalClientsRpcServer);
        }
        this.mngServer = LlapUtil.startProtocolServer((int)this.mngPort, (int)2, this.mngAddress, (Configuration)conf, (BlockingService)managementImpl, LlapManagementProtocolPB.class, (SecretManager)this.secretManager, (PolicyProvider)pp, (HiveConf.ConfVars[])new HiveConf.ConfVars[]{HiveConf.ConfVars.LLAP_MANAGEMENT_ACL, HiveConf.ConfVars.LLAP_MANAGEMENT_ACL_DENY});
    }

    public void serviceStop() {
        if (this.server != null) {
            this.server.stop();
        }
        if (this.externalClientsRpcServer != null) {
            this.externalClientsRpcServer.stop();
        }
        if (this.mngServer != null) {
            this.mngServer.stop();
        }
    }

    @InterfaceAudience.Private
    InetSocketAddress getBindAddress() {
        return this.srvAddress.get();
    }

    @InterfaceAudience.Private
    InetSocketAddress getManagementBindAddress() {
        return this.mngAddress.get();
    }

    @InterfaceAudience.Private
    InetSocketAddress getExternalClientsRpcServerBindAddress() {
        return this.externalClientsRpcServer.getListenerAddress();
    }

    public LlapDaemonProtocolProtos.GetTokenResponseProto getDelegationToken(RpcController controller, LlapDaemonProtocolProtos.GetTokenRequestProto request) throws ServiceException {
        if (this.secretManager == null) {
            throw new ServiceException("Operation not supported on unsecure cluster");
        }
        UserGroupInformation callingUser = null;
        Token token = null;
        try {
            callingUser = UserGroupInformation.getCurrentUser();
            boolean isSigningRequired = this.determineIfSigningIsRequired(callingUser);
            token = this.secretManager.createLlapToken(request.hasAppId() ? request.getAppId() : null, null, isSigningRequired);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        if (this.isRestrictedToClusterUser && !this.clusterUser.equals(callingUser.getShortUserName())) {
            throw new ServiceException("Management protocol ACL is too permissive. The access has been automatically restricted to " + this.clusterUser + "; " + callingUser.getShortUserName() + " is denied access. Please set " + HiveConf.ConfVars.LLAP_VALIDATE_ACLS.varname + " to false, or adjust " + HiveConf.ConfVars.LLAP_MANAGEMENT_ACL.varname + " and " + HiveConf.ConfVars.LLAP_MANAGEMENT_ACL_DENY.varname + " to a more restrictive ACL.");
        }
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        try {
            token.write((DataOutput)out);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        ByteString bs = ByteString.copyFrom((byte[])out.toByteArray());
        LlapDaemonProtocolProtos.GetTokenResponseProto response = LlapDaemonProtocolProtos.GetTokenResponseProto.newBuilder().setToken(bs).build();
        return response;
    }

    public LlapDaemonProtocolProtos.PurgeCacheResponseProto purgeCache(RpcController controller, LlapDaemonProtocolProtos.PurgeCacheRequestProto request) throws ServiceException {
        LlapDaemonProtocolProtos.PurgeCacheResponseProto.Builder responseProtoBuilder = LlapDaemonProtocolProtos.PurgeCacheResponseProto.newBuilder();
        LlapIo llapIo = LlapProxy.getIo();
        if (llapIo != null) {
            responseProtoBuilder.setPurgedMemoryBytes(llapIo.purge());
        } else {
            responseProtoBuilder.setPurgedMemoryBytes(0L);
        }
        return responseProtoBuilder.build();
    }

    public LlapDaemonProtocolProtos.GetDaemonMetricsResponseProto getDaemonMetrics(RpcController controller, LlapDaemonProtocolProtos.GetDaemonMetricsRequestProto request) throws ServiceException {
        LlapDaemonProtocolProtos.GetDaemonMetricsResponseProto.Builder responseProtoBuilder = LlapDaemonProtocolProtos.GetDaemonMetricsResponseProto.newBuilder();
        if (this.executorMetrics != null) {
            HashMap<String, Long> data = new HashMap<String, Long>();
            DumpingMetricsCollector dmc = new DumpingMetricsCollector(data);
            this.executorMetrics.getMetrics(dmc, true);
            data.forEach((key, value) -> responseProtoBuilder.addMetrics(LlapDaemonProtocolProtos.MapEntry.newBuilder().setKey(key).setValue(value.longValue()).build()));
        }
        return responseProtoBuilder.build();
    }

    public LlapDaemonProtocolProtos.SetCapacityResponseProto setCapacity(RpcController controller, LlapDaemonProtocolProtos.SetCapacityRequestProto request) throws ServiceException {
        try {
            return this.containerRunner.setCapacity(request);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public LlapDaemonProtocolProtos.EvictEntityResponseProto evictEntity(RpcController controller, LlapDaemonProtocolProtos.EvictEntityRequestProto protoRequest) throws ServiceException {
        LlapDaemonProtocolProtos.EvictEntityResponseProto.Builder responseProtoBuilder = LlapDaemonProtocolProtos.EvictEntityResponseProto.newBuilder();
        LlapIo llapIo = LlapProxy.getIo();
        if (llapIo != null) {
            long evicted = llapIo.evictEntity(protoRequest);
            responseProtoBuilder.setEvictedBytes(evicted);
        } else {
            responseProtoBuilder.setEvictedBytes(-1L);
        }
        return responseProtoBuilder.build();
    }

    public LlapDaemonProtocolProtos.GetCacheContentResponseProto getCacheContent(RpcController controller, LlapDaemonProtocolProtos.GetCacheContentRequestProto request) {
        LlapDaemonProtocolProtos.GetCacheContentResponseProto.Builder responseProtoBuilder = LlapDaemonProtocolProtos.GetCacheContentResponseProto.newBuilder();
        LlapIo llapIo = LlapProxy.getIo();
        if (llapIo != null) {
            LlapDaemonProtocolProtos.CacheEntryList entries = llapIo.fetchCachedContentInfo();
            responseProtoBuilder.setResult(entries);
        }
        return responseProtoBuilder.build();
    }

    private boolean determineIfSigningIsRequired(UserGroupInformation callingUser) {
        switch (this.isSigningRequiredConfig) {
            case FALSE: {
                return false;
            }
            case TRUE: {
                return true;
            }
            case EXCEPT_OWNER: {
                return !this.clusterUser.equals(callingUser.getShortUserName());
            }
        }
        throw new AssertionError((Object)("Unknown value " + (Object)((Object)this.isSigningRequiredConfig)));
    }

    private static enum TokenRequiresSigning {
        TRUE,
        FALSE,
        EXCEPT_OWNER;

    }
}

