/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Base64;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.NewCookie;
import org.apache.hive.service.CookieSigner;
import org.apache.hive.service.auth.HttpAuthUtils;
import org.apache.hive.service.auth.HttpAuthenticationException;
import org.apache.hive.service.auth.ldap.HttpEmptyAuthenticationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpAuthService {
    private static final Logger LOG = LoggerFactory.getLogger(HttpAuthService.class);
    public static final String USERNAME_REQUEST_PARAM_NAME = "username";
    public static final String PASSWORD_REQUEST_PARAM_NAME = "password";
    private static final SecureRandom RAN = new SecureRandom();
    public static final String HIVE_SERVER2_WEBUI_AUTH_COOKIE_NAME = "hive.server2.webui.auth";
    private final CookieSigner signer;
    private final String cookieDomain;
    private final String cookiePath;
    private final int cookieMaxAge;
    private final boolean isCookieSecure;
    private final String authCookieName;

    public HttpAuthService(String cookieDomain, String cookiePath, int cookieMaxAge, boolean isCookieSecure, String authCookieName) {
        String secret = Long.toString(RAN.nextLong());
        this.signer = new CookieSigner(secret.getBytes());
        this.cookieMaxAge = cookieMaxAge;
        this.cookieDomain = cookieDomain;
        this.cookiePath = cookiePath;
        this.authCookieName = authCookieName;
        this.isCookieSecure = isCookieSecure;
    }

    public Cookie signAndCreateCookie(String cookieToken) {
        return this.createCookie(this.signer.signCookie(cookieToken));
    }

    public Cookie createCookie(String str) {
        Cookie cookie = new Cookie(this.authCookieName, str);
        cookie.setMaxAge(this.cookieMaxAge);
        if (this.cookieDomain != null) {
            cookie.setDomain(this.cookieDomain);
        }
        if (this.cookiePath != null) {
            cookie.setPath(this.cookiePath);
        }
        cookie.setSecure(this.isCookieSecure);
        return cookie;
    }

    public String validateCookie(HttpServletRequest request) throws UnsupportedEncodingException {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No valid cookies associated with the request {}", (Object)request);
            }
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received cookies: {}", (Object)this.toCookieStr(cookies));
        }
        return this.getClientNameFromCookie(cookies);
    }

    private String getClientNameFromCookie(Cookie[] cookies) {
        for (Cookie currCookie : cookies) {
            String currName = currCookie.getName();
            if (!currName.equals(this.authCookieName)) continue;
            String currValue = currCookie.getValue();
            try {
                currValue = this.signer.verifyAndExtract(currValue);
            }
            catch (IllegalArgumentException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Invalid cookie", e);
                }
                currValue = null;
            }
            if (currValue == null) continue;
            String userName = HttpAuthUtils.getUserNameFromCookieToken(currValue);
            if (userName == null) {
                LOG.warn("Invalid cookie token {}", (Object)currValue);
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Validated the cookie for user {}", (Object)userName);
            }
            return userName;
        }
        return null;
    }

    public String verifyAndExtract(String signedValue) {
        return this.signer.verifyAndExtract(signedValue);
    }

    private String toCookieStr(Cookie[] cookies) {
        StringBuilder cookieStr = new StringBuilder();
        for (Cookie c : cookies) {
            cookieStr.append(c.getName()).append('=').append(c.getValue()).append(" ;\n");
        }
        return cookieStr.toString();
    }

    public String getUsername(HttpServletRequest request) throws HttpAuthenticationException {
        String usernameParam = request.getParameter(USERNAME_REQUEST_PARAM_NAME);
        if (usernameParam != null && !usernameParam.isEmpty()) {
            return usernameParam;
        }
        String authHeaderDecodedString = this.getAuthHeaderDecodedString(request);
        String[] credentials = authHeaderDecodedString.split(":", 2);
        if (credentials[0] == null || credentials[0].isEmpty()) {
            throw new HttpAuthenticationException("Authorization header received from the client does not contain username.");
        }
        return credentials[0];
    }

    public String getPassword(HttpServletRequest request) throws HttpAuthenticationException {
        String passwordParam = request.getParameter(PASSWORD_REQUEST_PARAM_NAME);
        if (passwordParam != null && !passwordParam.isEmpty()) {
            return passwordParam;
        }
        String authHeaderDecodedString = this.getAuthHeaderDecodedString(request);
        String[] credentials = authHeaderDecodedString.split(":", 2);
        if (credentials.length < 2 || credentials[1] == null || credentials[1].isEmpty()) {
            throw new HttpAuthenticationException("Authorization header received from the client does not contain password.");
        }
        return credentials[1];
    }

    private String getAuthHeaderDecodedString(HttpServletRequest request) throws HttpAuthenticationException {
        String authHeaderBase64Str = this.getAuthHeader(request);
        try {
            return new String(Base64.getDecoder().decode(authHeaderBase64Str), StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException e) {
            throw new HttpAuthenticationException("Authorization header received from the client does not contain base64 encoded data", e);
        }
    }

    public String getAuthHeader(HttpServletRequest request) throws HttpAuthenticationException {
        String authHeader = request.getHeader("Authorization");
        if (authHeader == null || authHeader.isEmpty()) {
            throw new HttpEmptyAuthenticationException("Authorization header received from the client is empty.");
        }
        LOG.debug("HTTP Auth Header [{}]", (Object)authHeader);
        String[] parts = authHeader.split(" ");
        String authHeaderBase64String = parts[parts.length - 1];
        if (authHeaderBase64String.isEmpty()) {
            throw new HttpAuthenticationException("Authorization header received from the client does not contain any data.");
        }
        return authHeaderBase64String;
    }

    public static String getHttpOnlyCookieHeader(Cookie cookie) {
        NewCookie newCookie = new NewCookie(cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getDomain(), cookie.getVersion(), cookie.getComment(), cookie.getMaxAge(), cookie.getSecure());
        return newCookie + "; HttpOnly";
    }
}

