/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.jdbc.saml;

import java.awt.Desktop;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import javax.servlet.Servlet;
import org.apache.hive.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.com.google.common.base.Preconditions;
import org.apache.hive.jdbc.Utils;
import org.apache.hive.jdbc.saml.HttpBrowserClientServlet;
import org.apache.hive.jdbc.saml.IJdbcBrowserClient;
import org.apache.hive.service.auth.saml.HiveSamlUtils;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveJdbcBrowserClient
implements IJdbcBrowserClient {
    private static final Logger LOG = LoggerFactory.getLogger(HiveJdbcBrowserClient.class);
    @VisibleForTesting
    public static final String TIMEOUT_ERROR_MSG = "Timed out while waiting for server response";
    private final int portFromUrl;
    private Integer serverPort;
    private final long timeoutInMs;
    private final BlockingQueue<IJdbcBrowserClient.HiveJdbcBrowserServerResponse> serverResponseQueue = new LinkedBlockingDeque<IJdbcBrowserClient.HiveJdbcBrowserServerResponse>();
    protected IJdbcBrowserClient.JdbcBrowserClientContext clientContext;
    private static final int DEFAULT_SOCKET_TIMEOUT_SECS = 120;
    private Server webServer;
    private IJdbcBrowserClient.HiveJdbcBrowserServerResponse serverResponse;

    HiveJdbcBrowserClient(Utils.JdbcConnectionParams connectionParams) throws IJdbcBrowserClient.HiveJdbcBrowserException {
        this.portFromUrl = Integer.parseInt(connectionParams.getSessionVars().getOrDefault("browserResponsePort", "0"));
        this.timeoutInMs = (long)Integer.parseInt(connectionParams.getSessionVars().getOrDefault("browserResponseTimeout", String.valueOf(120))) * 1000L;
    }

    @Override
    public void startListening() throws IJdbcBrowserClient.HiveJdbcBrowserException {
        this.webServer = new Server();
        ServerConnector serverConnector = new ServerConnector(this.webServer);
        serverConnector.setHost(HiveSamlUtils.LOOP_BACK_INTERFACE);
        serverConnector.setPort(this.portFromUrl);
        LOG.info("Browser response timeout is set to {} ms", (Object)this.timeoutInMs);
        serverConnector.setIdleTimeout(this.timeoutInMs);
        this.webServer.addConnector((Connector)serverConnector);
        ServletHandler servletHandler = new ServletHandler();
        servletHandler.addServletWithMapping(new ServletHolder((Servlet)new HttpBrowserClientServlet(this)), "/");
        this.webServer.setHandler((Handler)servletHandler);
        this.webServer.setStopTimeout(30000L);
        try {
            this.webServer.start();
            this.serverPort = ((ServerConnector)this.webServer.getConnectors()[0]).getLocalPort();
            LOG.debug("Listening on the port {} ", (Object)this.serverPort);
        }
        catch (Exception e) {
            throw new IJdbcBrowserClient.HiveJdbcBrowserException("Could not start http server", e);
        }
    }

    @Override
    public Integer getPort() {
        return this.serverPort;
    }

    public String toString() {
        return "HiveJdbcBrowserClient@" + this.serverPort;
    }

    @Override
    public IJdbcBrowserClient.HiveJdbcBrowserServerResponse getServerResponse() {
        return this.serverResponse;
    }

    @Override
    public void close() throws IOException {
        if (this.webServer != null && this.webServer.isRunning()) {
            try {
                this.webServer.stop();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            this.webServer = null;
        }
    }

    @Override
    public void init(IJdbcBrowserClient.JdbcBrowserClientContext clientContext) {
        this.reset();
        this.clientContext = clientContext;
        LOG.debug("Initialized the JDBCBrowser client with URL {}", (Object)clientContext.getSsoUri());
    }

    private void reset() {
        this.serverResponse = null;
        this.clientContext = null;
    }

    @Override
    public void doBrowserSSO() throws IJdbcBrowserClient.HiveJdbcBrowserException {
        this.logDebugInfoUri(this.clientContext.getSsoUri());
        this.openBrowserWindow();
        try {
            this.waitForServerResponse(this.timeoutInMs);
        }
        catch (InterruptedException e) {
            throw new IJdbcBrowserClient.HiveJdbcBrowserException(e);
        }
        if (this.serverResponse == null) {
            throw new IJdbcBrowserClient.HiveJdbcBrowserException(TIMEOUT_ERROR_MSG);
        }
        if (!this.serverResponse.isValid()) {
            throw new IJdbcBrowserClient.HiveJdbcBrowserException("Received invalid response from server. See driver logs for more details");
        }
    }

    private void logDebugInfoUri(URI ssoURI) {
        Map<Object, Object> uriParams = new HashMap();
        try {
            uriParams = this.getQueryParams(ssoURI);
        }
        catch (IJdbcBrowserClient.HiveJdbcBrowserException e) {
            LOG.info("Could get query params of the SSO URI", e);
        }
        LOG.debug("Initializing browser SSO request to URI. Relay state is {}", uriParams.get("RelayState"));
    }

    private Map<String, String> getQueryParams(URI ssoUri) throws IJdbcBrowserClient.HiveJdbcBrowserException {
        String[] params;
        String decodedUrl;
        try {
            decodedUrl = URLDecoder.decode(ssoUri.toString(), StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IJdbcBrowserClient.HiveJdbcBrowserException(e);
        }
        try {
            params = new URI(decodedUrl).getQuery().split("&");
        }
        catch (URISyntaxException e) {
            throw new IJdbcBrowserClient.HiveJdbcBrowserException(e);
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (String param : params) {
            String key = param.split("=")[0];
            String val = param.split("=")[1];
            paramMap.put(key, val);
        }
        return paramMap;
    }

    @VisibleForTesting
    protected void openBrowserWindow() throws IJdbcBrowserClient.HiveJdbcBrowserException {
        URI ssoUri = this.clientContext.getSsoUri();
        try {
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                Desktop.getDesktop().browse(ssoUri);
            } else {
                LOG.info("Desktop mode is not supported. Attempting to use OS commands to open the default browser");
                String ssoUriStr = ssoUri.toString();
                OsType os = this.getOperatingSystem();
                switch (os) {
                    case WINDOWS: {
                        Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + ssoUriStr);
                        break;
                    }
                    case MAC: {
                        Runtime.getRuntime().exec("open " + ssoUriStr);
                        break;
                    }
                    case LINUX: {
                        Runtime.getRuntime().exec("xdg-open " + ssoUriStr);
                        break;
                    }
                    case UNKNOWN: {
                        throw new IJdbcBrowserClient.HiveJdbcBrowserException("Unknown operating system " + System.getProperty("os.name"));
                    }
                }
            }
        }
        catch (IOException e) {
            throw new IJdbcBrowserClient.HiveJdbcBrowserException("Unable to open browser to execute SSO", e);
        }
    }

    public void addServerResponse(IJdbcBrowserClient.HiveJdbcBrowserServerResponse response) {
        this.serverResponseQueue.add(response);
    }

    private void waitForServerResponse(long timeoutInMs) throws InterruptedException {
        this.serverResponse = this.serverResponseQueue.poll(timeoutInMs, TimeUnit.MILLISECONDS);
    }

    @Override
    public String getClientIdentifier() {
        if (this.clientContext == null) {
            return null;
        }
        return this.clientContext.getClientIdentifier();
    }

    private void sendBrowserMsg(Socket socket, boolean success) throws IOException {
        PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
        ArrayList<String> content = new ArrayList<String>();
        content.add("HTTP/1.0 200 OK");
        content.add("Content-Type: text/html");
        String responseText = success ? "<!DOCTYPE html><html><head><meta charset=\"UTF-8\"/><title>SAML Response Received</title></head><body onload=\"waitAndClose()\">Successfully authenticated. You may close this window.</body><script>  function waitAndClose() {    setTimeout(function() {      window.close()    }, 100);  }</script></html>" : "<!DOCTYPE html><html><head><meta charset=\"UTF-8\"/><title>SAML Response Received</title></head><body>Authentication failed. Please check server logs for details. You may close this window.</body></html>";
        content.add(String.format("Content-Length: %s", responseText.length()));
        content.add("");
        content.add(responseText);
        for (int i = 0; i < content.size(); ++i) {
            if (i > 0) {
                out.print("\r\n");
            }
            out.print((String)content.get(i));
        }
        out.flush();
    }

    public OsType getMatchingOs(String osName) {
        if ((osName = osName.toLowerCase()).contains("win")) {
            return OsType.WINDOWS;
        }
        if (osName.contains("mac")) {
            return OsType.MAC;
        }
        if (osName.contains("nix") || osName.contains("nux") || osName.contains("aix")) {
            return OsType.LINUX;
        }
        return OsType.UNKNOWN;
    }

    private OsType getOperatingSystem() {
        String osName = System.getProperty("os.name");
        Preconditions.checkNotNull(osName, "os.name is null");
        return this.getMatchingOs(osName);
    }

    private static enum OsType {
        WINDOWS,
        MAC,
        LINUX,
        UNKNOWN;

    }
}

