/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.common.util;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.hive.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.common.util.SuppressFBWarnings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownHookManager {
    private static final org.apache.hadoop.util.ShutdownHookManager MGR = org.apache.hadoop.util.ShutdownHookManager.get();
    private static final DeleteOnExitHook DELETE_ON_EXIT_HOOK = new DeleteOnExitHook();
    private static final Logger LOG = LoggerFactory.getLogger(ShutdownHookManager.class.getName());
    public static final int GRACEFUL_SHUTDOWN_HOOK_PRIORITY = 1000;
    public static final int DEFAULT_SHUTDOWN_HOOK_PRIORITY = 10;
    public static final int DELETE_ON_EXIT_HOOK_PRIORITY = -1;

    public static void addShutdownHook(Runnable shutdownHook) {
        ShutdownHookManager.addShutdownHook(shutdownHook, 10);
    }

    public static void addShutdownHook(Runnable shutdownHook, int priority) {
        ShutdownHookManager.addShutdownHook(shutdownHook, priority, 30L);
    }

    public static void addGracefulShutDownHook(Runnable shutdownHook, long timeout) {
        ShutdownHookManager.addShutdownHook(shutdownHook, 1000, timeout);
    }

    private static void addShutdownHook(Runnable shutdownHook, int priority, long timeout) {
        if (priority < 0 || priority > 1000) {
            throw new IllegalArgumentException("Priority should be ranged between 0 and 1000");
        }
        if (!ShutdownHookManager.isShutdownInProgress()) {
            MGR.addShutdownHook(shutdownHook, priority, timeout, TimeUnit.SECONDS);
        }
    }

    public static boolean isShutdownInProgress() {
        return MGR.isShutdownInProgress();
    }

    public static boolean removeShutdownHook(Runnable shutdownHook) {
        if (shutdownHook == null || ShutdownHookManager.isShutdownInProgress()) {
            return false;
        }
        return MGR.removeShutdownHook(shutdownHook);
    }

    public static void deleteOnExit(File file) {
        if (MGR.isShutdownInProgress()) {
            LOG.warn("Shutdown in progress, cannot add a deleteOnExit");
        }
        ShutdownHookManager.DELETE_ON_EXIT_HOOK.deleteTargets.add(file);
    }

    public static void cancelDeleteOnExit(File file) {
        if (MGR.isShutdownInProgress()) {
            LOG.warn("Shutdown in progress, cannot cancel a deleteOnExit");
        }
        ShutdownHookManager.DELETE_ON_EXIT_HOOK.deleteTargets.remove(file);
    }

    @VisibleForTesting
    static boolean isRegisteredToDeleteOnExit(File file) {
        return ShutdownHookManager.DELETE_ON_EXIT_HOOK.deleteTargets.contains(file);
    }

    static {
        MGR.addShutdownHook(DELETE_ON_EXIT_HOOK, -1);
    }

    private static class DeleteOnExitHook
    implements Runnable {
        private final Set<File> deleteTargets = Collections.synchronizedSet(new HashSet());

        private DeleteOnExitHook() {
        }

        @Override
        @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"}, justification="Intended")
        public void run() {
            for (File deleteTarget : this.deleteTargets) {
                deleteTarget.delete();
            }
            this.deleteTargets.clear();
        }
    }
}

