/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.client.api;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.registry.client.api.DNSOperations;
import org.apache.hadoop.registry.client.api.RegistryConstants;
import org.apache.hadoop.registry.server.dns.RegistryDNS;
import org.apache.hadoop.util.Preconditions;

public final class DNSOperationsFactory
implements RegistryConstants {
    private DNSOperationsFactory() {
    }

    public static DNSOperations createInstance(Configuration conf) {
        return DNSOperationsFactory.createInstance("DNSOperations", DNSImplementation.DNSJAVA, conf);
    }

    public static DNSOperations createInstance(String name, DNSImplementation impl, Configuration conf) {
        Preconditions.checkArgument(conf != null, "Null configuration");
        RegistryDNS operations = null;
        switch (impl) {
            case DNSJAVA: {
                operations = new RegistryDNS(name);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("%s is not available", impl.toString()));
            }
        }
        return operations;
    }

    public static enum DNSImplementation {
        DNSJAVA;

    }
}

