/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive;

import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.common.type.TimestampTZ;
import org.apache.hadoop.hive.serde2.io.TimestampLocalTZWritable;
import org.apache.hadoop.hive.serde2.lazy.LazyTimestampLocalTZ;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.AbstractPrimitiveLazyObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampLocalTZObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TimestampLocalTZTypeInfo;
import org.apache.hive.common.util.TimestampParser;

public class LazyTimestampLocalTZObjectInspector
extends AbstractPrimitiveLazyObjectInspector<TimestampLocalTZWritable>
implements TimestampLocalTZObjectInspector {
    private final TimestampParser parser;

    protected LazyTimestampLocalTZObjectInspector(TimestampLocalTZTypeInfo typeInfo) {
        this(typeInfo, Collections.emptyList());
    }

    LazyTimestampLocalTZObjectInspector(TimestampLocalTZTypeInfo typeInfo, List<String> formats) {
        super(typeInfo);
        this.parser = new TimestampParser(formats == null ? Collections.emptyList() : formats);
    }

    @Override
    public TimestampTZ getPrimitiveJavaObject(Object o) {
        if (o == null) {
            return null;
        }
        TimestampTZ t2 = ((LazyTimestampLocalTZ)o).getWritableObject().getTimestampTZ();
        TimestampLocalTZTypeInfo timestampTZTypeInfo = (TimestampLocalTZTypeInfo)this.typeInfo;
        if (!t2.getZonedDateTime().getZone().equals(timestampTZTypeInfo.timeZone())) {
            t2.setZonedDateTime(t2.getZonedDateTime().withZoneSameInstant(timestampTZTypeInfo.timeZone()));
        }
        return t2;
    }

    @Override
    public Object copyObject(Object o) {
        return o == null ? null : new LazyTimestampLocalTZ((LazyTimestampLocalTZ)o);
    }

    public TimestampParser getParser() {
        return this.parser;
    }
}

