/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.properties;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.hadoop.hive.metastore.properties.SerializationProxy;
import org.slf4j.Logger;

public class Serializer<T extends Serializable> {
    private static final Logger LOGGER = SerializationProxy.LOGGER;
    static final Serializer<Serializable> SERIALIZER = new Serializer();

    public void readError(Exception xany, String msg) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(msg, xany);
        }
        throw SerializationProxy.ProxyException.convert(xany);
    }

    public void readWarning(Exception xany, String msg) {
        LOGGER.warn(msg, xany);
    }

    public void writeError(Exception xany, String msg) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(msg, xany);
        }
        throw SerializationProxy.ProxyException.convert(xany);
    }

    public void writeWarning(Exception xany, String msg) {
        SerializationProxy.LOGGER.warn(msg, xany);
    }

    public final <E extends T> boolean write(File file, E persist, Object ... args) {
        if (file != null) {
            boolean bl;
            block9: {
                OutputStream out = Files.newOutputStream(file.toPath(), new OpenOption[0]);
                try {
                    bl = this.write(out, persist, args);
                    if (out == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException xio) {
                        this.writeError(xio, "error writing " + file);
                    }
                }
                out.close();
            }
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <E extends T> boolean write(OutputStream out, E persist, Object ... args) {
        if (out != null) {
            ObjectOutputStream oos = null;
            Object[] stack = SerializationProxy.swapExtraArguments(args);
            try {
                oos = out instanceof ObjectOutputStream ? (ObjectOutputStream)out : new ObjectOutputStream(out);
                oos.writeObject(persist);
                boolean bl = true;
                return bl;
            }
            catch (IOException xio) {
                this.writeError(xio, "error writing stream " + out);
            }
            finally {
                SerializationProxy.swapExtraArguments(stack);
                if (oos != null) {
                    try {
                        oos.close();
                    }
                    catch (IOException xio) {
                        this.writeWarning(xio, "closing object stream: ");
                    }
                }
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final <E extends T> E read(File file, Object ... args) {
        if (file == null) return null;
        if (!file.exists()) return null;
        if (file.length() <= 0L) return null;
        try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            E e = this.read(in, args);
            return e;
        }
        catch (IOException | ClassCastException xany) {
            this.readError(xany, "error reading " + file);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <E extends T> E read(InputStream in, Object ... args) {
        if (in != null) {
            ObjectInputStream ois = null;
            Object[] stack = SerializationProxy.swapExtraArguments(args);
            try {
                Serializable t2;
                ois = in instanceof ObjectInputStream ? (ObjectInputStream)in : new ObjectInputStream(in);
                Serializable serializable = t2 = (Serializable)ois.readObject();
                return (E)serializable;
            }
            catch (IOException | ClassCastException | ClassNotFoundException xany) {
                this.readError(xany, "error reading " + in);
            }
            finally {
                SerializationProxy.swapExtraArguments(stack);
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException xio) {
                        this.readWarning(xio, "closing object stream: ");
                    }
                }
            }
        }
        return null;
    }
}

