/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hive.org.apache.thrift.EncodingUtils;
import org.apache.hive.org.apache.thrift.TBase;
import org.apache.hive.org.apache.thrift.TBaseHelper;
import org.apache.hive.org.apache.thrift.TException;
import org.apache.hive.org.apache.thrift.TFieldIdEnum;
import org.apache.hive.org.apache.thrift.annotation.Nullable;
import org.apache.hive.org.apache.thrift.meta_data.FieldMetaData;
import org.apache.hive.org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.hive.org.apache.thrift.meta_data.ListMetaData;
import org.apache.hive.org.apache.thrift.protocol.TCompactProtocol;
import org.apache.hive.org.apache.thrift.protocol.TField;
import org.apache.hive.org.apache.thrift.protocol.TList;
import org.apache.hive.org.apache.thrift.protocol.TProtocol;
import org.apache.hive.org.apache.thrift.protocol.TProtocolUtil;
import org.apache.hive.org.apache.thrift.protocol.TStruct;
import org.apache.hive.org.apache.thrift.protocol.TTupleProtocol;
import org.apache.hive.org.apache.thrift.scheme.IScheme;
import org.apache.hive.org.apache.thrift.scheme.SchemeFactory;
import org.apache.hive.org.apache.thrift.scheme.StandardScheme;
import org.apache.hive.org.apache.thrift.scheme.TupleScheme;
import org.apache.hive.org.apache.thrift.transport.TIOStreamTransport;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class FileMetadata
implements TBase<FileMetadata, _Fields>,
Serializable,
Cloneable,
Comparable<FileMetadata> {
    private static final TStruct STRUCT_DESC = new TStruct("FileMetadata");
    private static final TField TYPE_FIELD_DESC = new TField("type", 3, 1);
    private static final TField VERSION_FIELD_DESC = new TField("version", 3, 2);
    private static final TField DATA_FIELD_DESC = new TField("data", 15, 3);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new FileMetadataStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new FileMetadataTupleSchemeFactory();
    private byte type;
    private byte version;
    @Nullable
    private List<ByteBuffer> data;
    private static final int __TYPE_ISSET_ID = 0;
    private static final int __VERSION_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public FileMetadata() {
        this.type = 1;
        this.version = 1;
    }

    public FileMetadata(byte type, byte version, List<ByteBuffer> data) {
        this();
        this.type = type;
        this.setTypeIsSet(true);
        this.version = version;
        this.setVersionIsSet(true);
        this.data = data;
    }

    public FileMetadata(FileMetadata other) {
        this.__isset_bitfield = other.__isset_bitfield;
        this.type = other.type;
        this.version = other.version;
        if (other.isSetData()) {
            ArrayList<ByteBuffer> __this__data = new ArrayList<ByteBuffer>(other.data);
            this.data = __this__data;
        }
    }

    @Override
    public FileMetadata deepCopy() {
        return new FileMetadata(this);
    }

    @Override
    public void clear() {
        this.type = 1;
        this.version = 1;
        this.data = null;
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
        this.setTypeIsSet(true);
    }

    public void unsetType() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 0);
    }

    public boolean isSetType() {
        return EncodingUtils.testBit(this.__isset_bitfield, 0);
    }

    public void setTypeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 0, value);
    }

    public byte getVersion() {
        return this.version;
    }

    public void setVersion(byte version) {
        this.version = version;
        this.setVersionIsSet(true);
    }

    public void unsetVersion() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 1);
    }

    public boolean isSetVersion() {
        return EncodingUtils.testBit(this.__isset_bitfield, 1);
    }

    public void setVersionIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 1, value);
    }

    public int getDataSize() {
        return this.data == null ? 0 : this.data.size();
    }

    @Nullable
    public Iterator<ByteBuffer> getDataIterator() {
        return this.data == null ? null : this.data.iterator();
    }

    public void addToData(ByteBuffer elem) {
        if (this.data == null) {
            this.data = new ArrayList<ByteBuffer>();
        }
        this.data.add(elem);
    }

    @Nullable
    public List<ByteBuffer> getData() {
        return this.data;
    }

    public void setData(@Nullable List<ByteBuffer> data) {
        this.data = data;
    }

    public void unsetData() {
        this.data = null;
    }

    public boolean isSetData() {
        return this.data != null;
    }

    public void setDataIsSet(boolean value) {
        if (!value) {
            this.data = null;
        }
    }

    @Override
    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case TYPE: {
                if (value == null) {
                    this.unsetType();
                    break;
                }
                this.setType((Byte)value);
                break;
            }
            case VERSION: {
                if (value == null) {
                    this.unsetVersion();
                    break;
                }
                this.setVersion((Byte)value);
                break;
            }
            case DATA: {
                if (value == null) {
                    this.unsetData();
                    break;
                }
                this.setData((List)value);
            }
        }
    }

    @Override
    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case TYPE: {
                return this.getType();
            }
            case VERSION: {
                return this.getVersion();
            }
            case DATA: {
                return this.getData();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case TYPE: {
                return this.isSetType();
            }
            case VERSION: {
                return this.isSetVersion();
            }
            case DATA: {
                return this.isSetData();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof FileMetadata) {
            return this.equals((FileMetadata)that);
        }
        return false;
    }

    public boolean equals(FileMetadata that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_type = true;
        boolean that_present_type = true;
        if (this_present_type || that_present_type) {
            if (!this_present_type || !that_present_type) {
                return false;
            }
            if (this.type != that.type) {
                return false;
            }
        }
        boolean this_present_version = true;
        boolean that_present_version = true;
        if (this_present_version || that_present_version) {
            if (!this_present_version || !that_present_version) {
                return false;
            }
            if (this.version != that.version) {
                return false;
            }
        }
        boolean this_present_data = this.isSetData();
        boolean that_present_data = that.isSetData();
        if (this_present_data || that_present_data) {
            if (!this_present_data || !that_present_data) {
                return false;
            }
            if (!this.data.equals(that.data)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + this.type;
        hashCode = hashCode * 8191 + this.version;
        hashCode = hashCode * 8191 + (this.isSetData() ? 131071 : 524287);
        if (this.isSetData()) {
            hashCode = hashCode * 8191 + this.data.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(FileMetadata other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetType(), other.isSetType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetType() && (lastComparison = TBaseHelper.compareTo(this.type, other.type)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetVersion(), other.isSetVersion());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetVersion() && (lastComparison = TBaseHelper.compareTo(this.version, other.version)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetData(), other.isSetData());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetData() && (lastComparison = TBaseHelper.compareTo(this.data, other.data)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        FileMetadata.scheme(iprot).read(iprot, (FileMetadata)this);
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        FileMetadata.scheme(oprot).write(oprot, (FileMetadata)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FileMetadata(");
        boolean first = true;
        sb.append("type:");
        sb.append(this.type);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("version:");
        sb.append(this.version);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("data:");
        if (this.data == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString(this.data, sb);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read(new TCompactProtocol(new TIOStreamTransport(in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.TYPE, new FieldMetaData("type", 3, new FieldValueMetaData(3)));
        tmpMap.put(_Fields.VERSION, new FieldMetaData("version", 3, new FieldValueMetaData(3)));
        tmpMap.put(_Fields.DATA, new FieldMetaData("data", 3, new ListMetaData(15, new FieldValueMetaData(11, true))));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(FileMetadata.class, metaDataMap);
    }

    public static enum _Fields implements TFieldIdEnum
    {
        TYPE(1, "type"),
        VERSION(2, "version"),
        DATA(3, "data");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return TYPE;
                }
                case 2: {
                    return VERSION;
                }
                case 3: {
                    return DATA;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }

    private static class FileMetadataStandardSchemeFactory
    implements SchemeFactory {
        private FileMetadataStandardSchemeFactory() {
        }

        public FileMetadataStandardScheme getScheme() {
            return new FileMetadataStandardScheme();
        }
    }

    private static class FileMetadataTupleSchemeFactory
    implements SchemeFactory {
        private FileMetadataTupleSchemeFactory() {
        }

        public FileMetadataTupleScheme getScheme() {
            return new FileMetadataTupleScheme();
        }
    }

    private static class FileMetadataTupleScheme
    extends TupleScheme<FileMetadata> {
        private FileMetadataTupleScheme() {
        }

        @Override
        public void write(TProtocol prot, FileMetadata struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetType()) {
                optionals.set(0);
            }
            if (struct.isSetVersion()) {
                optionals.set(1);
            }
            if (struct.isSetData()) {
                optionals.set(2);
            }
            oprot.writeBitSet(optionals, 3);
            if (struct.isSetType()) {
                oprot.writeByte(struct.type);
            }
            if (struct.isSetVersion()) {
                oprot.writeByte(struct.version);
            }
            if (struct.isSetData()) {
                oprot.writeI32(struct.data.size());
                for (ByteBuffer _iter338 : struct.data) {
                    oprot.writeBinary(_iter338);
                }
            }
        }

        @Override
        public void read(TProtocol prot, FileMetadata struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(3);
            if (incoming.get(0)) {
                struct.type = iprot.readByte();
                struct.setTypeIsSet(true);
            }
            if (incoming.get(1)) {
                struct.version = iprot.readByte();
                struct.setVersionIsSet(true);
            }
            if (incoming.get(2)) {
                TList _list339 = iprot.readListBegin((byte)11);
                struct.data = new ArrayList<ByteBuffer>(_list339.size);
                for (int _i341 = 0; _i341 < _list339.size; ++_i341) {
                    ByteBuffer _elem340 = iprot.readBinary();
                    struct.data.add(_elem340);
                }
                struct.setDataIsSet(true);
            }
        }
    }

    private static class FileMetadataStandardScheme
    extends StandardScheme<FileMetadata> {
        private FileMetadataStandardScheme() {
        }

        @Override
        public void read(TProtocol iprot, FileMetadata struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 3) {
                            struct.type = iprot.readByte();
                            struct.setTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 3) {
                            struct.version = iprot.readByte();
                            struct.setVersionIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 15) {
                            TList _list334 = iprot.readListBegin();
                            struct.data = new ArrayList<ByteBuffer>(_list334.size);
                            for (int _i336 = 0; _i336 < _list334.size; ++_i336) {
                                ByteBuffer _elem335 = iprot.readBinary();
                                struct.data.add(_elem335);
                            }
                            iprot.readListEnd();
                            struct.setDataIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        @Override
        public void write(TProtocol oprot, FileMetadata struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            oprot.writeFieldBegin(TYPE_FIELD_DESC);
            oprot.writeByte(struct.type);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(VERSION_FIELD_DESC);
            oprot.writeByte(struct.version);
            oprot.writeFieldEnd();
            if (struct.data != null) {
                oprot.writeFieldBegin(DATA_FIELD_DESC);
                oprot.writeListBegin(new TList(11, struct.data.size()));
                for (ByteBuffer _iter337 : struct.data) {
                    oprot.writeBinary(_iter337);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }
}

