/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.jsonexplain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.common.jsonexplain.Connection;
import org.apache.hadoop.hive.common.jsonexplain.DagJsonParser;
import org.apache.hadoop.hive.common.jsonexplain.DagJsonParserUtils;
import org.apache.hadoop.hive.common.jsonexplain.Printer;
import org.apache.hadoop.hive.common.jsonexplain.Vertex;
import org.apache.hive.com.google.common.annotations.VisibleForTesting;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class Op {
    public final String name;
    public final DagJsonParser parser;
    public String operatorId;
    public Op parent;
    public final List<Op> children;
    public final Map<String, String> attrs;
    public final JSONObject opObject;
    public final Vertex vertex;
    public String outputVertexName;
    public OpType type;

    public Op(String name, String id, String outputVertexName, Op parent, List<Op> children, Map<String, String> attrs, JSONObject opObject, Vertex vertex, DagJsonParser tezJsonParser) throws JSONException {
        this.name = name;
        this.operatorId = id;
        this.type = this.deriveOpType(this.operatorId);
        this.outputVertexName = outputVertexName;
        this.parent = parent;
        this.children = children;
        this.attrs = attrs;
        this.opObject = opObject;
        this.vertex = vertex;
        this.parser = tezJsonParser;
    }

    private OpType deriveOpType(String operatorId) {
        if (operatorId != null) {
            if (operatorId.startsWith(OpType.MAPJOIN.toString())) {
                return OpType.MAPJOIN;
            }
            if (operatorId.startsWith(OpType.MERGEJOIN.toString())) {
                return OpType.MERGEJOIN;
            }
            if (operatorId.startsWith(OpType.RS.toString())) {
                return OpType.RS;
            }
            return OpType.OTHERS;
        }
        return OpType.OTHERS;
    }

    @VisibleForTesting
    void inlineJoinOp() throws Exception {
        if (this.type == OpType.MAPJOIN) {
            LinkedHashMap<String, Vertex> posToVertex = new LinkedHashMap<String, Vertex>();
            if (this.opObject.has("input vertices:")) {
                JSONObject vertexObj = this.opObject.getJSONObject("input vertices:");
                for (String pos : JSONObject.getNames((JSONObject)vertexObj)) {
                    String vertexName = vertexObj.getString(pos);
                    String[] c = null;
                    for (String[] stringArray : this.vertex.parentConnections) {
                        if (!stringArray.from.name.equals(vertexName)) continue;
                        posToVertex.put(pos, stringArray.from);
                        c = stringArray;
                        break;
                    }
                    if (c == null) continue;
                    this.parser.addInline(this, (Connection)c);
                }
                this.attrs.remove("input vertices:");
            }
            JSONObject keys = this.opObject.getJSONObject("keys:");
            HashSet<Vertex> parentVertexes = new HashSet<Vertex>();
            for (Connection connection : this.vertex.parentConnections) {
                parentVertexes.add(connection.from);
            }
            parentVertexes.removeAll(posToVertex.values());
            ArrayList<Op> remaining = new ArrayList<Op>(this.children);
            HashSet<Op> visited = new HashSet<Op>();
            while (!remaining.isEmpty()) {
                Op child = (Op)remaining.remove(0);
                visited.add(child);
                if (child.opObject.has("input vertices:")) {
                    JSONObject vertexObj = child.opObject.getJSONObject("input vertices:");
                    block4: for (String pos : JSONObject.getNames((JSONObject)vertexObj)) {
                        String vertexName = vertexObj.getString(pos);
                        for (Connection connection : this.vertex.parentConnections) {
                            if (!connection.from.name.equals(vertexName)) continue;
                            parentVertexes.remove(connection.from);
                            continue block4;
                        }
                    }
                }
                for (Op grandchild : child.children) {
                    if (visited.contains(grandchild)) continue;
                    remaining.add(grandchild);
                }
            }
            LinkedHashMap<JSONObject, String> posToOpId = new LinkedHashMap<JSONObject, String>();
            if (keys.length() != 0) {
                for (JSONObject jSONObject : JSONObject.getNames((JSONObject)keys)) {
                    Op joinRSOp;
                    Vertex v;
                    if (posToVertex.containsKey(jSONObject)) {
                        v = (Vertex)posToVertex.get(jSONObject);
                        if (v.outputOps.size() == 1) {
                            posToOpId.put(jSONObject, v.outputOps.get((int)0).operatorId);
                            continue;
                        }
                        if (v.outputOps.size() == 0 && v.vertexType == Vertex.VertexType.UNION) {
                            posToOpId.put(jSONObject, v.name);
                            continue;
                        }
                        joinRSOp = v.getJoinRSOp(this.vertex);
                        if (joinRSOp != null) {
                            posToOpId.put(jSONObject, joinRSOp.operatorId);
                            continue;
                        }
                        throw new Exception("Can not find join reduceSinkOp for " + v.name + " to join " + this.vertex.name + " when hive explain user is trying to identify the operator id.");
                    }
                    if (this.parent != null) {
                        posToOpId.put(jSONObject, this.parent.operatorId);
                        continue;
                    }
                    if (parentVertexes.size() == 1) {
                        v = (Vertex)parentVertexes.iterator().next();
                        parentVertexes.clear();
                        if (v.outputOps.size() == 1) {
                            posToOpId.put(jSONObject, v.outputOps.get((int)0).operatorId);
                            continue;
                        }
                        if (v.outputOps.size() == 0 && v.vertexType == Vertex.VertexType.UNION) {
                            posToOpId.put(jSONObject, v.name);
                            continue;
                        }
                        joinRSOp = v.getJoinRSOp(this.vertex);
                        if (joinRSOp != null) {
                            posToOpId.put(jSONObject, joinRSOp.operatorId);
                            continue;
                        }
                        throw new Exception("Can not find join reduceSinkOp for " + v.name + " to join " + this.vertex.name + " when hive explain user is trying to identify the operator id.");
                    }
                    throw new Exception("Can not find the source operator on one of the branches of map join.");
                }
            }
            this.attrs.remove("keys:");
            StringBuilder sb = new StringBuilder();
            JSONArray conditionMap = this.opObject.getJSONArray("condition map:");
            for (int index = 0; index < conditionMap.length(); ++index) {
                JSONObject jSONObject = conditionMap.getJSONObject(index);
                String k = (String)jSONObject.keys().next();
                JSONObject condObject = new JSONObject((String)jSONObject.get(k));
                String type = condObject.getString("type");
                String left = condObject.getString("left");
                String right = condObject.getString("right");
                if (keys.length() != 0) {
                    sb.append((String)posToOpId.get(left) + "." + keys.get(left) + "=" + (String)posToOpId.get(right) + "." + keys.get(right) + "(" + type + "),");
                    continue;
                }
                sb.append("(" + type + "),");
            }
            this.attrs.remove("condition map:");
            this.attrs.put("Conds:", sb.substring(0, sb.length() - 1));
        } else {
            JSONObject keys;
            LinkedHashMap<String, String> posToOpId = new LinkedHashMap<String, String>();
            if (this.vertex.mergeJoinDummyVertices.isEmpty()) {
                keys = this.vertex.tagToInput.entrySet().iterator();
                while (keys.hasNext()) {
                    Map.Entry<String, String> entry = keys.next();
                    Connection c = null;
                    for (Connection connection : this.vertex.parentConnections) {
                        if (!connection.from.name.equals(entry.getValue())) continue;
                        Vertex v = connection.from;
                        if (v.outputOps.size() == 1) {
                            posToOpId.put(entry.getKey(), v.outputOps.get((int)0).operatorId);
                        } else if (v.outputOps.size() == 0 && v.vertexType == Vertex.VertexType.UNION) {
                            posToOpId.put(entry.getKey(), v.name);
                        } else {
                            Op joinRSOp = v.getJoinRSOp(this.vertex);
                            if (joinRSOp != null) {
                                posToOpId.put(entry.getKey(), joinRSOp.operatorId);
                            } else {
                                throw new Exception("Can not find join reduceSinkOp for " + v.name + " to join " + this.vertex.name + " when hive explain user is trying to identify the operator id.");
                            }
                        }
                        c = connection;
                        break;
                    }
                    if (c != null) continue;
                    throw new Exception("Can not find " + entry.getValue() + " while parsing keys of merge join operator");
                }
            } else {
                posToOpId.put(this.vertex.tag, this.parent.operatorId);
                keys = this.vertex.mergeJoinDummyVertices.iterator();
                while (keys.hasNext()) {
                    Vertex v = (Vertex)keys.next();
                    if (v.outputOps.size() != 1) {
                        throw new Exception("Can not find a single root operators in a single vertex " + v.name + " when hive explain user is trying to identify the operator id.");
                    }
                    posToOpId.put(v.tag, v.outputOps.get((int)0).operatorId);
                }
            }
            if ((keys = this.opObject.getJSONObject("keys:")).length() != 0) {
                for (String key : JSONObject.getNames((JSONObject)keys)) {
                    if (posToOpId.containsKey(key)) continue;
                    throw new Exception("Can not find the source operator on one of the branches of merge join.");
                }
                for (Vertex v : this.vertex.mergeJoinDummyVertices) {
                    this.parser.addInline(this, new Connection(null, v));
                }
            }
            this.attrs.remove("keys:");
            StringBuilder sb = new StringBuilder();
            JSONArray conditionMap = this.opObject.getJSONArray("condition map:");
            for (int index = 0; index < conditionMap.length(); ++index) {
                JSONObject cond = conditionMap.getJSONObject(index);
                String k = (String)cond.keys().next();
                JSONObject condObject = new JSONObject((String)cond.get(k));
                String type = condObject.getString("type");
                String string = condObject.getString("left");
                String right = condObject.getString("right");
                if (keys.length() != 0) {
                    sb.append((String)posToOpId.get(string) + "." + keys.get(string) + "=" + (String)posToOpId.get(right) + "." + keys.get(right) + "(" + type + "),");
                    continue;
                }
                sb.append("(" + type + "),");
            }
            this.attrs.remove("condition map:");
            this.attrs.put("Conds:", sb.substring(0, sb.length() - 1));
        }
    }

    private String getNameWithOpIdStats() {
        StringBuilder sb = new StringBuilder();
        sb.append(DagJsonParserUtils.renameReduceOutputOperator(this.name, this.vertex));
        if (this.operatorId != null) {
            sb.append(" [" + this.operatorId + "]");
        }
        if (!DagJsonParserUtils.getOperatorNoStats().contains(this.name) && this.attrs.containsKey("Statistics:")) {
            sb.append(" (" + this.attrs.get("Statistics:") + ")");
        }
        this.attrs.remove("Statistics:");
        return sb.toString();
    }

    public void print(Printer printer, int indentFlag, boolean branchOfJoinOp) throws Exception {
        if (this.parser.printSet.contains(this)) {
            printer.println(DagJsonParser.prefixString(indentFlag) + " Please refer to the previous " + this.getNameWithOpIdStats());
            return;
        }
        this.parser.printSet.add(this);
        if (!branchOfJoinOp) {
            printer.println(DagJsonParser.prefixString(indentFlag) + this.getNameWithOpIdStats());
        } else {
            printer.println(DagJsonParser.prefixString(indentFlag, "<-") + this.getNameWithOpIdStats());
        }
        branchOfJoinOp = false;
        if (this.type == OpType.MAPJOIN || this.type == OpType.MERGEJOIN) {
            this.inlineJoinOp();
            branchOfJoinOp = true;
        }
        ArrayList<Connection> noninlined = new ArrayList<Connection>();
        if (this.parent == null && this.vertex != null) {
            for (Connection connection : this.vertex.parentConnections) {
                if (this.parser.isInline(connection.from)) continue;
                noninlined.add(connection);
            }
        }
        ++indentFlag;
        if (!this.attrs.isEmpty()) {
            printer.println(DagJsonParser.prefixString(indentFlag) + DagJsonParserUtils.attrsToString(this.attrs));
        }
        if (this.parser.inlineMap.containsKey(this)) {
            List<Connection> connections = this.parser.inlineMap.get(this);
            Collections.sort(connections);
            for (Connection connection : connections) {
                connection.from.print(printer, indentFlag, connection.type, this.vertex);
            }
        }
        if (this.parent != null) {
            this.parent.print(printer, indentFlag, branchOfJoinOp);
        } else {
            Collections.sort(noninlined);
            for (Connection connection : noninlined) {
                connection.from.print(printer, indentFlag, connection.type, this.vertex);
            }
        }
    }

    public void setOperatorId(String operatorId) {
        this.operatorId = operatorId;
        this.type = this.deriveOpType(operatorId);
    }

    public static enum OpType {
        MAPJOIN,
        MERGEJOIN,
        RS,
        OTHERS;

    }
}

